/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.CommonBundle;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunSessionService;
import com.intellij.execution.actions.CreateAction;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.PreferredPlace;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentActionsContributor;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.UIExperiment;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.customization.CustomActionsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.ide.ui.customization.DefaultActionGroupWithDelegate;
import com.intellij.idea.AppModeAssertions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupWrapper;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.MoreActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.content.SingleContentSupplier;
import com.intellij.psi.search.ExecutionSearchScopes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class RunContentBuilder
extends RunTab {
    @ApiStatus.Experimental
    public static final String RUN_TOOL_WINDOW_TOP_TOOLBAR_OLD_GROUP = "RunTab.TopToolbar.Old";
    @ApiStatus.Experimental
    public static final String RUN_TOOL_WINDOW_TOP_TOOLBAR_GROUP = "RunTab.TopToolbar";
    @ApiStatus.Experimental
    public static final String RUN_TOOL_WINDOW_TOP_TOOLBAR_MORE_GROUP = "RunTab.TopToolbar.More";
    private static final Logger LOG = Logger.getInstance(RunContentBuilder.class);
    private static final String RUN_TOOL_WINDOW_ID = "Run";
    private static final String JAVA_RUNNER = "JavaRunner";
    private final List<AnAction> myRunnerActions;
    private final ExecutionResult myExecutionResult;
    private DefaultActionGroup toolbar;
    @Nullable
    private SingleContentSupplier mySupplier;

    public RunContentBuilder(@NotNull ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        if (executionResult == null) {
            RunContentBuilder.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            RunContentBuilder.$$$reportNull$$$0(1);
        }
        this(executionResult, environment.getProject(), ExecutionSearchScopes.executionScope((Project)environment.getProject(), (RunProfile)environment.getRunProfile()), RunContentBuilder.getRunnerType(executionResult.getExecutionConsole()), environment.getExecutor().getId(), environment.getRunProfile().getName());
        this.myEnvironment = environment;
    }

    @ApiStatus.Internal
    public RunContentBuilder(@NotNull ExecutionResult executionResult, @NotNull Project project, @NotNull GlobalSearchScope searchScope, @NotNull String runnerType, @NotNull String runnerTitle, @NotNull String sessionName) {
        if (executionResult == null) {
            RunContentBuilder.$$$reportNull$$$0(2);
        }
        if (project == null) {
            RunContentBuilder.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            RunContentBuilder.$$$reportNull$$$0(4);
        }
        if (runnerType == null) {
            RunContentBuilder.$$$reportNull$$$0(5);
        }
        if (runnerTitle == null) {
            RunContentBuilder.$$$reportNull$$$0(6);
        }
        if (sessionName == null) {
            RunContentBuilder.$$$reportNull$$$0(7);
        }
        super(project, searchScope, runnerType, runnerTitle, sessionName);
        this.myRunnerActions = new SmartList();
        this.toolbar = null;
        this.myExecutionResult = executionResult;
        this.myUi.getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
    }

    @NotNull
    public static ExecutionEnvironment fix(@NotNull ExecutionEnvironment environment, @Nullable ProgramRunner runner) {
        if (environment == null) {
            RunContentBuilder.$$$reportNull$$$0(8);
        }
        if (runner == null || runner.equals((Object)environment.getRunner())) {
            ExecutionEnvironment executionEnvironment = environment;
            if (executionEnvironment == null) {
                RunContentBuilder.$$$reportNull$$$0(9);
            }
            return executionEnvironment;
        }
        ExecutionEnvironment executionEnvironment = new ExecutionEnvironmentBuilder(environment).runner(runner).build();
        if (executionEnvironment == null) {
            RunContentBuilder.$$$reportNull$$$0(10);
        }
        return executionEnvironment;
    }

    public void addAction(@NotNull AnAction action) {
        if (action == null) {
            RunContentBuilder.$$$reportNull$$$0(11);
        }
        this.myRunnerActions.add(action);
    }

    @NotNull
    private RunContentDescriptor createDescriptor(@NlsContexts.TabTitle String displayName, @Nullable Icon icon, @Nullable RunProfile profile) {
        AnAction[] additionalActionsToMerge;
        AnAction[] consoleActionsToMerge;
        AnAction[] anActionArray;
        ExecutionConsole console = this.myExecutionResult.getExecutionConsole();
        ExecutionResult executionResult = this.myExecutionResult;
        if (executionResult instanceof DefaultExecutionResult) {
            DefaultExecutionResult res = (DefaultExecutionResult)executionResult;
            anActionArray = res.getRestartActions();
        } else {
            anActionArray = null;
        }
        AnAction[] resultRestartActions = anActionArray;
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(console, this.myExecutionResult.getProcessHandler(), displayName, icon, this.myUi, resultRestartActions);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            RunContentDescriptor runContentDescriptor2 = contentDescriptor;
            if (runContentDescriptor2 == null) {
                RunContentBuilder.$$$reportNull$$$0(12);
            }
            return runContentDescriptor2;
        }
        Content consoleContent = null;
        if (console != null) {
            if (console instanceof ExecutionConsoleEx) {
                ((ExecutionConsoleEx)console).buildUi(this.myUi);
            } else {
                consoleContent = RunContentBuilder.buildConsoleUiDefault(this.myUi, console);
            }
            if (profile != null) {
                this.initLogConsoles(profile, contentDescriptor, console);
            }
        }
        if (consoleContent != null && this.myUi.getContentManager().getContentCount() == 1 && console instanceof TerminalExecutionConsole) {
            consoleActionsToMerge = ((TerminalExecutionConsole)console).createConsoleActions();
            consoleContent.setActions((ActionGroup)new DefaultActionGroup(), "RunnerToolbar", console.getComponent());
            additionalActionsToMerge = AnAction.EMPTY_ARRAY;
        } else if (consoleContent != null && this.myUi.getContentManager().getContentCount() == 1 && console instanceof RunContentActionsContributor) {
            RunContentActionsContributor contributor = (RunContentActionsContributor)console;
            consoleActionsToMerge = contributor.getActions();
            additionalActionsToMerge = contributor.getAdditionalActions();
            contributor.hideOriginalActions();
        } else {
            consoleActionsToMerge = AnAction.EMPTY_ARRAY;
            additionalActionsToMerge = AnAction.EMPTY_ARRAY;
        }
        AnAction[] restartActions = contentDescriptor.getRestartActions();
        this.initToolbars(restartActions, consoleActionsToMerge, additionalActionsToMerge);
        CustomActionsListener.subscribe((Disposable)this, () -> {
            DefaultActionGroup updatedToolbar = this.createActionToolbar(restartActions, consoleActionsToMerge, additionalActionsToMerge);
            this.toolbar.removeAll();
            this.toolbar.addAll(updatedToolbar.getChildren(ActionManager.getInstance()));
        });
        if (profile instanceof RunConfigurationBase) {
            RunConfigurationBase runConfigurationBase = (RunConfigurationBase)profile;
            if (console instanceof ObservableConsoleView && !ApplicationManager.getApplication().isUnitTestMode()) {
                ((ObservableConsoleView)console).addChangeListener((ObservableConsoleView.ChangeListener)new ConsoleToFrontListener(runConfigurationBase.isShowConsoleOnStdOut(), runConfigurationBase.isShowConsoleOnStdErr(), this.myProject, this.myEnvironment.getExecutor(), contentDescriptor, this.myUi), (Disposable)this);
            }
        }
        RunContentDescriptor runContentDescriptor3 = contentDescriptor;
        if (runContentDescriptor3 == null) {
            RunContentBuilder.$$$reportNull$$$0(13);
        }
        return runContentDescriptor3;
    }

    private void initToolbars(AnAction @NotNull [] restartActions, AnAction @NotNull [] consoleActions, AnAction @NotNull [] additionalActions) {
        if (restartActions == null) {
            RunContentBuilder.$$$reportNull$$$0(14);
        }
        if (consoleActions == null) {
            RunContentBuilder.$$$reportNull$$$0(15);
        }
        if (additionalActions == null) {
            RunContentBuilder.$$$reportNull$$$0(16);
        }
        this.toolbar = this.createActionToolbar(restartActions, consoleActions, additionalActions);
        if (UIExperiment.isNewDebuggerUIEnabled()) {
            RunnerLayoutUi runnerLayoutUi;
            final boolean isVerticalToolbar = Registry.get((String)"debugger.new.tool.window.layout.toolbar").isOptionEnabled("Vertical");
            if (Registry.is((String)"debugger.new.tool.window.layout.single.content", (boolean)false)) {
                this.mySupplier = new RunTab.RunTabSupplier((ActionGroup)this.toolbar){
                    {
                        super(RunContentBuilder.this, group2);
                        this.setMoveToolbar(!isVerticalToolbar);
                    }

                    @Override
                    @Nullable
                    public ActionGroup getToolbarActions() {
                        return isVerticalToolbar ? ActionGroup.EMPTY_GROUP : super.getToolbarActions();
                    }

                    @Override
                    @NotNull
                    public List<AnAction> getContentActions() {
                        List<AnAction> list = List.of(RunContentBuilder.this.myUi.getOptions().getLayoutActions());
                        if (list == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return list;
                    }

                    @NotNull
                    public String getMainToolbarPlace() {
                        return "RunnerToolbar";
                    }

                    @NotNull
                    public String getContentToolbarPlace() {
                        return "RunnerToolbar";
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/RunContentBuilder$1", "getContentActions"));
                    }
                };
            }
            if ((runnerLayoutUi = this.myUi) instanceof RunnerLayoutUiImpl) {
                RunnerLayoutUiImpl uiImpl = (RunnerLayoutUiImpl)runnerLayoutUi;
                uiImpl.setLeftToolbarVisible(isVerticalToolbar);
                if (Registry.is((String)"debugger.toolbar.before.tabs", (boolean)true)) {
                    uiImpl.setTopLeftActionsBefore(true);
                }
            }
            if (isVerticalToolbar) {
                this.myUi.getOptions().setLeftToolbar((ActionGroup)this.toolbar, "RunnerToolbar");
            } else {
                DefaultActionGroupWithDelegate topToolbar = new DefaultActionGroupWithDelegate((ActionGroup)this.toolbar);
                topToolbar.add((AnAction)new EmptyWhenDuplicate((ActionGroup)this.toolbar, group2 -> group2 instanceof RunTab.ToolbarActionGroup));
                this.myUi.getOptions().setTopLeftToolbar((ActionGroup)topToolbar, "RunnerToolbar");
            }
        } else {
            this.myUi.getOptions().setLeftToolbar((ActionGroup)this.toolbar, "RunnerToolbar");
        }
    }

    @Override
    @Nullable
    protected SingleContentSupplier getSupplier() {
        return this.mySupplier;
    }

    @NotNull
    private static String getRunnerType(@Nullable ExecutionConsole console) {
        String id;
        if (console instanceof ExecutionConsoleEx && (id = ((ExecutionConsoleEx)console).getExecutionConsoleId()) != null) {
            String string = "JavaRunner." + id;
            if (string == null) {
                RunContentBuilder.$$$reportNull$$$0(17);
            }
            return string;
        }
        return JAVA_RUNNER;
    }

    @NotNull
    public static Content buildConsoleUiDefault(@NotNull RunnerLayoutUi ui, @NotNull ExecutionConsole console) {
        if (ui == null) {
            RunContentBuilder.$$$reportNull$$$0(18);
        }
        if (console == null) {
            RunContentBuilder.$$$reportNull$$$0(19);
        }
        Content consoleContent = ui.createContent("ConsoleContent", console.getComponent(), CommonBundle.message((String)"title.console", (Object[])new Object[0]), null, console.getPreferredFocusableComponent());
        consoleContent.setCloseable(false);
        RunContentBuilder.addAdditionalConsoleEditorActions(console, consoleContent);
        ui.addContent(consoleContent, 0, PlaceInGrid.bottom, false);
        Content content = consoleContent;
        if (content == null) {
            RunContentBuilder.$$$reportNull$$$0(20);
        }
        return content;
    }

    public static void addAdditionalConsoleEditorActions(ExecutionConsole console, Content consoleContent) {
        DefaultActionGroup consoleActions = new DefaultActionGroup();
        if (console instanceof ConsoleView) {
            for (AnAction action : ((ConsoleView)console).createConsoleActions()) {
                consoleActions.add(action);
            }
        }
        consoleContent.setActions((ActionGroup)consoleActions, "RunnerToolbar", console.getComponent());
    }

    @NotNull
    private DefaultActionGroup createActionToolbar(AnAction @NotNull [] restartActions, AnAction @NotNull [] consoleActions, AnAction @NotNull [] additionalActions) {
        if (restartActions == null) {
            RunContentBuilder.$$$reportNull$$$0(21);
        }
        if (consoleActions == null) {
            RunContentBuilder.$$$reportNull$$$0(22);
        }
        if (additionalActions == null) {
            RunContentBuilder.$$$reportNull$$$0(23);
        }
        ActionManager actionManager = ActionManager.getInstance();
        boolean isNewLayout = UIExperiment.isNewDebuggerUIEnabled();
        String mainGroupId = isNewLayout ? RUN_TOOL_WINDOW_TOP_TOOLBAR_GROUP : RUN_TOOL_WINDOW_TOP_TOOLBAR_OLD_GROUP;
        ActionGroup toolbarGroup = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(mainGroupId);
        DefaultActionGroupWithDelegate actionGroup = new DefaultActionGroupWithDelegate(toolbarGroup);
        RunContentBuilder.addAvoidingDuplicates((DefaultActionGroup)actionGroup, toolbarGroup);
        DefaultActionGroup afterRunActions = new DefaultActionGroup(restartActions);
        if (!isNewLayout) {
            afterRunActions.add((AnAction)new CreateAction(AllIcons.General.Settings));
            afterRunActions.addSeparator();
        }
        MoreActionGroup moreGroup = null;
        if (isNewLayout) {
            moreGroup = RunContentBuilder.createToolbarMoreActionGroup((ActionGroup)actionGroup);
            ActionGroup moreActionGroup = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(RUN_TOOL_WINDOW_TOP_TOOLBAR_MORE_GROUP);
            RunContentBuilder.addAvoidingDuplicates((DefaultActionGroup)moreGroup, moreActionGroup);
        }
        RunContentBuilder.addActionsWithConstraints(afterRunActions.getChildren(actionManager), new Constraints(Anchor.AFTER, "Rerun"), (DefaultActionGroup)actionGroup, (DefaultActionGroup)moreGroup);
        DefaultActionGroup afterStopActions = new DefaultActionGroup(this.myExecutionResult.getActions());
        if (consoleActions.length > 0) {
            afterStopActions.addSeparator();
            afterStopActions.addAll(consoleActions);
        }
        if (!isNewLayout) {
            for (AnAction anAction : this.myRunnerActions) {
                if (anAction != null) {
                    afterStopActions.add(anAction);
                    continue;
                }
                afterStopActions.addSeparator();
            }
            RunContentBuilder.addActionsWithConstraints(afterStopActions.getChildren(actionManager), new Constraints(Anchor.AFTER, "Stop"), (DefaultActionGroup)actionGroup, null);
            actionGroup.addSeparator();
            actionGroup.add(this.myUi.getOptions().getLayoutActions());
            actionGroup.addSeparator();
            actionGroup.add(PinToolwindowTabAction.getPinAction());
        } else {
            afterStopActions.addSeparator();
            afterStopActions.addAll(this.myRunnerActions);
            RunContentBuilder.addActionsWithConstraints(afterStopActions.getChildren(actionManager), new Constraints(Anchor.AFTER, "Stop"), (DefaultActionGroup)actionGroup, (DefaultActionGroup)moreGroup);
            moreGroup.addSeparator();
            if (additionalActions.length > 0) {
                moreGroup.addSeparator();
                moreGroup.addAll(additionalActions);
            }
            actionGroup.add((AnAction)moreGroup);
            moreGroup.add((AnAction)new CreateAction());
        }
        DefaultActionGroupWithDelegate defaultActionGroupWithDelegate = actionGroup;
        if (defaultActionGroupWithDelegate == null) {
            RunContentBuilder.$$$reportNull$$$0(24);
        }
        return defaultActionGroupWithDelegate;
    }

    public RunContentDescriptor showRunContent(@Nullable RunContentDescriptor reuseContent) {
        RunProfile profile = this.myEnvironment.getRunProfile();
        return this.showRunContent(reuseContent, profile.getName(), profile.getIcon(), profile);
    }

    @ApiStatus.Internal
    @NotNull
    public RunContentDescriptor showRunContent(@Nullable RunContentDescriptor reuseContent, @NlsContexts.TabTitle String displayName, @Nullable Icon icon, @Nullable RunProfile runProfile) {
        if (RunContentManagerImpl.isSplitRun() && AppModeAssertions.isBackend() && this.myEnvironment.getExecutor().getToolWindowId().equals(RUN_TOOL_WINDOW_ID)) {
            RunContentDescriptor descriptor = this.buildHiddenDescriptor(reuseContent);
            this.registerDescriptor(reuseContent, descriptor);
            RunSessionService runSessionService = RunSessionService.getInstance();
            if (runSessionService != null) {
                runSessionService.storeRunSession(this.myEnvironment, descriptor);
            }
            RunContentDescriptor runContentDescriptor2 = descriptor;
            if (runContentDescriptor2 == null) {
                RunContentBuilder.$$$reportNull$$$0(25);
            }
            return runContentDescriptor2;
        }
        RunContentDescriptor descriptor = this.createDescriptor(displayName, icon, runProfile);
        return this.registerDescriptor(reuseContent, descriptor);
    }

    @NotNull
    private RunContentDescriptor registerDescriptor(@Nullable RunContentDescriptor reuseContent, RunContentDescriptor descriptor) {
        Disposer.register((Disposable)descriptor, (Disposable)this);
        Disposer.register((Disposable)this.myProject, (Disposable)descriptor);
        RunContentManagerImpl.copyContentAndBehavior(descriptor, reuseContent);
        this.myRunContentDescriptor = descriptor;
        RunContentDescriptor runContentDescriptor2 = descriptor;
        if (runContentDescriptor2 == null) {
            RunContentBuilder.$$$reportNull$$$0(26);
        }
        return runContentDescriptor2;
    }

    @ApiStatus.Internal
    public RunContentDescriptor buildHiddenDescriptor(@Nullable RunContentDescriptor reuseContent) {
        RunContentDescriptor descriptor = new RunContentDescriptor(this, this.myEnvironment.getRunProfile(), this.myExecutionResult, this.myUi){

            public boolean isHiddenContent() {
                return true;
            }
        };
        return this.registerDescriptor(reuseContent, descriptor);
    }

    public GlobalSearchScope getSearchScope() {
        return this.mySearchScope;
    }

    public static void addActionsWithConstraints(AnAction[] actions, Constraints constraints, DefaultActionGroup actionGroup, @Nullable DefaultActionGroup moreGroup) {
        RunContentBuilder.addActionsWithConstraints(Arrays.asList(actions), constraints, actionGroup, moreGroup);
    }

    public static void addActionsWithConstraints(List<AnAction> actions, Constraints constraints, DefaultActionGroup actionGroup, @Nullable DefaultActionGroup moreGroup) {
        for (AnAction action : ContainerUtil.reverse(actions)) {
            if (action == null) {
                LOG.error("Null action in toolbar " + String.valueOf(actions));
                continue;
            }
            if (moreGroup != null && action.getTemplatePresentation().getClientProperty(PREFERRED_PLACE) == PreferredPlace.MORE_GROUP) {
                RunContentBuilder.addAvoidingDuplicates(moreGroup, new AnAction[]{action}, Constraints.LAST, AnAction.EMPTY_ARRAY);
                continue;
            }
            RunContentBuilder.addAvoidingDuplicates(actionGroup, new AnAction[]{action}, constraints, AnAction.EMPTY_ARRAY);
        }
    }

    private static void addAvoidingDuplicates(DefaultActionGroup group2, AnAction[] actions, Constraints constraints, AnAction[] existingActions) {
        HashSet visited = ContainerUtil.newHashSet((Object[])existingActions);
        for (AnAction action : actions) {
            if (!(action instanceof Separator) && (visited.contains(action) || group2.containsAction(action))) continue;
            group2.add(action, constraints);
        }
    }

    @ApiStatus.Internal
    public static MoreActionGroup createToolbarMoreActionGroup(final ActionGroup toolbarGroup) {
        return new MoreActionGroup(){

            @NotNull
            public @Unmodifiable @NotNull List<? extends @NotNull AnAction> postProcessVisibleChildren(@NotNull AnActionEvent e, @NotNull @NotNull List<? extends @NotNull AnAction> visibleChildren) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (visibleChildren == null) {
                    3.$$$reportNull$$$0(1);
                }
                List toolbarChildren = e.getUpdateSession().children(toolbarGroup);
                List list = ContainerUtil.filter(visibleChildren, action -> action instanceof Separator || !toolbarChildren.contains(action));
                if (list == null) {
                    3.$$$reportNull$$$0(2);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "visibleChildren";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/execution/runners/RunContentBuilder$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/execution/runners/RunContentBuilder$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "postProcessVisibleChildren";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "postProcessVisibleChildren";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @ApiStatus.Internal
    public static void addAvoidingDuplicates(DefaultActionGroup toGroup, ActionGroup fromGroup) {
        RunContentBuilder.addAvoidingDuplicates(toGroup, RunContentBuilder.getChildActionsOrStubs(fromGroup), Constraints.LAST, AnAction.EMPTY_ARRAY);
    }

    private static AnAction @NotNull [] getChildActionsOrStubs(ActionGroup group2) {
        if (group2 instanceof DefaultActionGroup) {
            DefaultActionGroup defaultActionGroup = (DefaultActionGroup)group2;
            AnAction[] anActionArray = defaultActionGroup.getChildActionsOrStubs();
            if (anActionArray == null) {
                RunContentBuilder.$$$reportNull$$$0(27);
            }
            return anActionArray;
        }
        if (group2 instanceof CustomisedActionGroup) {
            CustomisedActionGroup customisedActionGroup = (CustomisedActionGroup)group2;
            AnAction[] anActionArray = customisedActionGroup.getDefaultChildrenOrStubs();
            if (anActionArray == null) {
                RunContentBuilder.$$$reportNull$$$0(28);
            }
            return anActionArray;
        }
        if (AnAction.EMPTY_ARRAY == null) {
            RunContentBuilder.$$$reportNull$$$0(29);
        }
        return AnAction.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 12, 13, 17, 20, 24, 25, 26, 27, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerTitle";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/runners/RunContentBuilder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restartActions";
                break;
            }
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleActions";
                break;
            }
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalActions";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/runners/RunContentBuilder";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fix";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "buildConsoleUiDefault";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionToolbar";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "showRunContent";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "registerDescriptor";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildActionsOrStubs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fix";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "initToolbars";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildConsoleUiDefault";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createActionToolbar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 12, 13, 17, 20, 24, 25, 26, 27, 28, 29 -> new IllegalStateException(string);
        };
    }

    public static final class ConsoleToFrontListener
    implements ObservableConsoleView.ChangeListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Executor myExecutor;
        @NotNull
        private final RunContentDescriptor myRunContentDescriptor;
        @NotNull
        private final RunnerLayoutUi myUi;
        private final boolean myShowConsoleOnStdOut;
        private final boolean myShowConsoleOnStdErr;
        private final AtomicBoolean myFocused;

        public ConsoleToFrontListener(@NotNull RunConfigurationBase runConfigurationBase, @NotNull Project project, @NotNull Executor executor, @NotNull RunContentDescriptor runContentDescriptor2, @NotNull RunnerLayoutUi ui) {
            if (runConfigurationBase == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(1);
            }
            if (executor == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(2);
            }
            if (runContentDescriptor2 == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(3);
            }
            if (ui == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(4);
            }
            this(runConfigurationBase.isShowConsoleOnStdOut(), runConfigurationBase.isShowConsoleOnStdErr(), project, executor, runContentDescriptor2, ui);
        }

        @ApiStatus.Internal
        public ConsoleToFrontListener(boolean showConsoleOnStdOut, boolean showConsoleOnStdErr, @NotNull Project project, @NotNull Executor executor, @NotNull RunContentDescriptor runContentDescriptor2, @NotNull RunnerLayoutUi ui) {
            if (project == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(5);
            }
            if (executor == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(6);
            }
            if (runContentDescriptor2 == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(7);
            }
            if (ui == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(8);
            }
            this.myFocused = new AtomicBoolean();
            this.myProject = project;
            this.myExecutor = executor;
            this.myRunContentDescriptor = runContentDescriptor2;
            this.myUi = ui;
            this.myShowConsoleOnStdOut = showConsoleOnStdOut;
            this.myShowConsoleOnStdErr = showConsoleOnStdErr;
        }

        public void textAdded(@NotNull String text, @NotNull ConsoleViewContentType type) {
            if (text == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(9);
            }
            if (type == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(10);
            }
            if (this.myProject.isDisposed() || this.myUi.isDisposed()) {
                return;
            }
            if ((type == ConsoleViewContentType.NORMAL_OUTPUT && this.myShowConsoleOnStdOut || type == ConsoleViewContentType.ERROR_OUTPUT && this.myShowConsoleOnStdErr) && this.myFocused.compareAndSet(false, true)) {
                RunContentManager.getInstance((Project)this.myProject).toFrontRunContent(this.myExecutor, this.myRunContentDescriptor);
                this.myUi.selectAndFocus(this.myUi.findContent("ConsoleContent"), false, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfigurationBase";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runContentDescriptor";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/runners/RunContentBuilder$ConsoleToFrontListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "textAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class EmptyWhenDuplicate
    extends ActionGroupWrapper {
        @NotNull
        private final Predicate<? super ActionGroup> myDuplicatePredicate;

        private EmptyWhenDuplicate(@NotNull ActionGroup delegate, @NotNull Predicate<? super ActionGroup> isDuplicate) {
            if (delegate == null) {
                EmptyWhenDuplicate.$$$reportNull$$$0(0);
            }
            if (isDuplicate == null) {
                EmptyWhenDuplicate.$$$reportNull$$$0(1);
            }
            super(delegate);
            this.myDuplicatePredicate = isDuplicate;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (e == null) {
                if (AnAction.EMPTY_ARRAY == null) {
                    EmptyWhenDuplicate.$$$reportNull$$$0(2);
                }
                return AnAction.EMPTY_ARRAY;
            }
            if (((Boolean)e.getUpdateSession().compute((Object)this, "isToolbarDuplicatedAnywhere", ActionUpdateThread.EDT, () -> this.isToolbarDuplicatedAnywhere(EmptyWhenDuplicate.getEventComponent(e)))).booleanValue()) {
                if (AnAction.EMPTY_ARRAY == null) {
                    EmptyWhenDuplicate.$$$reportNull$$$0(3);
                }
                return AnAction.EMPTY_ARRAY;
            }
            AnAction[] anActionArray = super.getChildren(e);
            if (anActionArray == null) {
                EmptyWhenDuplicate.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        @Nullable
        private static Component getEventComponent(@Nullable AnActionEvent e) {
            if (e == null) {
                return null;
            }
            SingleContentSupplier supplier = (SingleContentSupplier)e.getData(SingleContentSupplier.KEY);
            return supplier != null ? supplier.getTabs().getComponent() : null;
        }

        private boolean isToolbarDuplicatedAnywhere(@Nullable Component parent) {
            for (Component component : UIUtil.uiTraverser((Component)parent)) {
                ActionGroup group2;
                if (!(component instanceof ActionToolbarImpl) || !this.myDuplicatePredicate.test((ActionGroup)(group2 = ((ActionToolbarImpl)component).getActionGroup()))) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isDuplicate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/runners/RunContentBuilder$EmptyWhenDuplicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/runners/RunContentBuilder$EmptyWhenDuplicate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

