/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.target.BrowsableTargetEnvironmentType;
import com.intellij.execution.target.ContributedConfigurationsList;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentLanguagesPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0011H\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\b\u0010\u001e\u001a\u00020\u0002H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0019H\u0014J\b\u0010\"\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentDetailsConfigurable;", "Lcom/intellij/openapi/ui/NamedConfigurable;", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "config", "defaultLanguage", "Lcom/intellij/execution/target/LanguageRuntimeType;", "treeUpdate", "Ljava/lang/Runnable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/target/TargetEnvironmentConfiguration;Lcom/intellij/execution/target/LanguageRuntimeType;Ljava/lang/Runnable;)V", "targetConfigurable", "Lcom/intellij/openapi/options/Configurable;", "languagesPanel", "Lcom/intellij/execution/target/TargetEnvironmentLanguagesPanel;", "getBannerSlogan", "", "getIcon", "Ljavax/swing/Icon;", "expanded", "", "isModified", "getDisplayName", "apply", "", "reset", "setDisplayName", "name", "disposeUIResources", "getEditableObject", "createOptionsPanel", "Ljavax/swing/JComponent;", "resetOptionsPanel", "forceRefreshUI", "intellij.platform.execution.impl"})
public final class TargetEnvironmentDetailsConfigurable
extends NamedConfigurable<TargetEnvironmentConfiguration> {
    @NotNull
    private final Project project;
    @NotNull
    private final TargetEnvironmentConfiguration config;
    @NotNull
    private final Configurable targetConfigurable;
    @Nullable
    private TargetEnvironmentLanguagesPanel languagesPanel;

    public TargetEnvironmentDetailsConfigurable(@NotNull Project project, @NotNull TargetEnvironmentConfiguration config, @Nullable LanguageRuntimeType<?> defaultLanguage, @NotNull Runnable treeUpdate) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)treeUpdate, (String)"treeUpdate");
        super(true, treeUpdate);
        this.project = project;
        this.config = config;
        this.targetConfigurable = TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)this.config).createConfigurable(this.project, this.config, defaultLanguage, (Configurable)this);
    }

    @NotNull
    public String getBannerSlogan() {
        return this.config.getDisplayName();
    }

    @NotNull
    public Icon getIcon(boolean expanded) {
        return TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)this.config).getIcon();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        if (this.targetConfigurable.isModified()) return true;
        TargetEnvironmentLanguagesPanel targetEnvironmentLanguagesPanel = this.languagesPanel;
        if (targetEnvironmentLanguagesPanel == null) return false;
        if (!targetEnvironmentLanguagesPanel.isModified()) return false;
        return true;
    }

    @NotNull
    public String getDisplayName() {
        return this.config.getDisplayName();
    }

    public void apply() {
        block0: {
            this.targetConfigurable.apply();
            TargetEnvironmentLanguagesPanel targetEnvironmentLanguagesPanel = this.languagesPanel;
            if (targetEnvironmentLanguagesPanel == null) break block0;
            targetEnvironmentLanguagesPanel.applyAll();
        }
    }

    public void reset() {
        block0: {
            this.targetConfigurable.reset();
            TargetEnvironmentLanguagesPanel targetEnvironmentLanguagesPanel = this.languagesPanel;
            if (targetEnvironmentLanguagesPanel == null) break block0;
            targetEnvironmentLanguagesPanel.reset();
        }
    }

    public void setDisplayName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.config.setDisplayName(name);
    }

    public void disposeUIResources() {
        block0: {
            super.disposeUIResources();
            this.targetConfigurable.disposeUIResources();
            TargetEnvironmentLanguagesPanel targetEnvironmentLanguagesPanel = this.languagesPanel;
            if (targetEnvironmentLanguagesPanel == null) break block0;
            targetEnvironmentLanguagesPanel.disposeUIResources();
        }
    }

    @NotNull
    public TargetEnvironmentConfiguration getEditableObject() {
        return this.config;
    }

    @NotNull
    public JComponent createOptionsPanel() {
        JBScrollPane jBScrollPane;
        JPanel panel2 = new JPanel((LayoutManager)new VerticalLayout(4));
        panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)10, (int)10));
        JComponent jComponent = this.targetConfigurable.createComponent();
        if (jComponent == null) {
            throw new IllegalStateException();
        }
        panel2.add(jComponent);
        Supplier<TargetEnvironmentConfiguration> targetSupplier = null;
        targetSupplier = this.targetConfigurable instanceof BrowsableTargetEnvironmentType.ConfigurableCurrentConfigurationProvider ? () -> ((BrowsableTargetEnvironmentType.ConfigurableCurrentConfigurationProvider)((BrowsableTargetEnvironmentType.ConfigurableCurrentConfigurationProvider)this.targetConfigurable)).getCurrentConfiguration() : () -> TargetEnvironmentDetailsConfigurable.createOptionsPanel$lambda$0(this);
        TargetEnvironmentLanguagesPanel targetEnvironmentLanguagesPanel = this.languagesPanel = new TargetEnvironmentLanguagesPanel(this.project, TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)this.config), targetSupplier, (ContributedConfigurationsList<LanguageRuntimeConfiguration, LanguageRuntimeType<? extends LanguageRuntimeConfiguration>>)this.config.getRuntimes(), (Function0<Unit>)((Function0)() -> TargetEnvironmentDetailsConfigurable.createOptionsPanel$lambda$1(this)));
        Intrinsics.checkNotNull((Object)targetEnvironmentLanguagesPanel);
        panel2.add(targetEnvironmentLanguagesPanel.getComponent());
        JBScrollPane it = jBScrollPane = new JBScrollPane((Component)panel2);
        boolean bl = false;
        it.setBorder((Border)JBUI.Borders.empty());
        return (JComponent)jBScrollPane;
    }

    protected void resetOptionsPanel() {
        TargetEnvironmentLanguagesPanel targetEnvironmentLanguagesPanel = this.languagesPanel;
        if (targetEnvironmentLanguagesPanel != null) {
            targetEnvironmentLanguagesPanel.disposeUIResources();
        }
        this.languagesPanel = null;
        super.resetOptionsPanel();
    }

    private final void forceRefreshUI() {
        block0: {
            JComponent jComponent = this.createComponent();
            if (jComponent == null) break block0;
            JComponent it = jComponent;
            boolean bl = false;
            it.revalidate();
            it.repaint();
        }
    }

    private static final TargetEnvironmentConfiguration createOptionsPanel$lambda$0(TargetEnvironmentDetailsConfigurable this$0) {
        return this$0.config;
    }

    private static final Unit createOptionsPanel$lambda$1(TargetEnvironmentDetailsConfigurable this$0) {
        this$0.forceRefreshUI();
        return Unit.INSTANCE;
    }
}

