/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a@\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0010\u0010\f\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u000e\u0018\u00010\rH\u0002\u001a6\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\f\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u000e\u0018\u00010\rH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001a\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0002H\u0002\u001a\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"EXECUTOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/execution/Executor;", "chooseReuseContentForDescriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "descriptor", "executionId", "", "preferredName", "", "reuseCondition", "Ljava/util/function/Predicate;", "Lcom/intellij/ui/content/Content;", "getContentFromManager", "canReuseContent", "", "c", "getToolWindowIdForRunner", "executor", "createNewContent", "getRunContentByDescriptor", "isAlive", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nRunContentManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunContentManagerImpl.kt\ncom/intellij/execution/ui/RunContentManagerImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,794:1\n296#2,2:795\n1401#3,2:797\n13225#3,2:799\n*S KotlinDebug\n*F\n+ 1 RunContentManagerImpl.kt\ncom/intellij/execution/ui/RunContentManagerImplKt\n*L\n757#1:795,2\n779#1:797,2\n785#1:799,2\n*E\n"})
public final class RunContentManagerImplKt {
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final Key<Executor> EXECUTOR_KEY;

    private static final RunContentDescriptor chooseReuseContentForDescriptor(ContentManager contentManager, RunContentDescriptor descriptor, long executionId, String preferredName, Predicate<? super Content> reuseCondition) {
        Content content = null;
        if (descriptor != null) {
            if (descriptor.isContentReuseProhibited()) {
                return null;
            }
            Content attachedContent = descriptor.getAttachedContent();
            if (attachedContent != null && attachedContent.isValid() && (Intrinsics.areEqual((Object)descriptor.getDisplayName(), (Object)attachedContent.getDisplayName()) || !attachedContent.isPinned()) && contentManager.getContentsRecursively().contains(attachedContent)) {
                content = attachedContent;
            }
        }
        if (content == null) {
            content = RunContentManagerImplKt.getContentFromManager(contentManager, preferredName, executionId, reuseCondition);
        }
        if (content == null || !RunContentManagerImpl.Companion.isTerminated(content) || content.getExecutionId() == executionId && executionId != 0L) {
            return null;
        }
        RunContentDescriptor runContentDescriptor2 = RunContentManagerImpl.Companion.getRunContentDescriptorByContent(content);
        if (runContentDescriptor2 == null) {
            return null;
        }
        RunContentDescriptor oldDescriptor = runContentDescriptor2;
        if (oldDescriptor.isContentReuseProhibited()) {
            return null;
        }
        if (descriptor == null || oldDescriptor.getReusePolicy().canBeReusedBy(descriptor)) {
            return oldDescriptor;
        }
        return null;
    }

    private static final Content getContentFromManager(ContentManager contentManager, String preferredName, long executionId, Predicate<? super Content> reuseCondition) {
        Object v2;
        block4: {
            List list = contentManager.getContentsRecursively();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContentsRecursively(...)");
            List contents = CollectionsKt.toMutableList((Collection)list);
            Content first = contentManager.getSelectedContent();
            if (first != null && contents.remove(first)) {
                contents.add(0, first);
            }
            if (preferredName != null) {
                for (Object e : contents) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    Content c = (Content)e;
                    if (!RunContentManagerImplKt.canReuseContent(c, executionId) || !Intrinsics.areEqual((Object)preferredName, (Object)c.getDisplayName())) continue;
                    return c;
                }
            }
            Iterable $this$firstOrNull$iv = contents;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Content it = (Content)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(RunContentManagerImplKt.canReuseContent(it, executionId) && (reuseCondition == null || reuseCondition.test((Content)it)))) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        return v2;
    }

    private static final boolean canReuseContent(Content c, long executionId) {
        return !c.isPinned() && RunContentManagerImpl.Companion.isTerminated(c) && (c.getExecutionId() != executionId || executionId == 0L);
    }

    private static final String getToolWindowIdForRunner(Executor executor, RunContentDescriptor descriptor) {
        Object object = descriptor;
        if (object == null || (object = object.getContentToolWindowId()) == null) {
            String string = executor.getToolWindowId();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getToolWindowId(...)");
        }
        return object;
    }

    private static final Content createNewContent(RunContentDescriptor descriptor, Executor executor) {
        Icon icon;
        Content content = ContentFactory.getInstance().createContent(descriptor.getComponent(), descriptor.getDisplayName(), true);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
        if (AdvancedSettings.Companion.getBoolean("start.run.configurations.pinned")) {
            content2.setPinned(true);
        }
        if ((icon = descriptor.getIcon()) == null) {
            Icon icon2 = executor.getToolWindowIcon();
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getToolWindowIcon(...)");
        }
        content2.setIcon(icon);
        return content2;
    }

    private static final Content getRunContentByDescriptor(ContentManager contentManager, RunContentDescriptor descriptor) {
        Object object;
        block1: {
            Content[] contentArray = contentManager.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Object[] $this$firstOrNull$iv = contentArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Content it = (Content)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Intrinsics.areEqual((Object)descriptor, (Object)RunContentManagerImpl.Companion.getRunContentDescriptorByContent(it))) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (Content)object;
    }

    private static final boolean isAlive(ContentManager contentManager) {
        boolean bl;
        block1: {
            Content[] contentArray = contentManager.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Object[] $this$any$iv = contentArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Content it = (Content)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                RunContentDescriptor descriptor = RunContentManagerImpl.Companion.getRunContentDescriptorByContent(it);
                if (!(descriptor != null && RunContentManagerImplKt.isAlive(descriptor))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean isAlive(RunContentDescriptor descriptor) {
        ProcessHandler handler2 = descriptor.getProcessHandler();
        return handler2 != null && !handler2.isProcessTerminated();
    }

    public static final /* synthetic */ Content access$getRunContentByDescriptor(ContentManager contentManager, RunContentDescriptor descriptor) {
        return RunContentManagerImplKt.getRunContentByDescriptor(contentManager, descriptor);
    }

    public static final /* synthetic */ String access$getToolWindowIdForRunner(Executor executor, RunContentDescriptor descriptor) {
        return RunContentManagerImplKt.getToolWindowIdForRunner(executor, descriptor);
    }

    public static final /* synthetic */ RunContentDescriptor access$chooseReuseContentForDescriptor(ContentManager contentManager, RunContentDescriptor descriptor, long executionId, String preferredName, Predicate reuseCondition) {
        return RunContentManagerImplKt.chooseReuseContentForDescriptor(contentManager, descriptor, executionId, preferredName, reuseCondition);
    }

    public static final /* synthetic */ Content access$createNewContent(RunContentDescriptor descriptor, Executor executor) {
        return RunContentManagerImplKt.createNewContent(descriptor, executor);
    }

    public static final /* synthetic */ boolean access$isAlive(ContentManager contentManager) {
        return RunContentManagerImplKt.isAlive(contentManager);
    }

    public static final /* synthetic */ boolean access$isAlive(RunContentDescriptor descriptor) {
        return RunContentManagerImplKt.isAlive(descriptor);
    }

    static {
        Key key = Key.create((String)"Executor");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        EXECUTOR_KEY = key;
    }
}

