/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.impl.RunConfigurationStorageUi;
import com.intellij.execution.impl.RunOnTargetPanel;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.ui.RunConfigurationFragmentedEditor;
import com.intellij.execution.ui.TargetAwareRunConfigurationEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunnerAndConfigurationSettingsEditor
extends SettingsEditor<RunnerAndConfigurationSettings>
implements TargetAwareRunConfigurationEditor {
    private final RunConfigurationFragmentedEditor<RunConfigurationBase<?>> myConfigurationEditor;
    @Nullable
    private final RunConfigurationStorageUi myRCStorageUi;
    private final RunOnTargetPanel myRunOnTargetPanel;

    public RunnerAndConfigurationSettingsEditor(RunnerAndConfigurationSettings settings, RunConfigurationFragmentedEditor<RunConfigurationBase<?>> configurationEditor) {
        super(settings.createFactory());
        this.myConfigurationEditor = configurationEditor;
        this.myConfigurationEditor.addSettingsEditorListener(editor -> this.fireEditorStateChanged());
        Disposer.register((Disposable)this, this.myConfigurationEditor);
        Project project = settings.getConfiguration().getProject();
        if (!project.isDefault() && settings.isTemplate()) {
            this.myRCStorageUi = new RunConfigurationStorageUi(project, () -> this.fireEditorStateChanged());
            this.myRunOnTargetPanel = new RunOnTargetPanel(settings, this);
        } else {
            this.myRCStorageUi = null;
            this.myRunOnTargetPanel = null;
        }
    }

    public boolean isInplaceValidationSupported() {
        return this.myConfigurationEditor.isInplaceValidationSupported();
    }

    @Override
    public void targetChanged(String targetName) {
        this.myConfigurationEditor.targetChanged(targetName);
    }

    public boolean isSpecificallyModified() {
        return this.myRCStorageUi != null && this.myRCStorageUi.isModified() || this.myConfigurationEditor.isSpecificallyModified();
    }

    public boolean isReadyForApply() {
        return this.myConfigurationEditor.isReadyForApply();
    }

    protected void resetEditorFrom(@NotNull RunnerAndConfigurationSettings s) {
        if (s == null) {
            RunnerAndConfigurationSettingsEditor.$$$reportNull$$$0(0);
        }
        this.myConfigurationEditor.resetEditorFrom((RunnerAndConfigurationSettingsImpl)s);
        this.myConfigurationEditor.resetFrom((RunConfigurationBase)s.getConfiguration());
        if (this.myRCStorageUi != null) {
            this.myRCStorageUi.reset(s);
            this.myRunOnTargetPanel.reset();
        }
    }

    protected void applyEditorTo(@NotNull RunnerAndConfigurationSettings s) throws ConfigurationException {
        if (s == null) {
            RunnerAndConfigurationSettingsEditor.$$$reportNull$$$0(1);
        }
        this.myConfigurationEditor.applyEditorTo((RunnerAndConfigurationSettingsImpl)s);
        this.myConfigurationEditor.applyTo((RunConfigurationBase)s.getConfiguration());
        if (this.myRCStorageUi != null) {
            this.myRCStorageUi.apply(s);
            this.myRunOnTargetPanel.apply();
        }
    }

    @NotNull
    protected JComponent createEditor() {
        if (this.myRCStorageUi == null) {
            JComponent jComponent = this.myConfigurationEditor.getComponent();
            if (jComponent == null) {
                RunnerAndConfigurationSettingsEditor.$$$reportNull$$$0(2);
            }
            return jComponent;
        }
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        c.insets = JBUI.insets((int)5, (int)0, (int)5, (int)0);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panel2.add((Component)this.myRCStorageUi.createComponent(), c);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 11;
        c.insets = JBInsets.emptyInsets();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JPanel comp = new JPanel(new GridBagLayout());
        this.myRunOnTargetPanel.buildUi(comp, null);
        panel2.add((Component)comp, c);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 11;
        c.insets = JBInsets.emptyInsets();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel2.add((Component)this.myConfigurationEditor.getComponent(), c);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            RunnerAndConfigurationSettingsEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/RunnerAndConfigurationSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/RunnerAndConfigurationSettingsEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

