/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScriptFileUtil {
    private static final Logger LOG = Logger.getInstance(ScriptFileUtil.class);
    private static final String SCHEME = "mem://";
    private static final Map<String, VirtualFile> ourFilesMap = CollectionFactory.createConcurrentWeakValueMap();
    private static final AtomicLong ourFileCounter = new AtomicLong();

    private ScriptFileUtil() {
    }

    public static boolean isMemoryScriptPath(@Nullable String url) {
        return url != null && url.startsWith(SCHEME);
    }

    public static String getScriptFilePath(@NotNull VirtualFile file) {
        if (file == null) {
            ScriptFileUtil.$$$reportNull$$$0(0);
        }
        if (file.isInLocalFileSystem()) {
            return file.getPath();
        }
        long id = ourFileCounter.incrementAndGet();
        String url = SCHEME + id + "/" + file.getName();
        ourFilesMap.put(url, file);
        return url;
    }

    @Nullable
    public static VirtualFile findScriptFileByPath(@Nullable String path) {
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        if (!path.startsWith(SCHEME)) {
            return LocalFileSystem.getInstance().findFileByPath(path);
        }
        return ourFilesMap.get(path);
    }

    @NotNull
    public static String getLocalFilePath(@NotNull String scriptPath) throws CantRunException {
        if (scriptPath == null) {
            ScriptFileUtil.$$$reportNull$$$0(1);
        }
        if (ScriptFileUtil.isMemoryScriptPath(scriptPath)) {
            File tmpFile = ScriptFileUtil.copyToTempFile(scriptPath);
            String string = tmpFile.getAbsolutePath();
            if (string == null) {
                ScriptFileUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = scriptPath;
        if (string == null) {
            ScriptFileUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static File copyToTempFile(@NotNull @NlsSafe String path) throws CantRunException {
        File file;
        File ioFile;
        VirtualFile virtualFile;
        if (path == null) {
            ScriptFileUtil.$$$reportNull$$$0(4);
        }
        if ((virtualFile = ScriptFileUtil.findScriptFileByPath(path)) == null) {
            throw new CantRunException(ExecutionBundle.message((String)"script.exception.file.not.found", (Object[])new Object[]{path}));
        }
        try {
            ioFile = FileUtil.createTempFile((String)virtualFile.getName(), (String)"", (boolean)true);
        }
        catch (IOException e) {
            throw new CantRunException(ExecutionBundle.message((String)"script.exception.can.not.create.temp.file", (Object[])new Object[]{virtualFile.getName()}), (Throwable)e);
        }
        try {
            ScriptFileUtil.copyFile(virtualFile, ioFile);
            file = ioFile;
        }
        catch (IOException e) {
            throw new CantRunException(ExecutionBundle.message((String)"script.exception.can.not.write.temp.file", (Object[])new Object[]{virtualFile.getPath(), ioFile.getAbsolutePath()}), (Throwable)e);
        }
        if (file == null) {
            ScriptFileUtil.$$$reportNull$$$0(5);
        }
        return file;
    }

    private static void copyFile(@NotNull VirtualFile srcFile, @NotNull File destFile) throws IOException {
        if (srcFile == null) {
            ScriptFileUtil.$$$reportNull$$$0(6);
        }
        if (destFile == null) {
            ScriptFileUtil.$$$reportNull$$$0(7);
        }
        LOG.info("Copying to " + destFile.getPath());
        CharSequence content = ScriptFileUtil.getContent(srcFile);
        CharBuffer cb = CharBuffer.wrap(content);
        ByteBuffer bb = StandardCharsets.UTF_8.encode(cb);
        byte[] result2 = new byte[bb.remaining()];
        bb.get(result2);
        FileUtil.writeToFile((File)destFile, (byte[])result2, (boolean)false);
    }

    @NotNull
    private static CharSequence getContent(@NotNull VirtualFile file) {
        Document document;
        if (file == null) {
            ScriptFileUtil.$$$reportNull$$$0(8);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(file)) != null) {
            String string = document.getText();
            if (string == null) {
                ScriptFileUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        CharSequence charSequence = LoadTextUtil.loadText((VirtualFile)file);
        if (charSequence == null) {
            ScriptFileUtil.$$$reportNull$$$0(10);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/util/ScriptFileUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/util/ScriptFileUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFilePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToTempFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScriptFilePath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFilePath";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyToTempFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 9, 10 -> new IllegalStateException(string);
        };
    }
}

