/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.target.wizard;

import com.intellij.concurrency.ThreadContext;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslExecution;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.execution.ParametersListUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\r2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0016J\u0018\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\r2\u0006\u0010\u0016\u001a\u00020\u0012H\u0017J\u001b\u0010\u0018\u001a\u00020\u00152\u0011\u0010\u0019\u001a\r\u0012\t\u0012\u00070\u0012\u00a2\u0006\u0002\b\u001a0\u0017H\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/execution/wsl/target/wizard/WslTargetIntrospectable;", "Lcom/intellij/execution/target/LanguageRuntimeType$Introspectable;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "<init>", "(Lcom/intellij/execution/wsl/WSLDistribution;Lcom/intellij/execution/ui/ConsoleView;)V", "getDistribution", "()Lcom/intellij/execution/wsl/WSLDistribution;", "getConsole", "()Lcom/intellij/execution/ui/ConsoleView;", "targetPlatform", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/execution/target/TargetPlatform;", "getTargetPlatform", "()Ljava/util/concurrent/CompletableFuture;", "promiseEnvironmentVariable", "", "varName", "promiseExecuteScript", "Lcom/intellij/execution/process/ProcessOutput;", "script", "", "executeCommand", "cmd", "Lcom/intellij/openapi/util/NlsSafe;", "Companion", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nWslTargetIntrospectable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslTargetIntrospectable.kt\ncom/intellij/execution/wsl/target/wizard/WslTargetIntrospectable\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,84:1\n13#2:85\n*S KotlinDebug\n*F\n+ 1 WslTargetIntrospectable.kt\ncom/intellij/execution/wsl/target/wizard/WslTargetIntrospectable\n*L\n81#1:85\n*E\n"})
public final class WslTargetIntrospectable
extends LanguageRuntimeType.Introspectable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WSLDistribution distribution;
    @NotNull
    private final ConsoleView console;
    @NotNull
    private final CompletableFuture<TargetPlatform> targetPlatform;
    @NotNull
    private static final Logger LOG;

    public WslTargetIntrospectable(@NotNull WSLDistribution distribution, @NotNull ConsoleView console) {
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        this.distribution = distribution;
        this.console = console;
        CompletableFuture<TargetPlatform> completableFuture = CompletableFuture.completedFuture(new TargetPlatform(Platform.UNIX));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        this.targetPlatform = completableFuture;
    }

    @NotNull
    public final WSLDistribution getDistribution() {
        return this.distribution;
    }

    @NotNull
    public final ConsoleView getConsole() {
        return this.console;
    }

    @NotNull
    public CompletableFuture<TargetPlatform> getTargetPlatform() {
        return this.targetPlatform;
    }

    @NotNull
    public CompletableFuture<String> promiseEnvironmentVariable(@NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        CompletableFuture<String> completableFuture = CompletableFuture.supplyAsync(() -> WslTargetIntrospectable.promiseEnvironmentVariable$lambda$1(ThreadContext.captureThreadContext(() -> WslTargetIntrospectable.promiseEnvironmentVariable$lambda$0(this, varName))));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<ProcessOutput> promiseExecuteScript(@NotNull List<String> script) {
        Intrinsics.checkNotNullParameter(script, (String)"script");
        CompletableFuture<ProcessOutput> completableFuture = CompletableFuture.supplyAsync(() -> WslTargetIntrospectable.promiseExecuteScript$lambda$1(ThreadContext.captureThreadContext(() -> WslTargetIntrospectable.promiseExecuteScript$lambda$0(this, script))));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @Deprecated(message="Use the override with List<String> parameter type")
    @NotNull
    public CompletableFuture<String> promiseExecuteScript(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        List list = ParametersListUtil.parse((String)script);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
        CompletionStage completionStage = this.promiseExecuteScript(list).thenApply(arg_0 -> WslTargetIntrospectable.promiseExecuteScript$lambda$3(WslTargetIntrospectable::promiseExecuteScript$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @RequiresBackgroundThread
    private final ProcessOutput executeCommand(List<String> cmd) {
        ProcessOutput output;
        boolean executeCommandInShell = !Intrinsics.areEqual(cmd, (Object)CollectionsKt.listOf((Object)"pwd"));
        WSLCommandLineOptions wSLCommandLineOptions = new WSLCommandLineOptions().setExecuteCommandInShell(executeCommandInShell);
        Intrinsics.checkNotNullExpressionValue((Object)wSLCommandLineOptions, (String)"setExecuteCommandInShell(...)");
        WSLCommandLineOptions options = wSLCommandLineOptions;
        if (executeCommandInShell) {
            options.setExecuteCommandInInteractiveShell(true);
            options.setExecuteCommandInLoginShell(true);
        }
        GeneralCommandLine generalCommandLine = new PtyCommandLine(cmd).withRedirectErrorStream(true);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withRedirectErrorStream(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        if (executeCommandInShell) {
            v2 = WslExecution.executeInShellAndGetCommandOnlyStdout((WSLDistribution)this.distribution, (GeneralCommandLine)commandLine, (WSLCommandLineOptions)options, (int)10000, arg_0 -> WslTargetIntrospectable.executeCommand$lambda$0(this, arg_0));
        } else {
            this.distribution.patchCommandLine(commandLine, null, options);
            KillableProcessHandler processHandler = new KillableProcessHandler(commandLine);
            this.console.attachToProcess((ProcessHandler)processHandler);
            ProcessOutput processOutput = new CapturingProcessRunner((BaseProcessHandler)processHandler).runProcess(10000);
            Intrinsics.checkNotNull((Object)processOutput);
            v2 = output = processOutput;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Command " + cmd + " finished: stdout=" + output.getStdout() + ", stderr=" + output.getStderr() + ", timeout=" + output.isTimeout() + ", exitCode=" + output.getExitCode());
        }
        boolean success = !output.isTimeout() && output.getExitCode() == 0;
        Object[] objectArray = new Object[]{output.getExitCode()};
        this.console.print(IdeBundle.message((String)"wsl.target.introspection.step.command.finished.with.exit.code", (Object[])objectArray) + "\n\n", success ? ConsoleViewContentType.SYSTEM_OUTPUT : ConsoleViewContentType.ERROR_OUTPUT);
        return output;
    }

    private static final String promiseEnvironmentVariable$lambda$0(WslTargetIntrospectable this$0, String $varName) {
        return this$0.distribution.getEnvironmentVariable($varName);
    }

    private static final String promiseEnvironmentVariable$lambda$1(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    private static final ProcessOutput promiseExecuteScript$lambda$0(WslTargetIntrospectable this$0, List $script) {
        return this$0.executeCommand($script);
    }

    private static final ProcessOutput promiseExecuteScript$lambda$1(Function0 $tmp0) {
        return (ProcessOutput)$tmp0.invoke();
    }

    private static final String promiseExecuteScript$lambda$2(ProcessOutput output) {
        boolean success;
        boolean bl = success = !output.isTimeout() && output.getExitCode() == 0;
        if (!success) {
            Object[] objectArray = new Object[]{output.getExitCode()};
            throw new Exception(IdeBundle.message((String)"wsl.target.introspection.step.command.finished.with.exit.code", (Object[])objectArray));
        }
        return output.getStdout();
    }

    private static final String promiseExecuteScript$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void executeCommand$lambda$0(WslTargetIntrospectable this$0, ProcessHandler it) {
        this$0.console.attachToProcess(it);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WslTargetIntrospectable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/wsl/target/wizard/WslTargetIntrospectable$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

