/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.target.wizard;

import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeConfigurationKt;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentWizard;
import com.intellij.execution.target.TargetEnvironmentWizardStepKt;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.target.WslTargetConfigurable;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.execution.wsl.target.wizard.WslTargetCustomToolStep;
import com.intellij.execution.wsl.target.wizard.WslTargetIntrospectable;
import com.intellij.execution.wsl.target.wizard.WslTargetLanguageStep;
import com.intellij.execution.wsl.target.wizard.WslTargetStepBase;
import com.intellij.execution.wsl.target.wizard.WslTargetWizardModel;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J'\u0010\u0016\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u000b\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fH\u0002J\u0015\u0010 \u001a\u00020\u00142\u000b\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fH\u0002J\b\u0010!\u001a\u00020\"H\u0014J\r\u0010#\u001a\u00070$\u00a2\u0006\u0002\b\u001fH\u0002J\b\u0010%\u001a\u00020\"H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\n\u0010)\u001a\u0004\u0018\u00010'H\u0016J\b\u0010*\u001a\u00020\u0012H\u0016J\u0012\u0010+\u001a\u00020\u00142\b\u0010,\u001a\u0004\u0018\u00010-H\u0014J\b\u0010.\u001a\u00020\u0014H\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/execution/wsl/target/wizard/WslTargetIntrospectionStep;", "Lcom/intellij/execution/wsl/target/wizard/WslTargetStepBase;", "model", "Lcom/intellij/execution/wsl/target/wizard/WslTargetWizardModel;", "<init>", "(Lcom/intellij/execution/wsl/target/wizard/WslTargetWizardModel;)V", "selectDistributionConfigurable", "Lcom/intellij/execution/wsl/target/WslTargetConfigurable;", "getSelectDistributionConfigurable", "()Lcom/intellij/execution/wsl/target/WslTargetConfigurable;", "selectDistributionConfigurable$delegate", "Lkotlin/Lazy;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "getConsole", "()Lcom/intellij/execution/ui/ConsoleView;", "console$delegate", "introspectionFinished", "", "_init", "", "tryIntrospecting", "introspect", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "languageRuntimeConfiguration", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "introspectable", "Lcom/intellij/execution/wsl/target/wizard/WslTargetIntrospectable;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "Lorg/jetbrains/annotations/NotNull;", "finalizeIntrospection", "createMainPanel", "Ljavax/swing/JComponent;", "createBorder", "Ljavax/swing/border/Border;", "getPreferredFocusedComponent", "getStepId", "", "getNextStepId", "getPreviousStepId", "isComplete", "doCommit", "commitType", "Lcom/intellij/ide/wizard/AbstractWizardStepEx$CommitType;", "dispose", "Companion", "intellij.platform.execution.impl"})
public final class WslTargetIntrospectionStep
extends WslTargetStepBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy selectDistributionConfigurable$delegate;
    @NotNull
    private final Lazy console$delegate;
    private boolean introspectionFinished;
    @NotNull
    private static final Object ID = Reflection.getOrCreateKotlinClass(WslTargetIntrospectionStep.class);

    public WslTargetIntrospectionStep(@NotNull WslTargetWizardModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(model);
        this.selectDistributionConfigurable$delegate = LazyKt.lazy(() -> WslTargetIntrospectionStep.selectDistributionConfigurable_delegate$lambda$0(model));
        this.console$delegate = LazyKt.lazy(() -> WslTargetIntrospectionStep.console_delegate$lambda$0(model, this));
    }

    private final WslTargetConfigurable getSelectDistributionConfigurable() {
        Lazy lazy = this.selectDistributionConfigurable$delegate;
        return (WslTargetConfigurable)((Object)lazy.getValue());
    }

    private final ConsoleView getConsole() {
        Lazy lazy = this.console$delegate;
        return (ConsoleView)lazy.getValue();
    }

    public void _init() {
        super._init();
        this.getModel().resetLanguageConfigForIntrospection$intellij_platform_execution_impl();
        String string = IdeBundle.message((String)"wsl.target.introspection.step.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.setStepDescription(string);
        this.getConsole().clear();
        this.getSelectDistributionConfigurable().getConfig().setDistribution(this.getModel().getDistribution());
        this.getModel().setDistribution(null);
        this.getSelectDistributionConfigurable().reset();
        this.tryIntrospecting();
    }

    private final void tryIntrospecting() {
        block1: {
            this.getSelectDistributionConfigurable().apply();
            WSLDistribution wSLDistribution = this.getSelectDistributionConfigurable().getConfig().getDistribution();
            if (wSLDistribution == null) break block1;
            WSLDistribution it = wSLDistribution;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)this.getModel().getDistribution())) {
                this.getModel().setDistribution(it);
                this.introspect(it);
            }
        }
    }

    private final void introspect(WSLDistribution distribution) {
        this.setSpinningVisible(true);
        this.getModel().resetLanguageConfigForIntrospection$intellij_platform_execution_impl();
        this.getConsole().clear();
        ModalityState modalityState = ModalityState.stateForComponent((Component)this.getConsole().getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
        ModalityState modalityState2 = modalityState;
        this.introspectionFinished = false;
        ApplicationManager.getApplication().executeOnPooledThread(() -> WslTargetIntrospectionStep.introspect$lambda$0(distribution, this, modalityState2));
    }

    private final void introspect(LanguageRuntimeConfiguration languageRuntimeConfiguration, WslTargetIntrospectable introspectable, ModalityState modalityState) {
        if (languageRuntimeConfiguration == null) {
            this.finalizeIntrospection(modalityState);
            return;
        }
        LanguageRuntimeType.Introspector introspector = LanguageRuntimeConfigurationKt.getRuntimeType((LanguageRuntimeConfiguration)languageRuntimeConfiguration).createIntrospector(languageRuntimeConfiguration);
        if (introspector == null) {
            this.finalizeIntrospection(modalityState);
            return;
        }
        ((CompletableFuture)introspector.introspect((LanguageRuntimeType.Introspectable)introspectable).thenApply(arg_0 -> WslTargetIntrospectionStep.introspect$lambda$2(arg_0 -> WslTargetIntrospectionStep.introspect$lambda$1(this, arg_0), arg_0))).whenComplete((arg_0, arg_1) -> WslTargetIntrospectionStep.introspect$lambda$4((arg_0, arg_1) -> WslTargetIntrospectionStep.introspect$lambda$3(this, introspectable, modalityState, arg_0, arg_1), arg_0, arg_1));
    }

    private final void finalizeIntrospection(ModalityState modalityState) {
        ApplicationManager.getApplication().invokeLater(() -> WslTargetIntrospectionStep.finalizeIntrospection$lambda$0(this), modalityState);
    }

    @Override
    @NotNull
    protected JComponent createMainPanel() {
        BorderLayoutPanel panel2 = new BorderLayoutPanel();
        JComponent jComponent = this.getSelectDistributionConfigurable().createComponent();
        Intrinsics.checkNotNull((Object)jComponent);
        JComponent selectDistributionComponent = jComponent;
        selectDistributionComponent.setBorder(this.createBorder());
        panel2.addToTop((Component)selectDistributionComponent);
        panel2.addToCenter((Component)this.getConsole().getComponent());
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.register((Component)selectDistributionComponent);
        watcher.addUserActivityListener(() -> WslTargetIntrospectionStep.createMainPanel$lambda$0(this));
        return (JComponent)panel2;
    }

    private final Border createBorder() {
        Border border = JBUI.Borders.merge((Border)((Border)JBUI.Borders.empty((int)TargetEnvironmentWizardStepKt.Companion.getLARGE_VGAP(), (int)TargetEnvironmentWizard.Companion.defaultDialogInsets().left, (int)0, (int)0)), (Border)JBUI.Borders.merge((Border)WslTargetStepBase.Companion.visualPadding$intellij_platform_execution_impl(), (Border)IdeBorderFactory.createBorder((int)8), (boolean)true), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"merge(...)");
        return border;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent preferredFocusedComponent = this.getSelectDistributionConfigurable().getPreferredFocusedComponent();
        JComponent jComponent = preferredFocusedComponent;
        if (jComponent == null) {
            JComponent jComponent2 = this.getConsole().getPreferredFocusableComponent();
            jComponent = jComponent2;
            Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getPreferredFocusableComponent(...)");
        }
        return jComponent;
    }

    @NotNull
    public Object getStepId() {
        return ID;
    }

    @NotNull
    public Object getNextStepId() {
        return this.getModel().isCustomToolConfiguration$intellij_platform_execution_impl() ? WslTargetCustomToolStep.Companion.getID$intellij_platform_execution_impl() : WslTargetLanguageStep.Companion.getID();
    }

    @Nullable
    public Object getPreviousStepId() {
        return null;
    }

    public boolean isComplete() {
        return this.introspectionFinished && this.getModel().getDistribution() != null;
    }

    @Override
    protected void doCommit(@Nullable AbstractWizardStepEx.CommitType commitType) {
    }

    @Override
    public void dispose() {
        this.getSelectDistributionConfigurable().disposeUIResources();
        super.dispose();
    }

    private static final WslTargetConfigurable selectDistributionConfigurable_delegate$lambda$0(WslTargetWizardModel $model) {
        return new WslTargetConfigurable(new WslTargetEnvironmentConfiguration(null), $model.getProject());
    }

    private static final TerminalExecutionConsole console_delegate$lambda$0(WslTargetWizardModel $model, WslTargetIntrospectionStep this$0) {
        TerminalExecutionConsole terminalExecutionConsole;
        TerminalExecutionConsole it = terminalExecutionConsole = new TerminalExecutionConsole($model.getProject(), 86, 18, null);
        boolean bl = false;
        it.getTerminalWidget().getTerminalPanel().setCursorVisible(false);
        it.getTerminalWidget().getTerminalPanel().setFocusable(false);
        it.withConvertLfToCrlfForNonPtyProcess(true);
        Disposer.register((Disposable)((Disposable)this$0), (Disposable)((Disposable)it));
        return terminalExecutionConsole;
    }

    private static final Unit introspect$lambda$0$0(WslTargetIntrospectionStep this$0, ProcessOutput it) {
        if (it != null) {
            this$0.getModel().getSubject().setProjectRootOnTarget(it + "/" + this$0.getModel().getProject().getName());
        }
        return Unit.INSTANCE;
    }

    private static final Unit introspect$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final void introspect$lambda$0(WSLDistribution $distribution, WslTargetIntrospectionStep this$0, ModalityState $modalityState) {
        WslTargetIntrospectable introspectable = new WslTargetIntrospectable($distribution, this$0.getConsole());
        introspectable.promiseExecuteScript(CollectionsKt.listOf((Object)"pwd")).thenApply(arg_0 -> WslTargetIntrospectionStep.introspect$lambda$0$1(arg_0 -> WslTargetIntrospectionStep.introspect$lambda$0$0(this$0, arg_0), arg_0));
        this$0.introspect(this$0.getModel().getLanguageConfigForIntrospection(), introspectable, $modalityState);
    }

    private static final LanguageRuntimeConfiguration introspect$lambda$1(WslTargetIntrospectionStep this$0, LanguageRuntimeConfiguration it) {
        return this$0.getModel().getLanguageConfigForIntrospection();
    }

    private static final LanguageRuntimeConfiguration introspect$lambda$2(Function1 $tmp0, Object p0) {
        return (LanguageRuntimeConfiguration)$tmp0.invoke(p0);
    }

    private static final Unit introspect$lambda$3(WslTargetIntrospectionStep this$0, WslTargetIntrospectable $introspectable, ModalityState $modalityState, Object object, Throwable err) {
        if (err == null) {
            this$0.getConsole().print(IdeBundle.message((String)"wsl.target.introspection.step.completed.successfully", (Object[])new Object[0]), new ConsoleViewContentType("green", ConsoleHighlighter.GREEN));
        } else {
            this$0.getConsole().print(IdeBundle.message((String)"wsl.target.introspection.step.completed.with.errors", (Object[])new Object[0]), ConsoleViewContentType.ERROR_OUTPUT);
        }
        $introspectable.shutdown();
        this$0.finalizeIntrospection($modalityState);
        return Unit.INSTANCE;
    }

    private static final void introspect$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void finalizeIntrospection$lambda$0(WslTargetIntrospectionStep this$0) {
        this$0.introspectionFinished = true;
        this$0.setSpinningVisible(false);
        this$0.fireStateChanged();
    }

    private static final void createMainPanel$lambda$0(WslTargetIntrospectionStep this$0) {
        this$0.tryIntrospecting();
    }

    @NotNull
    public static final Object getID() {
        return Companion.getID();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0003\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/wsl/target/wizard/WslTargetIntrospectionStep$Companion;", "", "<init>", "()V", "ID", "getID$annotations", "getID", "()Ljava/lang/Object;", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getID() {
            return ID;
        }

        @JvmStatic
        public static /* synthetic */ void getID$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

