/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.ide.DataManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.terminal.IdeTerminalCopyPasteHandler;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.TerminalEscapeKeyListener;
import com.intellij.terminal.TerminalUiSettingsListener;
import com.intellij.terminal.actions.TerminalActionWrapper;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TerminalCopyPasteHandler;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionMenuBuilder;
import com.jediterm.terminal.ui.TerminalActionProvider;
import com.jediterm.terminal.ui.TerminalPanel;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.pty4j.windows.conpty.WinConPtyProcess;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTerminalPanel
extends TerminalPanel
implements FocusListener,
TerminalUiSettingsListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(JBTerminalPanel.class);
    @Language(value="devkit-action-id")
    @NonNls
    private static final String[] ACTIONS_TO_SKIP = new String[]{"ActivateTerminalToolWindow", "ActivateProjectToolWindow", "ActivateFavoritesToolWindow", "ActivateBookmarksToolWindow", "ActivateFindToolWindow", "ActivateRunToolWindow", "ActivateDebugToolWindow", "ActivateProblemsViewToolWindow", "ActivateTODOToolWindow", "ActivateStructureToolWindow", "ActivateHierarchyToolWindow", "ActivateServicesToolWindow", "ActivateCommitToolWindow", "ActivateVersionControlToolWindow", "HideActiveWindow", "HideAllWindows", "NextWindow", "PreviousWindow", "NextProjectWindow", "PreviousProjectWindow", "ShowBookmarks", "ShowTypeBookmarks", "FindInPath", "GotoBookmark0", "GotoBookmark1", "GotoBookmark2", "GotoBookmark3", "GotoBookmark4", "GotoBookmark5", "GotoBookmark6", "GotoBookmark7", "GotoBookmark8", "GotoBookmark9", "GotoAction", "GotoFile", "GotoClass", "GotoSymbol", "Vcs.Push", "ShowSettings", "RecentFiles", "Switcher", "RecentFilesFallback", "SwitcherFallback", "ResizeToolWindowLeft", "ResizeToolWindowRight", "ResizeToolWindowUp", "ResizeToolWindowDown", "MaximizeToolWindow", "TerminalIncreaseFontSize", "TerminalDecreaseFontSize", "TerminalResetFontSize"};
    private final TerminalEventDispatcher myEventDispatcher;
    private final JBTerminalSystemSettingsProviderBase mySettingsProvider;
    private final TerminalEscapeKeyListener myEscapeKeyListener;
    private final List<Consumer<? super KeyEvent>> myPreKeyEventConsumers;
    private List<AnAction> myActionsToSkip;

    public JBTerminalPanel(@NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @NotNull TerminalTextBuffer backBuffer, @NotNull StyleState styleState) {
        if (settingsProvider == null) {
            JBTerminalPanel.$$$reportNull$$$0(0);
        }
        if (backBuffer == null) {
            JBTerminalPanel.$$$reportNull$$$0(1);
        }
        if (styleState == null) {
            JBTerminalPanel.$$$reportNull$$$0(2);
        }
        super((SettingsProvider)settingsProvider, backBuffer, styleState);
        this.myEventDispatcher = new TerminalEventDispatcher();
        this.myPreKeyEventConsumers = new CopyOnWriteArrayList<Consumer<? super KeyEvent>>();
        this.mySettingsProvider = settingsProvider;
        this.addFocusListener(this);
        this.mySettingsProvider.addUiSettingsListener(this, this);
        this.setDefaultCursorShape(settingsProvider.getCursorShape());
        this.myEscapeKeyListener = new TerminalEscapeKeyListener(this);
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return JBUI.emptySize();
    }

    private boolean skipKeyEvent(@NotNull KeyEvent e) {
        if (e == null) {
            JBTerminalPanel.$$$reportNull$$$0(3);
        }
        return JBTerminalPanel.skipAction(e, this.myActionsToSkip);
    }

    private static boolean skipAction(@NotNull KeyEvent e, @Nullable List<? extends AnAction> actionsToSkip) {
        if (e == null) {
            JBTerminalPanel.$$$reportNull$$$0(4);
        }
        if (actionsToSkip != null) {
            KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
            for (AnAction anAction : actionsToSkip) {
                for (Shortcut sc : anAction.getShortcutSet().getShortcuts()) {
                    if (!sc.isKeyboard() || !sc.startsWith((Shortcut)eventShortcut)) continue;
                    return Registry.is((String)"terminal.Ctrl-E.opens.RecentFiles.popup", (boolean)false) || !"RecentFiles".equals(ActionManager.getInstance().getId(anAction)) || e.getModifiersEx() != 128 || e.getKeyCode() != 69;
                }
            }
        }
        return false;
    }

    public void handleKeyEvent(@NotNull KeyEvent e) {
        if (e == null) {
            JBTerminalPanel.$$$reportNull$$$0(5);
        }
        for (Consumer<? super KeyEvent> preKeyEventConsumer : this.myPreKeyEventConsumers) {
            preKeyEventConsumer.accept(e);
        }
        this.myEscapeKeyListener.handleKeyEvent(e);
        if (!e.isConsumed()) {
            super.handleKeyEvent(e);
        }
    }

    public void addPreKeyEventHandler(@NotNull Consumer<? super KeyEvent> preKeyEventHandler) {
        if (preKeyEventHandler == null) {
            JBTerminalPanel.$$$reportNull$$$0(6);
        }
        this.myPreKeyEventConsumers.add(preKeyEventHandler);
    }

    public List<TerminalAction> getActions() {
        String clearBufferActionName;
        List actions = super.getActions();
        TerminalAction clearBufferAction = (TerminalAction)ContainerUtil.find((Iterable)actions, arg_0 -> JBTerminalPanel.lambda$getActions$0(clearBufferActionName = this.mySettingsProvider.getClearBufferActionPresentation().getName(), arg_0));
        if (clearBufferAction != null) {
            clearBufferAction.withEnabledSupplier(() -> {
                if (this.getTerminalTextBuffer().isUsingAlternateBuffer()) {
                    return false;
                }
                JBTerminalWidget terminalWidget = (JBTerminalWidget)((Object)((Object)DataManager.getInstance().getDataContext((Component)((Object)this)).getData(JBTerminalWidget.TERMINAL_DATA_KEY)));
                if (terminalWidget == null || terminalWidget.getTerminalPanel() != this) {
                    return false;
                }
                ProcessTtyConnector connector = terminalWidget.getProcessTtyConnector();
                WinConPtyProcess winConPtyProcess = connector != null ? (WinConPtyProcess)ObjectUtils.tryCast((Object)connector.getProcess(), WinConPtyProcess.class) : null;
                return winConPtyProcess == null;
            });
        }
        return actions;
    }

    protected void setupAntialiasing(Graphics graphics) {
        UIUtil.setupComposite((Graphics2D)((Graphics2D)graphics));
        UISettings.setupAntialiasing((Graphics)graphics);
    }

    @NotNull
    protected TerminalCopyPasteHandler createCopyPasteHandler() {
        return new IdeTerminalCopyPasteHandler();
    }

    @NotNull
    protected JPopupMenu createPopupMenu(@NotNull TerminalActionProvider actionProvider) {
        if (actionProvider == null) {
            JBTerminalPanel.$$$reportNull$$$0(7);
        }
        JPopupMenu jPopupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", JBTerminalPanel.wrapTerminalActions(actionProvider)).getComponent();
        if (jPopupMenu == null) {
            JBTerminalPanel.$$$reportNull$$$0(8);
        }
        return jPopupMenu;
    }

    @NotNull
    private static ActionGroup wrapTerminalActions(@NotNull TerminalActionProvider provider) {
        if (provider == null) {
            JBTerminalPanel.$$$reportNull$$$0(9);
        }
        final DefaultActionGroup result2 = new DefaultActionGroup();
        TerminalAction.buildMenu((TerminalActionProvider)provider, (TerminalActionMenuBuilder)new TerminalActionMenuBuilder(){

            public void addAction(@NotNull TerminalAction action) {
                if (action == null) {
                    1.$$$reportNull$$$0(0);
                }
                result2.add((AnAction)new TerminalActionWrapper(action));
            }

            public void addSeparator() {
                result2.addSeparator();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/terminal/JBTerminalPanel$1", "addAction"));
            }
        });
        DefaultActionGroup defaultActionGroup = result2;
        if (defaultActionGroup == null) {
            JBTerminalPanel.$$$reportNull$$$0(10);
        }
        return defaultActionGroup;
    }

    protected void drawImage(Graphics2D gfx, BufferedImage image, int x, int y, ImageObserver observer) {
        UIUtil.drawImage((Graphics)gfx, (Image)image, (int)x, (int)y, (ImageObserver)observer);
    }

    protected void drawImage(Graphics2D g, BufferedImage image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        JBTerminalPanel.drawImage(g, image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    public static void drawImage(Graphics g, Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if (image instanceof JBHiDPIScaledImage) {
            Graphics2D newG = (Graphics2D)g.create(0, 0, image.getWidth(observer), image.getHeight(observer));
            newG.scale(0.5, 0.5);
            Image img = ((JBHiDPIScaledImage)image).getDelegate();
            if (img == null) {
                img = image;
            }
            newG.drawImage(img, 2 * dx1, 2 * dy1, 2 * dx2, 2 * dy2, sx1 * 2, sy1 * 2, sx2 * 2, sy2 * 2, observer);
            newG.scale(1.0, 1.0);
            newG.dispose();
        } else {
            g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        }
    }

    protected BufferedImage createBufferedImage(int width, int height) {
        return ImageUtil.createImage((int)width, (int)height, (int)2);
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (this.mySettingsProvider.overrideIdeShortcuts()) {
            this.myActionsToSkip = JBTerminalPanel.setupActionsToSkip();
            this.myEventDispatcher.register();
        } else {
            this.myActionsToSkip = null;
            this.myEventDispatcher.unregister();
        }
        if (GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
            ApplicationManager.getApplication().invokeLater(() -> FileDocumentManager.getInstance().saveAllDocuments(), ModalityState.nonModal());
        }
    }

    @NotNull
    private static List<AnAction> setupActionsToSkip() {
        ArrayList<AnAction> res = new ArrayList<AnAction>();
        ActionManager actionManager = ActionManager.getInstance();
        for (String actionId : ACTIONS_TO_SKIP) {
            AnAction action = actionManager.getAction(actionId);
            if (action == null) continue;
            res.add(action);
        }
        ArrayList<AnAction> arrayList = res;
        if (arrayList == null) {
            JBTerminalPanel.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.myActionsToSkip = null;
        this.myEventDispatcher.unregister();
        SaveAndSyncHandler.getInstance().scheduleRefresh();
    }

    @NotNull
    protected Font getFontToDisplay(char[] text, int start2, int end, @NotNull TextStyle style) {
        if (style == null) {
            JBTerminalPanel.$$$reportNull$$$0(12);
        }
        int fontStyle = 0;
        if (style.hasOption(TextStyle.Option.BOLD)) {
            fontStyle |= 1;
        }
        if (style.hasOption(TextStyle.Option.ITALIC)) {
            fontStyle |= 2;
        }
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay((char[])text, (int)start2, (int)end, (int)fontStyle, (FontPreferences)this.mySettingsProvider.getFontPreferences(), null);
        Font font = fontInfo.getFont().deriveFont(this.mySettingsProvider.getTerminalFontSize());
        if (font == null) {
            JBTerminalPanel.$$$reportNull$$$0(13);
        }
        return font;
    }

    @Override
    @ApiStatus.Internal
    public void cursorChanged() {
        this.setCursorShape(this.mySettingsProvider.getCursorShape());
        this.repaint();
    }

    @Override
    public void fontChanged() {
        this.reinitFontAndResize();
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        if (EditorSettingsExternalizable.getInstance().isWheelFontChangeEnabled() && EditorUtil.isChangeFontSize((MouseWheelEvent)e)) {
            int newFontSize = (int)this.mySettingsProvider.getTerminalFontSize() - e.getWheelRotation();
            if (newFontSize >= EditorFontsConstants.getMinEditorFontSize() && newFontSize <= EditorFontsConstants.getMaxEditorFontSize()) {
                this.mySettingsProvider.setTerminalFontSize(newFontSize);
            }
            return;
        }
        super.processMouseWheelEvent(e);
    }

    @NotNull
    JBTerminalSystemSettingsProviderBase getSettingsProvider() {
        JBTerminalSystemSettingsProviderBase jBTerminalSystemSettingsProviderBase = this.mySettingsProvider;
        if (jBTerminalSystemSettingsProviderBase == null) {
            JBTerminalPanel.$$$reportNull$$$0(14);
        }
        return jBTerminalSystemSettingsProviderBase;
    }

    @Nullable
    ToolWindow getContextToolWindow() {
        return (ToolWindow)DataManager.getInstance().getDataContext((Component)((Object)this)).getData(PlatformDataKeys.TOOL_WINDOW);
    }

    @Nullable
    Project getContextProject() {
        return (Project)DataManager.getInstance().getDataContext((Component)((Object)this)).getData(CommonDataKeys.PROJECT);
    }

    private static /* synthetic */ boolean lambda$getActions$0(String clearBufferActionName, TerminalAction action) {
        return action.getName().equals(clearBufferActionName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backBuffer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleState";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preKeyEventHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionProvider";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/JBTerminalPanel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/JBTerminalPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupMenu";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapTerminalActions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setupActionsToSkip";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontToDisplay";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "skipKeyEvent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "skipAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyEvent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPreKeyEventHandler";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPopupMenu";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrapTerminalActions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFontToDisplay";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 11, 13, 14 -> new IllegalStateException(string);
        };
    }

    private final class TerminalEventDispatcher
    implements IdeEventQueue.EventDispatcher {
        private boolean myRegistered = false;

        private TerminalEventDispatcher() {
        }

        public boolean dispatch(@NotNull AWTEvent e) {
            if (e == null) {
                TerminalEventDispatcher.$$$reportNull$$$0(0);
            }
            if (e instanceof KeyEvent) {
                this.dispatchKeyEvent((KeyEvent)e);
            }
            return false;
        }

        private void dispatchKeyEvent(@NotNull KeyEvent e) {
            if (e == null) {
                TerminalEventDispatcher.$$$reportNull$$$0(1);
            }
            if (e.getID() == 401 && !JBTerminalPanel.this.skipKeyEvent(e)) {
                if (!JBTerminalPanel.this.isFocusOwner()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Prevented attempt to process " + String.valueOf(KeyStroke.getKeyStrokeForEvent(e)) + " by not focused " + this.getDebugTerminalPanelName() + ", unregistering");
                    }
                    this.unregister();
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Consuming " + String.valueOf(KeyStroke.getKeyStrokeForEvent(e)) + ", registered:" + this.myRegistered);
                }
                JBTerminalPanel.this.dispatchEvent(e);
            }
        }

        void register() {
            ThreadingAssertions.assertEventDispatchThread();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Register terminal event dispatcher for " + this.getDebugTerminalPanelName());
            }
            if (this.myRegistered) {
                LOG.info("Already registered terminal event dispatcher");
            } else if (Disposer.isDisposed((Disposable)JBTerminalPanel.this)) {
                LOG.info("Already disposed " + String.valueOf(JBTerminalPanel.this));
            } else {
                IdeEventQueue.getInstance().addDispatcher((IdeEventQueue.EventDispatcher)this, (Disposable)JBTerminalPanel.this);
                this.myRegistered = true;
            }
        }

        void unregister() {
            ThreadingAssertions.assertEventDispatchThread();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unregister terminal event dispatcher for " + this.getDebugTerminalPanelName());
            }
            if (this.myRegistered) {
                IdeEventQueue.getInstance().removeDispatcher((IdeEventQueue.EventDispatcher)this);
            }
            this.myRegistered = false;
        }

        @NotNull
        private String getDebugTerminalPanelName() {
            String string = JBTerminalPanel.class.getSimpleName() + "@" + System.identityHashCode(JBTerminalPanel.this);
            if (string == null) {
                TerminalEventDispatcher.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/terminal/JBTerminalPanel$TerminalEventDispatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/terminal/JBTerminalPanel$TerminalEventDispatcher";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebugTerminalPanelName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "dispatch";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "dispatchKeyEvent";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

