/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.ConsoleActionsPostProcessor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.InputFilter;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.PtyBasedProcess;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.terminal.AppendableTerminalDataStream;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ProcessHandlerTtyConnector;
import com.intellij.terminal.TerminalConsoleContentHelper;
import com.intellij.terminal.TerminalExecutionConsoleBuilderKt;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.jediterm.terminal.util.CharUtils;
import com.pty4j.PtyProcess;
import com.pty4j.windows.conpty.WinConPtyProcess;
import java.awt.Color;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerminalExecutionConsole
implements ConsoleView,
ObservableConsoleView {
    private static final Logger LOG = Logger.getInstance(TerminalExecutionConsole.class);
    private final JBTerminalWidget myTerminalWidget;
    private final Project myProject;
    private final AppendableTerminalDataStream myDataStream;
    private final AtomicBoolean myAttachedToProcess;
    @NotNull
    private final InputFilter myInputMessageFilter;
    private volatile boolean myLastCR;
    private final TerminalConsoleContentHelper myContentHelper;
    private boolean myEnterKeyDefaultCodeEnabled;
    private boolean myConvertLfToCrlfForNonPtyProcess;
    private final AtomicBoolean myFirstOutput;

    @Deprecated
    public TerminalExecutionConsole(@NotNull Project project, @Nullable ProcessHandler processHandler) {
        if (project == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(0);
        }
        this(project, TerminalExecutionConsoleBuilderKt.DEFAULT_INITIAL_TERM_SIZE, TerminalExecutionConsoleBuilderKt.createDefaultConsoleSettingsProvider(), processHandler);
    }

    @Deprecated
    public TerminalExecutionConsole(@NotNull Project project, @Nullable ProcessHandler processHandler, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider) {
        if (project == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(1);
        }
        if (settingsProvider == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(2);
        }
        this(project, TerminalExecutionConsoleBuilderKt.DEFAULT_INITIAL_TERM_SIZE, settingsProvider, processHandler);
    }

    @Deprecated
    public TerminalExecutionConsole(@NotNull Project project, int columns, int lines, @Nullable ProcessHandler processHandler) {
        if (project == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(3);
        }
        this(project, new TermSize(columns, lines), TerminalExecutionConsoleBuilderKt.createDefaultConsoleSettingsProvider(), processHandler);
    }

    @Deprecated
    public TerminalExecutionConsole(@NotNull Project project, int columns, int lines, @Nullable ProcessHandler processHandler, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider) {
        if (project == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(4);
        }
        if (settingsProvider == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(5);
        }
        this(project, new TermSize(columns, lines), settingsProvider, processHandler);
    }

    private TerminalExecutionConsole(@NotNull Project project, @NotNull TermSize initialTermSize, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @Nullable ProcessHandler processHandler) {
        if (project == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(6);
        }
        if (initialTermSize == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(7);
        }
        if (settingsProvider == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(8);
        }
        this(project, initialTermSize, settingsProvider, false, processHandler);
    }

    TerminalExecutionConsole(@NotNull Project project, @NotNull TermSize initialTermSize, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider, boolean convertLfToCrlfForNonPtyProcess, @Nullable ProcessHandler processHandler) {
        if (project == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(9);
        }
        if (initialTermSize == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(10);
        }
        if (settingsProvider == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(11);
        }
        this.myAttachedToProcess = new AtomicBoolean(false);
        this.myLastCR = false;
        this.myContentHelper = new TerminalConsoleContentHelper(this);
        this.myEnterKeyDefaultCodeEnabled = true;
        this.myConvertLfToCrlfForNonPtyProcess = false;
        this.myFirstOutput = new AtomicBoolean(false);
        this.myProject = project;
        this.myDataStream = new AppendableTerminalDataStream();
        this.myTerminalWidget = new ConsoleTerminalWidget(project, initialTermSize.getColumns(), initialTermSize.getRows(), settingsProvider);
        this.myInputMessageFilter = ConsoleViewUtil.computeInputFilter((ConsoleView)this, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        this.myConvertLfToCrlfForNonPtyProcess = convertLfToCrlfForNonPtyProcess;
        if (processHandler != null) {
            this.attachToProcess(processHandler);
        }
    }

    @NotNull
    public JBTerminalWidget getTerminalWidget() {
        JBTerminalWidget jBTerminalWidget = this.myTerminalWidget;
        if (jBTerminalWidget == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(12);
        }
        return jBTerminalWidget;
    }

    private void printText(@NotNull String text, @Nullable ConsoleViewContentType contentType) throws IOException {
        Color foregroundColor;
        if (text == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(13);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("[" + Thread.currentThread().getName() + "] Print request received: " + CharUtils.toHumanReadableText((String)text));
        }
        Color color = foregroundColor = contentType != null ? contentType.getAttributes().getForegroundColor() : null;
        if (foregroundColor != null) {
            this.myDataStream.append(TerminalExecutionConsole.encodeColor(foregroundColor));
        }
        this.myDataStream.append(text);
        if (foregroundColor != null) {
            this.myDataStream.append("\u001b[39m");
        }
        this.myContentHelper.onContentTypePrinted(text, (ConsoleViewContentType)ObjectUtils.notNull((Object)contentType, (Object)ConsoleViewContentType.NORMAL_OUTPUT));
        if (this.myFirstOutput.compareAndSet(false, true) && contentType == ConsoleViewContentType.SYSTEM_OUTPUT && this.getProcess() instanceof WinConPtyProcess) {
            this.moveScreenToScrollbackBufferAndShowAllOutput();
        }
    }

    private void moveScreenToScrollbackBufferAndShowAllOutput() throws IOException {
        LOG.trace("Printing command line detected at the beginning of the output, scheduling a scroll command.");
        final BoundedRangeModel verticalScrollModel = this.myTerminalWidget.getTerminalPanel().getVerticalScrollModel();
        verticalScrollModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                verticalScrollModel.removeChangeListener(this);
                UiNotifyConnector.doWhenFirstShown((JComponent)((Object)TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel()), () -> TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel().scrollToShowAllOutput());
            }
        });
        this.myDataStream.append("\u001b[2J");
        this.myDataStream.append("\u001b[1;1H");
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(14);
        }
        if (parent == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(15);
        }
        this.myContentHelper.addChangeListener(listener2, parent);
    }

    @ApiStatus.Internal
    @RequiresEdt
    public void flushImmediately() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myContentHelper.flush();
    }

    @NotNull
    private static String encodeColor(@NotNull Color color) {
        if (color == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(16);
        }
        String string = "\u001b[38;2;" + color.getRed() + ";" + color.getGreen() + ";" + color.getBlue() + "m";
        if (string == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public TerminalExecutionConsole withEnterKeyDefaultCodeEnabled(boolean enterKeyDefaultCodeEnabled) {
        this.myEnterKeyDefaultCodeEnabled = enterKeyDefaultCodeEnabled;
        TerminalExecutionConsole terminalExecutionConsole = this;
        if (terminalExecutionConsole == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(18);
        }
        return terminalExecutionConsole;
    }

    @Deprecated
    @NotNull
    public TerminalExecutionConsole withConvertLfToCrlfForNonPtyProcess(boolean convertLfToCrlfForNonPtyProcess) {
        this.myConvertLfToCrlfForNonPtyProcess = convertLfToCrlfForNonPtyProcess;
        TerminalExecutionConsole terminalExecutionConsole = this;
        if (terminalExecutionConsole == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(19);
        }
        return terminalExecutionConsole;
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(20);
        }
        if (contentType == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(21);
        }
        String textCRLF = this.convertTextToCRLF(text);
        try {
            this.printText(textCRLF, contentType);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    private String convertTextToCRLF(@NotNull String text) {
        boolean preserveLastCR;
        if (text == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(22);
        }
        if (text.isEmpty()) {
            String string = text;
            if (string == null) {
                TerminalExecutionConsole.$$$reportNull$$$0(23);
            }
            return string;
        }
        boolean preserveFirstLF = text.startsWith(LineSeparator.LF.getSeparatorString()) && this.myLastCR;
        this.myLastCR = preserveLastCR = text.endsWith(LineSeparator.CR.getSeparatorString());
        String textToConvert = text.substring(preserveFirstLF ? 1 : 0, preserveLastCR ? text.length() - 1 : text.length());
        Object textCRLF = StringUtil.convertLineSeparators((String)textToConvert, (String)LineSeparator.CRLF.getSeparatorString());
        if (preserveFirstLF) {
            textCRLF = LineSeparator.LF.getSeparatorString() + (String)textCRLF;
        }
        if (preserveLastCR) {
            textCRLF = (String)textCRLF + LineSeparator.CR.getSeparatorString();
        }
        String string = textCRLF;
        if (string == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(24);
        }
        return string;
    }

    public void clear() {
        this.myLastCR = false;
        this.myTerminalWidget.getTerminalPanel().clearBuffer();
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(25);
        }
        this.attachToProcess(processHandler, true);
    }

    protected final void attachToProcess(@NotNull ProcessHandler processHandler, boolean attachToProcessOutput) {
        if (processHandler == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(26);
        }
        this.attachToProcess(processHandler, new ProcessHandlerTtyConnector(processHandler, EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset()), attachToProcessOutput);
    }

    public final void attachToProcess(@NotNull ProcessHandler processHandler, @NotNull TtyConnector ttyConnector, boolean attachToProcessOutput) {
        if (processHandler == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(27);
        }
        if (ttyConnector == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(28);
        }
        if (!this.myAttachedToProcess.compareAndSet(false, true)) {
            return;
        }
        this.myTerminalWidget.createTerminalSession(ttyConnector);
        this.myTerminalWidget.start();
        if (attachToProcessOutput) {
            final boolean isProcessWithPty = TerminalExecutionConsole.isProcessWithPty(processHandler);
            if (processHandler instanceof ColoredProcessHandler) {
                ColoredProcessHandler coloredProcessHandler = (ColoredProcessHandler)processHandler;
                coloredProcessHandler.addRawTextListener(new ColoredProcessHandler.RawTextListener(){

                    public void onRawTextAvailable(@NotNull String text, @NotNull Key<?> outputType) {
                        if (text == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        TerminalExecutionConsole.this.processProcessOutputText(text, outputType, isProcessWithPty);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "text";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/terminal/TerminalExecutionConsole$2";
                        objectArray[2] = "onRawTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            } else {
                processHandler.addProcessListener(new ProcessListener(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        TerminalExecutionConsole.this.processProcessOutputText(event.getText(), outputType, isProcessWithPty);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/terminal/TerminalExecutionConsole$3";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
        processHandler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                TerminalExecutionConsole.this.myAttachedToProcess.set(false);
                ApplicationManager.getApplication().invokeLater(() -> TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel().setCursorVisible(false), ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/terminal/TerminalExecutionConsole$4", "processTerminated"));
            }
        });
    }

    private void processProcessOutputText(@NotNull String text, @NotNull Key<?> outputType, boolean isProcessWithPty) {
        if (text == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(29);
        }
        if (outputType == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(30);
        }
        try {
            ConsoleViewContentType contentType = null;
            if (outputType != ProcessOutputTypes.STDOUT) {
                contentType = ConsoleViewContentType.getConsoleViewType(outputType);
            }
            if (outputType == ProcessOutputTypes.SYSTEM) {
                text = StringUtil.convertLineSeparators((String)text, (String)LineSeparator.CRLF.getSeparatorString());
            } else if (!isProcessWithPty && this.myConvertLfToCrlfForNonPtyProcess) {
                text = this.convertTextToCRLF(text);
            }
            ConsoleViewContentType notNullContentType = (ConsoleViewContentType)ObjectUtils.notNull((Object)contentType, (Object)ConsoleViewContentType.NORMAL_OUTPUT);
            List result2 = this.myInputMessageFilter.applyFilter(text, notNullContentType);
            if (result2 == null) {
                this.printText(text, contentType);
            } else {
                for (Pair pair : result2) {
                    if (pair.first == null) continue;
                    this.printText((String)pair.first, (ConsoleViewContentType)ObjectUtils.chooseNotNull((Object)((ConsoleViewContentType)pair.second), (Object)contentType));
                }
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static boolean isProcessWithPty(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(31);
        }
        if (processHandler instanceof BaseProcessHandler) {
            PtyBasedProcess ptyBasedProcess;
            BaseProcessHandler baseProcessHandler = (BaseProcessHandler)processHandler;
            Process process2 = baseProcessHandler.getProcess();
            return process2 instanceof PtyProcess || process2 instanceof PtyBasedProcess && (ptyBasedProcess = (PtyBasedProcess)process2).hasPty();
        }
        return false;
    }

    public void setOutputPaused(boolean value) {
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable) {
        if (runnable == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(32);
        }
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(33);
        }
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(34);
        }
        this.myTerminalWidget.addMessageFilter(filter);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(35);
        }
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    public AnAction @NotNull [] createConsoleActions() {
        AnAction[] result2 = new AnAction[]{new ScrollToTheEndAction(), new ClearAction()};
        List postProcessors = ConsoleActionsPostProcessor.EP_NAME.getExtensionList();
        for (ConsoleActionsPostProcessor postProcessor : postProcessors) {
            result2 = postProcessor.postProcess((ConsoleView)this, result2);
        }
        if (result2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(36);
        }
        return result2;
    }

    public void allowHeavyFilters() {
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myTerminalWidget.getComponent();
        if (jComponent == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(37);
        }
        return jComponent;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public void dispose() {
    }

    public static boolean isAcceptable(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(38);
        }
        return TerminalExecutionConsole.isProcessWithPty(processHandler);
    }

    @Nullable
    private Process getProcess() {
        ProcessHandlerTtyConnector phc = (ProcessHandlerTtyConnector)ObjectUtils.tryCast((Object)this.myTerminalWidget.getTtyConnector(), ProcessHandlerTtyConnector.class);
        return phc != null ? phc.getProcess() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 17, 18, 19, 23, 24, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialTermSize";
                break;
            }
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/TerminalExecutionConsole";
                break;
            }
            case 13: 
            case 20: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ttyConnector";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalWidget";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeColor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnterKeyDefaultCodeEnabled";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "withConvertLfToCrlfForNonPtyProcess";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTextToCRLF";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 36: 
            case 37: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "printText";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "encodeColor";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "convertTextToCRLF";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processProcessOutputText";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isProcessWithPty";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 17, 18, 19, 23, 24, 36, 37 -> new IllegalStateException(string);
        };
    }

    private final class ConsoleTerminalWidget
    extends JBTerminalWidget {
        private ConsoleTerminalWidget(Project project, int columns, @NotNull int lines, JBTerminalSystemSettingsProviderBase provider) {
            if (project == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(0);
            }
            if (provider == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(1);
            }
            super(project, columns, lines, provider, TerminalExecutionConsole.this, (Disposable)TerminalExecutionConsole.this);
        }

        @Override
        protected JBTerminalPanel createTerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull StyleState styleState, @NotNull TerminalTextBuffer textBuffer) {
            if (settingsProvider == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(2);
            }
            if (styleState == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(3);
            }
            if (textBuffer == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(4);
            }
            JBTerminalPanel panel2 = new JBTerminalPanel((JBTerminalSystemSettingsProviderBase)settingsProvider, textBuffer, styleState){

                public void clearBuffer() {
                    super.clearBuffer(false);
                }
            };
            Disposer.register((Disposable)this, (Disposable)panel2);
            return panel2;
        }

        protected TerminalStarter createTerminalStarter(@NotNull JediTerminal terminal, @NotNull TtyConnector connector) {
            if (terminal == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(5);
            }
            if (connector == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(6);
            }
            return new TerminalStarter(terminal, connector, TerminalExecutionConsole.this.myDataStream, TerminalExecutionConsole.this.myTerminalWidget.getTypeAheadManager(), this.getExecutorServiceManager()){

                public byte[] getCode(int key, int modifiers) {
                    if (key == 10 && modifiers == 0 && TerminalExecutionConsole.this.myEnterKeyDefaultCodeEnabled) {
                        byte[] byArray;
                        PtyProcess process2 = (PtyProcess)ObjectUtils.tryCast((Object)TerminalExecutionConsole.this.getProcess(), PtyProcess.class);
                        if (process2 != null) {
                            byte[] byArray2 = new byte[1];
                            byArray = byArray2;
                            byArray2[0] = process2.getEnterKeyCode();
                        } else {
                            byArray = LineSeparator.CR.getSeparatorBytes();
                        }
                        return byArray;
                    }
                    return super.getCode(key, modifiers);
                }
            };
        }

        @Override
        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(7);
            }
            super.uiDataSnapshot(sink);
            sink.set(LangDataKeys.CONSOLE_VIEW, (Object)TerminalExecutionConsole.this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingsProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "styleState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textBuffer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "terminal";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connector";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole$ConsoleTerminalWidget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTerminalPanel";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTerminalStarter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ScrollToTheEndAction
    extends DumbAwareAction {
        private ScrollToTheEndAction() {
            super(ActionsBundle.messagePointer((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]), ActionsBundle.messagePointer((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]), AllIcons.RunConfigurations.Scroll_down);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ScrollToTheEndAction.$$$reportNull$$$0(0);
            }
            BoundedRangeModel verticalScrollModel = TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel().getVerticalScrollModel();
            e.getPresentation().setEnabled(verticalScrollModel.getValue() != 0);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ScrollToTheEndAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ScrollToTheEndAction.$$$reportNull$$$0(2);
            }
            TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel().getVerticalScrollModel().setValue(0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/terminal/TerminalExecutionConsole$ScrollToTheEndAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole$ScrollToTheEndAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private final class ClearAction
    extends DumbAwareAction {
        private ClearAction() {
            super(ExecutionBundle.messagePointer((String)"clear.all.from.console.action.name", (Object[])new Object[0]), ExecutionBundle.messagePointer((String)"clear.all.from.console.action.text", (Object[])new Object[0]), AllIcons.Actions.GC);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ClearAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(2);
            }
            TerminalExecutionConsole.this.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/terminal/TerminalExecutionConsole$ClearAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole$ClearAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

