/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.AdditionalTabComponentManagerImpl;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogConsoleImpl;
import com.intellij.diagnostic.logging.LogConsoleManager;
import com.intellij.execution.configurations.AdditionalTabComponentManagerEx;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.UIExperiment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LogConsoleManagerBase
implements LogConsoleManager,
AdditionalTabComponentManagerEx {
    private final Project myProject;
    private final GlobalSearchScope mySearchScope;
    private final AdditionalTabComponentManagerEx myDelegate;

    protected LogConsoleManagerBase(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(1);
        }
        this(project, searchScope, null);
    }

    @ApiStatus.Internal
    protected LogConsoleManagerBase(@NotNull Project project, @NotNull GlobalSearchScope searchScope, @Nullable AdditionalTabComponentManagerEx delegate) {
        if (project == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.mySearchScope = searchScope;
        this.myDelegate = delegate != null ? delegate : new AdditionalTabComponentManagerImpl(this.getUi(), this.getDefaultIcon());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addLogConsole(@NlsContexts.TabTitle @NotNull String name, final @NotNull String path, @NotNull Charset charset, long skippedContent, @NotNull RunConfigurationBase runConfigurationBase) {
        void runConfiguration;
        if (name == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(4);
        }
        if (path == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(5);
        }
        if (charset == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(6);
        }
        if (runConfigurationBase == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(7);
        }
        boolean useBuildInActions = UIExperiment.isNewDebuggerUIEnabled();
        this.doAddLogConsole(new LogConsoleImpl(this.myProject, new File(path), charset, skippedContent, name, useBuildInActions, this.mySearchScope){

            @Override
            public boolean isActive() {
                return LogConsoleManagerBase.this.isConsoleActive(path);
            }
        }, path, this.getDefaultIcon(), (RunProfile)runConfiguration);
    }

    private void doAddLogConsole(final @NotNull LogConsoleBase log, String id, Icon icon, @Nullable RunProfile runProfile) {
        if (log == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(8);
        }
        if (runProfile instanceof RunConfigurationBase) {
            ((RunConfigurationBase)runProfile).customizeLogConsole((LogConsole)log);
        }
        log.attachStopLogConsoleTrackingListener(this.getProcessHandler());
        this.addAdditionalTabComponent(log, id, icon);
        this.getUi().addListener(new ContentManagerListener(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                log.activate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/logging/LogConsoleManagerBase$2", "selectionChanged"));
            }
        }, (Disposable)log);
    }

    private boolean isConsoleActive(String id) {
        Content content = this.getUi().findContent(id);
        return content != null && content.isSelected();
    }

    @Override
    public void removeLogConsole(@NotNull String path) {
        Content content;
        if (path == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(9);
        }
        if ((content = this.getUi().findContent(path)) != null) {
            this.removeAdditionalTabComponent((LogConsoleBase)((Object)content.getComponent()));
        }
    }

    public void addAdditionalTabComponent(@NotNull AdditionalTabComponent tabComponent, @NotNull String id) {
        if (tabComponent == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(10);
        }
        if (id == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(11);
        }
        this.myDelegate.addAdditionalTabComponent(tabComponent, id);
    }

    public Content addAdditionalTabComponent(@NotNull AdditionalTabComponent tabComponent, @NotNull String id, @Nullable Icon icon) {
        if (tabComponent == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(12);
        }
        if (id == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(13);
        }
        return this.addAdditionalTabComponent(tabComponent, id, icon, true);
    }

    @Nullable
    public Content addAdditionalTabComponent(@NotNull AdditionalTabComponent tabComponent, @NotNull String id, @Nullable Icon icon, boolean closeable) {
        if (tabComponent == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(14);
        }
        if (id == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(15);
        }
        return this.myDelegate.addAdditionalTabComponent(tabComponent, id, icon, closeable);
    }

    public void removeAdditionalTabComponent(@NotNull AdditionalTabComponent component) {
        if (component == null) {
            LogConsoleManagerBase.$$$reportNull$$$0(16);
        }
        this.myDelegate.removeAdditionalTabComponent(component);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDelegate);
    }

    protected abstract Icon getDefaultIcon();

    protected abstract RunnerLayoutUi getUi();

    public abstract ProcessHandler getProcessHandler();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabComponent";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/logging/LogConsoleManagerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addLogConsole";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doAddLogConsole";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "removeLogConsole";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addAdditionalTabComponent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAdditionalTabComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

