/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.logging.EditLogPatternDialog;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.SmartList;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class LogsFragment<T extends RunConfigurationBase<?>>
extends SettingsEditorFragment<T, JComponent> {
    private final Map<LogFileOptions, PredefinedLogFile> myLog2Predefined = new HashMap<LogFileOptions, PredefinedLogFile>();
    private final List<PredefinedLogFile> myUnresolvedPredefined = new SmartList();
    private final TableView<LogFileOptions> myFilesTable;
    private final ListTableModel<LogFileOptions> myModel;

    public LogsFragment() {
        super("log.monitor", DiagnosticBundle.message((String)"log.monitor.fragment.name", (Object[])new Object[0]), null, null, null, null, t -> !t.getLogFiles().isEmpty());
        this.setActionHint(ExecutionBundle.message((String)"the.ide.will.display.the.selected.logs.in.the.run.tool.window", (Object[])new Object[0]));
        TabNameColumnInfo TAB_NAME = new TabNameColumnInfo();
        FileColumnInfo FILE = new FileColumnInfo();
        MyIsActiveColumnInfo IS_SHOW = new MyIsActiveColumnInfo();
        MyIsSkipColumnInfo IS_SKIP_CONTENT = new MyIsSkipColumnInfo();
        this.myModel = new ListTableModel(new ColumnInfo[]{TAB_NAME, FILE, IS_SHOW, IS_SKIP_CONTENT});
        this.myFilesTable = new TableView(this.myModel);
        this.myFilesTable.getEmptyText().setText(DiagnosticBundle.message((String)"log.monitor.no.files", (Object[])new Object[0]));
        JTableHeader tableHeader = this.myFilesTable.getTableHeader();
        FontMetrics fontMetrics = tableHeader.getFontMetrics(tableHeader.getFont());
        int preferredWidth = fontMetrics.stringWidth(IS_SHOW.getName()) + 20;
        this.setUpColumnWidth(tableHeader, preferredWidth, 2);
        preferredWidth = fontMetrics.stringWidth(IS_SKIP_CONTENT.getName()) + 20;
        this.setUpColumnWidth(tableHeader, preferredWidth, 3);
        this.setUpColumnWidth(tableHeader, 100, 0);
        this.myFilesTable.setColumnSelectionAllowed(false);
        this.myFilesTable.setShowGrid(false);
        this.myFilesTable.setDragEnabled(false);
        this.myFilesTable.setShowHorizontalLines(false);
        this.myFilesTable.setShowVerticalLines(false);
        this.myFilesTable.setIntercellSpacing(new Dimension(0, 0));
        this.myFilesTable.setupEasyFocusTraversing();
        this.myComponent = ToolbarDecorator.createDecorator(this.myFilesTable).setToolbarPosition(ActionToolbarPosition.BOTTOM).setMinimumSize((Dimension)new JBDimension(0, 100)).setAddAction(button -> {
            ArrayList<LogFileOptions> newList = new ArrayList<LogFileOptions>(this.myModel.getItems());
            LogFileOptions newOptions = new LogFileOptions("", "", true);
            if (LogsFragment.showEditorDialog(newOptions)) {
                newList.add(newOptions);
                this.myModel.setItems(newList);
                int index = this.myModel.getRowCount() - 1;
                this.myModel.fireTableRowsInserted(index, index);
                this.myFilesTable.setRowSelectionInterval(index, index);
            }
        }).setRemoveAction(button -> {
            int i;
            TableUtil.stopEditing(this.myFilesTable);
            int[] selected = this.myFilesTable.getSelectedRows();
            if (selected.length == 0) {
                return;
            }
            for (i = selected.length - 1; i >= 0; --i) {
                this.myModel.removeRow(selected[i]);
            }
            for (i = selected.length - 1; i >= 0; --i) {
                int idx = selected[i];
                this.myModel.fireTableRowsDeleted(idx, idx);
            }
            int selection = selected[0];
            if (selection >= this.myModel.getRowCount()) {
                selection = this.myModel.getRowCount() - 1;
            }
            if (selection >= 0) {
                this.myFilesTable.setRowSelectionInterval(selection, selection);
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myFilesTable, true));
        }).setEditAction(button -> {
            int selectedRow = this.myFilesTable.getSelectedRow();
            LogsFragment.showEditorDialog((LogFileOptions)this.myFilesTable.getSelectedObject());
            this.myModel.fireTableDataChanged();
            this.myFilesTable.setRowSelectionInterval(selectedRow, selectedRow);
        }).setRemoveActionUpdater(e -> this.myFilesTable.getSelectedRowCount() >= 1 && !this.myLog2Predefined.containsKey(this.myFilesTable.getSelectedObject())).setEditActionUpdater(e -> this.myFilesTable.getSelectedRowCount() >= 1 && !this.myLog2Predefined.containsKey(this.myFilesTable.getSelectedObject()) && this.myFilesTable.getSelectedObject() != null).disableUpDownActions().createPanel();
    }

    private void setUpColumnWidth(JTableHeader tableHeader, int preferredWidth, int columnIdx) {
        this.myFilesTable.getColumnModel().getColumn(columnIdx).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        TableColumn tableColumn = tableHeader.getColumnModel().getColumn(columnIdx);
        tableColumn.setWidth(preferredWidth);
        tableColumn.setPreferredWidth(preferredWidth);
        tableColumn.setMinWidth(preferredWidth);
        tableColumn.setMaxWidth(preferredWidth);
    }

    protected void resetEditorFrom(@NotNull T configuration) {
        if (configuration == null) {
            LogsFragment.$$$reportNull$$$0(0);
        }
        ArrayList<LogFileOptions> list = new ArrayList<LogFileOptions>();
        List logFiles = configuration.getLogFiles();
        for (LogFileOptions setting2 : logFiles) {
            list.add(new LogFileOptions(setting2.getName(), setting2.getPathPattern(), setting2.isEnabled(), setting2.isSkipContent(), setting2.isShowAll()));
        }
        this.myLog2Predefined.clear();
        this.myUnresolvedPredefined.clear();
        List predefinedLogFiles = configuration.getPredefinedLogFiles();
        for (PredefinedLogFile predefinedLogFile : predefinedLogFiles) {
            PredefinedLogFile logFile = new PredefinedLogFile();
            logFile.copyFrom((BaseState)predefinedLogFile);
            LogFileOptions options = configuration.getOptionsForPredefinedLogFile(logFile);
            if (options != null) {
                this.myLog2Predefined.put(options, logFile);
                list.add(options);
                continue;
            }
            this.myUnresolvedPredefined.add(logFile);
        }
        this.myModel.setItems(list);
    }

    protected void applyEditorTo(@NotNull T configuration) {
        if (configuration == null) {
            LogsFragment.$$$reportNull$$$0(1);
        }
        configuration.removeAllLogFiles();
        configuration.removeAllPredefinedLogFiles();
        if (!this.isSelected()) {
            return;
        }
        for (int i = 0; i < this.myModel.getRowCount(); ++i) {
            LogFileOptions options = (LogFileOptions)this.myModel.getItem(i);
            if (Objects.equals(options.getPathPattern(), "")) continue;
            Boolean checked = (Boolean)this.myModel.getValueAt(i, 2);
            Boolean skipped = (Boolean)this.myModel.getValueAt(i, 3);
            PredefinedLogFile predefined = this.myLog2Predefined.get(options);
            if (predefined != null) {
                PredefinedLogFile file = new PredefinedLogFile();
                file.setId(predefined.getId());
                file.setEnabled(options.isEnabled());
                configuration.addPredefinedLogFile(file);
                continue;
            }
            configuration.addLogFile(options.getPathPattern(), options.getName(), checked.booleanValue(), skipped.booleanValue(), options.isShowAll());
        }
        for (PredefinedLogFile logFile : this.myUnresolvedPredefined) {
            configuration.addPredefinedLogFile(logFile);
        }
    }

    private static boolean showEditorDialog(@NotNull LogFileOptions options) {
        if (options == null) {
            LogsFragment.$$$reportNull$$$0(2);
        }
        EditLogPatternDialog dialog = new EditLogPatternDialog();
        dialog.init(options.getName(), options.getPathPattern(), options.isShowAll());
        if (dialog.showAndGet()) {
            options.setName(dialog.getName());
            options.setPathPattern(dialog.getLogPattern());
            options.setShowAll(dialog.isShowAllFiles());
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/logging/LogsFragment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showEditorDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class TabNameColumnInfo
    extends ColumnInfo<LogFileOptions, String> {
        TabNameColumnInfo() {
            super(DiagnosticBundle.message((String)"log.monitor.tab.name.column", (Object[])new Object[0]));
        }

        @Nullable
        public TableCellRenderer getRenderer(LogFileOptions options) {
            return new DefaultTableCellRenderer();
        }

        public String valueOf(LogFileOptions object) {
            return object.getName();
        }

        public void setValue(LogFileOptions options, String value) {
            options.setName(value);
        }

        public boolean isCellEditable(LogFileOptions o) {
            return !LogsFragment.this.myLog2Predefined.containsKey(o);
        }
    }

    private final class FileColumnInfo
    extends ColumnInfo<LogFileOptions, String> {
        FileColumnInfo() {
            super(DiagnosticBundle.message((String)"log.monitor.file.column", (Object[])new Object[0]));
        }

        public String valueOf(LogFileOptions object) {
            return object.getPathPattern();
        }

        public void setValue(LogFileOptions options, String value) {
            options.setPathPattern(value);
        }

        public boolean isCellEditable(LogFileOptions o) {
            return !LogsFragment.this.myLog2Predefined.containsKey(o);
        }

        @Nullable
        public TableCellEditor getEditor(LogFileOptions options) {
            return new LocalPathCellEditor();
        }
    }

    private final class MyIsActiveColumnInfo
    extends ColumnInfo<LogFileOptions, Boolean> {
        private MyIsActiveColumnInfo() {
            super(DiagnosticBundle.message((String)"log.monitor.is.active.column", (Object[])new Object[0]));
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(LogFileOptions object) {
            return object.isEnabled();
        }

        public boolean isCellEditable(LogFileOptions element) {
            return true;
        }

        public void setValue(LogFileOptions element, Boolean checked) {
            PredefinedLogFile predefinedLogFile = LogsFragment.this.myLog2Predefined.get(element);
            if (predefinedLogFile != null) {
                predefinedLogFile.setEnabled(checked.booleanValue());
            }
            element.setEnabled(checked.booleanValue());
        }
    }

    private final class MyIsSkipColumnInfo
    extends ColumnInfo<LogFileOptions, Boolean> {
        private MyIsSkipColumnInfo() {
            super(DiagnosticBundle.message((String)"log.monitor.is.skipped.column", (Object[])new Object[0]));
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(LogFileOptions element) {
            return element.isSkipContent();
        }

        public boolean isCellEditable(LogFileOptions element) {
            return !LogsFragment.this.myLog2Predefined.containsKey(element);
        }

        public void setValue(LogFileOptions element, Boolean skipped) {
            element.setSkipContent(skipped.booleanValue());
        }
    }
}

