/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.SuggestUsingRunDashBoardUtil;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.statistics.RunConfigurationOptionUsagesCollector;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunConfigurationStartHistory;
import com.intellij.icons.AllIcons;
import com.intellij.idea.AppMode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContextAction
extends BaseRunConfigurationAction {
    private final Executor myExecutor;

    public RunContextAction(@NotNull Executor executor) {
        if (executor == null) {
            RunContextAction.$$$reportNull$$$0(0);
        }
        super((Supplier<String>)ExecutionBundle.messagePointer((String)"perform.action.with.context.configuration.action.name", (Object[])new Object[]{executor.getStartActionText()}), (Supplier<String>)Presentation.NULL_STRING, () -> ((Executor)executor).getIcon());
        this.myExecutor = executor;
    }

    @Override
    protected void perform(@NotNull RunnerAndConfigurationSettings configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            RunContextAction.$$$reportNull$$$0(1);
        }
        if (context == null) {
            RunContextAction.$$$reportNull$$$0(2);
        }
        RunManagerEx runManager = (RunManagerEx)context.getRunManager();
        DataContext dataContext = context.getDefaultDataContext();
        ReadAction.nonBlocking(() -> this.findExisting(context)).finishOnUiThread(ModalityState.nonModal(), existingConfiguration -> {
            if (configuration != existingConfiguration) {
                RunConfigurationOptionUsagesCollector.logAddNew(context.getProject(), configuration.getType().getId(), context.getPlace());
                runManager.setTemporaryConfiguration(configuration);
                this.perform(runManager, configuration, dataContext);
            } else {
                this.perform(runManager, configuration, dataContext);
            }
        }).submit((java.util.concurrent.Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void perform(RunManagerEx runManager, RunnerAndConfigurationSettings configuration, DataContext dataContext) {
        if (runManager.shouldSetRunConfigurationFromContext()) {
            runManager.setSelectedConfiguration(configuration);
            RunConfigurationStartHistory.getInstance(configuration.getConfiguration().getProject()).register(configuration);
        }
        if (LOG.isDebugEnabled()) {
            String configurationClass = configuration.getConfiguration().getClass().getName();
            LOG.debug(String.format("Execute run configuration: %s", configurationClass));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !AppMode.isRunningFromDevBuild()) {
            return;
        }
        ExecutionUtil.doRunConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)this.myExecutor, null, null, (DataContext)dataContext);
    }

    @Override
    protected boolean isEnabledFor(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            RunContextAction.$$$reportNull$$$0(3);
        }
        return this.getRunner(configuration) != null;
    }

    @Nullable
    private ProgramRunner<?> getRunner(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            RunContextAction.$$$reportNull$$$0(4);
        }
        return ProgramRunner.getRunner((String)this.myExecutor.getId(), (RunProfile)configuration);
    }

    @Override
    protected void updatePresentation(@NotNull Presentation presentation, @NotNull String actionText, ConfigurationContext context) {
        if (presentation == null) {
            RunContextAction.$$$reportNull$$$0(5);
        }
        if (actionText == null) {
            RunContextAction.$$$reportNull$$$0(6);
        }
        presentation.setText(this.myExecutor.getStartActionText(actionText), true);
        Pair<Boolean, Boolean> b = this.isEnabledAndVisible(context);
        presentation.setEnabled(((Boolean)b.first).booleanValue());
        presentation.setVisible(((Boolean)b.second).booleanValue());
    }

    private Pair<Boolean, Boolean> isEnabledAndVisible(@NotNull ConfigurationContext context) {
        ProgramRunner<?> runner;
        RunnerAndConfigurationSettings configuration;
        if (context == null) {
            RunContextAction.$$$reportNull$$$0(7);
        }
        if ((configuration = this.findExisting(context)) == null) {
            configuration = context.getConfiguration();
        }
        ProgramRunner<?> programRunner = runner = configuration == null ? null : this.getRunner(configuration.getConfiguration());
        if (runner == null) {
            return Pair.create((Object)false, (Object)false);
        }
        Project project = context.getProject();
        return Pair.create((Object)(!ExecutionManager.getInstance((Project)project).isStarting(configuration.getUniqueID(), this.myExecutor.getId(), runner.getRunnerId()) ? 1 : 0), (Object)true);
    }

    @Override
    @NotNull
    protected List<AnAction> createChildActions(@NotNull ConfigurationContext context, @NotNull List<? extends ConfigurationFromContext> configurations) {
        if (context == null) {
            RunContextAction.$$$reportNull$$$0(8);
        }
        if (configurations == null) {
            RunContextAction.$$$reportNull$$$0(9);
        }
        ArrayList<AnAction> childActions = new ArrayList<AnAction>(super.createChildActions(context, configurations));
        boolean isMultipleConfigurationsFromAlternativeLocations = configurations.size() > 1 && configurations.get(0).isFromAlternativeLocation();
        boolean isRunAction = this.myExecutor.getId().equals("Run");
        if (isMultipleConfigurationsFromAlternativeLocations && isRunAction) {
            childActions.add(this.runAllConfigurationsAction(context, configurations));
        }
        ArrayList<AnAction> arrayList = childActions;
        if (arrayList == null) {
            RunContextAction.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private AnAction runAllConfigurationsAction(final @NotNull ConfigurationContext context, final @NotNull List<? extends ConfigurationFromContext> configurationsFromContext) {
        if (context == null) {
            RunContextAction.$$$reportNull$$$0(11);
        }
        if (configurationsFromContext == null) {
            RunContextAction.$$$reportNull$$$0(12);
        }
        return new AnAction(CommonBundle.message((String)"action.text.run.all", (Object[])new Object[0]), ExecutionBundle.message((String)"run.all.configurations.available.in.this.context", (Object[])new Object[0]), AllIcons.RunConfigurations.Compound){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                long groupId = ExecutionEnvironment.getNextUnusedExecutionId();
                List types = ContainerUtil.map((Collection)configurationsFromContext, context1 -> context1.getConfiguration().getType());
                SuggestUsingRunDashBoardUtil.promptUserToUseRunDashboard(context.getProject(), types);
                for (ConfigurationFromContext configuration : configurationsFromContext) {
                    ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration.getConfigurationSettings(), (Executor)RunContextAction.this.myExecutor, (long)groupId);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/actions/RunContextAction$1", "actionPerformed"));
            }
        };
    }

    public Executor getExecutor() {
        return this.myExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/RunContextAction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationsFromContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/RunContextAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRunner";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledAndVisible";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createChildActions";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runAllConfigurationsAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

