/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.compound;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsSafe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigurationSelectionUtil {
    @NotNull
    @NlsSafe
    public static String getDisplayText(@NotNull RunConfiguration configuration, @Nullable ExecutionTarget target) {
        if (configuration == null) {
            ConfigurationSelectionUtil.$$$reportNull$$$0(0);
        }
        String string = configuration.getType().getDisplayName() + " '" + configuration.getName() + "'" + (String)(target != null && target != DefaultExecutionTarget.INSTANCE && !target.isExternallyManaged() ? " | " + target.getDisplayName() : "");
        if (string == null) {
            ConfigurationSelectionUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static ListPopup createPopup(final @NotNull Project project, final @NotNull RunManagerImpl runManager, final @NotNull List<? extends RunConfiguration> configurations, final @NotNull BiConsumer<? super List<RunConfiguration>, ? super ExecutionTarget> onSelected) {
        if (project == null) {
            ConfigurationSelectionUtil.$$$reportNull$$$0(2);
        }
        if (runManager == null) {
            ConfigurationSelectionUtil.$$$reportNull$$$0(3);
        }
        if (configurations == null) {
            ConfigurationSelectionUtil.$$$reportNull$$$0(4);
        }
        if (onSelected == null) {
            ConfigurationSelectionUtil.$$$reportNull$$$0(5);
        }
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)new MultiSelectionListPopupStep<RunConfiguration>(null, configurations){

            @Nullable
            public ListSeparator getSeparatorAbove(RunConfiguration value) {
                int i = configurations.indexOf(value);
                if (i < 1) {
                    return null;
                }
                RunConfiguration previous2 = (RunConfiguration)configurations.get(i - 1);
                return value.getType() != previous2.getType() ? new ListSeparator() : null;
            }

            public Icon getIconFor(RunConfiguration value) {
                return value.getType().getIcon();
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @NotNull
            public String getTextFor(RunConfiguration value) {
                String string = value.getName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep<?> onChosen(final List<RunConfiguration> selectedConfigs, boolean finalChoice) {
                if (finalChoice) {
                    onSelected.accept(selectedConfigs, null);
                    return FINAL_CHOICE;
                }
                return new BaseListPopupStep<ExecutionTarget>(null, this.getTargets(selectedConfigs)){

                    public boolean isSpeedSearchEnabled() {
                        return true;
                    }

                    public Icon getIconFor(ExecutionTarget value) {
                        return value.getIcon();
                    }

                    @NotNull
                    public String getTextFor(ExecutionTarget value) {
                        String string = value.getDisplayName();
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public PopupStep<?> onChosen(ExecutionTarget selectedTarget, boolean finalChoice) {
                        onSelected.accept(selectedConfigs, selectedTarget);
                        return FINAL_CHOICE;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/compound/ConfigurationSelectionUtil$1$1", "getTextFor"));
                    }
                };
            }

            public boolean hasSubstep(List<? extends RunConfiguration> selectedValues) {
                return !this.getTargets(selectedValues).isEmpty();
            }

            @NotNull
            public List<ExecutionTarget> getTargets(List<? extends RunConfiguration> selectedValues) {
                LinkedHashSet intersection = new LinkedHashSet();
                for (int i = 0; i < selectedValues.size(); ++i) {
                    List targets;
                    RunConfiguration config = selectedValues.get(i);
                    RunnerAndConfigurationSettingsImpl settings = runManager.getSettings(config);
                    List list = targets = settings == null ? Collections.emptyList() : ExecutionTargetManager.getTargetsToChooseFor((Project)project, (RunConfiguration)settings.getConfiguration());
                    if (i == 0) {
                        intersection.addAll(targets);
                        continue;
                    }
                    intersection.retainAll(targets);
                }
                return new ArrayList<ExecutionTarget>(intersection);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/compound/ConfigurationSelectionUtil$1", "getTextFor"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/compound/ConfigurationSelectionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSelected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/compound/ConfigurationSelectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayText";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

