/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public abstract class AbstractFileHyperlinkFilter
implements Filter {
    private static final Logger LOG = Logger.getInstance(AbstractFileHyperlinkFilter.class);
    private final Project myProject;
    private ProjectFileIndex myFileIndex;
    private final VirtualFile myBaseDir;

    public AbstractFileHyperlinkFilter(@NotNull Project project, @Nullable String baseDir) {
        if (project == null) {
            AbstractFileHyperlinkFilter.$$$reportNull$$$0(0);
        }
        this(project, AbstractFileHyperlinkFilter.findDir(baseDir));
    }

    public AbstractFileHyperlinkFilter(@NotNull Project project, @Nullable VirtualFile baseDir) {
        if (project == null) {
            AbstractFileHyperlinkFilter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myBaseDir = baseDir;
    }

    @Nullable
    protected static VirtualFile findDir(@Nullable String baseDir) {
        if (StringUtil.isEmpty((String)baseDir)) {
            return null;
        }
        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(baseDir);
        return dir != null && dir.isValid() && dir.isDirectory() ? dir : null;
    }

    protected boolean supportVfsRefresh() {
        return false;
    }

    @Nullable
    public final Filter.Result applyFilter(@NotNull String line, int entireLength) {
        List<FileHyperlinkRawData> links;
        if (line == null) {
            AbstractFileHyperlinkFilter.$$$reportNull$$$0(2);
        }
        try {
            links = this.parse(line);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to parse '" + line + "' with " + String.valueOf(this.getClass()), (Throwable)e);
            return null;
        }
        ArrayList<Filter.ResultItem> items = new ArrayList<Filter.ResultItem>();
        for (FileHyperlinkRawData link : links) {
            File ioFile;
            String filePath = FileUtil.toSystemIndependentName((String)link.getFilePath());
            if (StringUtil.isEmptyOrSpaces((String)filePath)) continue;
            VirtualFile file = this.findFile(filePath);
            Object info = null;
            boolean grayedHyperLink = false;
            if (file != null) {
                info = new OpenFileHyperlinkInfo(this.myProject, file, link.getDocumentLine(), link.getDocumentColumn(), link.getIsUseBrowser());
                grayedHyperLink = this.isGrayedHyperlink(file);
            } else if (this.supportVfsRefresh() && (ioFile = this.findIoFile(filePath)) != null) {
                info = new MyFileHyperlinkInfo(ioFile, link.getDocumentLine(), link.getDocumentColumn());
            }
            if (info == null) continue;
            int offset = entireLength - line.length();
            items.add(new Filter.ResultItem(offset + link.getHyperlinkStartInd(), offset + link.getHyperlinkEndInd(), (HyperlinkInfo)info, grayedHyperLink));
        }
        return items.isEmpty() ? null : new Filter.Result(items);
    }

    @Nullable
    private File findIoFile(@NotNull String filePath) {
        File ioFile;
        if (filePath == null) {
            AbstractFileHyperlinkFilter.$$$reportNull$$$0(3);
        }
        if ((ioFile = new File(filePath)).isAbsolute() && ioFile.isFile()) {
            return ioFile;
        }
        if (this.myBaseDir != null && (ioFile = new File(this.myBaseDir.getPath(), filePath)).isFile()) {
            return ioFile;
        }
        return null;
    }

    private boolean isGrayedHyperlink(@NotNull VirtualFile file) {
        if (file == null) {
            AbstractFileHyperlinkFilter.$$$reportNull$$$0(4);
        }
        if (this.myProject.isDefault()) {
            return true;
        }
        ProjectFileIndex fileIndex = this.getFileIndex();
        return !fileIndex.isInContent(file) || fileIndex.isInLibrary(file);
    }

    @NotNull
    private ProjectFileIndex getFileIndex() {
        ProjectFileIndex fileIndex = this.myFileIndex;
        if (fileIndex == null) {
            this.myFileIndex = fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        }
        ProjectFileIndex projectFileIndex = fileIndex;
        if (projectFileIndex == null) {
            AbstractFileHyperlinkFilter.$$$reportNull$$$0(5);
        }
        return projectFileIndex;
    }

    @NotNull
    public abstract List<FileHyperlinkRawData> parse(@NotNull String var1);

    @Nullable
    public VirtualFile findFile(@NotNull String filePath) {
        VirtualFile file;
        if (filePath == null) {
            AbstractFileHyperlinkFilter.$$$reportNull$$$0(6);
        }
        if ((file = LocalFileFinder.findFile((String)filePath)) == null && SystemInfo.isWindows && OSAgnosticPathUtil.isUncPath((String)filePath)) {
            file = LocalFileSystem.getInstance().findFileByPath(filePath);
        }
        if (file == null && this.myBaseDir != null && this.myBaseDir.isValid()) {
            file = this.myBaseDir.findFileByRelativePath(filePath);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/AbstractFileHyperlinkFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/AbstractFileHyperlinkFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findIoFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isGrayedHyperlink";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static final class MyFileHyperlinkInfo
    implements HyperlinkInfo {
        private final File myIoFile;
        private final int myDocumentLine;
        private final int myDocumentColumn;
        private Ref<VirtualFile> myFileRef;

        MyFileHyperlinkInfo(@NotNull File ioFile, int documentLine, int documentColumn) {
            if (ioFile == null) {
                MyFileHyperlinkInfo.$$$reportNull$$$0(0);
            }
            this.myIoFile = ioFile;
            this.myDocumentLine = documentLine;
            this.myDocumentColumn = documentColumn;
        }

        public void navigate(@NotNull Project project) {
            Ref fileRef;
            if (project == null) {
                MyFileHyperlinkInfo.$$$reportNull$$$0(1);
            }
            if ((fileRef = this.myFileRef) == null) {
                VirtualFile file = (VirtualFile)WriteAction.compute(() -> VfsUtil.findFileByIoFile((File)this.myIoFile, (boolean)true));
                this.myFileRef = fileRef = Ref.create((Object)file);
            }
            if (fileRef.get() != null) {
                OpenFileHyperlinkInfo linkInfo = new OpenFileHyperlinkInfo(project, (VirtualFile)fileRef.get(), this.myDocumentLine, this.myDocumentColumn);
                linkInfo.navigate(project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ioFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/filters/AbstractFileHyperlinkFilter$MyFileHyperlinkInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "navigate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

