/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.CommonBundle;
import com.intellij.build.BuildContentManager;
import com.intellij.concurrency.IntelliJContextElement;
import com.intellij.concurrency.ThreadContext;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunContentDescriptorId;
import com.intellij.execution.RunContentDescriptorIdImplKt;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.CompatibilityAwareRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.ExecutionManagerImplKt;
import com.intellij.execution.impl.InProgressEntry;
import com.intellij.execution.impl.ProcessExecutionListener;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.impl.RunContentDescriptorLifecycleListener;
import com.intellij.execution.impl.RunContentDescriptorLifecycleListenerKt;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.execution.impl.RunningConfigurationEntry;
import com.intellij.execution.impl.TargetPrepareComponent;
import com.intellij.execution.impl.statistics.RunConfigurationUsageTriggerCollector;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.Alarm;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.ui.EDT;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 m2\u00020\u00012\u00020\u0002:\u0002mnB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0002J&\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0014\u0010$\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010'0&0%H\u0017J\u0018\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u0014H\u0016J$\u0010)\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0%H\u0002J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u0010\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u00020\u001dH\u0016J\r\u00101\u001a\u000702\u00a2\u0006\u0002\b3H\u0016J\u0013\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0016\u00a2\u0006\u0002\u00107J,\u00108\u001a\u00020\u001d2\n\u00109\u001a\u00060:j\u0002`;2\u0006\u0010\u001e\u001a\u00020\u00142\u000e\u0010<\u001a\n\u0018\u00010:j\u0004\u0018\u0001`;H\u0016J\u001c\u0010=\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\n\u00109\u001a\u00060:j\u0002`;H\u0002JF\u0010>\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010/2\b\u0010C\u001a\u0004\u0018\u0001062\u0010\u0010D\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0014\u0018\u00010EH\u0016J\u0010\u0010>\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0016J \u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010G0&2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010H\u001a\u00020IH\u0016J\"\u0010J\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\n2\b\b\u0002\u0010L\u001a\u00020\nH\u0007J\u0018\u0010M\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010L\u001a\u00020\nH\u0002JE\u0010J\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u000f\u0010N\u001a\u000b\u0012\u0002\b\u00030O\u00a2\u0006\u0002\b32\u0006\u0010L\u001a\u00020\n2\u000b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b32\r\u0010P\u001a\t\u0018\u00010/\u00a2\u0006\u0002\bQH\u0014J*\u0010R\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\b\u0010S\u001a\u0004\u0018\u00010\u0013H\u0015J\u0018\u0010T\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010!\u001a\u00020UH\u0015J \u0010V\u001a\u00020\n2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020X2\u0006\u0010Z\u001a\u00020XH\u0016J.\u0010V\u001a\u00020\n2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020X2\u0006\u0010Z\u001a\u00020XH\u0002J&\u0010\\\u001a\b\u0012\u0004\u0012\u00020\n0]2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020X2\u0006\u0010Z\u001a\u00020XH\u0017J\u001c\u0010^\u001a\u00020\u001d2\n\u0010_\u001a\u00060:j\u0002`;2\u0006\u0010`\u001a\u00020aH\u0002J\u0016\u0010b\u001a\b\u0012\u0004\u0012\u00020'0c2\u0006\u0010d\u001a\u00020/H\u0002J\u001e\u0010e\u001a\b\u0012\u0004\u0012\u00020'0c2\u000e\u0010f\u001a\n\u0012\u0006\b\u0000\u0012\u00020/0gH\u0016J\u001c\u0010h\u001a\b\u0012\u0004\u0012\u00020'0c2\u000e\u0010f\u001a\n\u0012\u0006\b\u0000\u0012\u00020/0gJ\u0016\u0010i\u001a\b\u0012\u0004\u0012\u00020-0\u001a2\u0006\u0010j\u001a\u00020'H\u0016J\u0014\u0010k\u001a\b\u0012\u0004\u0012\u00020/0\u001a2\u0006\u0010j\u001a\u00020'J\u0014\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\u0006\u0010j\u001a\u00020'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\n@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Lcom/intellij/execution/impl/ExecutionManagerImpl;", "Lcom/intellij/execution/ExecutionManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "forceCompilationInTests", "", "getForceCompilationInTests", "()Z", "setForceCompilationInTests", "(Z)V", "awaitingTerminationAlarm", "Lcom/intellij/util/Alarm;", "awaitingRunProfiles", "Ljava/util/HashMap;", "Lcom/intellij/execution/configurations/RunProfile;", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "runningConfigurations", "", "Lcom/intellij/execution/impl/RunningConfigurationEntry;", "inProgress", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/intellij/execution/impl/InProgressEntry;", "processNotStarted", "", "environment", "activity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "e", "", "startRunProfile", "starter", "Lkotlin/Function0;", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "Lcom/intellij/execution/RunProfileStarter;", "doStartRunProfile", "task", "registerRecentExecutor", "getRecentExecutor", "Lcom/intellij/execution/Executor;", "setting", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "dispose", "getContentManager", "Lcom/intellij/execution/ui/RunContentManager;", "Lorg/jetbrains/annotations/NotNull;", "getRunningProcesses", "", "Lcom/intellij/execution/process/ProcessHandler;", "()[Lcom/intellij/execution/process/ProcessHandler;", "compileAndRun", "startRunnable", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "onCancelRunnable", "doRun", "restartRunProfile", "executor", "target", "Lcom/intellij/execution/ExecutionTarget;", "configuration", "processHandler", "environmentCustomization", "Ljava/util/function/Consumer;", "executePreparationTasks", "", "currentState", "Lcom/intellij/execution/configurations/RunProfileState;", "executeConfiguration", "showSettings", "assignNewId", "editConfigurationUntilSuccess", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "runnerAndConfigurationSettings", "Lorg/jetbrains/annotations/Nullable;", "handleProgramRunnerExecutionError", "profile", "handleExecutionError", "Lcom/intellij/execution/ExecutionException;", "isStarting", "configurationId", "", "executorId", "runnerId", "inProgressEntries", "isStartingFlow", "Lkotlinx/coroutines/flow/Flow;", "awaitTermination", "request", "delayMillis", "", "getIncompatibleRunningDescriptors", "", "configurationAndSettings", "getRunningDescriptors", "condition", "Lcom/intellij/openapi/util/Condition;", "getDescriptors", "getExecutors", "descriptor", "getConfigurations", "getExecutionEnvironments", "Companion", "MyProcessHandler", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nExecutionManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionManagerImpl.kt\ncom/intellij/execution/impl/ExecutionManagerImpl\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1181:1\n230#2,5:1182\n230#2,5:1187\n230#2,5:1198\n230#2,5:1203\n230#2,5:1208\n1#3:1192\n37#4,2:1193\n1807#5,3:1195\n13#6:1213\n*S KotlinDebug\n*F\n+ 1 ExecutionManagerImpl.kt\ncom/intellij/execution/impl/ExecutionManagerImpl\n*L\n226#1:1182,5\n286#1:1187,5\n343#1:1198,5\n786#1:1203,5\n783#1:1208,5\n417#1:1193,2\n885#1:1195,3\n87#1:1213\n*E\n"})
public class ExecutionManagerImpl
extends ExecutionManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    private volatile boolean forceCompilationInTests;
    @NotNull
    private final Alarm awaitingTerminationAlarm;
    @NotNull
    private final HashMap<RunProfile, ExecutionEnvironment> awaitingRunProfiles;
    @NotNull
    private final List<RunningConfigurationEntry> runningConfigurations;
    @NotNull
    private final MutableStateFlow<Set<InProgressEntry>> inProgress;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ProcessHandler[] EMPTY_PROCESS_HANDLERS;
    @NotNull
    private static final Key<RunProfile> DELEGATED_RUN_PROFILE_KEY;
    @JvmField
    @NotNull
    public static final Key<Object> EXECUTION_SESSION_ID_KEY;
    @JvmField
    @NotNull
    public static final Key<Boolean> EXECUTION_SKIP_RUN;
    @NotNull
    private static final Key<Boolean> TERMINATING_FOR_RERUN;
    @NotNull
    private static final Key<Boolean> REPORT_NEXT_START_AS_RERUN;
    @NotNull
    private static final Key<StructuredIdeActivity> PARENT_PROFILE_IDE_ACTIVITY;

    public ExecutionManagerImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        SimpleMessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(this.coroutineScope);
        connection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

            public void projectClosed(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (project == project) {
                    Set nextValue$iv;
                    Object prevValue$iv;
                    MutableStateFlow $this$update$iv = inProgress;
                    boolean $i$f$update = false;
                    do {
                        prevValue$iv = $this$update$iv.getValue();
                        Set it = (Set)prevValue$iv;
                        boolean bl = false;
                    } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SetsKt.emptySet())));
                }
            }
        });
        this.awaitingTerminationAlarm = new Alarm(this.coroutineScope, Alarm.ThreadToUse.SWING_THREAD);
        this.awaitingRunProfiles = new HashMap();
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.runningConfigurations = list;
        this.inProgress = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());
    }

    public final boolean getForceCompilationInTests() {
        return this.forceCompilationInTests;
    }

    @TestOnly
    public final void setForceCompilationInTests(boolean bl) {
        this.forceCompilationInTests = bl;
    }

    private final void processNotStarted(ExecutionEnvironment environment, StructuredIdeActivity activity, Throwable e) {
        Set it;
        Set nextValue$iv;
        Object prevValue$iv;
        RunConfigurationUsageTriggerCollector.logProcessFinished(activity, RunConfigurationUsageTriggerCollector.RunConfigurationFinishType.FAILED_TO_START);
        String string = environment.getExecutor().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String executorId = string;
        Object object = environment.getRunnerAndConfigurationSettings();
        if (object == null || (object = object.getUniqueID()) == null) {
            object = "";
        }
        String string2 = environment.getRunner().getRunnerId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRunnerId(...)");
        InProgressEntry inProgressEntry = new InProgressEntry((String)object, executorId, string2);
        MutableStateFlow<Set<InProgressEntry>> $this$update$iv = this.inProgress;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (Set)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SetsKt.minus((Set)it, (Object)inProgressEntry))));
        ProgramRunner.Callback callback = environment.getCallback();
        if (callback != null) {
            callback.processNotStarted(e);
        }
        ((ExecutionListener)this.project.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processNotStarted(executorId, environment, e);
    }

    static /* synthetic */ void processNotStarted$default(ExecutionManagerImpl executionManagerImpl, ExecutionEnvironment executionEnvironment, StructuredIdeActivity structuredIdeActivity, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processNotStarted");
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        executionManagerImpl.processNotStarted(executionEnvironment, structuredIdeActivity, throwable);
    }

    @ApiStatus.Internal
    public void startRunProfile(@NotNull ExecutionEnvironment environment, @NotNull Function0<? extends Promise<RunContentDescriptor>> starter) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(starter, (String)"starter");
        this.doStartRunProfile(environment, (Function0<? extends Promise<RunContentDescriptor>>)((Function0)() -> ExecutionManagerImpl.startRunProfile$lambda$0(starter, environment)));
    }

    public void startRunProfile(@NotNull RunProfileStarter starter, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)starter, (String)"starter");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.doStartRunProfile(environment, (Function0<? extends Promise<RunContentDescriptor>>)((Function0)() -> ExecutionManagerImpl.startRunProfile$lambda$1(starter, environment)));
    }

    private final void doStartRunProfile(ExecutionEnvironment environment, Function0<? extends Promise<RunContentDescriptor>> task2) {
        Set it;
        Set nextValue$iv;
        Object prevValue$iv;
        StructuredIdeActivity activity = ExecutionManagerImplKt.access$triggerUsage(environment);
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RunManager runManager = RunManager.Companion.getInstance(project);
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
        runManager.refreshUsagesList(runProfile);
        Project project2 = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        RunContentDescriptor reuseContent = RunContentManager.getInstance((Project)project3).getReuseContent(environment);
        if (reuseContent != null) {
            reuseContent.setExecutionId(environment.getExecutionId());
            environment.setContentToReuse(reuseContent);
        }
        Executor executor = environment.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getExecutor(...)");
        Executor executor2 = executor;
        Object object = environment.getRunnerAndConfigurationSettings();
        if (object == null || (object = object.getUniqueID()) == null) {
            object = "";
        }
        String string = executor2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = environment.getRunner().getRunnerId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRunnerId(...)");
        InProgressEntry inProgressEntry = new InProgressEntry((String)object, string, string2);
        MutableStateFlow<Set<InProgressEntry>> $this$update$iv = this.inProgress;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (Set)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SetsKt.plus((Set)it, (Object)inProgressEntry))));
        ((ExecutionListener)project3.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processStartScheduled(executor2.getId(), environment);
        this.registerRecentExecutor(environment);
        Runnable startRunnable2 = () -> ExecutionManagerImpl.doStartRunProfile$lambda$1(project3, executor2, environment, task2, this, activity, inProgressEntry);
        if (!this.forceCompilationInTests && ApplicationManager.getApplication().isUnitTestMode()) {
            startRunnable2.run();
        } else {
            this.compileAndRun(() -> ExecutionManagerImpl.doStartRunProfile$lambda$2(startRunnable2, project3), environment, () -> ExecutionManagerImpl.doStartRunProfile$lambda$3(project3, this, environment, activity));
        }
    }

    private final void registerRecentExecutor(ExecutionEnvironment environment) {
        block0: {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
            if (runnerAndConfigurationSettings == null) break block0;
            RunnerAndConfigurationSettings it = runnerAndConfigurationSettings;
            boolean bl = false;
            PropertiesComponent.getInstance((Project)this.project).setValue(it.getUniqueID() + ".executor", environment.getExecutor().getId());
        }
    }

    @Nullable
    public final Executor getRecentExecutor(@NotNull RunnerAndConfigurationSettings setting2) {
        Executor executor;
        String executorId;
        Intrinsics.checkNotNullParameter((Object)setting2, (String)"setting");
        String string = executorId = PropertiesComponent.getInstance((Project)this.project).getValue(setting2.getUniqueID() + ".executor");
        if (string != null) {
            String it = string;
            boolean bl = false;
            executor = ExecutorRegistry.getInstance().getExecutorById(it);
        } else {
            executor = null;
        }
        return executor;
    }

    public void dispose() {
        for (RunningConfigurationEntry entry : this.runningConfigurations) {
            Disposer.dispose((Disposable)((Disposable)entry.getDescriptor()));
        }
        this.runningConfigurations.clear();
    }

    @NotNull
    public RunContentManager getContentManager() {
        RunContentManager runContentManager = RunContentManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)runContentManager, (String)"getInstance(...)");
        return runContentManager;
    }

    @NotNull
    public ProcessHandler[] getRunningProcesses() {
        ProcessHandler[] processHandlerArray;
        block6: {
            block5: {
                Object handlers = null;
                for (RunContentDescriptor descriptor : Companion.getAllDescriptors(this.project)) {
                    ProcessHandler processHandler;
                    if (descriptor.getProcessHandler() == null) continue;
                    if (handlers == null) {
                        handlers = (List)new SmartList();
                    }
                    handlers.add(processHandler);
                }
                processHandlerArray = handlers;
                if (handlers == null) break block5;
                Collection $this$toTypedArray$iv = (Collection)processHandlerArray;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                processHandlerArray = thisCollection$iv.toArray(new ProcessHandler[0]);
                if (processHandlerArray != null) break block6;
            }
            processHandlerArray = EMPTY_PROCESS_HANDLERS;
        }
        return processHandlerArray;
    }

    public void compileAndRun(@NotNull Runnable startRunnable2, @NotNull ExecutionEnvironment environment, @Nullable Runnable onCancelRunnable) {
        Intrinsics.checkNotNullParameter((Object)startRunnable2, (String)"startRunnable");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Ref.LongRef id = new Ref.LongRef();
        id.element = environment.getExecutionId();
        if (id.element == 0L) {
            id.element = environment.assignNewExecutionId();
        }
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
        RunProfile profile = runProfile;
        if (!(profile instanceof RunConfiguration)) {
            startRunnable2.run();
            return;
        }
        List<BeforeRunTask<?>> beforeRunTasks = RunManagerImplKt.doGetBeforeRunTasks((RunConfiguration)profile);
        if (beforeRunTasks.isEmpty()) {
            startRunnable2.run();
            return;
        }
        DataContext context = environment.getDataContext();
        DataContext dataContext = context;
        if (dataContext == null) {
            DataContext dataContext2 = SimpleDataContext.getProjectContext((Project)this.project);
            dataContext = dataContext2;
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getProjectContext(...)");
        }
        DataContext projectContext = dataContext;
        Map runBeforeRunExecutorMap = Collections.synchronizedMap(new LinkedHashMap());
        ApplicationManager.getApplication().executeOnPooledThread(() -> ExecutionManagerImpl.compileAndRun$lambda$0(beforeRunTasks, this, environment, onCancelRunnable, runBeforeRunExecutorMap, id, projectContext, profile, startRunnable2));
    }

    private final void doRun(ExecutionEnvironment environment, Runnable startRunnable2) {
        Boolean allowSkipRun = (Boolean)environment.getUserData(EXECUTION_SKIP_RUN);
        if (allowSkipRun != null && allowSkipRun.booleanValue()) {
            ExecutionManagerImpl.processNotStarted$default(this, environment, null, null, 4, null);
            return;
        }
        ActionsKt.runInEdt((ModalityState)ModalityState.any(), () -> ExecutionManagerImpl.doRun$lambda$0(this, environment, startRunnable2));
    }

    public void restartRunProfile(@NotNull Project project, @NotNull Executor executor, @NotNull ExecutionTarget target, @Nullable RunnerAndConfigurationSettings configuration, @Nullable ProcessHandler processHandler, @Nullable Consumer<? super ExecutionEnvironment> environmentCustomization) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ExecutionEnvironmentBuilder builder2 = ExecutionManagerImplKt.access$createEnvironmentBuilder(project, executor, configuration);
        if (processHandler != null) {
            for (RunContentDescriptor descriptor : Companion.getAllDescriptors(project)) {
                if (descriptor.getProcessHandler() != processHandler) continue;
                builder2.contentToReuse(descriptor);
                break;
            }
        }
        ExecutionEnvironment environment = ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)builder2.target(target), null, (int)1, null);
        Consumer<? super ExecutionEnvironment> consumer = environmentCustomization;
        if (consumer != null) {
            consumer.accept((ExecutionEnvironment)environment);
        }
        this.restartRunProfile(environment);
    }

    public void restartRunProfile(@NotNull ExecutionEnvironment environment) {
        List list;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunnerAndConfigurationSettings configuration = environment.getRunnerAndConfigurationSettings();
        List<RunContentDescriptor> runningIncompatible = null;
        runningIncompatible = configuration == null ? CollectionsKt.emptyList() : this.getIncompatibleRunningDescriptors(configuration);
        RunContentDescriptor contentToReuse = environment.getContentToReuse();
        if (configuration != null && !configuration.getConfiguration().isAllowRunningInParallel()) {
            list = this.getRunningDescriptors((Condition<? super RunnerAndConfigurationSettings>)((Condition)arg_0 -> ExecutionManagerImpl.restartRunProfile$lambda$0(configuration, arg_0)));
        } else if (Companion.isProcessRunning(contentToReuse)) {
            RunContentDescriptor runContentDescriptor2 = contentToReuse;
            Intrinsics.checkNotNull((Object)runContentDescriptor2);
            list = CollectionsKt.listOf((Object)runContentDescriptor2);
        } else {
            list = CollectionsKt.emptyList();
        }
        List runningOfTheSameType = list;
        List list2 = ContainerUtil.concat((List)runningOfTheSameType, runningIncompatible);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"concat(...)");
        List runningToStop = list2;
        if (!((Collection)runningToStop).isEmpty()) {
            if (configuration != null) {
                if (!((Collection)runningOfTheSameType).isEmpty() && (runningOfTheSameType.size() > 1 || contentToReuse == null || CollectionsKt.first((List)runningOfTheSameType) != contentToReuse)) {
                    RunConfiguration.RestartSingletonResult result2 = configuration.getConfiguration().restartSingleton(environment);
                    if (result2 == RunConfiguration.RestartSingletonResult.NO_FURTHER_ACTION) {
                        return;
                    }
                    if (result2 == RunConfiguration.RestartSingletonResult.ASK_AND_RESTART) {
                        Project project = environment.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        String string = configuration.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (!ExecutionManagerImplKt.access$userApprovesStopForSameTypeConfigurations(project, string, runningOfTheSameType.size())) {
                            return;
                        }
                    }
                }
                if (!((Collection)runningIncompatible).isEmpty()) {
                    String string = configuration.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!ExecutionManagerImplKt.access$userApprovesStopForIncompatibleConfigurations(this.project, string, runningIncompatible)) {
                        return;
                    }
                }
            }
            for (RunContentDescriptor descriptor : runningToStop) {
                RunContentDescriptor runContentDescriptor3 = descriptor;
                if (runContentDescriptor3 != null && (runContentDescriptor3 = runContentDescriptor3.getProcessHandler()) != null) {
                    runContentDescriptor3.putUserData(TERMINATING_FOR_RERUN, (Object)true);
                }
                Companion.stopProcess(descriptor);
            }
            environment.putUserData(REPORT_NEXT_START_AS_RERUN, (Object)true);
        }
        if (this.awaitingRunProfiles.get(environment.getRunProfile()) == environment) {
            return;
        }
        ((Map)this.awaitingRunProfiles).put(environment.getRunProfile(), environment);
        this.awaitTermination(new Runnable(this, environment, configuration, runningOfTheSameType){
            final /* synthetic */ ExecutionManagerImpl this$0;
            final /* synthetic */ ExecutionEnvironment $environment;
            final /* synthetic */ RunnerAndConfigurationSettings $configuration;
            final /* synthetic */ List<RunContentDescriptor> $runningOfTheSameType;
            {
                this.this$0 = $receiver;
                this.$environment = $environment;
                this.$configuration = $configuration;
                this.$runningOfTheSameType = $runningOfTheSameType;
            }

            public void run() {
                WriteIntentReadAction.run(() -> restartRunProfile.1.run$lambda$0(this.this$0, this.$environment, this.$configuration, this, this.$runningOfTheSameType));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final void run$lambda$0(ExecutionManagerImpl this$0, ExecutionEnvironment $environment, RunnerAndConfigurationSettings $configuration, restartRunProfile.1 this$1, List $runningOfTheSameType) {
                if (ExecutionManagerImpl.access$getAwaitingRunProfiles$p(this$0).get($environment.getRunProfile()) != $environment) {
                    return;
                }
                Object object = $configuration;
                if (object == null || (object = object.getUniqueID()) == null) {
                    object = "";
                }
                String string = $environment.getExecutor().getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                String string2 = $environment.getRunner().getRunnerId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRunnerId(...)");
                InProgressEntry inProgressEntry = new InProgressEntry((String)object, string, string2);
                if ($configuration != null && !$configuration.getType().isDumbAware() && DumbService.Companion.getInstance(ExecutionManagerImpl.access$getProject$p(this$0)).isDumb() || ((Set)ExecutionManagerImpl.access$getInProgress$p(this$0).getValue()).contains(inProgressEntry)) {
                    ExecutionManagerImpl.access$awaitTermination(this$0, this$1, 100L);
                    return;
                }
                for (RunContentDescriptor descriptor : $runningOfTheSameType) {
                    ProcessHandler processHandler = descriptor.getProcessHandler();
                    if (processHandler == null || processHandler.isProcessTerminated()) continue;
                    ExecutionManagerImpl.access$awaitTermination(this$0, this$1, 100L);
                    return;
                }
                ExecutionManagerImpl.access$getAwaitingRunProfiles$p(this$0).remove($environment.getRunProfile());
                if ($environment.getProject().isDisposed()) {
                    return;
                }
                RunnerAndConfigurationSettings settings = $environment.getRunnerAndConfigurationSettings();
                AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"IJPL-162789");
                Throwable throwable = null;
                try {
                    AccessToken it = (AccessToken)autoCloseable;
                    boolean bl = false;
                    ExecutionManagerImpl.executeConfiguration$default(this$0, $environment, settings != null && settings.isEditBeforeRun(), false, 4, null);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
        }, 50L);
    }

    @NotNull
    public Promise<Object> executePreparationTasks(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState currentState) {
        Object object;
        BuildContentManager buildContentManager;
        TargetPrepareComponent component;
        MyProcessHandler processHandler;
        block7: {
            Object[] it;
            block6: {
                Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
                Intrinsics.checkNotNullParameter((Object)currentState, (String)"currentState");
                if (!(environment.getRunProfile() instanceof TargetEnvironmentAwareRunProfile)) {
                    return Promises.resolvedPromise();
                }
                RunProfile runProfile = environment.getRunProfile();
                Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.intellij.execution.target.TargetEnvironmentAwareRunProfile");
                TargetEnvironmentAwareRunProfile targetEnvironmentAwareRunProfile = (TargetEnvironmentAwareRunProfile)runProfile;
                if (!targetEnvironmentAwareRunProfile.needPrepareTarget()) {
                    return Promises.resolvedPromise();
                }
                processHandler = new MyProcessHandler();
                ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(environment.getProject()).getConsole();
                Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
                ConsoleView consoleView2 = consoleView;
                ProcessTerminatedListener.attach((ProcessHandler)processHandler);
                consoleView2.attachToProcess((ProcessHandler)processHandler);
                component = new TargetPrepareComponent(consoleView2);
                BuildContentManager buildContentManager2 = BuildContentManager.getInstance((Project)environment.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)buildContentManager2, (String)"getInstance(...)");
                buildContentManager = buildContentManager2;
                object = TargetEnvironmentConfigurations.getEffectiveTargetName((TargetEnvironmentAwareRunProfile)targetEnvironmentAwareRunProfile, (Project)environment.getProject());
                if (object == null) break block6;
                it = object;
                boolean bl = false;
                Object[] objectArray = new Object[]{it, environment.getRunProfile().getName()};
                String string = ExecutionBundle.message((String)"tab.title.prepare.environment", (Object[])objectArray);
                object = string;
                if (string != null) break block7;
            }
            it = new Object[]{environment.getRunProfile().getName()};
            String string = ExecutionBundle.message((String)"tab.title.prepare.target.environment", (Object[])it);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        Object contentName = object;
        ToolWindow toolWindow = buildContentManager.getOrCreateToolWindow();
        Intrinsics.checkNotNullExpressionValue((Object)toolWindow, (String)"getOrCreateToolWindow(...)");
        ToolWindow toolWindow2 = toolWindow;
        ContentManager contentManager = toolWindow2.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        ContentImpl contentImpl = new ContentImpl((JComponent)component, (String)contentName, true);
        contentImpl.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
        contentImpl.setIcon(environment.getRunProfile().getIcon());
        Content[] contentArray = contentManager2.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        for (Content content : contentArray) {
            JComponent contentComponent;
            if (!Intrinsics.areEqual((Object)contentName, (Object)content.getDisplayName()) || content.isPinned()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)content.getComponent(), (String)"getComponent(...)");
            if (!(contentComponent instanceof TargetPrepareComponent) || !((TargetPrepareComponent)contentComponent).isPreparationFinished()) continue;
            contentManager2.removeContent(content, true);
        }
        contentManager2.addContent((Content)contentImpl);
        contentManager2.setSelectedContent((Content)contentImpl);
        toolWindow2.activate(null);
        AsyncPromise promise = new AsyncPromise();
        ApplicationManager.getApplication().executeOnPooledThread(() -> ExecutionManagerImpl.executePreparationTasks$lambda$1(processHandler, promise, environment, currentState, component));
        return (Promise)promise;
    }

    @ApiStatus.Internal
    public final void executeConfiguration(@NotNull ExecutionEnvironment environment, boolean showSettings, boolean assignNewId) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Companion.withEnvironmentDataContext(environment.getDataContext(), () -> ExecutionManagerImpl.executeConfiguration$lambda$0(environment, this, showSettings, assignNewId));
    }

    public static /* synthetic */ void executeConfiguration$default(ExecutionManagerImpl executionManagerImpl, ExecutionEnvironment executionEnvironment, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeConfiguration");
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        executionManagerImpl.executeConfiguration(executionEnvironment, bl, bl2);
    }

    private final void editConfigurationUntilSuccess(ExecutionEnvironment environment, boolean assignNewId) {
        ReadAction.nonBlocking(() -> ExecutionManagerImpl.editConfigurationUntilSuccess$lambda$0(environment)).finishOnUiThread(ModalityState.nonModal(), arg_0 -> ExecutionManagerImpl.editConfigurationUntilSuccess$lambda$2(arg_0 -> ExecutionManagerImpl.editConfigurationUntilSuccess$lambda$1(this, environment, assignNewId, arg_0), arg_0)).expireWith((Disposable)this).submit((java.util.concurrent.Executor)AppExecutorUtil.getAppExecutorService());
    }

    protected void executeConfiguration(@NotNull ExecutionEnvironment environment, @NotNull ProgramRunner<?> runner, boolean assignNewId, @NotNull Project project, @Nullable RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            ExecutionEnvironment effectiveEnvironment = environment;
            if (!Intrinsics.areEqual(runner, (Object)effectiveEnvironment.getRunner())) {
                effectiveEnvironment = ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)new ExecutionEnvironmentBuilder(effectiveEnvironment).runner(runner), null, (int)1, null);
            }
            if (assignNewId) {
                effectiveEnvironment.assignNewExecutionId();
            }
            runner.execute(effectiveEnvironment);
        }
        catch (ExecutionException e) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
            this.handleProgramRunnerExecutionError(project, environment, e, (RunProfile)(runnerAndConfigurationSettings2 != null ? runnerAndConfigurationSettings2.getConfiguration() : null));
        }
    }

    @ApiStatus.Internal
    protected void handleProgramRunnerExecutionError(@NotNull Project project, @NotNull ExecutionEnvironment environment, @NotNull Throwable e, @Nullable RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ProgramRunnerUtil.handleExecutionError(project, environment, e, profile);
    }

    @ApiStatus.Internal
    protected void handleExecutionError(@NotNull ExecutionEnvironment environment, @NotNull ExecutionException e) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)e);
    }

    public boolean isStarting(@NotNull String configurationId, @NotNull String executorId, @NotNull String runnerId) {
        Intrinsics.checkNotNullParameter((Object)configurationId, (String)"configurationId");
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)runnerId, (String)"runnerId");
        return this.isStarting((Set)this.inProgress.getValue(), configurationId, executorId, runnerId);
    }

    private final boolean isStarting(Set<InProgressEntry> inProgressEntries, String configurationId, String executorId, String runnerId) {
        boolean bl;
        block4: {
            if (!Intrinsics.areEqual((Object)configurationId, (Object)"")) {
                return inProgressEntries.contains(new InProgressEntry(configurationId, executorId, runnerId));
            }
            Iterable $this$any$iv = inProgressEntries;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    InProgressEntry it = (InProgressEntry)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getExecutorId(), (Object)executorId) && Intrinsics.areEqual((Object)it.getRunnerId(), (Object)runnerId))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @ApiStatus.Internal
    @NotNull
    public Flow<Boolean> isStartingFlow(@NotNull String configurationId, @NotNull String executorId, @NotNull String runnerId) {
        Intrinsics.checkNotNullParameter((Object)configurationId, (String)"configurationId");
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)runnerId, (String)"runnerId");
        return FlowKt.channelFlow((Function2)((Function2)new Function2<ProducerScope<? super Boolean>, Continuation<? super Unit>, Object>(this, configurationId, executorId, runnerId, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ExecutionManagerImpl this$0;
            final /* synthetic */ String $configurationId;
            final /* synthetic */ String $executorId;
            final /* synthetic */ String $runnerId;
            {
                this.this$0 = $receiver;
                this.$configurationId = $configurationId;
                this.$executorId = $executorId;
                this.$runnerId = $runnerId;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                ProducerScope producerScope = (ProducerScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$channelFlow;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$channelFlow);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)ExecutionManagerImpl.access$getInProgress$p(this.this$0)), (Function2)((Function2)new Function2<Set<? extends InProgressEntry>, Continuation<? super Unit>, Object>((ProducerScope<? super Boolean>)$this$channelFlow, this.this$0, this.$configurationId, this.$executorId, this.$runnerId, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ ProducerScope<Boolean> $$this$channelFlow;
                            final /* synthetic */ ExecutionManagerImpl this$0;
                            final /* synthetic */ String $configurationId;
                            final /* synthetic */ String $executorId;
                            final /* synthetic */ String $runnerId;
                            {
                                this.$$this$channelFlow = $$this$channelFlow;
                                this.this$0 = $receiver;
                                this.$configurationId = $configurationId;
                                this.$executorId = $executorId;
                                this.$runnerId = $runnerId;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Set set = (Set)this.L$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                        this.label = 1;
                                        Object object2 = this.$$this$channelFlow.send((Object)Boxing.boxBoolean((boolean)ExecutionManagerImpl.access$isStarting(this.this$0, (Set)it, this.$configurationId, this.$executorId, this.$runnerId)), (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(Set<InProgressEntry> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProducerScope<? super Boolean> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void awaitTermination(Runnable request, long delayMillis) {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode()) {
            app.invokeLater(request, EDT.isCurrentThreadEdt() ? ModalityState.current() : ModalityState.any());
        } else {
            this.awaitingTerminationAlarm.addRequest(request, delayMillis);
        }
    }

    private final List<RunContentDescriptor> getIncompatibleRunningDescriptors(RunnerAndConfigurationSettings configurationAndSettings) {
        RunConfiguration runConfiguration = configurationAndSettings.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
        RunConfiguration configurationToCheckCompatibility = runConfiguration;
        return this.getRunningDescriptors((Condition<? super RunnerAndConfigurationSettings>)((Condition)arg_0 -> ExecutionManagerImpl.getIncompatibleRunningDescriptors$lambda$0(configurationToCheckCompatibility, arg_0)));
    }

    @NotNull
    public List<RunContentDescriptor> getRunningDescriptors(@NotNull Condition<? super RunnerAndConfigurationSettings> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        SmartList result2 = new SmartList();
        for (RunningConfigurationEntry entry : this.runningConfigurations) {
            ProcessHandler processHandler;
            if (entry.getSettings() == null || !condition.value((Object)entry.getSettings()) || (processHandler = entry.getDescriptor().getProcessHandler()) == null || processHandler.isProcessTerminated()) continue;
            result2.add((Object)entry.getDescriptor());
        }
        return (List)result2;
    }

    @NotNull
    public final List<RunContentDescriptor> getDescriptors(@NotNull Condition<? super RunnerAndConfigurationSettings> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        SmartList result2 = new SmartList();
        for (RunningConfigurationEntry entry : this.runningConfigurations) {
            if (entry.getSettings() == null || !condition.value((Object)entry.getSettings())) continue;
            result2.add((Object)entry.getDescriptor());
        }
        return (List)result2;
    }

    @NotNull
    public Set<Executor> getExecutors(@NotNull RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        HashSet<Executor> result2 = new HashSet<Executor>();
        for (RunningConfigurationEntry entry : this.runningConfigurations) {
            if (descriptor != entry.getDescriptor()) continue;
            result2.add(entry.getExecutor());
        }
        return result2;
    }

    @NotNull
    public final Set<RunnerAndConfigurationSettings> getConfigurations(@NotNull RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        HashSet<RunnerAndConfigurationSettings> result2 = new HashSet<RunnerAndConfigurationSettings>();
        for (RunningConfigurationEntry entry : this.runningConfigurations) {
            RunnerAndConfigurationSettings settings = entry.getSettings();
            if (descriptor != entry.getDescriptor() || settings == null) continue;
            result2.add(settings);
        }
        return result2;
    }

    @NotNull
    public final Set<ExecutionEnvironment> getExecutionEnvironments(@NotNull RunContentDescriptor descriptor) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Set $this$getExecutionEnvironments_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        for (RunningConfigurationEntry entry : this.runningConfigurations) {
            if (entry.getDescriptor() != descriptor) continue;
            $this$getExecutionEnvironments_u24lambda_u240.add(entry.getExecutionEnvironment());
        }
        return SetsKt.build((Set)set);
    }

    private static final RunContentDescriptor startRunProfile$lambda$0$1(ExecutionEnvironment $environment, RunContentDescriptor descriptor) {
        block3: {
            if (descriptor != null) {
                descriptor.setExecutionId($environment.getExecutionId());
                String toolWindowId = RunContentManager.getInstance((Project)$environment.getProject()).getContentDescriptorToolWindowId($environment);
                if (toolWindowId != null) {
                    descriptor.setContentToolWindowId(toolWindowId);
                }
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = $environment.getRunnerAndConfigurationSettings();
                if (runnerAndConfigurationSettings != null) {
                    RunnerAndConfigurationSettings it = runnerAndConfigurationSettings;
                    boolean bl = false;
                    descriptor.setActivateToolWindowWhenAdded(it.isActivateToolWindowBeforeRun() || it.isFocusToolWindowBeforeRun());
                    descriptor.setAutoFocusContent(it.isFocusToolWindowBeforeRun());
                }
            }
            ProgramRunner.Callback callback = $environment.getCallback();
            if (callback == null) break block3;
            ProgramRunner.Callback it = callback;
            boolean bl = false;
            it.processStarted(descriptor);
            $environment.setCallback(null);
        }
        return descriptor;
    }

    private static final RunContentDescriptor startRunProfile$lambda$0$2(Function1 $tmp0, Object p0) {
        return (RunContentDescriptor)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Promise startRunProfile$lambda$0(Function0 $starter, ExecutionEnvironment $environment) {
        Promise promise;
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"IJPL-162793");
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            promise = (Promise)$starter.invoke();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Promise promise2 = promise.then(arg_0 -> ExecutionManagerImpl.startRunProfile$lambda$0$2(arg_0 -> ExecutionManagerImpl.startRunProfile$lambda$0$1($environment, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    private static final Promise startRunProfile$lambda$1(RunProfileStarter $starter, ExecutionEnvironment $environment) {
        Promise promise = $starter.executeAsync($environment);
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"executeAsync(...)");
        return promise;
    }

    private static final void doStartRunProfile$lambda$1$0$0$0(ExecutionManagerImpl this$0, RunningConfigurationEntry $entry) {
        this$0.runningConfigurations.remove($entry);
    }

    private static final void doStartRunProfile$lambda$1$0$0(RunContentDescriptor $descriptor, ExecutionManagerImpl this$0, ExecutionEnvironment $environment, StructuredIdeActivity $activity, Executor $executor, Project $project, InProgressEntry $inProgressEntry) {
        if ($descriptor == null) {
            ExecutionManagerImpl.processNotStarted$default(this$0, $environment, $activity, null, 4, null);
            return;
        }
        RunningConfigurationEntry entry = new RunningConfigurationEntry($descriptor, $environment, $executor);
        if ($descriptor.getId() == null) {
            CoroutineScope coroutineScope = $descriptor.getCoroutineScope();
            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
            $descriptor.setId((RunContentDescriptorId)RunContentDescriptorIdImplKt.storeGlobally($descriptor, coroutineScope));
        }
        $descriptor.setRunConfigurationName($environment.getRunProfile().getName());
        RunProfile runProfile = $environment.getRunProfile();
        RunConfiguration runConfiguration = runProfile instanceof RunConfiguration ? (RunConfiguration)runProfile : null;
        $descriptor.setRunConfigurationTypeId(runConfiguration != null && (runConfiguration = runConfiguration.getType()) != null ? runConfiguration.getId() : null);
        this$0.runningConfigurations.add(entry);
        Disposer.register((Disposable)((Disposable)$descriptor), () -> ExecutionManagerImpl.doStartRunProfile$lambda$1$0$0$0(this$0, entry));
        ((RunContentDescriptorLifecycleListener)$project.getMessageBus().syncPublisher(RunContentDescriptorLifecycleListenerKt.RUN_CONTENT_DESCRIPTOR_LIFECYCLE_TOPIC)).beforeContentShown($descriptor, $executor);
        if (!$descriptor.isHiddenContent() && !$environment.isHeadless()) {
            RunContentManager.getInstance((Project)$project).showRunContent($executor, $descriptor, $environment.getContentToReuse());
            ((RunContentDescriptorLifecycleListener)$project.getMessageBus().syncPublisher(RunContentDescriptorLifecycleListenerKt.RUN_CONTENT_DESCRIPTOR_LIFECYCLE_TOPIC)).afterContentShown($descriptor, $executor);
        }
        StructuredIdeActivity structuredIdeActivity = $activity;
        if (structuredIdeActivity != null) {
            VarargEventId varargEventId = RunConfigurationUsageTriggerCollector.UI_SHOWN_STAGE;
            Intrinsics.checkNotNullExpressionValue((Object)varargEventId, (String)"UI_SHOWN_STAGE");
            StructuredIdeActivity.stageStarted$default((StructuredIdeActivity)structuredIdeActivity, (VarargEventId)varargEventId, null, (int)2, null);
        }
        $environment.setContentToReuse($descriptor);
        ProcessHandler processHandler = $descriptor.getProcessHandler();
        if (processHandler != null) {
            Set it;
            Set nextValue$iv;
            Object prevValue$iv;
            if (!processHandler.isStartNotified()) {
                ((ExecutionListener)$project.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processStarting($executor.getId(), $environment, processHandler);
                processHandler.startNotify();
            }
            MutableStateFlow<Set<InProgressEntry>> $this$update$iv = this$0.inProgress;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = (Set)prevValue$iv;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SetsKt.minus((Set)it, (Object)$inProgressEntry))));
            ((ExecutionListener)$project.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processStarted($executor.getId(), $environment, processHandler);
            String string = $executor.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            ProcessExecutionListener listener2 = new ProcessExecutionListener($project, string, $environment, $descriptor, $activity);
            processHandler.addProcessListener((ProcessListener)listener2);
            boolean terminating = processHandler.isProcessTerminating();
            boolean terminated = processHandler.isProcessTerminated();
            if (terminating || terminated) {
                listener2.processWillTerminate(new ProcessEvent(processHandler), false);
                if (terminated) {
                    int n;
                    if (processHandler.isStartNotified()) {
                        Integer n2 = processHandler.getExitCode();
                        n = n2 != null ? n2 : -1;
                    } else {
                        n = -1;
                    }
                    int exitCode = n;
                    listener2.processTerminated(new ProcessEvent(processHandler, exitCode));
                }
            }
        }
    }

    private static final void doStartRunProfile$lambda$1$handleError(ExecutionManagerImpl this$0, ExecutionEnvironment $environment, StructuredIdeActivity activity, Project project, Throwable e) {
        this$0.processNotStarted($environment, activity, e);
        if (!(e instanceof ProcessCanceledException)) {
            this$0.handleProgramRunnerExecutionError(project, $environment, e, $environment.getRunProfile());
            LOG.debug(e);
        }
    }

    private static final Unit doStartRunProfile$lambda$1$0(Project $project, ExecutionManagerImpl this$0, ExecutionEnvironment $environment, StructuredIdeActivity $activity, Executor $executor, InProgressEntry $inProgressEntry, RunContentDescriptor descriptor) {
        AppUIUtil.invokeLaterIfProjectAlive((Project)$project, () -> ExecutionManagerImpl.doStartRunProfile$lambda$1$0$0(descriptor, this$0, $environment, $activity, $executor, $project, $inProgressEntry));
        return Unit.INSTANCE;
    }

    private static final void doStartRunProfile$lambda$1$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void doStartRunProfile$lambda$1$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void doStartRunProfile$lambda$1(Project $project, Executor $executor, ExecutionEnvironment $environment, Function0 $task, ExecutionManagerImpl this$0, StructuredIdeActivity $activity, InProgressEntry $inProgressEntry) {
        if ($project.isDisposed()) {
            return;
        }
        ((ExecutionListener)$project.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processStarting($executor.getId(), $environment);
        try {
            Promise promise = ((Promise)$task.invoke()).onSuccess(arg_0 -> ExecutionManagerImpl.doStartRunProfile$lambda$1$1(arg_0 -> ExecutionManagerImpl.doStartRunProfile$lambda$1$0($project, this$0, $environment, $activity, $executor, $inProgressEntry, arg_0), arg_0)).onError(arg_0 -> ExecutionManagerImpl.doStartRunProfile$lambda$1$2((Function1)new Function1<Throwable, Unit>(this$0, $environment, $activity, $project){
                final /* synthetic */ ExecutionManagerImpl this$0;
                final /* synthetic */ ExecutionEnvironment $environment;
                final /* synthetic */ StructuredIdeActivity $activity;
                final /* synthetic */ Project $project;
                {
                    this.this$0 = $receiver;
                    this.$environment = $environment;
                    this.$activity = $activity;
                    this.$project = $project;
                    super(1, Intrinsics.Kotlin.class, "handleError", "doStartRunProfile$lambda$1$handleError(Lcom/intellij/execution/impl/ExecutionManagerImpl;Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/intellij/internal/statistic/StructuredIdeActivity;Lcom/intellij/openapi/project/Project;Ljava/lang/Throwable;)V", 0);
                }

                public final void invoke(Throwable p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ExecutionManagerImpl.access$doStartRunProfile$lambda$1$handleError(this.this$0, this.$environment, this.$activity, this.$project, p0);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)promise);
        }
        catch (Throwable e) {
            ExecutionManagerImpl.doStartRunProfile$lambda$1$handleError(this$0, $environment, $activity, $project, e);
        }
    }

    private static final void doStartRunProfile$lambda$2(Runnable $startRunnable, Project $project) {
        ApplicationManager.getApplication().invokeLater($startRunnable, $project.getDisposed());
    }

    private static final void doStartRunProfile$lambda$3(Project $project, ExecutionManagerImpl this$0, ExecutionEnvironment $environment, StructuredIdeActivity $activity) {
        if (!$project.isDisposed()) {
            ExecutionManagerImpl.processNotStarted$default(this$0, $environment, $activity, null, 4, null);
        }
    }

    private static final void compileAndRun$lambda$0(List $beforeRunTasks, ExecutionManagerImpl this$0, ExecutionEnvironment $environment, Runnable $onCancelRunnable, Map $runBeforeRunExecutorMap, Ref.LongRef $id, DataContext $projectContext, RunProfile $profile, Runnable $startRunnable) {
        Executor executor;
        BeforeRunTaskProvider provider;
        for (BeforeRunTask task2 : $beforeRunTasks) {
            block15: {
                Executor executor2;
                RunnerAndConfigurationSettings settings;
                block14: {
                    provider = BeforeRunTaskProvider.getProvider((Project)this$0.project, (Key)task2.getProviderId());
                    if (provider == null || !(task2 instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) || (settings = ((RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)task2).getSettings()) == null) continue;
                    executor2 = executor = Registry.Companion.is("lock.run.executor.for.before.run.tasks", false) ? DefaultRunExecutor.getRunExecutorInstance() : $environment.getExecutor();
                    Intrinsics.checkNotNull((Object)executor2);
                    ExecutionEnvironmentBuilder builder2 = ExecutionEnvironmentBuilder.Companion.createOrNull(executor2, settings);
                    if (builder2 == null) break block14;
                    executor2 = executor;
                    Intrinsics.checkNotNull((Object)executor2);
                    if (RunManagerImpl.Companion.canRunConfiguration(settings, executor2)) break block15;
                }
                executor2 = executor = DefaultRunExecutor.getRunExecutorInstance();
                Intrinsics.checkNotNull((Object)executor2);
                if (!RunManagerImpl.Companion.canRunConfiguration(settings, executor2)) {
                    Runnable runnable = $onCancelRunnable;
                    if (runnable != null) {
                        runnable.run();
                    }
                    executor2 = new Object[]{settings};
                    this$0.handleExecutionError($environment, new ExecutionException(ExecutionBundle.message((String)"dialog.message.cannot.start.before.run.task", (Object[])executor2)));
                    return;
                }
            }
            Intrinsics.checkNotNull((Object)$runBeforeRunExecutorMap);
            $runBeforeRunExecutorMap.put(task2, executor);
        }
        for (BeforeRunTask task2 : $beforeRunTasks) {
            if (this$0.project.isDisposed()) {
                return;
            }
            provider = BeforeRunTaskProvider.getProvider((Project)this$0.project, (Key)task2.getProviderId());
            if (provider == null) {
                LOG.warn("Cannot find BeforeRunTaskProvider for id='" + task2.getProviderId() + "'");
                continue;
            }
            ExecutionEnvironmentBuilder builder3 = new ExecutionEnvironmentBuilder($environment).contentToReuse(null);
            executor = (Executor)$runBeforeRunExecutorMap.get(task2);
            if (executor != null) {
                builder3.executor(executor);
            }
            ExecutionEnvironment taskEnvironment = ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)builder3, null, (int)1, null);
            taskEnvironment.setExecutionId($id.element);
            EXECUTION_SESSION_ID_KEY.set((UserDataHolder)taskEnvironment, (Object)$id.element);
            try {
                if (provider.executeTask($projectContext, (RunConfiguration)$profile, taskEnvironment, task2)) continue;
                LOG.debug("Before launch task '" + task2 + "' doesn't finish successfully, cancelling execution");
                if ($onCancelRunnable != null) {
                    SwingUtilities.invokeLater($onCancelRunnable);
                }
                return;
            }
            catch (ProcessCanceledException e) {
                LOG.debug("Before launch task '" + task2 + "' cancelled, cancelling execution", (Throwable)e);
                if ($onCancelRunnable != null) {
                    SwingUtilities.invokeLater($onCancelRunnable);
                }
                return;
            }
        }
        this$0.doRun($environment, $startRunnable);
    }

    private static final Unit doRun$lambda$0(ExecutionManagerImpl this$0, ExecutionEnvironment $environment, Runnable $startRunnable) {
        if (this$0.project.isDisposed()) {
            return Unit.INSTANCE;
        }
        RunnerAndConfigurationSettings settings = $environment.getRunnerAndConfigurationSettings();
        if (settings != null && !settings.getType().isDumbAware() && DumbService.Companion.isDumb(this$0.project)) {
            DumbService.Companion.getInstance(this$0.project).runWhenSmart($startRunnable);
        } else {
            try {
                $startRunnable.run();
            }
            catch (IndexNotReadyException ignored) {
                this$0.handleExecutionError($environment, new ExecutionException(ExecutionBundle.message((String)"dialog.message.cannot.start.while.indexing.in.progress", (Object[])new Object[0])));
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean restartRunProfile$lambda$0(RunnerAndConfigurationSettings $configuration, RunnerAndConfigurationSettings it) {
        Intrinsics.checkNotNull((Object)it);
        return ExecutionManagerImplKt.isOfSameType(it, $configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void executePreparationTasks$lambda$1(MyProcessHandler $processHandler, AsyncPromise $promise, ExecutionEnvironment $environment, RunProfileState $currentState, TargetPrepareComponent $component) {
        try {
            $processHandler.startNotify();
            TargetProgressIndicator targetProgressIndicator2 = new TargetProgressIndicator($processHandler){
                private volatile boolean stopped;
                final /* synthetic */ MyProcessHandler $processHandler;
                {
                    this.$processHandler = $processHandler;
                }

                public final boolean getStopped() {
                    return this.stopped;
                }

                public final void setStopped(boolean bl) {
                    this.stopped = bl;
                }

                public void addText(String text, Key<?> key) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    Intrinsics.checkNotNullParameter(key, (String)"key");
                    this.$processHandler.notifyTextAvailable(text, key);
                }

                public boolean isCanceled() {
                    return false;
                }

                public void stop() {
                    this.stopped = true;
                }

                public boolean isStopped() {
                    return this.stopped;
                }
            };
            $promise.setResult((Object)$environment.prepareTargetEnvironment($currentState, targetProgressIndicator2));
        }
        catch (Throwable t) {
            try {
                LOG.warn(t);
                Object[] objectArray = new Object[]{t.getLocalizedMessage()};
                String string = ExecutionBundle.message((String)"message.error.happened.0", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $promise.setError(string);
                $processHandler.notifyTextAvailable(StringUtil.notNullize((String)t.getLocalizedMessage()), (Key)ProcessOutputType.STDERR);
                $processHandler.notifyTextAvailable("\n", (Key)ProcessOutputType.STDERR);
            }
            catch (Throwable throwable) {
                int exitCode = $promise.isSucceeded() ? 0 : -1;
                $processHandler.notifyProcessTerminated(exitCode);
                $component.setPreparationFinished();
                throw throwable;
            }
            int exitCode = $promise.isSucceeded() ? 0 : -1;
            $processHandler.notifyProcessTerminated(exitCode);
            $component.setPreparationFinished();
        }
        int exitCode = $promise.isSucceeded() ? 0 : -1;
        $processHandler.notifyProcessTerminated(exitCode);
        $component.setPreparationFinished();
    }

    private static final Boolean executeConfiguration$lambda$0$1(ExecutionEnvironment $environment) {
        return RunManagerImpl.Companion.canRunConfiguration($environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit executeConfiguration$lambda$0$2(ExecutionManagerImpl this$0, ExecutionEnvironment $environment, boolean $assignNewId, InProgressEntry $inProgressEntry, Boolean canRun) {
        Object[] objectArray;
        Set it;
        Set nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<Set<InProgressEntry>> $this$update$iv = this$0.inProgress;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (Set)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SetsKt.minus((Set)it, (Object)$inProgressEntry))));
        if (canRun.booleanValue()) {
            objectArray = (Object[])SlowOperations.knownIssue((String)"IJPL-162789");
            Throwable throwable = null;
            try {
                AccessToken it2 = (AccessToken)objectArray;
                boolean bl = false;
                ProgramRunner programRunner = $environment.getRunner();
                Intrinsics.checkNotNullExpressionValue((Object)programRunner, (String)"getRunner(...)");
                this$0.executeConfiguration($environment, programRunner, $assignNewId, this$0.project, $environment.getRunnerAndConfigurationSettings());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)objectArray, (Throwable)throwable);
            }
            return Unit.INSTANCE;
        }
        objectArray = new Object[]{0};
        if (!RunDialog.editConfiguration($environment, ExecutionBundle.message((String)"dialog.title.edit.configuration", (Object[])objectArray))) {
            ExecutionManagerImpl.processNotStarted$default(this$0, $environment, null, null, 4, null);
            return Unit.INSTANCE;
        }
        this$0.editConfigurationUntilSuccess($environment, $assignNewId);
        return Unit.INSTANCE;
    }

    private static final void executeConfiguration$lambda$0$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit executeConfiguration$lambda$0(ExecutionEnvironment $environment, ExecutionManagerImpl this$0, boolean $showSettings, boolean $assignNewId) {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = $environment.getRunnerAndConfigurationSettings();
        Project project = $environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ProgramRunner programRunner = $environment.getRunner();
        Intrinsics.checkNotNullExpressionValue((Object)programRunner, (String)"getRunner(...)");
        ProgramRunner runner = programRunner;
        if (runnerAndConfigurationSettings != null) {
            ExecutionTargetManager executionTargetManager = ExecutionTargetManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)executionTargetManager, (String)"getInstance(...)");
            ExecutionTargetManager targetManager = executionTargetManager;
            if (!targetManager.doCanRun(runnerAndConfigurationSettings.getConfiguration(), $environment.getExecutionTarget())) {
                this$0.handleExecutionError($environment, new ExecutionException(ProgramRunnerUtil.getCannotRunOnErrorMessage($environment.getRunProfile(), $environment.getExecutionTarget())));
                ExecutionManagerImpl.processNotStarted$default(this$0, $environment, null, null, 4, null);
                return Unit.INSTANCE;
            }
            if (!DumbService.Companion.isDumb(project2)) {
                if ($showSettings && runnerAndConfigurationSettings.isEditBeforeRun()) {
                    Object[] objectArray = new Object[]{0};
                    if (!RunDialog.editConfiguration($environment, ExecutionBundle.message((String)"dialog.title.edit.configuration", (Object[])objectArray))) {
                        ExecutionManagerImpl.processNotStarted$default(this$0, $environment, null, null, 4, null);
                        return Unit.INSTANCE;
                    }
                    this$0.editConfigurationUntilSuccess($environment, $assignNewId);
                } else {
                    Set it;
                    Set nextValue$iv;
                    Object prevValue$iv;
                    Object object = $environment.getRunnerAndConfigurationSettings();
                    if (object == null || (object = object.getUniqueID()) == null) {
                        object = "";
                    }
                    String string = $environment.getExecutor().getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    String string2 = $environment.getRunner().getRunnerId();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRunnerId(...)");
                    InProgressEntry inProgressEntry = new InProgressEntry((String)object, string, string2);
                    MutableStateFlow<Set<InProgressEntry>> $this$update$iv = this$0.inProgress;
                    boolean $i$f$update = false;
                    do {
                        prevValue$iv = $this$update$iv.getValue();
                        it = (Set)prevValue$iv;
                        boolean bl = false;
                    } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SetsKt.plus((Set)it, (Object)inProgressEntry))));
                    CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> ExecutionManagerImpl.executeConfiguration$lambda$0$1($environment)).finishOnUiThread(ModalityState.nonModal(), arg_0 -> ExecutionManagerImpl.executeConfiguration$lambda$0$3(arg_0 -> ExecutionManagerImpl.executeConfiguration$lambda$0$2(this$0, $environment, $assignNewId, inProgressEntry, arg_0), arg_0)).expireWith((Disposable)this$0).submit((java.util.concurrent.Executor)AppExecutorUtil.getAppExecutorService());
                    Intrinsics.checkNotNull((Object)cancellablePromise);
                }
                return Unit.INSTANCE;
            }
        }
        this$0.executeConfiguration($environment, runner, $assignNewId, project2, runnerAndConfigurationSettings);
        return Unit.INSTANCE;
    }

    private static final Boolean editConfigurationUntilSuccess$lambda$0(ExecutionEnvironment $environment) {
        return RunManagerImpl.Companion.canRunConfiguration($environment);
    }

    private static final Unit editConfigurationUntilSuccess$lambda$1(ExecutionManagerImpl this$0, ExecutionEnvironment $environment, boolean $assignNewId, Boolean canRun) {
        boolean runAnyway;
        if (!canRun.booleanValue()) {
            String string = ExecutionBundle.message((String)"dialog.message.configuration.still.incorrect.do.you.want.to.edit.it.again", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            String string2 = ExecutionBundle.message((String)"dialog.title.change.configuration.settings", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String title = string2;
            v2 = Messages.showYesNoDialog((Project)this$0.project, (String)message, (String)title, (String)CommonBundle.message((String)"button.edit", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"run.continue.anyway", (Object[])new Object[0]), (Icon)Messages.getErrorIcon()) != 0;
        } else {
            v2 = runAnyway = true;
        }
        if (canRun.booleanValue() || runAnyway) {
            String string = $environment.getExecutor().getId();
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = $environment.getRunnerAndConfigurationSettings();
            Intrinsics.checkNotNull((Object)runnerAndConfigurationSettings);
            ProgramRunner runner = ProgramRunner.getRunner((String)string, (RunProfile)((RunProfile)runnerAndConfigurationSettings.getConfiguration()));
            if (runner == null) {
                Object[] objectArray = new Object[]{$environment.getRunProfile().getName()};
                this$0.handleExecutionError($environment, new ExecutionException(ExecutionBundle.message((String)"dialog.message.cannot.find.runner", (Object[])objectArray)));
            } else {
                this$0.executeConfiguration($environment, runner, $assignNewId, this$0.project, $environment.getRunnerAndConfigurationSettings());
            }
            return Unit.INSTANCE;
        }
        Object[] objectArray = new Object[]{0};
        if (!RunDialog.editConfiguration($environment, ExecutionBundle.message((String)"dialog.title.edit.configuration", (Object[])objectArray))) {
            ExecutionManagerImpl.processNotStarted$default(this$0, $environment, null, null, 4, null);
            return Unit.INSTANCE;
        }
        this$0.editConfigurationUntilSuccess($environment, $assignNewId);
        return Unit.INSTANCE;
    }

    private static final void editConfigurationUntilSuccess$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean getIncompatibleRunningDescriptors$lambda$0(RunConfiguration $configurationToCheckCompatibility, RunnerAndConfigurationSettings runningConfigurationAndSettings) {
        RunConfiguration runConfiguration = runningConfigurationAndSettings.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
        RunConfiguration runningConfiguration = runConfiguration;
        return runningConfiguration instanceof CompatibilityAwareRunProfile ? ((CompatibilityAwareRunProfile)runningConfiguration).mustBeStoppedToRun($configurationToCheckCompatibility) : false;
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final DataContext getEnvironmentDataContext() {
        return Companion.getEnvironmentDataContext();
    }

    @JvmStatic
    @NotNull
    public static final ExecutionManagerImpl getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @Nullable
    public static final ExecutionManagerImpl getInstanceIfCreated(@NotNull Project project) {
        return Companion.getInstanceIfCreated(project);
    }

    @JvmStatic
    public static final boolean isProcessRunning(@Nullable RunContentDescriptor descriptor) {
        return Companion.isProcessRunning(descriptor);
    }

    @JvmStatic
    public static final void stopProcess(@Nullable RunContentDescriptor descriptor) {
        Companion.stopProcess(descriptor);
    }

    @JvmStatic
    public static final void stopProcess(@Nullable ProcessHandler processHandler) {
        Companion.stopProcess(processHandler);
    }

    @JvmStatic
    @NotNull
    public static final List<RunContentDescriptor> getAllDescriptors(@NotNull Project project) {
        return Companion.getAllDescriptors(project);
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final void setDelegatedRunProfile(@NotNull RunProfile runProfile, @NotNull RunProfile runProfileToDelegate) {
        Companion.setDelegatedRunProfile(runProfile, runProfileToDelegate);
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final RunProfile getDelegatedRunProfile(@NotNull RunProfile runProfile) {
        return Companion.getDelegatedRunProfile(runProfile);
    }

    public static final /* synthetic */ HashMap access$getAwaitingRunProfiles$p(ExecutionManagerImpl $this) {
        return $this.awaitingRunProfiles;
    }

    public static final /* synthetic */ void access$awaitTermination(ExecutionManagerImpl $this, Runnable request, long delayMillis) {
        $this.awaitTermination(request, delayMillis);
    }

    public static final /* synthetic */ boolean access$isStarting(ExecutionManagerImpl $this, Set inProgressEntries, String configurationId, String executorId, String runnerId) {
        return $this.isStarting(inProgressEntries, configurationId, executorId, runnerId);
    }

    public static final /* synthetic */ void access$doStartRunProfile$lambda$1$handleError(ExecutionManagerImpl this$0, ExecutionEnvironment $environment, StructuredIdeActivity activity, Project project, Throwable e) {
        ExecutionManagerImpl.doStartRunProfile$lambda$1$handleError(this$0, $environment, activity, project, e);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ExecutionManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        EMPTY_PROCESS_HANDLERS = new ProcessHandler[0];
        Key key = Key.create((String)"DELEGATED_RUN_PROFILE_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DELEGATED_RUN_PROFILE_KEY = key;
        EXECUTION_SESSION_ID_KEY = ExecutionManager.EXECUTION_SESSION_ID_KEY;
        EXECUTION_SKIP_RUN = ExecutionManager.EXECUTION_SKIP_RUN;
        Key key2 = Key.create((String)"TERMINATING_FOR_RERUN");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        TERMINATING_FOR_RERUN = key2;
        Key key3 = Key.create((String)"REPORT_NEXT_START_AS_RERUN");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        REPORT_NEXT_START_AS_RERUN = key3;
        Key key4 = Key.create((String)"PARENT_PROFILE_IDE_ACTIVITY");
        Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"create(...)");
        PARENT_PROFILE_IDE_ACTIVITY = key4;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u00017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0007J+\u0010\u0015\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007J\u0012\u0010*\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0007J\u0012\u0010+\u001a\u00020\u001e2\b\u0010,\u001a\u0004\u0018\u00010-H\u0007J\u0012\u0010.\u001a\u00020/2\b\u0010,\u001a\u0004\u0018\u00010-H\u0007J\u0012\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\nH\u0007J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020-022\u0006\u0010(\u001a\u00020)H\u0007J\u0018\u00103\u001a\u00020/2\u0006\u00104\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u000eH\u0007J\u0012\u00106\u001a\u0004\u0018\u00010\u000e2\u0006\u00104\u001a\u00020\u000eH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR'\u0010\f\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\u0002\b\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u001f\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u001e0\u001e0\r\u00a2\u0006\u0002\b\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0012R'\u0010!\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u001e0\u001e0\r\u00a2\u0006\u0002\b\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0012R'\u0010#\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010$0$0\r\u00a2\u0006\u0002\b\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0012\u00a8\u00068"}, d2={"Lcom/intellij/execution/impl/ExecutionManagerImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "EMPTY_PROCESS_HANDLERS", "", "Lcom/intellij/execution/process/ProcessHandler;", "[Lcom/intellij/execution/process/ProcessHandler;", "DELEGATED_RUN_PROFILE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/execution/configurations/RunProfile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getDELEGATED_RUN_PROFILE_KEY$intellij_platform_execution_impl", "()Lcom/intellij/openapi/util/Key;", "getEnvironmentDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "withEnvironmentDataContext", "Lcom/intellij/openapi/application/AccessToken;", "dataContext", "T", "action", "Lkotlin/Function0;", "(Lcom/intellij/openapi/actionSystem/DataContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "EXECUTION_SESSION_ID_KEY", "EXECUTION_SKIP_RUN", "", "TERMINATING_FOR_RERUN", "getTERMINATING_FOR_RERUN$intellij_platform_execution_impl", "REPORT_NEXT_START_AS_RERUN", "getREPORT_NEXT_START_AS_RERUN$intellij_platform_execution_impl", "PARENT_PROFILE_IDE_ACTIVITY", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "getPARENT_PROFILE_IDE_ACTIVITY$intellij_platform_execution_impl", "getInstance", "Lcom/intellij/execution/impl/ExecutionManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceIfCreated", "isProcessRunning", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "stopProcess", "", "processHandler", "getAllDescriptors", "", "setDelegatedRunProfile", "runProfile", "runProfileToDelegate", "getDelegatedRunProfile", "EnvDataContextElement", "intellij.platform.execution.impl"})
    @SourceDebugExtension(value={"SMAP\nExecutionManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionManagerImpl.kt\ncom/intellij/execution/impl/ExecutionManagerImpl$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,1181:1\n58#2:1182\n58#2:1183\n*S KotlinDebug\n*F\n+ 1 ExecutionManagerImpl.kt\ncom/intellij/execution/impl/ExecutionManagerImpl$Companion\n*L\n138#1:1182\n181#1:1183\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final Key<RunProfile> getDELEGATED_RUN_PROFILE_KEY$intellij_platform_execution_impl() {
            return DELEGATED_RUN_PROFILE_KEY;
        }

        @JvmStatic
        @ApiStatus.Internal
        @Nullable
        public final DataContext getEnvironmentDataContext() {
            EnvDataContextElement envDataContextElement = (EnvDataContextElement)ThreadContext.currentThreadContext().get((CoroutineContext.Key)EnvDataContextElement.Companion);
            return envDataContextElement != null ? envDataContextElement.getDataContext() : null;
        }

        @ApiStatus.Internal
        @NotNull
        public final AccessToken withEnvironmentDataContext(@Nullable DataContext dataContext) {
            CoroutineContext context = ThreadContext.currentThreadContext();
            return ThreadContext.installThreadContext((CoroutineContext)context.plus((CoroutineContext)new EnvDataContextElement(dataContext)), (boolean)true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ApiStatus.Internal
        public final <T> T withEnvironmentDataContext(@Nullable DataContext dataContext, @NotNull Function0<? extends T> action) {
            Object object;
            Intrinsics.checkNotNullParameter(action, (String)"action");
            CoroutineContext context = ThreadContext.currentThreadContext();
            AutoCloseable autoCloseable = (AutoCloseable)ThreadContext.installThreadContext((CoroutineContext)context.plus((CoroutineContext)new EnvDataContextElement(dataContext)), (boolean)true);
            Throwable throwable = null;
            try {
                AccessToken it = (AccessToken)autoCloseable;
                boolean bl = false;
                object = action.invoke();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return (T)object;
        }

        @NotNull
        public final Key<Boolean> getTERMINATING_FOR_RERUN$intellij_platform_execution_impl() {
            return TERMINATING_FOR_RERUN;
        }

        @NotNull
        public final Key<Boolean> getREPORT_NEXT_START_AS_RERUN$intellij_platform_execution_impl() {
            return REPORT_NEXT_START_AS_RERUN;
        }

        @NotNull
        public final Key<StructuredIdeActivity> getPARENT_PROFILE_IDE_ACTIVITY$intellij_platform_execution_impl() {
            return PARENT_PROFILE_IDE_ACTIVITY;
        }

        @JvmStatic
        @NotNull
        public final ExecutionManagerImpl getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ExecutionManager executionManager = ExecutionManager.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)executionManager, (String)"null cannot be cast to non-null type com.intellij.execution.impl.ExecutionManagerImpl");
            return (ExecutionManagerImpl)executionManager;
        }

        @JvmStatic
        @Nullable
        public final ExecutionManagerImpl getInstanceIfCreated(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
            boolean $i$f$serviceIfCreated = false;
            Object object = $this$serviceIfCreated$iv.getServiceIfCreated(ExecutionManager.class);
            return object instanceof ExecutionManagerImpl ? (ExecutionManagerImpl)((Object)object) : null;
        }

        @JvmStatic
        public final boolean isProcessRunning(@Nullable RunContentDescriptor descriptor) {
            RunContentDescriptor runContentDescriptor2 = descriptor;
            ProcessHandler processHandler = runContentDescriptor2 != null ? runContentDescriptor2.getProcessHandler() : null;
            return processHandler != null && !processHandler.isProcessTerminated();
        }

        @JvmStatic
        public final void stopProcess(@Nullable RunContentDescriptor descriptor) {
            RunContentDescriptor runContentDescriptor2 = descriptor;
            this.stopProcess((ProcessHandler)(runContentDescriptor2 != null ? runContentDescriptor2.getProcessHandler() : null));
        }

        @JvmStatic
        public final void stopProcess(@Nullable ProcessHandler processHandler) {
            if (processHandler == null) {
                return;
            }
            processHandler.putUserData(ProcessHandler.TERMINATION_REQUESTED, (Object)true);
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.childScope((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (String)("Destroy " + processHandler.getClass().getName()), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (boolean)true), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(processHandler, null){
                int label;
                final /* synthetic */ ProcessHandler $processHandler;
                {
                    this.$processHandler = $processHandler;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (this.$processHandler instanceof KillableProcess && this.$processHandler.isProcessTerminating()) {
                                ((KillableProcess)this.$processHandler).killProcess();
                            } else if (!this.$processHandler.isProcessTerminated()) {
                                if (this.$processHandler.detachIsDefault()) {
                                    this.$processHandler.detachProcess();
                                } else {
                                    this.$processHandler.destroyProcess();
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @JvmStatic
        @NotNull
        public final List<RunContentDescriptor> getAllDescriptors(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
            boolean $i$f$serviceIfCreated = false;
            Object object = (RunContentManager)$this$serviceIfCreated$iv.getServiceIfCreated(RunContentManager.class);
            if (object == null || (object = object.getAllDescriptors()) == null) {
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        @JvmStatic
        @ApiStatus.Internal
        public final void setDelegatedRunProfile(@NotNull RunProfile runProfile, @NotNull RunProfile runProfileToDelegate) {
            Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
            Intrinsics.checkNotNullParameter((Object)runProfileToDelegate, (String)"runProfileToDelegate");
            if (runProfile != runProfileToDelegate && runProfile instanceof UserDataHolder) {
                this.getDELEGATED_RUN_PROFILE_KEY$intellij_platform_execution_impl().set((UserDataHolder)runProfile, (Object)runProfileToDelegate);
            }
        }

        @JvmStatic
        @ApiStatus.Internal
        @Nullable
        public final RunProfile getDelegatedRunProfile(@NotNull RunProfile runProfile) {
            Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
            return runProfile instanceof UserDataHolder ? (RunProfile)((UserDataHolder)runProfile).getUserData(this.getDELEGATED_RUN_PROFILE_KEY$intellij_platform_execution_impl()) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fX\u0096\u0084\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/impl/ExecutionManagerImpl$Companion$EnvDataContextElement;", "Lkotlin/coroutines/CoroutineContext$Element;", "Lcom/intellij/concurrency/IntelliJContextElement;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "<init>", "(Lcom/intellij/openapi/actionSystem/DataContext;)V", "getDataContext", "()Lcom/intellij/openapi/actionSystem/DataContext;", "produceChildElement", "parentContext", "Lkotlin/coroutines/CoroutineContext;", "isStructured", "", "key", "Lkotlin/coroutines/CoroutineContext$Key;", "getKey", "()Lkotlin/coroutines/CoroutineContext$Key;", "Companion", "intellij.platform.execution.impl"})
        private static final class EnvDataContextElement
        implements CoroutineContext.Element,
        IntelliJContextElement {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @Nullable
            private final DataContext dataContext;
            @NotNull
            private final CoroutineContext.Key<?> key;

            public EnvDataContextElement(@Nullable DataContext dataContext) {
                this.dataContext = dataContext;
                this.key = Companion;
            }

            @Nullable
            public final DataContext getDataContext() {
                return this.dataContext;
            }

            @NotNull
            public IntelliJContextElement produceChildElement(@NotNull CoroutineContext parentContext, boolean isStructured) {
                Intrinsics.checkNotNullParameter((Object)parentContext, (String)"parentContext");
                return this;
            }

            @NotNull
            public CoroutineContext.Key<?> getKey() {
                return this.key;
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/execution/impl/ExecutionManagerImpl$Companion$EnvDataContextElement$Companion;", "Lkotlin/coroutines/CoroutineContext$Key;", "Lcom/intellij/execution/impl/ExecutionManagerImpl$Companion$EnvDataContextElement;", "<init>", "()V", "intellij.platform.execution.impl"})
            public static final class Companion
            implements CoroutineContext.Key<EnvDataContextElement> {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0005H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/execution/impl/ExecutionManagerImpl$MyProcessHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "<init>", "()V", "destroyProcessImpl", "", "detachProcessImpl", "detachIsDefault", "", "getProcessInput", "Ljava/io/OutputStream;", "notifyProcessTerminated", "exitCode", "", "intellij.platform.execution.impl"})
    private static final class MyProcessHandler
    extends ProcessHandler {
        protected void destroyProcessImpl() {
        }

        protected void detachProcessImpl() {
        }

        public boolean detachIsDefault() {
            return false;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return null;
        }

        public void notifyProcessTerminated(int exitCode) {
            super.notifyProcessTerminated(exitCode);
        }
    }
}

