/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.execution.impl.RunConfigurationTemplatesConfigurableKt;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0012\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/execution/impl/ProjectRunConfigurationConfigurable;", "Lcom/intellij/execution/impl/RunConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createLeftPanel", "Ljavax/swing/JComponent;", "typeOrFactorySelected", "", "userObject", "", "addRunConfigurationsToModel", "model", "Ljavax/swing/tree/DefaultMutableTreeNode;", "createTipPanelAboutAddingNewRunConfiguration", "configurationType", "Lcom/intellij/execution/configurations/ConfigurationType;", "intellij.platform.execution.impl"})
public class ProjectRunConfigurationConfigurable
extends RunConfigurable {
    public ProjectRunConfigurationConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    protected JComponent createLeftPanel() {
        if (this.getProject().isDefault()) {
            JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.getTree()));
            Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
            return jScrollPane;
        }
        RunConfigurable.MyRemoveAction removeAction = new RunConfigurable.MyRemoveAction(this);
        String[] stringArray = new String[]{ExecutionBundle.message((String)"add.new.run.configuration.action2.name", (Object[])new Object[0]), ExecutionBundle.message((String)"remove.run.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"action.name.save.configuration", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.edit.default.configuration.settings.text", (Object[])new Object[0]), ExecutionBundle.message((String)"move.up.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"move.down.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.create.folder.text", (Object[])new Object[0])};
        this.setToolbarDecorator(ToolbarDecorator.createDecorator((JTree)((JTree)this.getTree())).setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder((Border)JBUI.Borders.empty()).setScrollPaneBorder((Border)JBUI.Borders.empty()).setAddAction((AnActionButtonRunnable)this.getToolbarAddAction()).setAddActionName(ExecutionBundle.message((String)"add.new.run.configuration.action2.name", (Object[])new Object[0])).setRemoveAction((AnActionButtonRunnable)removeAction).setRemoveActionUpdater((AnActionButtonUpdater)removeAction).setRemoveActionName(ExecutionBundle.message((String)"remove.run.configuration.action.name", (Object[])new Object[0])).addExtraAction((AnAction)new RunConfigurable.MyCopyAction(this)).addExtraAction((AnAction)new RunConfigurable.MySaveAction(this)).addExtraAction((AnAction)new RunConfigurable.MyCreateFolderAction(this)).addExtraAction((AnAction)new RunConfigurable.MySortFolderAction(this)).setMinimumSize((Dimension)new JBDimension(200, 200)).setButtonComparator(stringArray).setForcedDnD());
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBackground(JBColor.background());
        ToolbarDecorator toolbarDecorator = this.getToolbarDecorator();
        Intrinsics.checkNotNull((Object)toolbarDecorator);
        panel2.add((Component)toolbarDecorator.createPanel(), "Center");
        String string = ExecutionBundle.message((String)"edit.configuration.templates", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ActionLink actionLink = new ActionLink(string, arg_0 -> ProjectRunConfigurationConfigurable.createLeftPanel$lambda$0(this, arg_0));
        actionLink.setBorder(JBUI.Borders.empty((int)10));
        actionLink.setBackground(JBColor.background());
        panel2.add((Component)actionLink, "South");
        this.initTree();
        return panel2;
    }

    @Override
    protected void typeOrFactorySelected(@NotNull Object userObject) {
        Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
        this.drawPressAddButtonMessage((ConfigurationType)userObject);
    }

    @Override
    protected void addRunConfigurationsToModel(@NotNull DefaultMutableTreeNode model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        for (Map.Entry<ConfigurationType, Map<String, List<RunnerAndConfigurationSettings>>> entry : this.getRunManager().getConfigurationsGroupedByTypeAndFolder(true).entrySet()) {
            ConfigurationType type = entry.getKey();
            Map<String, List<RunnerAndConfigurationSettings>> folderMap = entry.getValue();
            DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(type);
            model.add(typeNode);
            for (Map.Entry<String, List<RunnerAndConfigurationSettings>> entry2 : folderMap.entrySet()) {
                String folder = entry2.getKey();
                List<RunnerAndConfigurationSettings> configurations = entry2.getValue();
                DefaultMutableTreeNode node = null;
                if (folder == null) {
                    node = typeNode;
                } else {
                    node = new DefaultMutableTreeNode(folder);
                    typeNode.add(node);
                }
                for (RunnerAndConfigurationSettings it : configurations) {
                    node.add(new DefaultMutableTreeNode(it));
                }
            }
        }
    }

    @Override
    @NotNull
    protected JComponent createTipPanelAboutAddingNewRunConfiguration(@Nullable ConfigurationType configurationType) {
        JBPanelWithEmptyText messagePanel = new JBPanelWithEmptyText();
        messagePanel.getEmptyText().appendLine(ExecutionBundle.message((String)"status.text.add.new.run.configuration", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> ProjectRunConfigurationConfigurable.createTipPanelAboutAddingNewRunConfiguration$lambda$0(configurationType, this, arg_0)).appendLine(ExecutionBundle.message((String)"status.text.or.select.run.configuration.to.edit", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES, null);
        return (JComponent)messagePanel;
    }

    private static final Unit createLeftPanel$lambda$0(ProjectRunConfigurationConfigurable this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RunConfigurationTemplatesConfigurableKt.showTemplatesDialog(this$0.getProject(), this$0.getSelectedConfigurationType());
        return Unit.INSTANCE;
    }

    private static final void createTipPanelAboutAddingNewRunConfiguration$lambda$0(ConfigurationType $configurationType, ProjectRunConfigurationConfigurable this$0, ActionEvent it) {
        if ($configurationType == null) {
            RunConfigurable.MyToolbarAddAction myToolbarAddAction = this$0.getToolbarAddAction();
            Object object = it.getSource();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.event.MouseEvent");
            myToolbarAddAction.showAddPopup(true, (MouseEvent)object);
        } else {
            ConfigurationFactory[] configurationFactoryArray = $configurationType.getConfigurationFactories();
            Intrinsics.checkNotNullExpressionValue((Object)configurationFactoryArray, (String)"getConfigurationFactories(...)");
            if (!(((Object[])configurationFactoryArray).length == 0)) {
                ConfigurationFactory configurationFactory = $configurationType.getConfigurationFactories()[0];
                Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"get(...)");
                this$0.createNewConfiguration(configurationFactory);
            }
        }
    }
}

