/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.diagnostic.PluginException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.PersistentAwareRunConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleConfigurationType;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunConfigurationLevel;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImplKt;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunConfigurationStartHistory;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.PathMacroSubstitutorProviderKt;
import com.intellij.openapi.components.impl.ProjectPathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0002\u0014\u0017\u0018\u0000 l2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u00032\u00020\u00052\u00020\u0006:\u0003lmnB1\b\u0007\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010&\u001a\u00070'\u00a2\u0006\u0002\b(H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010)\u001a\u00020\fH\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\fH\u0016J\b\u0010-\u001a\u00020+H\u0016J\b\u0010.\u001a\u00020\fH\u0016J\b\u0010/\u001a\u00020+H\u0016J\b\u00100\u001a\u00020\fH\u0016J\u0010\u00101\u001a\u00020+2\u0006\u00102\u001a\u00020\u001aH\u0016J\b\u00103\u001a\u00020\fH\u0016J\n\u00104\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u00105\u001a\u00020\nH\u0016J\u0010\u00106\u001a\u00020+2\b\u00107\u001a\u0004\u0018\u00010\nJ\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u000209H\u0016J\u0010\u0010:\u001a\u00020+2\u0006\u0010;\u001a\u00020\u001aH\u0016J\u0010\u0010<\u001a\u00020\u00022\u0006\u00107\u001a\u00020\nH\u0002J\b\u0010=\u001a\u00020\u001aH\u0016J\b\u0010>\u001a\u00020\u001aH\u0016J\u0010\u0010?\u001a\u00020+2\u0006\u0010,\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010@\u001a\u00020+2\u0006\u0010,\u001a\u00020\fH\u0016J\b\u0010\u001c\u001a\u00020\fH\u0016J\u0010\u0010A\u001a\u00020+2\u0006\u0010,\u001a\u00020\fH\u0016J\b\u0010\u001d\u001a\u00020\fH\u0016J\u0012\u0010B\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u001aH\u0016J\n\u0010C\u001a\u0004\u0018\u00010\u001aH\u0016J$\u0010D\u001a\u00020+2\u0006\u0010E\u001a\u00020F2\u0006\u00100\u001a\u00020\f2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010\u001aH\u0007J\u000e\u0010H\u001a\u00020+2\u0006\u0010E\u001a\u00020FJ\b\u0010I\u001a\u00020FH\u0016J\u0012\u0010J\u001a\u00020+2\b\u0010K\u001a\u0004\u0018\u00010LH\u0016J\u001b\u0010M\u001a\u0004\u0018\u00010N2\u000e\b\u0004\u0010O\u001a\b\u0012\u0004\u0012\u00020+0PH\u0082\bJ'\u0010Q\u001a\u0004\u0018\u0001HR\"\b\b\u0000\u0010R*\u00020S2\f\u0010T\u001a\b\u0012\u0004\u0012\u0002HR0UH\u0016\u00a2\u0006\u0002\u0010VJ\u0016\u0010W\u001a\u0004\u0018\u00010X2\n\u0010T\u001a\u0006\u0012\u0002\b\u00030UH\u0016J\r\u0010Y\u001a\u00070Z\u00a2\u0006\u0002\b[H\u0016J\b\u0010\\\u001a\u00020\u0000H\u0016J\u0015\u0010]\u001a\u00020+2\u0006\u0010^\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b_J2\u0010`\u001a\u00020+\"\u0004\b\u0000\u0010R2\u0010\u0010a\u001a\f\u0012\u0004\u0012\u0002HR0bR\u00020\u00002\u0010\u0010c\u001a\f\u0012\u0004\u0012\u0002HR0bR\u00020\u0000H\u0002J\u0012\u0010d\u001a\u00020+2\n\u0010T\u001a\u0006\u0012\u0002\b\u00030UJ\u0012\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020\u0004H\u0096\u0082\u0004J\n\u0010h\u001a\u00020\u001aH\u0096\u0080\u0004J\n\u0010i\u001a\u0004\u0018\u00010jH\u0016J\u0006\u0010k\u001a\u00020\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006o"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;", "", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "", "", "Lcom/intellij/configurationStore/SerializableScheme;", "Lcom/intellij/openapi/options/Scheme;", "manager", "Lcom/intellij/execution/impl/RunManagerImpl;", "_configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "isTemplate", "", "level", "Lcom/intellij/execution/impl/RunConfigurationLevel;", "<init>", "(Lcom/intellij/execution/impl/RunManagerImpl;Lcom/intellij/execution/configurations/RunConfiguration;ZLcom/intellij/execution/impl/RunConfigurationLevel;)V", "getManager", "()Lcom/intellij/execution/impl/RunManagerImpl;", "runnerSettings", "com/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$runnerSettings$1", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$runnerSettings$1;", "configurationPerRunnerSettings", "com/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$configurationPerRunnerSettings$1", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$configurationPerRunnerSettings$1;", "pathIfStoredInArbitraryFile", "", "isEditBeforeRun", "isActivateToolWindowBeforeRun", "isFocusToolWindowBeforeRun", "wasSingletonSpecifiedExplicitly", "folderName", "uniqueId", "filePathIfRunningCurrentFile", "getFilePathIfRunningCurrentFile", "()Ljava/lang/String;", "setFilePathIfRunningCurrentFile", "(Ljava/lang/String;)V", "getFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "Lorg/jetbrains/annotations/Nullable;", "isTemporary", "setTemporary", "", "value", "storeInLocalWorkspace", "isStoredInLocalWorkspace", "storeInDotIdeaFolder", "isStoredInDotIdeaFolder", "storeInArbitraryFileInProject", "filePath", "isStoredInArbitraryFileInProject", "getPathIfStoredInArbitraryFileInProject", "getConfiguration", "setConfiguration", "configuration", "createFactory", "Lcom/intellij/openapi/util/Factory;", "setName", "name", "getSettings", "getName", "getUniqueID", "setEditBeforeRun", "setActivateToolWindowBeforeRun", "setFocusToolWindowBeforeRun", "setFolderName", "getFolderName", "readExternal", "element", "Lorg/jdom/Element;", "configFilePath", "writeExternal", "writeScheme", "checkSettings", "executor", "Lcom/intellij/execution/Executor;", "doCheck", "Lcom/intellij/execution/configurations/RuntimeConfigurationWarning;", "check", "Lkotlin/Function0;", "getRunnerSettings", "T", "Lcom/intellij/execution/configurations/RunnerSettings;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "(Lcom/intellij/execution/runners/ProgramRunner;)Lcom/intellij/execution/configurations/RunnerSettings;", "getConfigurationSettings", "Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "getType", "Lcom/intellij/execution/configurations/ConfigurationType;", "Lorg/jetbrains/annotations/NotNull;", "clone", "importRunnerAndConfigurationSettings", "template", "importRunnerAndConfigurationSettings$intellij_platform_execution_impl", "importFromTemplate", "templateItem", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$RunnerItem;", "item", "handleRunnerRemoved", "compareTo", "", "other", "toString", "getSchemeState", "Lcom/intellij/openapi/options/SchemeState;", "needsToBeMigrated", "Companion", "InfoProvider", "RunnerItem", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nRunnerAndConfigurationSettingsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunnerAndConfigurationSettingsImpl.kt\ncom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,650:1\n413#1,5:680\n413#1,5:685\n1#2:651\n1#2:663\n1#2:677\n1642#3,10:652\n1915#3:662\n1916#3:664\n1652#3:665\n1642#3,10:666\n1915#3:676\n1916#3:678\n1652#3:679\n*S KotlinDebug\n*F\n+ 1 RunnerAndConfigurationSettingsImpl.kt\ncom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl\n*L\n385#1:680,5\n401#1:685,5\n379#1:663\n380#1:677\n379#1:652,10\n379#1:662\n379#1:664\n379#1:665\n380#1:666,10\n380#1:676\n380#1:678\n380#1:679\n*E\n"})
public final class RunnerAndConfigurationSettingsImpl
implements Cloneable,
RunnerAndConfigurationSettings,
Comparable<Object>,
SerializableScheme,
Scheme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RunManagerImpl manager;
    @Nullable
    private RunConfiguration _configuration;
    private boolean isTemplate;
    @NotNull
    private RunConfigurationLevel level;
    @NotNull
    private final runnerSettings.1 runnerSettings;
    @NotNull
    private final configurationPerRunnerSettings.1 configurationPerRunnerSettings;
    @Nullable
    private String pathIfStoredInArbitraryFile;
    private boolean isEditBeforeRun;
    private boolean isActivateToolWindowBeforeRun;
    private boolean isFocusToolWindowBeforeRun;
    private boolean wasSingletonSpecifiedExplicitly;
    @Nullable
    private String folderName;
    @Nullable
    private String uniqueId;
    @Nullable
    private String filePathIfRunningCurrentFile;

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager, @Nullable RunConfiguration _configuration, boolean isTemplate, @NotNull RunConfigurationLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)manager), (String)"manager");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.manager = manager;
        this._configuration = _configuration;
        this.isTemplate = isTemplate;
        this.level = level;
        RunConfiguration runConfiguration = this._configuration;
        PersistentAwareRunConfiguration persistentAwareRunConfiguration = runConfiguration instanceof PersistentAwareRunConfiguration ? (PersistentAwareRunConfiguration)runConfiguration : null;
        if (persistentAwareRunConfiguration != null) {
            persistentAwareRunConfiguration.setTemplate(this.isTemplate);
        }
        this.runnerSettings = new RunnerItem<RunnerSettings>(this){
            final /* synthetic */ RunnerAndConfigurationSettingsImpl this$0;
            {
                this.this$0 = $receiver;
                super("RunnerSettings");
            }

            public RunnerSettings createSettings(ProgramRunner<?> runner) {
                Intrinsics.checkNotNullParameter(runner, (String)"runner");
                return runner.createConfigurationData((ConfigurationInfoProvider)this.this$0.new InfoProvider(runner));
            }
        };
        this.configurationPerRunnerSettings = new RunnerItem<ConfigurationPerRunnerSettings>(this){
            final /* synthetic */ RunnerAndConfigurationSettingsImpl this$0;
            {
                this.this$0 = $receiver;
                super("ConfigurationWrapper");
            }

            public ConfigurationPerRunnerSettings createSettings(ProgramRunner<?> runner) {
                Intrinsics.checkNotNullParameter(runner, (String)"runner");
                return this.this$0.getConfiguration().createRunnerSettings((ConfigurationInfoProvider)this.this$0.new InfoProvider(runner));
            }
        };
        this.isActivateToolWindowBeforeRun = true;
    }

    public /* synthetic */ RunnerAndConfigurationSettingsImpl(RunManagerImpl runManagerImpl, RunConfiguration runConfiguration, boolean bl, RunConfigurationLevel runConfigurationLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            runConfiguration = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            runConfigurationLevel = RunConfigurationLevel.WORKSPACE;
        }
        this(runManagerImpl, runConfiguration, bl, runConfigurationLevel);
    }

    @NotNull
    public final RunManagerImpl getManager() {
        return this.manager;
    }

    @Nullable
    public final String getFilePathIfRunningCurrentFile() {
        return this.filePathIfRunningCurrentFile;
    }

    public final void setFilePathIfRunningCurrentFile(@Nullable String string) {
        this.filePathIfRunningCurrentFile = string;
    }

    @NotNull
    public ConfigurationFactory getFactory() {
        RunConfiguration runConfiguration = this._configuration;
        if (runConfiguration == null || (runConfiguration = runConfiguration.getFactory()) == null) {
            UnknownConfigurationType unknownConfigurationType = UnknownConfigurationType.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)unknownConfigurationType, (String)"getInstance(...)");
            runConfiguration = (ConfigurationFactory)unknownConfigurationType;
        }
        return runConfiguration;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public boolean isTemporary() {
        return this.level == RunConfigurationLevel.TEMPORARY;
    }

    public void setTemporary(boolean value) {
        this.level = value ? RunConfigurationLevel.TEMPORARY : RunConfigurationLevel.WORKSPACE;
        this.pathIfStoredInArbitraryFile = null;
    }

    public void storeInLocalWorkspace() {
        if (this.level != RunConfigurationLevel.TEMPORARY) {
            this.level = RunConfigurationLevel.WORKSPACE;
        }
        this.pathIfStoredInArbitraryFile = null;
    }

    public boolean isStoredInLocalWorkspace() {
        return this.level == RunConfigurationLevel.WORKSPACE || this.level == RunConfigurationLevel.TEMPORARY;
    }

    public void storeInDotIdeaFolder() {
        this.level = RunConfigurationLevel.PROJECT;
        this.pathIfStoredInArbitraryFile = null;
    }

    public boolean isStoredInDotIdeaFolder() {
        return this.level == RunConfigurationLevel.PROJECT && this.pathIfStoredInArbitraryFile == null;
    }

    public void storeInArbitraryFileInProject(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.level = RunConfigurationLevel.PROJECT;
        this.pathIfStoredInArbitraryFile = filePath;
    }

    public boolean isStoredInArbitraryFileInProject() {
        return this.level == RunConfigurationLevel.PROJECT && this.pathIfStoredInArbitraryFile != null;
    }

    @Nullable
    public String getPathIfStoredInArbitraryFileInProject() {
        return this.pathIfStoredInArbitraryFile;
    }

    @NotNull
    public RunConfiguration getConfiguration() {
        RunConfiguration runConfiguration = this._configuration;
        if (runConfiguration == null) {
            RunConfiguration runConfiguration2 = UnknownConfigurationType.getInstance().createTemplateConfiguration(this.manager.getProject());
            runConfiguration = runConfiguration2;
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration2, (String)"createTemplateConfiguration(...)");
        }
        return runConfiguration;
    }

    public final void setConfiguration(@Nullable RunConfiguration configuration) {
        this._configuration = configuration;
    }

    @NotNull
    public Factory<RunnerAndConfigurationSettings> createFactory() {
        return () -> RunnerAndConfigurationSettingsImpl.createFactory$lambda$0(this);
    }

    public void setName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean alreadyExists = this.uniqueId != null && this.manager.getConfigurationById(this.getUniqueID()) != null;
        String oldUniqueId = this.uniqueId;
        this.uniqueId = null;
        this.getConfiguration().setName(name);
        if (alreadyExists) {
            this.manager.addConfiguration(this);
            RunConfigurationStartHistory runConfigHistory = RunConfigurationStartHistory.Companion.getInstance(this.manager.getProject());
            RunConfigurationStartHistory.State it = runConfigHistory.getState();
            boolean bl = false;
            Object object = new Set[]{it.getPinned(), it.getHistory()};
            for (Set set : CollectionsKt.listOf((Object[])object)) {
                RunConfigurationStartHistory.Element element;
                Object v0;
                block3: {
                    object = set;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        RunConfigurationStartHistory.Element it2 = (RunConfigurationStartHistory.Element)t;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it2.getSetting(), (Object)oldUniqueId)) continue;
                        v0 = t;
                        break block3;
                    }
                    v0 = null;
                }
                if ((RunConfigurationStartHistory.Element)v0 == null) continue;
                RunConfigurationStartHistory.Element $this$setName_u24lambda_u242 = element;
                boolean bl3 = false;
                $this$setName_u24lambda_u242.setSetting(this.getSettings(this.getConfiguration()).getUniqueID());
            }
            runConfigHistory.reloadState();
        }
    }

    private final RunnerAndConfigurationSettings getSettings(RunConfiguration configuration) {
        return new RunnerAndConfigurationSettingsImpl(this.manager, configuration, false, null, 12, null);
    }

    @NotNull
    public String getName() {
        RunConfiguration configuration = this.getConfiguration();
        if (this.isTemplate) {
            Object[] objectArray = new Object[]{this.getFactory().getName()};
            String string = ExecutionBundle.message((String)"runner.and.configuration.settings.from.template", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        String string = configuration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public String getUniqueID() {
        String result2;
        block3: {
            block2: {
                result2 = this.uniqueId;
                if (result2 == null) break block2;
                CharSequence charSequence = result2;
                String string = this.getConfiguration().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) break block3;
            }
            RunConfiguration configuration = this.getConfiguration();
            this.uniqueId = result2 = Companion.getUniqueIdFor(configuration);
        }
        return result2;
    }

    public void setEditBeforeRun(boolean value) {
        this.isEditBeforeRun = value;
    }

    public boolean isEditBeforeRun() {
        return this.isEditBeforeRun;
    }

    public void setActivateToolWindowBeforeRun(boolean value) {
        this.isActivateToolWindowBeforeRun = value;
    }

    public boolean isActivateToolWindowBeforeRun() {
        return this.isActivateToolWindowBeforeRun;
    }

    public void setFocusToolWindowBeforeRun(boolean value) {
        this.isFocusToolWindowBeforeRun = value;
    }

    public boolean isFocusToolWindowBeforeRun() {
        return this.isFocusToolWindowBeforeRun;
    }

    public void setFolderName(@Nullable String value) {
        this.folderName = value;
    }

    @Nullable
    public String getFolderName() {
        return this.folderName;
    }

    @JvmOverloads
    public final void readExternal(@NotNull Element element, boolean isStoredInDotIdeaFolder, @Nullable String configFilePath) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.isTemplate = element.getAttributeBooleanValue("default");
        this.level = isStoredInDotIdeaFolder ? RunConfigurationLevel.PROJECT : (element.getAttributeBooleanValue("temporary") || Intrinsics.areEqual((Object)"tempConfiguration", (Object)element.getName()) ? RunConfigurationLevel.TEMPORARY : RunConfigurationLevel.WORKSPACE);
        this.isEditBeforeRun = element.getAttributeBooleanValue("editBeforeRun");
        String value = element.getAttributeValue("activateToolWindowBeforeRun");
        this.isActivateToolWindowBeforeRun = value == null || Boolean.parseBoolean(value);
        this.isFocusToolWindowBeforeRun = element.getAttributeBooleanValue("focusToolWindowBeforeRun");
        this.folderName = element.getAttributeValue("folderName");
        ConfigurationFactory factory = this.manager.getFactory(element.getAttributeValue("type"), element.getAttributeValue("factoryName"), !this.isTemplate);
        RunConfiguration runConfiguration = factory.createTemplateConfiguration(this.manager.getProject(), (RunManager)this.manager);
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"createTemplateConfiguration(...)");
        RunConfiguration configuration = runConfiguration;
        if (!this.isTemplate) {
            String string = element.getAttributeValue("name");
            if (string == null) {
                return;
            }
            configuration.setName(string);
        }
        this._configuration = configuration;
        this.uniqueId = null;
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PathMacroSubstitutorProviderKt.getProjectPathMacroSubstitutor((Project)project, (String)configFilePath).expandPaths(element);
        if (configuration instanceof ModuleBasedConfiguration && ((ModuleBasedConfiguration)configuration).isModuleDirMacroSupported()) {
            String moduleName;
            Element element2 = element.getChild("module");
            String string = moduleName = element2 != null ? element2.getAttributeValue("name") : null;
            if (moduleName != null) {
                Module module = ((ModuleBasedConfiguration)configuration).getConfigurationModule().findModule(moduleName);
                if (module != null) {
                    Module it = module;
                    boolean bl = false;
                    PathMacroManager.getInstance((Module)it).expandPaths(element);
                }
            }
        }
        RunnerAndConfigurationSettingsImplKt.deserializeConfigurationFrom(configuration, element, this.isTemplate);
        this.wasSingletonSpecifiedExplicitly = false;
        String singletonStr = element.getAttributeValue("singleton");
        CharSequence charSequence = singletonStr;
        if (charSequence == null || charSequence.length() == 0) {
            configuration.setAllowRunningInParallel(factory.getSingletonPolicy().isAllowRunningInParallel());
        } else {
            this.wasSingletonSpecifiedExplicitly = true;
            configuration.setAllowRunningInParallel(!Boolean.parseBoolean(singletonStr));
        }
        this.runnerSettings.loadState(element);
        this.configurationPerRunnerSettings.loadState(element);
        this.manager.readBeforeRunTasks(element.getChild("method"), this, configuration);
    }

    public static /* synthetic */ void readExternal$default(RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl, Element element, boolean bl, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        runnerAndConfigurationSettingsImpl.readExternal(element, bl, string);
    }

    public final void writeExternal(@NotNull Element element) {
        String string;
        String it;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RunConfiguration configuration = this.getConfiguration();
        if (configuration.getType().isManaged()) {
            if (this.isTemplate) {
                v0 = element.setAttribute("default", "true");
            } else {
                if (!RunnerAndConfigurationSettingsImplKt.access$isNewSerializationAllowed(this)) {
                    element.setAttribute("default", "false");
                }
                String string2 = StringKt.nullize$default((String)configuration.getName(), (boolean)false, (int)1, null);
                if (string2 != null) {
                    it = string2;
                    boolean bl = false;
                    v0 = element.setAttribute("name", it);
                } else {
                    v0 = null;
                }
            }
            ConfigurationFactory factory = this.getFactory();
            element.setAttribute("type", factory.getType().getId());
            if (!(factory.getType() instanceof SimpleConfigurationType)) {
                element.setAttribute("factoryName", factory.getId());
            }
            if (this.folderName != null) {
                String string3 = this.folderName;
                Intrinsics.checkNotNull((Object)string3);
                element.setAttribute("folderName", string3);
            }
            if (this.isEditBeforeRun) {
                element.setAttribute("editBeforeRun", "true");
            }
            if (!this.isActivateToolWindowBeforeRun) {
                element.setAttribute("activateToolWindowBeforeRun", "false");
            }
            if (this.isFocusToolWindowBeforeRun) {
                element.setAttribute("focusToolWindowBeforeRun", "true");
            }
            if (this.wasSingletonSpecifiedExplicitly || configuration.isAllowRunningInParallel() != factory.getSingletonPolicy().isAllowRunningInParallel()) {
                element.setAttribute("singleton", String.valueOf(!configuration.isAllowRunningInParallel()));
            }
            if (this.isTemporary()) {
                element.setAttribute("temporary", "true");
            }
        }
        RunnerAndConfigurationSettingsImplKt.serializeConfigurationInto(configuration, element);
        if (configuration.getType().isManaged()) {
            this.runnerSettings.getState(element);
            this.configurationPerRunnerSettings.getState(element);
        }
        if (configuration.getType().isManaged()) {
            Element it2 = this.manager.writeBeforeRunTasks(configuration);
            boolean bl = false;
            element.addContent(it2);
        }
        if (configuration instanceof ModuleBasedConfiguration && ((ModuleBasedConfiguration)configuration).isModuleDirMacroSupported()) {
            Module module = ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule();
            if (module != null) {
                it = module;
                boolean bl = false;
                PathMacroManager.getInstance((Module)it).collapsePathsRecursively(element);
            }
        }
        Project project = configuration.getProject();
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)project));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        PathMacroManager macroManager = pathMacroManager;
        String string4 = project.getBasePath();
        if (string4 != null) {
            String it3 = string4;
            boolean bl = false;
            string = PathUtilRt.getParentPath((String)it3);
        } else {
            string = null;
        }
        String projectParentPath = string;
        CharSequence bl = projectParentPath;
        if (!(bl == null || bl.length() == 0)) {
            ReplacePathToMacroMap replacePathMap;
            ProjectPathMacroManager projectPathMacroManager = macroManager instanceof ProjectPathMacroManager ? (ProjectPathMacroManager)macroManager : null;
            Object object = replacePathMap = projectPathMacroManager != null ? projectPathMacroManager.getReplacePathMap() : null;
            if (replacePathMap != null) {
                char c = '$';
                String string5 = "PROJECT_DIR";
                replacePathMap.addReplacement(projectParentPath, c + string5 + "$/..", true);
                PathMacroManager.collapsePaths((Element)element, (boolean)true, (ReplacePathToMacroMap)replacePathMap);
                return;
            }
        }
        PathMacroManager.getInstance((ComponentManager)((ComponentManager)project)).collapsePathsRecursively(element);
    }

    @NotNull
    public Element writeScheme() {
        Element element = new Element("configuration");
        this.writeExternal(element);
        return element;
    }

    public void checkSettings(@Nullable Executor executor) {
        ProgramRunner it$iv$iv;
        boolean bl;
        String it;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        RunConfiguration configuration = this.getConfiguration();
        DataContext dataContext = ProgramParametersConfigurator.projectContext(configuration.getProject(), null, null);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"projectContext(...)");
        DataContext dataContext2 = dataContext;
        RuntimeConfigurationException warning = (RuntimeConfigurationException)((Object)ReadAction.nonBlocking(() -> RunnerAndConfigurationSettingsImpl.checkSettings$lambda$0(dataContext2, configuration)).executeSynchronously());
        if (!(configuration instanceof RunConfigurationBase)) {
            if (warning != null) {
                throw warning;
            }
            return;
        }
        HashSet<ProgramRunner> runners = new HashSet<ProgramRunner>();
        Iterable iterable = this.runnerSettings.getSettings().keySet();
        HashSet<ProgramRunner> hashSet = runners;
        boolean $i$f$mapNotNull = false;
        void var8_12 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (String)element$iv$iv;
            boolean bl3 = false;
            if (ProgramRunner.findRunnerById((String)it) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        hashSet.addAll((List)destination$iv$iv);
        $this$mapNotNull$iv = this.configurationPerRunnerSettings.getSettings().keySet();
        hashSet = runners;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (String)element$iv$iv;
            boolean bl4 = false;
            if (ProgramRunner.findRunnerById((String)it) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        hashSet.addAll((List)destination$iv$iv);
        Executor executor2 = executor;
        if (executor2 != null) {
            Executor it2 = executor2;
            boolean bl5 = false;
            ProgramRunner programRunner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)((RunProfile)configuration));
            if (programRunner != null) {
                ProgramRunner it3 = programRunner;
                boolean bl6 = false;
                runners.add(it3);
            }
        }
        boolean runnerFound = false;
        Object[] objectArray = runners.iterator();
        Intrinsics.checkNotNullExpressionValue(objectArray, (String)"iterator(...)");
        Object[] it2 = objectArray;
        while (it2.hasNext()) {
            RuntimeConfigurationWarning runnerWarning;
            RuntimeConfigurationWarning runtimeConfigurationWarning;
            Object e = it2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            ProgramRunner runner = (ProgramRunner)e;
            if (executor != null && !runner.canRun(executor.getId(), (RunProfile)configuration)) continue;
            RunnerAndConfigurationSettingsImpl this_$iv = this;
            boolean $i$f$doCheck = false;
            try {
                boolean bl7 = false;
                ((RunConfigurationBase)configuration).checkRunnerSettings(runner, (RunnerSettings)this.runnerSettings.getSettings().get(runner.getRunnerId()), (ConfigurationPerRunnerSettings)this.configurationPerRunnerSettings.getSettings().get(runner.getRunnerId()));
                runtimeConfigurationWarning = null;
            }
            catch (RuntimeConfigurationWarning ex$iv) {
                runtimeConfigurationWarning = runnerWarning = ex$iv;
            }
            if (runnerWarning != null) {
                if (warning != null) continue;
                warning = (RuntimeConfigurationException)((Object)runnerWarning);
                continue;
            }
            runnerFound = true;
        }
        if (executor != null && !Intrinsics.areEqual((Object)executor, (Object)DefaultRunExecutor.getRunExecutorInstance()) && !runnerFound) {
            it2 = new Object[]{executor.getId(), configuration};
            throw new RuntimeConfigurationError(ExecutionBundle.message((String)"dialog.message.no.runners.for.configuration", (Object[])it2));
        }
        if (executor != null) {
            RuntimeConfigurationWarning beforeRunWarning;
            RuntimeConfigurationWarning runtimeConfigurationWarning;
            RunnerAndConfigurationSettingsImpl this_$iv = this;
            boolean $i$f$doCheck = false;
            try {
                boolean bl8 = false;
                ((RunConfigurationBase)configuration).checkSettingsBeforeRun();
                runtimeConfigurationWarning = null;
            }
            catch (RuntimeConfigurationWarning ex$iv) {
                runtimeConfigurationWarning = beforeRunWarning = ex$iv;
            }
            if (warning == null && beforeRunWarning != null) {
                warning = (RuntimeConfigurationException)((Object)beforeRunWarning);
            }
        }
        if (warning != null) {
            throw warning;
        }
    }

    private final RuntimeConfigurationWarning doCheck(Function0<Unit> check) {
        boolean $i$f$doCheck = false;
        try {
            check.invoke();
            return null;
        }
        catch (RuntimeConfigurationWarning ex) {
            return ex;
        }
    }

    @Nullable
    public <T extends RunnerSettings> T getRunnerSettings(@NotNull ProgramRunner<T> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        return (T)((RunnerSettings)this.runnerSettings.getOrCreateSettings(runner));
    }

    @Nullable
    public ConfigurationPerRunnerSettings getConfigurationSettings(@NotNull ProgramRunner<?> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        return (ConfigurationPerRunnerSettings)this.configurationPerRunnerSettings.getOrCreateSettings(runner);
    }

    @NotNull
    public ConfigurationType getType() {
        ConfigurationType configurationType = this.getFactory().getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"getType(...)");
        return configurationType;
    }

    @NotNull
    public RunnerAndConfigurationSettingsImpl clone() {
        RunConfiguration runConfiguration = this._configuration;
        Intrinsics.checkNotNull((Object)runConfiguration);
        RunnerAndConfigurationSettingsImpl copy = new RunnerAndConfigurationSettingsImpl(this.manager, runConfiguration.clone(), false, null, 12, null);
        copy.importRunnerAndConfigurationSettings$intellij_platform_execution_impl(this);
        copy.level = this.level;
        copy.pathIfStoredInArbitraryFile = this.pathIfStoredInArbitraryFile;
        return copy;
    }

    public final void importRunnerAndConfigurationSettings$intellij_platform_execution_impl(@NotNull RunnerAndConfigurationSettingsImpl template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        this.importFromTemplate(template.runnerSettings, this.runnerSettings);
        this.importFromTemplate(template.configurationPerRunnerSettings, this.configurationPerRunnerSettings);
        this.isEditBeforeRun = template.isEditBeforeRun;
        this.isActivateToolWindowBeforeRun = template.isActivateToolWindowBeforeRun;
        this.isFocusToolWindowBeforeRun = template.isFocusToolWindowBeforeRun;
    }

    private final <T> void importFromTemplate(RunnerItem<T> templateItem, RunnerItem<T> item) {
        for (String runnerId : templateItem.getSettings().keySet()) {
            ProgramRunner runner;
            if (ProgramRunner.findRunnerById((String)runnerId) == null) continue;
            T data = item.createSettings(runner);
            item.getSettings().put(runnerId, data);
            if (data == null) continue;
            Element temp = new Element("dummy");
            if (templateItem.getSettings().get(runnerId) == null) continue;
            try {
                T templateSettings;
                ((JDOMExternalizable)templateSettings).writeExternal(temp);
                ((JDOMExternalizable)data).readExternal(temp);
            }
            catch (WriteExternalException e) {
                RunManagerImpl.Companion.getLOG$intellij_platform_execution_impl().error((Throwable)e);
            }
            catch (InvalidDataException e) {
                RunManagerImpl.Companion.getLOG$intellij_platform_execution_impl().error((Throwable)e);
            }
        }
    }

    public final void handleRunnerRemoved(@NotNull ProgramRunner<?> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        this.runnerSettings.handleRunnerRemoved(runner);
    }

    @Override
    public int compareTo(@NotNull Object other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other instanceof RunnerAndConfigurationSettings) {
            String string = this.getName();
            String string2 = ((RunnerAndConfigurationSettings)other).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            n = string.compareTo(string2);
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public String toString() {
        return this.getType().getDisplayName() + ": " + (this.isTemplate ? "<template>" : this.getName()) + " (level: " + this.level + ")";
    }

    @Nullable
    public SchemeState getSchemeState() {
        RunConfiguration configuration = this._configuration;
        return configuration == null ? SchemeState.UNCHANGED : (configuration instanceof UnknownRunConfiguration ? (((UnknownRunConfiguration)configuration).isDoNotStore() ? SchemeState.NON_PERSISTENT : SchemeState.UNCHANGED) : (!configuration.getType().isManaged() ? SchemeState.NON_PERSISTENT : null));
    }

    public final boolean needsToBeMigrated() {
        RunConfiguration runConfiguration = this._configuration;
        PersistentAwareRunConfiguration persistentAwareRunConfiguration = runConfiguration instanceof PersistentAwareRunConfiguration ? (PersistentAwareRunConfiguration)runConfiguration : null;
        return persistentAwareRunConfiguration != null ? persistentAwareRunConfiguration.needsToBeMigrated() : false;
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager, @Nullable RunConfiguration _configuration, boolean isTemplate) {
        Intrinsics.checkNotNullParameter((Object)((Object)manager), (String)"manager");
        this(manager, _configuration, isTemplate, null, 8, null);
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager, @Nullable RunConfiguration _configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)manager), (String)"manager");
        this(manager, _configuration, false, null, 12, null);
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager) {
        Intrinsics.checkNotNullParameter((Object)((Object)manager), (String)"manager");
        this(manager, null, false, null, 14, null);
    }

    @JvmOverloads
    public final void readExternal(@NotNull Element element, boolean isStoredInDotIdeaFolder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RunnerAndConfigurationSettingsImpl.readExternal$default(this, element, isStoredInDotIdeaFolder, null, 4, null);
    }

    private static final RunnerAndConfigurationSettings createFactory$lambda$0(RunnerAndConfigurationSettingsImpl this$0) {
        RunConfiguration configuration = this$0.getConfiguration();
        RunManagerImpl runManagerImpl = this$0.manager;
        ConfigurationFactory configurationFactory = configuration.getFactory();
        Intrinsics.checkNotNull((Object)configurationFactory);
        return new RunnerAndConfigurationSettingsImpl(runManagerImpl, configurationFactory.createConfiguration("", configuration), this$0.isTemplate, null, 8, null);
    }

    private static final Unit checkSettings$lambda$0$0(RunConfiguration $configuration) {
        $configuration.checkConfiguration();
        return Unit.INSTANCE;
    }

    private static final RuntimeConfigurationException checkSettings$lambda$0(DataContext $dataContext, RunConfiguration $configuration) {
        try {
            ExecutionManagerImpl.Companion.withEnvironmentDataContext($dataContext, () -> RunnerAndConfigurationSettingsImpl.checkSettings$lambda$0$0($configuration));
        }
        catch (RuntimeConfigurationException e) {
            return e;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final String getUniqueIdFor(@NotNull RunConfiguration configuration) {
        return Companion.getUniqueIdFor(configuration);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$Companion;", "", "<init>", "()V", "getUniqueIdFor", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getUniqueIdFor(@NotNull RunConfiguration configuration) {
            String string;
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            ConfigurationType configurationType = configuration.getType();
            Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"getType(...)");
            ConfigurationType type = configurationType;
            if (!type.isManaged() && (string = configuration.getId()) != null) {
                String it = string;
                boolean bl = false;
                return it;
            }
            UnknownRunConfiguration unknownRunConfiguration = configuration instanceof UnknownRunConfiguration ? (UnknownRunConfiguration)configuration : null;
            return configuration.getType().getDisplayName() + "." + configuration.getName() + (unknownRunConfiguration != null ? Integer.valueOf(unknownRunConfiguration.getUniqueID()) : "");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$InfoProvider;", "Lcom/intellij/execution/configurations/ConfigurationInfoProvider;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "<init>", "(Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;Lcom/intellij/execution/runners/ProgramRunner;)V", "getRunner", "()Lcom/intellij/execution/runners/ProgramRunner;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "getConfiguration", "()Lcom/intellij/execution/configurations/RunConfiguration;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "getRunnerSettings", "()Lcom/intellij/execution/configurations/RunnerSettings;", "configurationSettings", "Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "getConfigurationSettings", "()Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "intellij.platform.execution.impl"})
    private final class InfoProvider
    implements ConfigurationInfoProvider {
        @NotNull
        private final ProgramRunner<?> runner;

        public InfoProvider(ProgramRunner<?> runner) {
            Intrinsics.checkNotNullParameter(runner, (String)"runner");
            this.runner = runner;
        }

        @NotNull
        public ProgramRunner<?> getRunner() {
            return this.runner;
        }

        @NotNull
        public RunConfiguration getConfiguration() {
            return RunnerAndConfigurationSettingsImpl.this.getConfiguration();
        }

        @Nullable
        public RunnerSettings getRunnerSettings() {
            return RunnerAndConfigurationSettingsImpl.this.getRunnerSettings(this.getRunner());
        }

        @Nullable
        public ConfigurationPerRunnerSettings getConfigurationSettings() {
            return RunnerAndConfigurationSettingsImpl.this.getConfigurationSettings(this.getRunner());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00a2\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rJ\u0016\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rJ\u001b\u0010\u0018\u001a\u0004\u0018\u00018\u00002\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0015H&\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00152\b\u0010\u001d\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0019\u0010\u001f\u001a\u0004\u0018\u00018\u00002\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0015\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010 \u001a\u00020\u00122\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000fj\b\u0012\u0004\u0012\u00020\u0004`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$RunnerItem;", "T", "", "childTagName", "", "<init>", "(Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;Ljava/lang/String;)V", "settings", "", "getSettings", "()Ljava/util/Map;", "unloadedSettings", "", "Lorg/jdom/Element;", "loadedIds", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "loadState", "", "element", "findRunner", "Lcom/intellij/execution/runners/ProgramRunner;", "runnerId", "getState", "createSettings", "runner", "(Lcom/intellij/execution/runners/ProgramRunner;)Ljava/lang/Object;", "add", "state", "data", "(Lorg/jdom/Element;Lcom/intellij/execution/runners/ProgramRunner;Ljava/lang/Object;)V", "getOrCreateSettings", "handleRunnerRemoved", "intellij.platform.execution.impl"})
    @SourceDebugExtension(value={"SMAP\nRunnerAndConfigurationSettingsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunnerAndConfigurationSettingsImpl.kt\ncom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$RunnerItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,650:1\n1#2:651\n296#3,2:652\n1661#3,3:654\n383#4,7:657\n*S KotlinDebug\n*F\n+ 1 RunnerAndConfigurationSettingsImpl.kt\ncom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$RunnerItem\n*L\n539#1:652,2\n567#1:654,3\n599#1:657,7\n*E\n"})
    private abstract class RunnerItem<T> {
        @NotNull
        private final String childTagName;
        @NotNull
        private final Map<String, T> settings;
        @Nullable
        private List<Element> unloadedSettings;
        @NotNull
        private final HashSet<String> loadedIds;

        public RunnerItem(String childTagName) {
            Intrinsics.checkNotNullParameter((Object)childTagName, (String)"childTagName");
            this.childTagName = childTagName;
            this.settings = new HashMap();
            this.loadedIds = new HashSet();
        }

        @NotNull
        public final Map<String, T> getSettings() {
            return this.settings;
        }

        public final void loadState(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.settings.clear();
            if (this.unloadedSettings != null) {
                List<Element> list = this.unloadedSettings;
                Intrinsics.checkNotNull(list);
                list.clear();
            }
            this.loadedIds.clear();
            Iterator iterator = element.getChildren(this.childTagName).iterator();
            while (iterator.hasNext()) {
                ProgramRunner<?> runner;
                Element state = (Element)iterator.next();
                if (state.getAttributeValue("RunnerId") != null) {
                    String it;
                    boolean bl = false;
                    v1 = this.findRunner(it);
                } else {
                    v1 = runner = null;
                }
                if (runner == null) {
                    iterator.remove();
                }
                Intrinsics.checkNotNull((Object)state);
                ProgramRunner<?> programRunner = runner;
                this.add(state, runner, programRunner == null ? null : (T)this.createSettings(programRunner));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final ProgramRunner<?> findRunner(String runnerId) {
            ProgramRunner programRunner;
            List runnersById = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)ProgramRunner.PROGRAM_RUNNER_EP.lazySequence(), arg_0 -> RunnerItem.findRunner$lambda$0(runnerId, arg_0)));
            if (runnersById.isEmpty()) {
                programRunner = null;
            } else if (runnersById.size() == 1) {
                programRunner = (ProgramRunner)CollectionsKt.firstOrNull((List)runnersById);
            } else {
                RunManagerImpl.Companion.getLOG$intellij_platform_execution_impl().error("More than one runner found for ID: " + runnerId);
                for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
                    ProgramRunner programRunner2;
                    Object v1;
                    block6: {
                        void $this$firstOrNull$iv;
                        Iterable iterable = runnersById;
                        RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl = RunnerAndConfigurationSettingsImpl.this;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            ProgramRunner it = (ProgramRunner)element$iv;
                            boolean bl = false;
                            if (!it.canRun(executor.getId(), (RunProfile)runnerAndConfigurationSettingsImpl.getConfiguration())) continue;
                            v1 = element$iv;
                            break block6;
                        }
                        v1 = null;
                    }
                    if ((programRunner2 = (ProgramRunner)v1) == null) continue;
                    ProgramRunner it = programRunner2;
                    boolean bl = false;
                    return it;
                }
                programRunner = null;
            }
            return programRunner;
        }

        /*
         * WARNING - void declaration
         */
        public final void getState(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            SmartList runnerSettings2 = new SmartList();
            for (String string : this.settings.keySet()) {
                T settings = this.settings.get(string);
                boolean wasLoaded = this.loadedIds.contains(string);
                if (settings == null && !wasLoaded) continue;
                Element state = new Element(this.childTagName);
                if (settings != null) {
                    ((JDOMExternalizable)settings).writeExternal(state);
                }
                if (!wasLoaded && JDOMUtil.isEmpty((Element)state)) continue;
                state.setAttribute("RunnerId", string);
                runnerSettings2.add((Object)state);
            }
            List<Element> list = this.unloadedSettings;
            if (list != null) {
                Iterable iterable = list;
                Collection destination$iv = (Collection)runnerSettings2;
                boolean $i$f$mapTo = false;
                for (Object item$iv : iterable) {
                    void it;
                    Element element2 = (Element)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.clone());
                }
                SmartList cfr_ignored_0 = (SmartList)destination$iv;
            }
            CollectionsKt.sortWith((List)((List)runnerSettings2), RunnerItem::getState$lambda$1);
            Iterator iterator = runnerSettings2.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Element element3 = (Element)e;
                element.addContent(element3);
            }
        }

        @Nullable
        public abstract T createSettings(@NotNull ProgramRunner<?> var1);

        private final void add(Element state, ProgramRunner<?> runner, T data) {
            if (runner == null) {
                if (this.unloadedSettings == null) {
                    this.unloadedSettings = (List)new SmartList();
                }
                List<Element> list = this.unloadedSettings;
                Intrinsics.checkNotNull(list);
                Element element = JDOMUtil.internElement((Element)state);
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"internElement(...)");
                list.add(element);
                return;
            }
            if (data != null) {
                ((JDOMExternalizable)data).readExternal(state);
            }
            String string = runner.getRunnerId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRunnerId(...)");
            this.settings.put(string, data);
            this.loadedIds.add(runner.getRunnerId());
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final T getOrCreateSettings(@NotNull ProgramRunner<?> runner) {
            Intrinsics.checkNotNullParameter(runner, (String)"runner");
            try {
                Object object;
                void $this$getOrPut$iv;
                Map<String, T> map = this.settings;
                String key$iv = runner.getRunnerId();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    T answer$iv = this.createSettings(runner);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                return (T)object;
            }
            catch (AbstractMethodError e) {
                PluginException.logPluginError((Logger)RunManagerImpl.Companion.getLOG$intellij_platform_execution_impl(), (String)("Update failed for: " + RunnerAndConfigurationSettingsImpl.this.getConfiguration().getType().getDisplayName() + ", runner: " + runner.getRunnerId()), (Throwable)e, runner.getClass());
                return null;
            }
        }

        public final void handleRunnerRemoved(@NotNull ProgramRunner<?> runner) {
            Intrinsics.checkNotNullParameter(runner, (String)"runner");
            RunnerSettings runnerSettings2 = (RunnerSettings)this.settings.get(runner.getRunnerId());
            if (runnerSettings2 != null) {
                this.settings.remove(runner.getRunnerId());
                Element element = new Element(this.childTagName);
                runnerSettings2.writeExternal(element);
                if (this.unloadedSettings == null) {
                    this.unloadedSettings = (List)new SmartList();
                }
                List<Element> list = this.unloadedSettings;
                Intrinsics.checkNotNull(list);
                Element element2 = JDOMUtil.internElement((Element)element);
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"internElement(...)");
                list.add(element2);
                this.loadedIds.remove(runner.getRunnerId());
            }
        }

        private static final boolean findRunner$lambda$0(String $runnerId, ProgramRunner it) {
            return Intrinsics.areEqual((Object)$runnerId, (Object)it.getRunnerId());
        }

        private static final int getState$lambda$1(Element o1, Element o2) {
            String string = o1.getAttributeValue("RunnerId");
            if (string == null) {
                return 1;
            }
            String attributeValue1 = string;
            return StringUtil.compare((String)attributeValue1, (String)o2.getAttributeValue("RunnerId"), (boolean)false);
        }
    }
}

