/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch.execution;

import com.intellij.execution.multilaunch.MultiLaunchConfiguration;
import com.intellij.execution.multilaunch.execution.ExecutionSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/multilaunch/execution/ExecutionSessionManager;", "", "<init>", "()V", "activeSessions", "", "Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;", "Lcom/intellij/execution/multilaunch/execution/ExecutionSession;", "rwLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "setActiveSession", "", "configuration", "session", "getActiveSession", "Companion", "intellij.platform.execution.impl"})
public final class ExecutionSessionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<MultiLaunchConfiguration, ExecutionSession> activeSessions = new LinkedHashMap();
    @NotNull
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setActiveSession(@NotNull MultiLaunchConfiguration configuration, @Nullable ExecutionSession session) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            ExecutionSession executionSession = session == null ? this.activeSessions.remove(configuration) : this.activeSessions.put(configuration, session);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ExecutionSession getActiveSession(@NotNull MultiLaunchConfiguration configuration) {
        ExecutionSession executionSession;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            executionSession = this.activeSessions.get(configuration);
        }
        finally {
            readLock.unlock();
        }
        return executionSession;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/multilaunch/execution/ExecutionSessionManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/execution/multilaunch/execution/ExecutionSessionManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.execution.impl"})
    @SourceDebugExtension(value={"SMAP\nExecutionSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionSessionManager.kt\ncom/intellij/execution/multilaunch/execution/ExecutionSessionManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,34:1\n30#2,2:35\n*S KotlinDebug\n*F\n+ 1 ExecutionSessionManager.kt\ncom/intellij/execution/multilaunch/execution/ExecutionSessionManager$Companion\n*L\n14#1:35,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExecutionSessionManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ExecutionSessionManager> serviceClass$iv = ExecutionSessionManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ExecutionSessionManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

