/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runToolbar;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistryImpl;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ExecutorAction;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runToolbar.ExecutorRunToolbarAction;
import com.intellij.execution.runToolbar.RunToolbarDataKt;
import com.intellij.execution.runToolbar.RunToolbarMainSlotState;
import com.intellij.execution.runToolbar.RunToolbarProcess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0006\u001a\u00020\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarProcessAction;", "Lcom/intellij/execution/actions/ExecutorAction;", "Lcom/intellij/execution/runToolbar/ExecutorRunToolbarAction;", "Lcom/intellij/openapi/project/DumbAware;", "process", "Lcom/intellij/execution/runToolbar/RunToolbarProcess;", "executor", "Lcom/intellij/execution/Executor;", "<init>", "(Lcom/intellij/execution/runToolbar/RunToolbarProcess;Lcom/intellij/execution/Executor;)V", "getProcess", "()Lcom/intellij/execution/runToolbar/RunToolbarProcess;", "displayTextInToolbar", "", "getInformativeIcon", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "selectedConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "", "checkMainSlotVisibility", "state", "Lcom/intellij/execution/runToolbar/RunToolbarMainSlotState;", "update", "getSelectedConfiguration", "canRun", "intellij.platform.execution.impl"})
public class RunToolbarProcessAction
extends ExecutorAction
implements ExecutorRunToolbarAction,
DumbAware {
    @NotNull
    private final RunToolbarProcess process;
    @JvmField
    @NotNull
    protected final Executor executor;

    public RunToolbarProcessAction(@NotNull RunToolbarProcess process2, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        super(executor);
        this.process = process2;
        this.executor = executor;
    }

    @Override
    @NotNull
    public RunToolbarProcess getProcess() {
        return this.process;
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    @Override
    @NotNull
    protected Icon getInformativeIcon(@NotNull Project project, @NotNull RunnerAndConfigurationSettings selectedConfiguration, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)selectedConfiguration, (String)"selectedConfiguration");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Icon icon = this.executor.getIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
        return icon;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) break block2;
            Project project2 = project;
            boolean bl = false;
            if (this.canRun(e)) {
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.getSelectedConfiguration(e);
                if (runnerAndConfigurationSettings != null) {
                    RunnerAndConfigurationSettings it = runnerAndConfigurationSettings;
                    boolean bl2 = false;
                    RunConfiguration runConfiguration = it.getConfiguration();
                    DataContext dataContext = e.getDataContext();
                    Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                    ExecutorRegistryImpl.RunnerHelper.run(project2, runConfiguration, it, dataContext, this.executor);
                }
            }
        }
    }

    @Override
    public boolean checkMainSlotVisibility(@NotNull RunToolbarMainSlotState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return state == RunToolbarMainSlotState.CONFIGURATION;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setText(this.executor.getActionName());
        e.getPresentation().setVisible(!RunToolbarDataKt.isActiveProcess(e));
        if (!RunToolbarProcess.Companion.isExperimentalUpdatingEnabled()) {
            RunToolbarMainSlotState runToolbarMainSlotState = RunToolbarDataKt.mainState(e);
            if (runToolbarMainSlotState != null) {
                RunToolbarMainSlotState it = runToolbarMainSlotState;
                boolean bl = false;
                e.getPresentation().setVisible(e.getPresentation().isVisible() && this.checkMainSlotVisibility(it));
            }
        }
        if (e.getPresentation().isVisible()) {
            e.getPresentation().setEnabled(this.canRun(e));
        }
    }

    @Override
    @Nullable
    protected RunnerAndConfigurationSettings getSelectedConfiguration(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return RunToolbarDataKt.configuration(e);
    }

    protected final boolean canRun(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project != null) {
            boolean bl;
            Project project2 = project;
            boolean bl2 = false;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.getSelectedConfiguration(e);
            if (runnerAndConfigurationSettings != null) {
                RunnerAndConfigurationSettings it = runnerAndConfigurationSettings;
                boolean bl3 = false;
                RunConfiguration runConfiguration = it.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
                bl = ExecutorRegistryImpl.RunnerHelper.canRun$default(project2, this.executor, runConfiguration, null, 8, null);
            } else {
                bl = false;
            }
            return bl;
        }
        return false;
    }
}

