/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.AdditionalRunningOptions;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.InlineResumeCreator;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.StoppableRunDescriptorsKt;
import com.intellij.execution.actions.ExecutorAction;
import com.intellij.execution.actions.RunConfigurationsComboBoxAction;
import com.intellij.execution.actions.RunCurrentFileExecutorAction;
import com.intellij.execution.actions.RunSpecifiedConfigExecutorAction;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.PinConfigurationAction;
import com.intellij.execution.ui.RedesignedRunWidgetKt;
import com.intellij.execution.ui.RunConfigurationStartHistory;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunToolbarPopupKt;
import com.intellij.execution.ui.StopConfigurationInlineAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0000\u001aT\u0010\u0019\u001a\u00020\u00142 \u0010\u001a\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00130\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\"H\u0002\u001a0\u0010(\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020 H\u0002\u001a*\u0010.\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002\u001a \u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u001a\u00102\u001a\u0004\u0018\u00010+2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\tH\u0002\u001a\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002\u001a\u0016\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0016\u0010;\u001a\u00020\u00012\u0006\u00105\u001a\u0002062\u0006\u0010<\u001a\u00020\u0004\u001a\u0014\u0010=\u001a\u0004\u0018\u00010\t2\b\u0010>\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0014\u0010?\u001a\n @*\u0004\u0018\u00010\u00010\u0001*\u00020\tH\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006A"}, d2={"RUN", "", "DEBUG", "recentLimit", "", "getRecentLimit", "()I", "RUN_CONFIGURATION_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "RUN_CONFIGURATION_ID", "Lcom/intellij/openapi/util/Key;", "TAG_PINNED", "TAG_RECENT", "TAG_REGULAR_HIDE", "TAG_REGULAR_SHOW", "TAG_REGULAR_DUPE", "TAG_HIDDEN", "createRunConfigurationsActionGroup", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "selectedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createRunConfigurationActionGroup", "folderMaps", "", "", "alreadyShownIds", "", "withShowAllToggle", "", "actionCreator", "Lkotlin/Function1;", "VOID_EXECUTION_TOPIC", "Lcom/intellij/util/messages/Topic;", "Ljava/lang/Runnable;", "getVOID_EXECUTION_TOPIC", "()Lcom/intellij/util/messages/Topic;", "createRunConfigurationWithInlines", "conf", "runExecutor", "Lcom/intellij/execution/Executor;", "debugExecutor", "isPinned", "createCurrentFileWithInlineActions", "checkIfRunWithExecutor", "config", "executor", "getActiveExecutor", "stopAll", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createStopPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "runCounterToString", "stopCount", "getPersistedConfiguration", "configuration", "shortenName", "kotlin.jvm.PlatformType", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nRunToolbarPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunToolbarPopup.kt\ncom/intellij/execution/ui/RunToolbarPopupKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,816:1\n1220#2,2:817\n1249#2,4:819\n1642#2,10:823\n1915#2:833\n1916#2:835\n1652#2:836\n296#2,2:838\n296#2,2:840\n1391#2:842\n1480#2,5:843\n1586#2:848\n1661#2,3:849\n1915#2,2:852\n1915#2,2:854\n1#3:834\n1#3:837\n*S KotlinDebug\n*F\n+ 1 RunToolbarPopup.kt\ncom/intellij/execution/ui/RunToolbarPopupKt\n*L\n110#1:817,2\n110#1:819,4\n114#1:823,10\n114#1:833\n114#1:835\n114#1:836\n484#1:838,2\n485#1:840,2\n519#1:842\n519#1:843,5\n524#1:848\n524#1:849,3\n525#1:852,2\n533#1:854,2\n114#1:834\n*E\n"})
public final class RunToolbarPopupKt {
    @NotNull
    private static final String RUN = "Run";
    @NotNull
    private static final String DEBUG = "Debug";
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final DataKey<RunnerAndConfigurationSettings> RUN_CONFIGURATION_KEY = DataKey.Companion.create("sub.popup.parent.action");
    @JvmField
    @NotNull
    public static final Key<String> RUN_CONFIGURATION_ID;
    @NotNull
    private static final String TAG_PINNED = "pinned";
    @NotNull
    private static final String TAG_RECENT = "recent";
    @NotNull
    private static final String TAG_REGULAR_HIDE = "regular-hide";
    @NotNull
    private static final String TAG_REGULAR_SHOW = "regular-show";
    @NotNull
    private static final String TAG_REGULAR_DUPE = "regular-dupe";
    @NotNull
    private static final String TAG_HIDDEN = "hidden";
    @ApiStatus.Internal
    @Topic.ProjectLevel
    @NotNull
    private static final Topic<Runnable> VOID_EXECUTION_TOPIC;

    private static final int getRecentLimit() {
        return AdvancedSettings.Companion.getInt("max.recent.run.configurations");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<AnAction> createRunConfigurationsActionGroup(@NotNull Project project, @Nullable VirtualFile selectedFile) {
        boolean withShowAllToggle;
        Object element$iv$iv$iv;
        Iterator $this$mapNotNullTo$iv$iv;
        void it;
        ArrayList<AnAction> arrayList;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        ExecutorRegistry registry = ExecutorRegistry.getInstance();
        Executor executor = registry.getExecutorById(RUN);
        if (executor == null) {
            throw new IllegalStateException("No 'Run' executor found".toString());
        }
        Executor runExecutor = executor;
        Executor executor2 = registry.getExecutorById(DEBUG);
        if (executor2 == null) {
            throw new IllegalStateException("No 'Debug' executor found".toString());
        }
        Executor debugExecutor = executor2;
        Iterable $this$associateBy$iv = RunManager.Companion.getInstance(project).getAllSettings();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo22 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)element$iv$iv;
            arrayList = destination$iv$iv;
            boolean bl = false;
            arrayList.put(it.getUniqueID(), element$iv$iv);
        }
        Map cfgMap = destination$iv$iv;
        Set<String> pinnedIds = RunConfigurationStartHistory.Companion.getInstance(project).pinned();
        Set<String> historyIds = RunConfigurationStartHistory.Companion.getInstance(project).history();
        Iterable $this$mapNotNull$iv = pinnedIds;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$associateByTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        AnAction $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        AnAction anAction = $this$forEach$iv$iv$iv.iterator();
        while (anAction.hasNext()) {
            RunnerAndConfigurationSettings it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = anAction.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            if ((RunnerAndConfigurationSettings)cfgMap.get(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List pinned = (List)destination$iv$iv2;
        Set recents = SequencesKt.toSet((Sequence)SequencesKt.take((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)SetsKt.minus(historyIds, (Iterable)pinnedIds)), arg_0 -> RunToolbarPopupKt.createRunConfigurationsActionGroup$lambda$2(cfgMap, arg_0)), (int)Math.max(RunToolbarPopupKt.getRecentLimit(), 0)));
        HashSet<String> alreadyShownIds = new HashSet<String>();
        if (!((Collection)pinned).isEmpty()) {
            actions.add((AnAction)Separator.create((String)ExecutionBundle.message((String)"run.toolbar.widget.dropdown.pinned.separator.text", (Object[])new Object[0])));
            for (RunnerAndConfigurationSettings conf : pinned) {
                $this$forEach$iv$iv$iv = $i$f$mapNotNullTo = RunToolbarPopupKt.createRunConfigurationWithInlines(project, conf, runExecutor, debugExecutor, true);
                arrayList = actions;
                boolean bl = false;
                it.getTemplatePresentation().putClientProperty(ActionUtil.SEARCH_TAG, (Object)TAG_PINNED);
                it.getTemplatePresentation().putClientProperty(ActionUtil.SECONDARY_TEXT, (Object)conf.getFolderName());
                arrayList.add($i$f$mapNotNullTo);
                alreadyShownIds.add(conf.getUniqueID());
            }
            actions.add((AnAction)Separator.create());
        }
        Map<ConfigurationType, Map<String, List<RunnerAndConfigurationSettings>>> configurationMap = RunManagerImpl.Companion.getInstanceImpl(project).getConfigurationsGroupedByTypeAndFolder(true);
        int configurationCount = SequencesKt.sumOfInt((Sequence)SequencesKt.map((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)configurationMap.values()), RunToolbarPopupKt::createRunConfigurationsActionGroup$lambda$4)), RunToolbarPopupKt::createRunConfigurationsActionGroup$lambda$5));
        boolean bl = (!((Collection)recents).isEmpty() || !((Collection)pinned).isEmpty()) && configurationCount >= RunToolbarPopupKt.getRecentLimit() ? true : (withShowAllToggle = false);
        if (withShowAllToggle) {
            actions.add((AnAction)Separator.create((String)ExecutionBundle.message((String)"run.toolbar.widget.dropdown.recent.separator.text", (Object[])new Object[0])));
            for (RunnerAndConfigurationSettings conf : recents) {
                void it3;
                anAction = RunToolbarPopupKt.createRunConfigurationWithInlines(project, conf, runExecutor, debugExecutor, false);
                element$iv$iv$iv = anAction;
                arrayList = actions;
                boolean bl4 = false;
                it3.getTemplatePresentation().putClientProperty(ActionUtil.SEARCH_TAG, (Object)TAG_RECENT);
                it3.getTemplatePresentation().putClientProperty(ActionUtil.SECONDARY_TEXT, (Object)conf.getFolderName());
                arrayList.add(anAction);
                alreadyShownIds.add(conf.getUniqueID());
            }
            actions.add((AnAction)Separator.create());
            actions.add(ActionManager.getInstance().getAction("AllRunConfigurationsToggle"));
        }
        actions.add(RunToolbarPopupKt.createRunConfigurationActionGroup(configurationMap.values(), (Set<String>)alreadyShownIds, withShowAllToggle, (Function1<? super RunnerAndConfigurationSettings, ? extends AnAction>)((Function1)arg_0 -> RunToolbarPopupKt.createRunConfigurationsActionGroup$lambda$7(project, runExecutor, debugExecutor, arg_0))));
        if (RunConfigurationsComboBoxAction.hasRunCurrentFileItem(project)) {
            actions.add(RunToolbarPopupKt.createCurrentFileWithInlineActions(project, selectedFile, runExecutor, debugExecutor));
        }
        actions.add((AnAction)Separator.create());
        actions.add(ActionManager.getInstance().getAction("editRunConfigurations"));
        return actions;
    }

    private static final AnAction createRunConfigurationActionGroup(Collection<? extends Map<String, ? extends List<? extends RunnerAndConfigurationSettings>>> folderMaps, Set<String> alreadyShownIds, boolean withShowAllToggle, Function1<? super RunnerAndConfigurationSettings, ? extends AnAction> actionCreator) {
        String regularTag = withShowAllToggle ? TAG_REGULAR_HIDE : TAG_REGULAR_SHOW;
        return (AnAction)new ActionGroup(folderMaps, alreadyShownIds, regularTag, actionCreator){
            final /* synthetic */ Collection<Map<String, List<RunnerAndConfigurationSettings>>> $folderMaps;
            final /* synthetic */ Set<String> $alreadyShownIds;
            final /* synthetic */ String $regularTag;
            final /* synthetic */ Function1<RunnerAndConfigurationSettings, AnAction> $actionCreator;
            {
                this.$folderMaps = $folderMaps;
                this.$alreadyShownIds = $alreadyShownIds;
                this.$regularTag = $regularTag;
                this.$actionCreator = $actionCreator;
            }

            public AnAction[] getChildren(AnActionEvent e) {
                ArrayList<createRunConfigurationActionGroup.getChildren.1> result2 = new ArrayList<createRunConfigurationActionGroup.getChildren.1>();
                for (Map<String, List<RunnerAndConfigurationSettings>> folderMap : this.$folderMaps) {
                    result2.add(new ActionGroup(folderMap, this.$alreadyShownIds, this.$regularTag, this.$actionCreator){
                        final /* synthetic */ Map<String, List<RunnerAndConfigurationSettings>> $folderMap;
                        final /* synthetic */ Set<String> $alreadyShownIds;
                        final /* synthetic */ String $regularTag;
                        final /* synthetic */ Function1<RunnerAndConfigurationSettings, AnAction> $actionCreator;
                        {
                            this.$folderMap = $folderMap;
                            this.$alreadyShownIds = $alreadyShownIds;
                            this.$regularTag = $regularTag;
                            this.$actionCreator = $actionCreator;
                            this.getTemplatePresentation().putClientProperty(ActionUtil.ALWAYS_VISIBLE_GROUP, (Object)true);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public AnAction[] getChildren(AnActionEvent e) {
                            Set<String> set;
                            Set<String> set2;
                            Object folderName;
                            ArrayList<Object> result2 = new ArrayList<Object>();
                            for (Map.Entry<String, List<RunnerAndConfigurationSettings>> folderEntry : this.$folderMap.entrySet()) {
                                folderName = folderEntry.getKey();
                                if (folderName == null) {
                                    void $this$forEach$iv;
                                    set2 = (Set<String>)((Object)folderEntry.getValue());
                                    set = this.$alreadyShownIds;
                                    String string = this.$regularTag;
                                    Function1<RunnerAndConfigurationSettings, AnAction> function1 = this.$actionCreator;
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        void it;
                                        RunnerAndConfigurationSettings cfg = (RunnerAndConfigurationSettings)element$iv;
                                        boolean bl3 = false;
                                        String tag = set.contains(cfg.getUniqueID()) ? "regular-dupe" : string;
                                        Object object = function1.invoke((Object)cfg);
                                        AnAction anAction = (AnAction)object;
                                        ArrayList<Object> arrayList = result2;
                                        boolean bl2 = false;
                                        it.getTemplatePresentation().putClientProperty(ActionUtil.SEARCH_TAG, (Object)tag);
                                        arrayList.add(object);
                                    }
                                    continue;
                                }
                                result2.add(new ActionGroup((String)folderName, this.$regularTag, folderEntry, this.$actionCreator){
                                    final /* synthetic */ Map.Entry<String, List<RunnerAndConfigurationSettings>> $folderEntry;
                                    final /* synthetic */ Function1<RunnerAndConfigurationSettings, AnAction> $actionCreator;
                                    {
                                        this.$folderEntry = $folderEntry;
                                        this.$actionCreator = $actionCreator;
                                        this.getTemplatePresentation().setPopupGroup(true);
                                        this.getTemplatePresentation().setText($folderName);
                                        this.getTemplatePresentation().setIcon(AllIcons.Nodes.Folder);
                                        this.getTemplatePresentation().putClientProperty(ActionUtil.SEARCH_TAG, (Object)$regularTag);
                                        this.getTemplatePresentation().putClientProperty(ActionUtil.ALWAYS_VISIBLE_GROUP, (Object)true);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public AnAction[] getChildren(AnActionEvent e) {
                                        void $this$mapTo$iv$iv;
                                        void $this$map$iv;
                                        Iterable iterable = this.$folderEntry.getValue();
                                        Function1<RunnerAndConfigurationSettings, AnAction> function1 = this.$actionCreator;
                                        boolean $i$f$map = false;
                                        void var5_7 = $this$map$iv;
                                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        boolean $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            void cfg;
                                            RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)item$iv$iv;
                                            Collection collection = destination$iv$iv;
                                            boolean bl = false;
                                            collection.add((AnAction)function1.invoke((Object)cfg));
                                        }
                                        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                                        boolean $i$f$toTypedArray = false;
                                        Collection thisCollection$iv = $this$toTypedArray$iv;
                                        return thisCollection$iv.toArray(new AnAction[0]);
                                    }
                                });
                            }
                            for (Map.Entry<String, List<RunnerAndConfigurationSettings>> folderEntry : this.$folderMap.entrySet()) {
                                void $this$forEach$iv;
                                if (folderEntry.getKey() == null) continue;
                                folderName = folderEntry.getValue();
                                set2 = this.$alreadyShownIds;
                                set = this.$actionCreator;
                                boolean $i$f$forEach = false;
                                for (E element$iv : $this$forEach$iv) {
                                    void it;
                                    RunnerAndConfigurationSettings cfg = (RunnerAndConfigurationSettings)element$iv;
                                    boolean bl = false;
                                    if (set2.contains(cfg.getUniqueID())) continue;
                                    Object object = set.invoke(cfg);
                                    AnAction bl3 = (AnAction)object;
                                    ArrayList<Object> arrayList = result2;
                                    boolean bl4 = false;
                                    it.getTemplatePresentation().putClientProperty(ActionUtil.SEARCH_TAG, (Object)"hidden");
                                    it.getTemplatePresentation().putClientProperty(ActionUtil.SECONDARY_TEXT, (Object)folderEntry.getKey());
                                    arrayList.add(object);
                                }
                            }
                            Collection $this$toTypedArray$iv = result2;
                            boolean $i$f$toTypedArray = false;
                            Collection thisCollection$iv = $this$toTypedArray$iv;
                            return thisCollection$iv.toArray(new AnAction[0]);
                        }
                    });
                    result2.add(Separator.getInstance());
                }
                Collection $this$toTypedArray$iv = result2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new AnAction[0]);
            }
        };
    }

    @NotNull
    public static final Topic<Runnable> getVOID_EXECUTION_TOPIC() {
        return VOID_EXECUTION_TOPIC;
    }

    private static final AnAction createRunConfigurationWithInlines(Project project, RunnerAndConfigurationSettings conf, Executor runExecutor, Executor debugExecutor, boolean isPinned) {
        Executor activeExecutor = RunToolbarPopupKt.getActiveExecutor(project, conf);
        boolean showRerunAndStopButtons = !conf.getConfiguration().isAllowRunningInParallel() && activeExecutor != null;
        AnAction resumeAction = InlineResumeCreator.Companion.getInstance(project).getInlineResumeCreator(conf, false);
        AnAction[] anActionArray = new AnAction[]{new RunSpecifiedConfigExecutorAction(runExecutor, conf, false), new StopConfigurationInlineAction(runExecutor, conf), resumeAction, new RunSpecifiedConfigExecutorAction(debugExecutor, conf, false), new StopConfigurationInlineAction(debugExecutor, conf), activeExecutor != null && !Intrinsics.areEqual((Object)activeExecutor, (Object)runExecutor) && !Intrinsics.areEqual((Object)activeExecutor, (Object)debugExecutor) ? new StopConfigurationInlineAction(activeExecutor, conf) : null};
        List inlineActions = CollectionsKt.listOfNotNull((Object[])anActionArray);
        for (AnAction it : inlineActions) {
            it.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.IfRequested);
        }
        DefaultActionGroup inlineActionGroup = new DefaultActionGroup(inlineActions);
        Function1<AnActionEvent, Predicate<Executor>> exclude = RedesignedRunWidgetKt.executorFilterByParentGroupFactory((ActionGroup)new DefaultActionGroup(inlineActions));
        ActionGroup extraGroup = AdditionalRunningOptions.Companion.getInstance(project).getAdditionalActions(conf, false);
        return (AnAction)new RunConfigurationsComboBoxAction.SelectConfigAction(project, conf, inlineActionGroup, extraGroup, showRerunAndStopButtons, activeExecutor, runExecutor, debugExecutor, isPinned, exclude){
            final /* synthetic */ Project $project;
            final /* synthetic */ RunnerAndConfigurationSettings $conf;
            final /* synthetic */ DefaultActionGroup $inlineActionGroup;
            final /* synthetic */ ActionGroup $extraGroup;
            final /* synthetic */ boolean $showRerunAndStopButtons;
            final /* synthetic */ Executor $activeExecutor;
            final /* synthetic */ Executor $runExecutor;
            final /* synthetic */ Executor $debugExecutor;
            final /* synthetic */ boolean $isPinned;
            final /* synthetic */ Function1<AnActionEvent, Predicate<Executor>> $exclude;
            {
                this.$project = $project;
                this.$conf = $conf;
                this.$inlineActionGroup = $inlineActionGroup;
                this.$extraGroup = $extraGroup;
                this.$showRerunAndStopButtons = $showRerunAndStopButtons;
                this.$activeExecutor = $activeExecutor;
                this.$runExecutor = $runExecutor;
                this.$debugExecutor = $debugExecutor;
                this.$isPinned = $isPinned;
                this.$exclude = $exclude;
                super($project, $conf);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.update(e);
                List list = ActionGroupUtil.getVisibleActions((ActionGroup)((ActionGroup)this.$inlineActionGroup), (AnActionEvent)e).toList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
                List<AnAction> filtered = RedesignedRunWidgetKt.filterOutRunIfDebugResumeIsPresent(e, list);
                e.getPresentation().putClientProperty(ActionUtil.INLINE_ACTIONS, filtered);
                if (Registry.Companion.is("run.popup.show.inlines.for.active.configurations", false)) {
                    boolean isRunning = RunToolbarPopupKt.access$getActiveExecutor(this.$project, this.$conf) != null;
                    Iterable $this$forEach$iv = filtered;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        AnAction it = (AnAction)element$iv;
                        boolean bl = false;
                        e.getUpdateSession().presentation(it).putClientProperty(ActionUtil.ALWAYS_VISIBLE_INLINE_ACTION, (Object)isRunning);
                    }
                }
            }

            public AnAction[] getChildren(AnActionEvent e) {
                List prefix = CollectionsKt.listOf((Object)this.$extraGroup);
                if (this.$showRerunAndStopButtons) {
                    Executor extraExecutor = this.$activeExecutor == this.$runExecutor ? this.$debugExecutor : this.$runExecutor;
                    prefix = CollectionsKt.plus((Collection)prefix, (Object)((Object)new RunSpecifiedConfigExecutorAction(extraExecutor, this.$conf, false)));
                }
                PinConfigurationAction pinAction = new PinConfigurationAction(this.$conf, this.$isPinned);
                Collection collection = prefix;
                List<AnAction> list = this.getDefaultChildren((Predicate)this.$exclude.invoke((Object)e));
                Intrinsics.checkNotNullExpressionValue(list, (String)"getDefaultChildren(...)");
                Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list), (Object)((Object)pinAction));
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new AnAction[0]);
            }
        };
    }

    private static final AnAction createCurrentFileWithInlineActions(Project project, VirtualFile selectedFile, Executor runExecutor, Executor debugExecutor) {
        StopConfigurationInlineAction stopConfigurationInlineAction;
        StopConfigurationInlineAction stopConfigurationInlineAction2;
        StopConfigurationInlineAction stopConfigurationInlineAction3;
        Object[] objectArray;
        int n;
        Object v4;
        RunnerAndConfigurationSettings runRunningConfig;
        RunnerAndConfigurationSettings it;
        block12: {
            Object object;
            Object configs;
            block11: {
                Object object2;
                block14: {
                    block13: {
                        if (DumbService.Companion.isDumb(project)) {
                            return (AnAction)new RunConfigurationsComboBoxAction.RunCurrentFileAction();
                        }
                        VirtualFile virtualFile = selectedFile;
                        Object psiFile = virtualFile != null ? VirtualFileUtil.findPsiFile((VirtualFile)virtualFile, (Project)project) : null;
                        object2 = psiFile;
                        if (object2 == null) break block13;
                        PsiFile it2 = object2;
                        boolean bl = false;
                        List<RunnerAndConfigurationSettings> list = ExecutorAction.getRunConfigsForCurrentFile(it2, false);
                        object2 = list;
                        if (list != null) break block14;
                    }
                    object2 = CollectionsKt.emptyList();
                }
                configs = object2;
                Iterable $this$firstOrNull$iv = (Iterable)configs;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (RunnerAndConfigurationSettings)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!RunToolbarPopupKt.checkIfRunWithExecutor(it, runExecutor, project)) continue;
                    object = element$iv;
                    break block11;
                }
                object = null;
            }
            runRunningConfig = (RunnerAndConfigurationSettings)object;
            Iterable $this$firstOrNull$iv = (Iterable)configs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunnerAndConfigurationSettings it3 = (RunnerAndConfigurationSettings)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it3);
                if (!RunToolbarPopupKt.checkIfRunWithExecutor(it3, debugExecutor, project)) continue;
                v4 = element$iv;
                break block12;
            }
            v4 = null;
        }
        RunnerAndConfigurationSettings debugRunningConfig = v4;
        Object[] $i$f$firstOrNull = new Object[4];
        $i$f$firstOrNull[0] = new RunCurrentFileExecutorAction(runExecutor);
        Object[] objectArray2 = $i$f$firstOrNull;
        int n2 = 1;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runRunningConfig;
        if (runnerAndConfigurationSettings != null) {
            Object element$iv;
            element$iv = runnerAndConfigurationSettings;
            n = n2;
            objectArray = objectArray2;
            boolean bl = false;
            stopConfigurationInlineAction3 = new StopConfigurationInlineAction(runExecutor, it);
            objectArray2 = objectArray;
            n2 = n;
            stopConfigurationInlineAction2 = stopConfigurationInlineAction3;
        } else {
            stopConfigurationInlineAction2 = null;
        }
        objectArray2[n2] = stopConfigurationInlineAction2;
        $i$f$firstOrNull[2] = new RunCurrentFileExecutorAction(debugExecutor);
        Object[] objectArray3 = $i$f$firstOrNull;
        int n3 = 3;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = debugRunningConfig;
        if (runnerAndConfigurationSettings2 != null) {
            it = runnerAndConfigurationSettings2;
            n = n3;
            objectArray = objectArray3;
            boolean bl = false;
            stopConfigurationInlineAction3 = new StopConfigurationInlineAction(runExecutor, it);
            objectArray3 = objectArray;
            n3 = n;
            stopConfigurationInlineAction = stopConfigurationInlineAction3;
        } else {
            stopConfigurationInlineAction = null;
        }
        objectArray3[n3] = stopConfigurationInlineAction;
        List inlineActions = CollectionsKt.listOfNotNull((Object[])$i$f$firstOrNull);
        for (Object it4 : inlineActions) {
            ((AnAction)it4).getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.IfRequested);
        }
        Function1<AnActionEvent, Predicate<Executor>> exclude = RedesignedRunWidgetKt.executorFilterByParentGroupFactory((ActionGroup)new DefaultActionGroup(inlineActions));
        return (AnAction)new RunConfigurationsComboBoxAction.RunCurrentFileAction(inlineActions, debugRunningConfig, runExecutor, runRunningConfig, debugExecutor, exclude){
            final /* synthetic */ RunnerAndConfigurationSettings $debugRunningConfig;
            final /* synthetic */ Executor $runExecutor;
            final /* synthetic */ RunnerAndConfigurationSettings $runRunningConfig;
            final /* synthetic */ Executor $debugExecutor;
            final /* synthetic */ Function1<AnActionEvent, Predicate<Executor>> $exclude;
            {
                this.$debugRunningConfig = $debugRunningConfig;
                this.$runExecutor = $runExecutor;
                this.$runRunningConfig = $runRunningConfig;
                this.$debugExecutor = $debugExecutor;
                this.$exclude = $exclude;
                this.getTemplatePresentation().putClientProperty(ActionUtil.INLINE_ACTIONS, $inlineActions);
            }

            public AnAction[] getChildren(AnActionEvent e) {
                List prefix = CollectionsKt.emptyList();
                if (this.$debugRunningConfig != null) {
                    prefix = CollectionsKt.plus((Collection)prefix, (Object)((Object)new RunCurrentFileExecutorAction(this.$runExecutor)));
                }
                if (this.$runRunningConfig != null) {
                    prefix = CollectionsKt.plus((Collection)prefix, (Object)((Object)new RunCurrentFileExecutorAction(this.$debugExecutor)));
                }
                Collection collection = prefix;
                List<AnAction> list = this.getDefaultChildren((Predicate)this.$exclude.invoke((Object)e));
                Intrinsics.checkNotNullExpressionValue(list, (String)"getDefaultChildren(...)");
                Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)collection, (Iterable)list);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new AnAction[0]);
            }
        };
    }

    private static final boolean checkIfRunWithExecutor(RunnerAndConfigurationSettings config, Executor executor, Project project) {
        if (ProgramRunner.getRunner((String)executor.getId(), (RunProfile)((RunProfile)config.getConfiguration())) == null) {
            return false;
        }
        return RunToolbarPopupKt.getActiveExecutor(project, config) == executor;
    }

    /*
     * WARNING - void declaration
     */
    private static final Executor getActiveExecutor(Project project, RunnerAndConfigurationSettings conf) {
        void $this$flatMapTo$iv$iv;
        ExecutionManagerImpl executionManager = ExecutionManagerImpl.Companion.getInstance(project);
        Iterable $this$flatMap$iv = executionManager.getRunningDescriptors((Condition<? super RunnerAndConfigurationSettings>)((Condition)arg_0 -> RunToolbarPopupKt.getActiveExecutor$lambda$1(arg_0 -> RunToolbarPopupKt.getActiveExecutor$lambda$0(conf, arg_0), arg_0)));
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RunContentDescriptor it = (RunContentDescriptor)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = executionManager.getExecutors(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (Executor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final void stopAll(AnActionEvent e) {
        void $this$mapTo$iv$iv;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Iterable $this$map$iv = StoppableRunDescriptorsKt.getStoppableDescriptors(project2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((RunContentDescriptor)it.getFirst());
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RunContentDescriptor descr = (RunContentDescriptor)element$iv;
            boolean bl = false;
            ExecutionManagerImpl.Companion.stopProcess(descr);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBPopup createStopPopup(@NotNull DataContext context, @NotNull Project project) {
        void it;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DefaultActionGroup group2 = new DefaultActionGroup();
        List<Pair<RunContentDescriptor, RunnerAndConfigurationSettings>> descriptorsByEnv = StoppableRunDescriptorsKt.getStoppableDescriptors(project);
        Iterable $this$forEach$iv = descriptorsByEnv;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Pair pair = (Pair)element$iv2;
            boolean bl = false;
            RunContentDescriptor descr = (RunContentDescriptor)pair.component1();
            RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)pair.component2();
            Object object = settings;
            if (object == null || (object = RunToolbarPopupKt.shortenName(object)) == null) {
                object = descr.getDisplayName();
            }
            Object name = object;
            Object[] objectArray = new Object[]{name};
            group2.add((AnAction)DumbAwareAction.create((String)ExecutionBundle.message((String)"stop.item.new.ui.popup", (Object[])objectArray), arg_0 -> RunToolbarPopupKt.createStopPopup$lambda$0$1(arg_0 -> RunToolbarPopupKt.createStopPopup$lambda$0$0(descr, arg_0), arg_0)));
        }
        group2.addSeparator();
        String string = ColorUtil.toHex((Color)JBUI.CurrentTheme.StatusBar.Widget.FOREGROUND);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHex(...)");
        String textColor = string;
        element$iv2 = new Object[]{"<a style=\"color:#" + textColor + ";\">" + descriptorsByEnv.size() + "</a>"};
        String string2 = ExecutionBundle.message((String)"stop.all.new.ui.popup", element$iv2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message = string2;
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)("<html>" + message + "</html>"), arg_0 -> RunToolbarPopupKt.createStopPopup$lambda$2(RunToolbarPopupKt::createStopPopup$lambda$1, arg_0));
        element$iv2 = dumbAwareAction;
        DefaultActionGroup defaultActionGroup = group2;
        boolean bl = false;
        it.copyShortcutFrom(ActionManager.getInstance().getAction("Stop"));
        defaultActionGroup.add((AnAction)dumbAwareAction);
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group2, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, ActionPlaces.getPopupPlace((String)"MainToolbar"));
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        return (JBPopup)listPopup;
    }

    @NotNull
    public static final String runCounterToString(@NotNull AnActionEvent e, int stopCount) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return stopCount > 9 && Intrinsics.areEqual((Object)e.getPlace(), (Object)"NewUiRunToolbar") ? "9+" : String.valueOf(stopCount);
    }

    private static final RunnerAndConfigurationSettings getPersistedConfiguration(RunnerAndConfigurationSettings configuration) {
        Object v4;
        block5: {
            RunConfiguration conf = null;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = configuration;
            if (runnerAndConfigurationSettings == null) {
                return null;
            }
            RunConfiguration runConfiguration = runnerAndConfigurationSettings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            conf = runConfiguration;
            RunProfile runProfile = ExecutionManagerImpl.Companion.getDelegatedRunProfile((RunProfile)conf);
            if (runProfile == null) {
                runProfile = (RunProfile)conf;
            }
            conf = runProfile;
            Project project = configuration.getConfiguration().getProject();
            if (project == null) {
                return null;
            }
            Project project2 = project;
            if (project2.isDisposed()) {
                return null;
            }
            Iterable iterable = RunManager.Companion.getInstance(project2).getAllSettings();
            for (Object t : iterable) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getConfiguration(), (Object)conf)) continue;
                v4 = t;
                break block5;
            }
            v4 = null;
        }
        return v4;
    }

    @Nls
    private static final String shortenName(RunnerAndConfigurationSettings $this$shortenName) {
        return Executor.shortenNameIfNeeded((String)$this$shortenName.getName());
    }

    private static final RunnerAndConfigurationSettings createRunConfigurationsActionGroup$lambda$2(Map $cfgMap, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (RunnerAndConfigurationSettings)$cfgMap.get(it);
    }

    private static final Collection createRunConfigurationsActionGroup$lambda$4(Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.values();
    }

    private static final int createRunConfigurationsActionGroup$lambda$5(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.size();
    }

    private static final AnAction createRunConfigurationsActionGroup$lambda$7(Project $project, Executor $runExecutor, Executor $debugExecutor, RunnerAndConfigurationSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RunToolbarPopupKt.createRunConfigurationWithInlines($project, it, $runExecutor, $debugExecutor, false);
    }

    private static final boolean getActiveExecutor$lambda$0(RunnerAndConfigurationSettings $conf, RunnerAndConfigurationSettings it) {
        return $conf == it;
    }

    private static final boolean getActiveExecutor$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit createStopPopup$lambda$0$0(RunContentDescriptor $descr, AnActionEvent it) {
        ExecutionManagerImpl.Companion.stopProcess($descr);
        return Unit.INSTANCE;
    }

    private static final void createStopPopup$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createStopPopup$lambda$1(AnActionEvent it) {
        Intrinsics.checkNotNull((Object)it);
        RunToolbarPopupKt.stopAll(it);
        return Unit.INSTANCE;
    }

    private static final void createStopPopup$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$shortenName(RunnerAndConfigurationSettings $receiver) {
        return RunToolbarPopupKt.shortenName($receiver);
    }

    public static final /* synthetic */ int access$getRecentLimit() {
        return RunToolbarPopupKt.getRecentLimit();
    }

    public static final /* synthetic */ RunnerAndConfigurationSettings access$getPersistedConfiguration(RunnerAndConfigurationSettings configuration) {
        return RunToolbarPopupKt.getPersistedConfiguration(configuration);
    }

    public static final /* synthetic */ Executor access$getActiveExecutor(Project project, RunnerAndConfigurationSettings conf) {
        return RunToolbarPopupKt.getActiveExecutor(project, conf);
    }

    static {
        Key key = Key.create((String)"sub.popup.run.configuration.unique.id");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        RUN_CONFIGURATION_ID = key;
        VOID_EXECUTION_TOPIC = new Topic("any execution event", Runnable.class);
    }
}

