/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.filters.Filter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.JediTermHyperlinkFilterAdapter;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.terminal.TerminalExecutorServiceManagerImpl;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.TerminalTitleKt;
import com.intellij.terminal.search.DefaultJediTermSearchComponent;
import com.intellij.terminal.search.JediTermSearchComponentProvider;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.terminal.ui.TtyConnectorAccessor;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBSwingUtilities;
import com.jediterm.core.Color;
import com.jediterm.core.compatibility.Point;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TerminalExecutorServiceManager;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.SelectionUtil;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.AwtTransformers;
import com.jediterm.terminal.ui.JediTermSearchComponent;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.TerminalPanel;
import com.jediterm.terminal.ui.TerminalWidgetListener;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Graphics;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import kotlin.Pair;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTerminalWidget
extends JediTermWidget
implements Disposable,
UiCompatibleDataProvider {
    private static final Logger LOG = Logger.getInstance(JBTerminalWidget.class);
    public static final DataKey<JBTerminalWidget> TERMINAL_DATA_KEY = DataKey.create((String)JBTerminalWidget.class.getName());
    public static final DataKey<String> SELECTED_TEXT_DATA_KEY = DataKey.create((String)(JBTerminalWidget.class.getName() + " selected text"));
    private JBTerminalWidgetListener myListener;
    private final Project myProject;
    @NotNull
    private final TerminalTitle myTerminalTitle;
    @NotNull
    private final JediTermHyperlinkFilterAdapter myHyperlinkFilter;
    private final TerminalWidgetBridge myBridge;

    public JBTerminalWidget(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @NotNull Disposable parent) {
        if (project == null) {
            JBTerminalWidget.$$$reportNull$$$0(0);
        }
        if (settingsProvider == null) {
            JBTerminalWidget.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            JBTerminalWidget.$$$reportNull$$$0(2);
        }
        this(project, 80, 24, settingsProvider, null, parent);
    }

    public JBTerminalWidget(@NotNull Project project, int columns, int lines, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @Nullable TerminalExecutionConsole console, @NotNull Disposable parent) {
        if (project == null) {
            JBTerminalWidget.$$$reportNull$$$0(3);
        }
        if (settingsProvider == null) {
            JBTerminalWidget.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            JBTerminalWidget.$$$reportNull$$$0(5);
        }
        super(columns, lines, (SettingsProvider)settingsProvider);
        this.myTerminalTitle = new TerminalTitle();
        this.myBridge = new TerminalWidgetBridge();
        this.myProject = project;
        this.myHyperlinkFilter = new JediTermHyperlinkFilterAdapter(project, console, this);
        this.addAsyncHyperlinkFilter(this.myHyperlinkFilter);
        Disposer.register((Disposable)parent, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myBridge);
        this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return JBTerminalWidget.this.getTerminalPanel();
            }
        });
        TerminalTitleKt.bindApplicationTitle(this.myTerminalTitle, this.getTerminal(), this);
    }

    public JBTerminalWidgetListener getListener() {
        return this.myListener;
    }

    public void setListener(JBTerminalWidgetListener listener2) {
        this.myListener = listener2;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            JBTerminalWidget.$$$reportNull$$$0(6);
        }
        return project;
    }

    @NotNull
    protected TerminalExecutorServiceManager createExecutorServiceManager() {
        return new TerminalExecutorServiceManagerImpl();
    }

    protected JBTerminalPanel createTerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull StyleState styleState, @NotNull TerminalTextBuffer textBuffer) {
        if (settingsProvider == null) {
            JBTerminalWidget.$$$reportNull$$$0(7);
        }
        if (styleState == null) {
            JBTerminalWidget.$$$reportNull$$$0(8);
        }
        if (textBuffer == null) {
            JBTerminalWidget.$$$reportNull$$$0(9);
        }
        JBTerminalPanel panel2 = new JBTerminalPanel((JBTerminalSystemSettingsProviderBase)settingsProvider, textBuffer, styleState);
        Disposer.register((Disposable)this, (Disposable)panel2);
        return panel2;
    }

    @NotNull
    public JBTerminalPanel getTerminalPanel() {
        JBTerminalPanel jBTerminalPanel = (JBTerminalPanel)super.getTerminalPanel();
        if (jBTerminalPanel == null) {
            JBTerminalWidget.$$$reportNull$$$0(10);
        }
        return jBTerminalPanel;
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)((Object)this), (Graphics)super.getComponentGraphics(graphics));
    }

    protected JScrollBar createScrollBar() {
        JBScrollBar bar = new JBScrollBar(){

            public java.awt.Color getBackground() {
                return JBTerminalWidget.this.myTerminalPanel.getBackground();
            }
        };
        bar.setOpaque(true);
        bar.putClientProperty(JBScrollPane.Alignment.class, (Object)JBScrollPane.Alignment.RIGHT);
        bar.putClientProperty((Object)JBScrollBar.TRACK, (g, x, y, width, height, object) -> {
            SubstringFinder.FindResult result2 = this.myTerminalPanel.getFindResult();
            if (result2 != null) {
                int modelHeight = bar.getModel().getMaximum() - bar.getModel().getMinimum();
                TerminalColor backgroundColor = this.mySettingsProvider.getFoundPatternColor().getBackground();
                if (backgroundColor != null) {
                    g.setColor(AwtTransformers.toAwtColor((Color)this.mySettingsProvider.getTerminalColorPalette().getBackground(backgroundColor)));
                }
                int anchorHeight = Math.max(2, height / modelHeight);
                for (SubstringFinder.FindResult.FindItem r : result2.getItems()) {
                    int where = height * r.getStart().y / modelHeight;
                    g.fillRect(x, y + where, width, anchorHeight);
                }
            }
        });
        return bar;
    }

    @Nullable
    public ProcessTtyConnector getProcessTtyConnector() {
        return (ProcessTtyConnector)ObjectUtils.tryCast((Object)this.getTtyConnector(), ProcessTtyConnector.class);
    }

    static boolean isTerminalToolWindow(@Nullable ToolWindow toolWindow) {
        return toolWindow != null && "Terminal".equals(toolWindow.getId());
    }

    public void dispose() {
        this.close();
    }

    @NotNull
    protected JediTermSearchComponent createSearchComponent() {
        JediTermSearchComponentProvider provider = (JediTermSearchComponentProvider)ApplicationManager.getApplication().getService(JediTermSearchComponentProvider.class);
        return provider != null ? provider.createSearchComponent(this) : new DefaultJediTermSearchComponent();
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            JBTerminalWidget.$$$reportNull$$$0(11);
        }
        this.myHyperlinkFilter.addFilter(filter);
    }

    public void start(TtyConnector connector) {
        this.setTtyConnector(connector);
        this.start();
    }

    @NotNull
    public JBTerminalSystemSettingsProviderBase getSettingsProvider() {
        JBTerminalSystemSettingsProviderBase jBTerminalSystemSettingsProviderBase = (JBTerminalSystemSettingsProviderBase)this.mySettingsProvider;
        if (jBTerminalSystemSettingsProviderBase == null) {
            JBTerminalWidget.$$$reportNull$$$0(12);
        }
        return jBTerminalSystemSettingsProviderBase;
    }

    public void notifyStarted() {
        if (this.myListener != null) {
            this.myListener.onTerminalStarted();
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            JBTerminalWidget.$$$reportNull$$$0(13);
        }
        sink.set(SELECTED_TEXT_DATA_KEY, (Object)this.getSelectedText());
        sink.set(TERMINAL_DATA_KEY, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static String getSelectedText(@NotNull TerminalPanel terminalPanel) {
        TerminalSelection selection;
        if (terminalPanel == null) {
            JBTerminalWidget.$$$reportNull$$$0(14);
        }
        if ((selection = terminalPanel.getSelection()) == null) {
            return null;
        }
        TerminalTextBuffer buffer = terminalPanel.getTerminalTextBuffer();
        buffer.lock();
        try {
            Pair points = selection.pointsForRun(buffer.getWidth());
            String string = SelectionUtil.getSelectionText((Point)((Point)points.getFirst()), (Point)((Point)points.getSecond()), (TerminalTextBuffer)buffer);
            return string;
        }
        finally {
            buffer.unlock();
        }
    }

    @NotNull
    public String getText() {
        return JBTerminalWidget.getText(this.getTerminalPanel());
    }

    @Nullable
    public String getSelectedText() {
        return JBTerminalWidget.getSelectedText(this.getTerminalPanel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static String getText(@NotNull TerminalPanel terminalPanel) {
        if (terminalPanel == null) {
            JBTerminalWidget.$$$reportNull$$$0(15);
        }
        TerminalTextBuffer buffer = terminalPanel.getTerminalTextBuffer();
        buffer.lock();
        TerminalSelection selection = new TerminalSelection(new Point(0, -buffer.getHistoryLinesCount()), new Point(buffer.getWidth(), buffer.getScreenLinesCount() - 1));
        Pair points = selection.pointsForRun(buffer.getWidth());
        String string = SelectionUtil.getSelectionText((Point)((Point)points.getFirst()), (Point)((Point)points.getSecond()), (TerminalTextBuffer)buffer);
        String string2 = string;
        if (string2 == null) {
            JBTerminalWidget.$$$reportNull$$$0(16);
        }
        return string2;
        finally {
            buffer.unlock();
        }
    }

    public void writePlainMessage(@NotNull @Nls String message) {
        if (message == null) {
            JBTerminalWidget.$$$reportNull$$$0(17);
        }
        String str = StringUtil.convertLineSeparators((String)message, (String)LineSeparator.LF.getSeparatorString());
        List lines = StringUtil.split((String)str, (String)LineSeparator.LF.getSeparatorString(), (boolean)true, (boolean)false);
        boolean first = true;
        for (String line : lines) {
            if (!first) {
                this.myTerminal.carriageReturn();
                this.myTerminal.newLine();
            }
            this.myTerminal.writeCharacters(line);
            first = false;
        }
    }

    @NotNull
    public TerminalTitle getTerminalTitle() {
        TerminalTitle terminalTitle = this.myTerminalTitle;
        if (terminalTitle == null) {
            JBTerminalWidget.$$$reportNull$$$0(18);
        }
        return terminalTitle;
    }

    protected void executeCommand(@NotNull String shellCommand) throws IOException {
        if (shellCommand == null) {
            JBTerminalWidget.$$$reportNull$$$0(19);
        }
        throw new RuntimeException("Should be called for ShellTerminalWidget only");
    }

    @Nullable
    protected List<String> getShellCommand() {
        throw new RuntimeException("Should be called for ShellTerminalWidget only");
    }

    protected void setShellCommand(@Nullable List<String> command) {
        throw new RuntimeException("Should be called for ShellTerminalWidget only");
    }

    protected boolean hasRunningCommands() throws IllegalStateException {
        return false;
    }

    @Nullable
    protected String getCurrentDirectory() {
        return null;
    }

    @NotNull
    public TerminalWidget asNewWidget() {
        TerminalWidgetBridge terminalWidgetBridge = this.myBridge;
        if (terminalWidgetBridge == null) {
            JBTerminalWidget.$$$reportNull$$$0(20);
        }
        return terminalWidgetBridge;
    }

    @Nullable
    public static JBTerminalWidget asJediTermWidget(@NotNull TerminalWidget widget) {
        JBTerminalWidget jBTerminalWidget;
        if (widget == null) {
            JBTerminalWidget.$$$reportNull$$$0(21);
        }
        if (widget instanceof TerminalWidgetBridge) {
            TerminalWidgetBridge bridge = (TerminalWidgetBridge)widget;
            jBTerminalWidget = bridge.widget();
        } else {
            jBTerminalWidget = null;
        }
        return jBTerminalWidget;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10, 12, 16, 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/JBTerminalWidget";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleState";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textBuffer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalPanel";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellCommand";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/JBTerminalWidget";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsProvider";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalTitle";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "asNewWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 16: 
            case 18: 
            case 20: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalPanel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writePlainMessage";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "asJediTermWidget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10, 12, 16, 18, 20 -> new IllegalStateException(string);
        };
    }

    private final class TerminalWidgetBridge
    implements TerminalWidget {
        private final TtyConnectorAccessor myTtyConnectorAccessor = new TtyConnectorAccessor();

        private TerminalWidgetBridge() {
        }

        @NotNull
        private JBTerminalWidget widget() {
            JBTerminalWidget jBTerminalWidget = JBTerminalWidget.this;
            if (jBTerminalWidget == null) {
                TerminalWidgetBridge.$$$reportNull$$$0(0);
            }
            return jBTerminalWidget;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.widget().getComponent();
            if (jComponent == null) {
                TerminalWidgetBridge.$$$reportNull$$$0(1);
            }
            return jComponent;
        }

        public JComponent getPreferredFocusableComponent() {
            return this.widget().getPreferredFocusableComponent();
        }

        @Override
        @NotNull
        public TerminalTitle getTerminalTitle() {
            TerminalTitle terminalTitle = this.widget().myTerminalTitle;
            if (terminalTitle == null) {
                TerminalWidgetBridge.$$$reportNull$$$0(2);
            }
            return terminalTitle;
        }

        @Override
        public void connectToTty(@NotNull TtyConnector ttyConnector, @NotNull TermSize initialTermSize) {
            if (ttyConnector == null) {
                TerminalWidgetBridge.$$$reportNull$$$0(3);
            }
            if (initialTermSize == null) {
                TerminalWidgetBridge.$$$reportNull$$$0(4);
            }
            this.widget().getTerminal().resize(initialTermSize, RequestOrigin.User);
            this.widget().createTerminalSession(ttyConnector);
            this.widget().start();
            this.widget().getComponent().revalidate();
            this.widget().notifyStarted();
            this.myTtyConnectorAccessor.setTtyConnector(ttyConnector);
        }

        @Override
        @Nullable
        public TermSize getTermSize() {
            return this.widget().getTerminalPanel().getTerminalSizeFromComponent();
        }

        @Override
        public void writePlainMessage(@NotNull @Nls String message) {
            if (message == null) {
                TerminalWidgetBridge.$$$reportNull$$$0(5);
            }
            this.widget().writePlainMessage(message);
        }

        @Override
        public void setCursorVisible(boolean visible) {
            ApplicationManager.getApplication().invokeLater(() -> this.widget().getTerminalPanel().setCursorVisible(false), JBTerminalWidget.this.myProject.getDisposed());
        }

        public void dispose() {
        }

        @Override
        @NotNull
        public TtyConnectorAccessor getTtyConnectorAccessor() {
            TtyConnectorAccessor ttyConnectorAccessor = this.myTtyConnectorAccessor;
            if (ttyConnectorAccessor == null) {
                TerminalWidgetBridge.$$$reportNull$$$0(6);
            }
            return ttyConnectorAccessor;
        }

        @Override
        public boolean hasFocus() {
            return this.widget().getTerminalPanel().hasFocus();
        }

        @Override
        public void requestFocus() {
            IdeFocusManager.getInstance((Project)JBTerminalWidget.this.myProject).requestFocus((Component)((Object)this.widget().getTerminalPanel()), true);
        }

        @Override
        public void addTerminationCallback(final @NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
            if (onTerminated == null) {
                TerminalWidgetBridge.$$$reportNull$$$0(7);
            }
            if (parentDisposable == null) {
                TerminalWidgetBridge.$$$reportNull$$$0(8);
            }
            TerminalWidgetListener listener2 = new TerminalWidgetListener(){

                public void allSessionsClosed(com.jediterm.terminal.ui.TerminalWidget widget) {
                    onTerminated.run();
                }
            };
            this.widget().addListener(listener2);
            Disposer.register((Disposable)parentDisposable, () -> this.widget().removeListener(listener2));
        }

        @Override
        public void addNotification(@NotNull JComponent notificationComponent, @NotNull Disposable disposable) {
            if (notificationComponent == null) {
                TerminalWidgetBridge.$$$reportNull$$$0(9);
            }
            if (disposable == null) {
                TerminalWidgetBridge.$$$reportNull$$$0(10);
            }
            this.widget().add(notificationComponent, "North");
            Disposer.register((Disposable)disposable, () -> {
                this.widget().remove(notificationComponent);
                this.widget().revalidate();
            });
        }

        @Override
        public void sendCommandToExecute(@NotNull String shellCommand) {
            if (shellCommand == null) {
                TerminalWidgetBridge.$$$reportNull$$$0(11);
            }
            try {
                this.widget().executeCommand(shellCommand);
            }
            catch (IOException e) {
                LOG.info("Cannot execute shell command: " + shellCommand);
            }
        }

        @Override
        @NotNull
        public CharSequence getText() {
            String string = this.widget().getText();
            if (string == null) {
                TerminalWidgetBridge.$$$reportNull$$$0(12);
            }
            return string;
        }

        @Override
        public boolean isCommandRunning() {
            try {
                return this.widget().hasRunningCommands();
            }
            catch (IllegalStateException e) {
                return true;
            }
        }

        @Override
        @Nullable
        public String getCurrentDirectory() {
            return this.widget().getCurrentDirectory();
        }

        @Override
        @Nullable
        public List<String> getShellCommand() {
            return this.widget().getShellCommand();
        }

        @Override
        public void setShellCommand(@Nullable List<String> command) {
            this.widget().setShellCommand(command);
        }

        @Override
        @NotNull
        public @NotNull CompletableFuture<@NotNull TermSize> getTerminalSizeInitializedFuture() {
            throw new IllegalStateException("getTerminalSizeInitializedFuture is not supported in TerminalWidgetBridge");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5, 7, 8, 9, 10, 11 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/terminal/JBTerminalWidget$TerminalWidgetBridge";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ttyConnector";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialTermSize";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onTerminated";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notificationComponent";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shellCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "widget";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTerminalTitle";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/terminal/JBTerminalWidget$TerminalWidgetBridge";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTtyConnectorAccessor";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "connectToTty";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "writePlainMessage";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addTerminationCallback";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addNotification";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "sendCommandToExecute";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
            };
        }
    }
}

