/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.util.ui.UIUtil;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TerminalEscapeKeyListener {
    private final JBTerminalPanel myTerminalPanel;
    private final AnAction myTerminalSwitchFocusToEditorAction;

    public TerminalEscapeKeyListener(@NotNull JBTerminalPanel terminalPanel) {
        if (terminalPanel == null) {
            TerminalEscapeKeyListener.$$$reportNull$$$0(0);
        }
        this.myTerminalPanel = terminalPanel;
        this.myTerminalSwitchFocusToEditorAction = ActionManager.getInstance().getAction("Terminal.SwitchFocusToEditor");
    }

    public void handleKeyEvent(@NotNull KeyEvent e) {
        if (e == null) {
            TerminalEscapeKeyListener.$$$reportNull$$$0(1);
        }
        if (e.getID() == 401 && !e.isConsumed() && this.isMatched(e) && this.switchFocusToEditorIfSuitable()) {
            e.consume();
        }
    }

    private boolean isMatched(@NotNull KeyEvent e) {
        KeyStroke stroke;
        if (e == null) {
            TerminalEscapeKeyListener.$$$reportNull$$$0(2);
        }
        return (stroke = this.getKeyStroke()) != null && stroke.getKeyCode() == e.getKeyCode() && stroke.getModifiers() == UIUtil.getAllModifiers((InputEvent)e);
    }

    @Nullable
    private KeyStroke getKeyStroke() {
        if (this.myTerminalSwitchFocusToEditorAction == null) {
            return null;
        }
        return KeymapUtil.getKeyStroke((ShortcutSet)this.myTerminalSwitchFocusToEditorAction.getShortcutSet());
    }

    private boolean switchFocusToEditorIfSuitable() {
        Project project;
        if (this.shouldSwitchFocusToEditor() && (project = this.myTerminalPanel.getContextProject()) != null && !project.isDisposed()) {
            ToolWindowManager.getInstance((Project)project).activateEditorComponent();
            return true;
        }
        return false;
    }

    private boolean shouldSwitchFocusToEditor() {
        if (this.myTerminalPanel.getTerminalTextBuffer().isUsingAlternateBuffer()) {
            return false;
        }
        ToolWindow toolWindow = this.myTerminalPanel.getContextToolWindow();
        if (toolWindow == null) {
            return false;
        }
        return !JBTerminalWidget.isTerminalToolWindow(toolWindow) || AdvancedSettings.getBoolean((String)"terminal.escape.moves.focus.to.editor");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/terminal/TerminalEscapeKeyListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleKeyEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isMatched";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

