/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.StopAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressModel;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class StopBackgroundProcessesAction
extends DumbAwareAction {
    StopBackgroundProcessesAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            StopBackgroundProcessesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            StopBackgroundProcessesAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(!StopBackgroundProcessesAction.getCancellableProcesses(e.getProject()).isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Component component;
        if (e == null) {
            StopBackgroundProcessesAction.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        List<StopAction.HandlerItem> handlerItems = StopBackgroundProcessesAction.getItemsList(StopBackgroundProcessesAction.getCancellableProcesses(project));
        if (handlerItems.isEmpty()) {
            return;
        }
        JBList list = new JBList(handlerItems);
        list.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer((ListItemDescriptor)new ListItemDescriptorAdapter<StopAction.HandlerItem>(this){

            @Nullable
            public String getTextFor(StopAction.HandlerItem item) {
                return item.displayName;
            }

            @Nullable
            public Icon getIconFor(StopAction.HandlerItem item) {
                return item.icon;
            }

            public boolean hasSeparatorAboveOf(StopAction.HandlerItem item) {
                return item.hasSeparator;
            }
        }));
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setMovable(true).setTitle(handlerItems.size() == 1 ? ExecutionBundle.message((String)"confirm.background.process.stop", (Object[])new Object[0]) : ExecutionBundle.message((String)"stop.background.process", (Object[])new Object[0])).setNamerForFiltering(o -> o.displayName).setItemChosenCallback(() -> {
            List valuesList = list.getSelectedValuesList();
            for (Object o : valuesList) {
                if (!(o instanceof StopAction.HandlerItem)) continue;
                ((StopAction.HandlerItem)o).stop();
            }
        }).setRequestFocus(true).createPopup();
        InputEvent inputEvent = e.getInputEvent();
        Component component2 = component = inputEvent != null ? inputEvent.getComponent() : null;
        if (component != null && ("MainToolbar".equals(e.getPlace()) || "NavBarToolbar".equals(e.getPlace()))) {
            popup.showUnderneathOf(component);
        } else if (project == null) {
            popup.showInBestPositionFor(dataContext);
        } else {
            popup.showCenteredInCurrentWindow(project);
        }
    }

    private static @Unmodifiable @NotNull List<Pair<TaskInfo, ProgressModel>> getCancellableProcesses(@Nullable Project project) {
        StatusBarEx statusBar;
        IdeFrame frame = WindowManagerEx.getInstanceEx().findFrameFor(project);
        StatusBarEx statusBarEx = statusBar = frame == null ? null : (StatusBarEx)frame.getStatusBar();
        if (statusBar == null) {
            List<Pair<TaskInfo, ProgressModel>> list = Collections.emptyList();
            if (list == null) {
                StopBackgroundProcessesAction.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<Pair<TaskInfo, ProgressModel>> list = statusBar.getBackgroundProcessModels().stream().filter(pair -> {
            TaskInfo taskInfo = (TaskInfo)pair.getFirst();
            return taskInfo.isCancellable() && !((ProgressModel)pair.getSecond()).isStopping(taskInfo);
        }).toList();
        if (list == null) {
            StopBackgroundProcessesAction.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static List<StopAction.HandlerItem> getItemsList(@NotNull List<Pair<TaskInfo, ProgressModel>> tasks) {
        if (tasks == null) {
            StopBackgroundProcessesAction.$$$reportNull$$$0(5);
        }
        ArrayList<StopAction.HandlerItem> items = new ArrayList<StopAction.HandlerItem>(tasks.size());
        for (final Pair<TaskInfo, ProgressModel> eachPair : tasks) {
            items.add(new StopAction.HandlerItem(((TaskInfo)eachPair.getFirst()).getTitle(), AllIcons.Process.Step_passive, false){

                @Override
                void stop() {
                    ((ProgressModel)eachPair.getSecond()).cancel();
                }
            });
        }
        ArrayList<StopAction.HandlerItem> arrayList = items;
        if (arrayList == null) {
            StopBackgroundProcessesAction.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/StopBackgroundProcessesAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/StopBackgroundProcessesAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancellableProcesses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getItemsList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5 -> new IllegalArgumentException(string);
        };
    }
}

