/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.EnvFilesOptions;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EnvironmentVariablesComponent
extends LabeledComponent<TextFieldWithBrowseButton>
implements UserActivityProviderComponent {
    @NonNls
    private static final String ENVS = "envs";
    @NonNls
    public static final String ENV = "env";
    @NonNls
    public static final String NAME = "name";
    @NonNls
    public static final String VALUE = "value";
    @NonNls
    private static final String OPTION = "option";
    @NonNls
    private static final String ENV_VARIABLES = "ENV_VARIABLES";
    public final EnvironmentVariablesTextFieldWithBrowseButton myEnvVars = this.createBrowseComponent();

    public EnvironmentVariablesComponent() {
        this.setComponent((JComponent)((Object)this.myEnvVars));
        this.setText(ExecutionBundle.message((String)"environment.variables.component.title", (Object[])new Object[0]));
        this.putClientProperty(DslComponentProperty.INTERACTIVE_COMPONENT, this.myEnvVars.getChildComponent());
        this.putClientProperty(DslComponentProperty.VERTICAL_COMPONENT_GAP, VerticalComponentGap.BOTH);
    }

    @NotNull
    protected EnvironmentVariablesTextFieldWithBrowseButton createBrowseComponent() {
        return new EnvironmentVariablesTextFieldWithBrowseButton();
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            EnvironmentVariablesComponent.$$$reportNull$$$0(0);
        }
        this.myEnvVars.setEnvs(envs);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myEnvVars.getEnvs();
        if (map == null) {
            EnvironmentVariablesComponent.$$$reportNull$$$0(1);
        }
        return map;
    }

    public boolean isPassParentEnvs() {
        return this.myEnvVars.isPassParentEnvs();
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myEnvVars.setPassParentEnvs(passParentEnvs);
    }

    public void setEnvFilePaths(List<String> envFilePaths) {
        this.myEnvVars.setEnvFilePaths(envFilePaths);
    }

    public List<String> getEnvFilePaths() {
        return this.myEnvVars.getEnvFilePaths();
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvVars.getData();
        if (environmentVariablesData == null) {
            EnvironmentVariablesComponent.$$$reportNull$$$0(2);
        }
        return environmentVariablesData;
    }

    public void setEnvData(@NotNull EnvironmentVariablesData envData) {
        if (envData == null) {
            EnvironmentVariablesComponent.$$$reportNull$$$0(3);
        }
        this.myEnvVars.setData(envData);
    }

    public void reset(CommonProgramRunConfigurationParameters s) {
        this.setEnvs(s.getEnvs());
        this.setPassParentEnvs(s.isPassParentEnvs());
        if (s instanceof EnvFilesOptions) {
            this.myEnvVars.setEnvFilePaths(((EnvFilesOptions)((Object)s)).getEnvFilePaths());
        }
    }

    public void apply(CommonProgramRunConfigurationParameters s) {
        s.setEnvs(this.getEnvs());
        s.setPassParentEnvs(this.isPassParentEnvs());
        if (s instanceof EnvFilesOptions) {
            ((EnvFilesOptions)((Object)s)).setEnvFilePaths(this.myEnvVars.getEnvFilePaths());
        }
    }

    public static void readExternal(Element element, Map<String, String> envs) {
        Element envsElement = element.getChild(ENVS);
        if (envsElement != null) {
            for (Element envElement : envsElement.getChildren(ENV)) {
                String envName = envElement.getAttributeValue(NAME);
                String envValue = envElement.getAttributeValue(VALUE);
                if (envName == null || envValue == null) continue;
                envs.put(envName, envValue);
            }
        } else {
            for (Element o : element.getChildren(OPTION)) {
                if (!Comparing.strEqual((String)o.getAttributeValue(NAME), (String)ENV_VARIABLES)) continue;
                EnvironmentVariablesComponent.splitVars(envs, o.getAttributeValue(VALUE));
                break;
            }
        }
    }

    private static void splitVars(Map<String, String> envs, String val) {
        if (val != null) {
            String[] envVars;
            for (String envVar : envVars = val.split(";")) {
                int idx = envVar.indexOf(61);
                if (idx <= -1) continue;
                envs.put(envVar.substring(0, idx), idx < envVar.length() - 1 ? envVar.substring(idx + 1) : "");
            }
        }
    }

    public static void writeExternal(@NotNull Element element, @NotNull Map<String, String> envs) {
        if (element == null) {
            EnvironmentVariablesComponent.$$$reportNull$$$0(4);
        }
        if (envs == null) {
            EnvironmentVariablesComponent.$$$reportNull$$$0(5);
        }
        if (envs.isEmpty()) {
            return;
        }
        Element envsElement = new Element(ENVS);
        for (String envName : envs.keySet()) {
            Element envElement = new Element(ENV);
            envElement.setAttribute(NAME, envName);
            envElement.setAttribute(VALUE, envs.get(envName));
            envsElement.addContent(envElement);
        }
        element.addContent(envsElement);
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            EnvironmentVariablesComponent.$$$reportNull$$$0(6);
        }
        this.myEnvVars.addChangeListener(changeListener);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            EnvironmentVariablesComponent.$$$reportNull$$$0(7);
        }
        this.myEnvVars.removeChangeListener(changeListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = ENVS;
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configuration/EnvironmentVariablesComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configuration/EnvironmentVariablesComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setEnvData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

