/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.EnvVariablesTable;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.io.IdeUtilIoBundle;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentVariablesDialog
extends DialogWrapper {
    @NotNull
    private final EnvironmentVariablesTextFieldWithBrowseButton myParent;
    @NotNull
    private final EnvVariablesTable myUserTable;
    @NotNull
    private final EnvVariablesTable mySystemTable;
    @Nullable
    private final JCheckBox myIncludeSystemVarsCb;
    @NotNull
    private final JPanel myWholePanel;
    private final boolean myAlwaysIncludeSystemVars;

    protected EnvironmentVariablesDialog(@NotNull EnvironmentVariablesTextFieldWithBrowseButton parent) {
        if (parent == null) {
            EnvironmentVariablesDialog.$$$reportNull$$$0(0);
        }
        this(parent, false);
    }

    protected EnvironmentVariablesDialog(@NotNull EnvironmentVariablesTextFieldWithBrowseButton parent, boolean alwaysIncludeSystemVars) {
        if (parent == null) {
            EnvironmentVariablesDialog.$$$reportNull$$$0(1);
        }
        super((Component)((Object)parent), true);
        this.myParent = parent;
        this.myAlwaysIncludeSystemVars = alwaysIncludeSystemVars;
        LinkedHashMap<String, String> userMap = new LinkedHashMap<String, String>(this.myParent.getEnvs());
        TreeMap<String, String> parentMap = new TreeMap<String, String>(new GeneralCommandLine().getParentEnvironment());
        this.myParent.myParentDefaults.putAll(parentMap);
        List<EnvironmentVariable> userList = EnvironmentVariablesTextFieldWithBrowseButton.convertToVariables(userMap, false);
        List<EnvironmentVariable> systemList = EnvironmentVariablesTextFieldWithBrowseButton.convertToVariables(parentMap, true);
        this.myUserTable = this.createEnvVariablesTable(userList, true);
        this.mySystemTable = this.createEnvVariablesTable(systemList, false);
        if (!alwaysIncludeSystemVars) {
            this.myIncludeSystemVarsCb = new JCheckBox(ExecutionBundle.message((String)"env.vars.system.include.title", (Object[])new Object[0]));
            this.myIncludeSystemVarsCb.setSelected(this.myParent.isPassParentEnvs());
            this.myIncludeSystemVarsCb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EnvironmentVariablesDialog.this.updateSysTableState();
                }
            });
        } else {
            this.myIncludeSystemVarsCb = null;
        }
        JLabel label2 = new JLabel(ExecutionBundle.message((String)"env.vars.user.title", (Object[])new Object[0]));
        label2.setLabelFor(this.myUserTable.getTableView().getComponent());
        this.myWholePanel = new JPanel((LayoutManager)new MigLayout("fill, ins 0, gap 0, hidemode 3"));
        this.myWholePanel.add((Component)label2, "hmax pref, wrap");
        this.myWholePanel.add((Component)this.myUserTable.getComponent(), "push, grow, wrap, gaptop 5");
        JComponent tablesSeparator = this.myIncludeSystemVarsCb != null ? this.myIncludeSystemVarsCb : new JLabel(ExecutionBundle.message((String)"env.vars.system.title", (Object[])new Object[0]));
        this.myWholePanel.add((Component)tablesSeparator, "hmax pref, wrap, gaptop 5");
        this.myWholePanel.add((Component)this.mySystemTable.getComponent(), "push, grow, wrap, gaptop 5");
        this.updateSysTableState();
        this.setTitle(ExecutionBundle.message((String)"environment.variables.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    @NotNull
    protected MyEnvVariablesTable createEnvVariablesTable(@NotNull List<EnvironmentVariable> variables, boolean userList) {
        if (variables == null) {
            EnvironmentVariablesDialog.$$$reportNull$$$0(2);
        }
        return new MyEnvVariablesTable(variables, userList);
    }

    public Dimension getInitialSize() {
        Dimension size = super.getInitialSize();
        if (size != null) {
            return size;
        }
        return new Dimension(500, 500);
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "EnvironmentVariablesDialog";
    }

    private void updateSysTableState() {
        this.mySystemTable.getTableView().setEnabled(this.isIncludeSystemVars());
        ArrayList<EnvironmentVariable> userList = new ArrayList<EnvironmentVariable>(this.myUserTable.getEnvironmentVariables());
        ArrayList systemList = new ArrayList(this.mySystemTable.getEnvironmentVariables());
        boolean[] dirty = new boolean[]{false};
        if (this.isIncludeSystemVars()) {
            Iterator iterator = userList.iterator();
            while (iterator.hasNext()) {
                EnvironmentVariable userVariable2 = (EnvironmentVariable)iterator.next();
                Optional<EnvironmentVariable> optional = systemList.stream().filter(systemVariable -> systemVariable.getName().equals(userVariable2.getName())).findAny();
                optional.ifPresent(variable -> {
                    if (!Objects.equals(variable.getValue(), userVariable2.getValue())) {
                        variable.setValue(userVariable2.getValue());
                        iterator.remove();
                        dirty[0] = true;
                    }
                });
            }
        } else {
            for (EnvironmentVariable systemVariable2 : systemList) {
                if (!this.myParent.isModifiedSysEnv(systemVariable2)) continue;
                Optional<EnvironmentVariable> optional = userList.stream().filter(userVariable -> userVariable.getName().equals(systemVariable2.getName())).findAny();
                if (optional.isPresent()) {
                    optional.get().setValue(systemVariable2.getValue());
                } else {
                    EnvironmentVariable clone = systemVariable2.clone();
                    clone.IS_PREDEFINED = false;
                    userList.add(clone);
                    systemVariable2.setValue(this.myParent.myParentDefaults.get(systemVariable2.getName()));
                }
                dirty[0] = true;
            }
        }
        if (dirty[0]) {
            this.myUserTable.setValues(userList);
            this.mySystemTable.setValues(systemList);
        }
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            EnvironmentVariablesDialog.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        for (EnvironmentVariable variable : this.myUserTable.getEnvironmentVariables()) {
            String name = variable.getName();
            String value = variable.getValue();
            if (StringUtil.isEmpty((String)name) && StringUtil.isEmpty((String)value)) continue;
            if (!EnvironmentUtil.isValidName((String)name)) {
                return new ValidationInfo(IdeUtilIoBundle.message((String)"run.configuration.invalid.env.name", (Object[])new Object[]{name}));
            }
            if (EnvironmentUtil.isValidValue((String)value)) continue;
            return new ValidationInfo(IdeUtilIoBundle.message((String)"run.configuration.invalid.env.value", (Object[])new Object[]{name, value}));
        }
        return super.doValidate();
    }

    protected void doOKAction() {
        this.myUserTable.stopEditing();
        LinkedHashMap<String, String> envs = new LinkedHashMap<String, String>();
        for (EnvironmentVariable variable : this.myUserTable.getEnvironmentVariables()) {
            if (StringUtil.isEmpty((String)variable.getName()) && StringUtil.isEmpty((String)variable.getValue())) continue;
            envs.put(variable.getName(), variable.getValue());
        }
        for (EnvironmentVariable variable : this.mySystemTable.getEnvironmentVariables()) {
            if (!this.myParent.isModifiedSysEnv(variable)) continue;
            envs.put(variable.getName(), variable.getValue());
        }
        this.myParent.setEnvs(envs);
        this.myParent.setPassParentEnvs(this.isIncludeSystemVars());
        super.doOKAction();
    }

    private boolean isIncludeSystemVars() {
        return this.myAlwaysIncludeSystemVars || this.myIncludeSystemVarsCb != null && this.myIncludeSystemVarsCb.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configuration/EnvironmentVariablesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configuration/EnvironmentVariablesDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createEnvVariablesTable";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    protected class MyEnvVariablesTable
    extends EnvVariablesTable {
        protected final boolean myUserList;

        protected MyEnvVariablesTable(List<EnvironmentVariable> list, boolean userList) {
            this.myUserList = userList;
            TableView tableView = this.getTableView();
            tableView.setVisibleRowCount(7);
            this.setValues(list);
            this.setPasteActionEnabled(this.myUserList);
        }

        @Nullable
        protected AnActionButtonRunnable createAddAction() {
            return this.myUserList ? super.createAddAction() : null;
        }

        @Nullable
        protected AnActionButtonRunnable createRemoveAction() {
            return this.myUserList ? super.createRemoveAction() : null;
        }

        protected AnAction @NotNull [] createExtraToolbarActions() {
            AnAction[] anActionArray = this.myUserList ? super.createExtraToolbarActions() : (AnAction[])ArrayUtil.append((Object[])super.createExtraToolbarActions(), (Object)new DumbAwareAction(ActionsBundle.message((String)"action.ChangesView.Revert.text", (Object[])new Object[0]), null, AllIcons.Actions.Rollback){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyEnvVariablesTable.this.stopEditing();
                    List variables = MyEnvVariablesTable.this.getSelection();
                    for (EnvironmentVariable environmentVariable : variables) {
                        if (!EnvironmentVariablesDialog.this.myParent.isModifiedSysEnv(environmentVariable)) continue;
                        environmentVariable.setValue(EnvironmentVariablesDialog.this.myParent.myParentDefaults.get(environmentVariable.getName()));
                        MyEnvVariablesTable.this.setModified();
                    }
                    MyEnvVariablesTable.this.getTableView().revalidate();
                    MyEnvVariablesTable.this.getTableView().repaint();
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    List selection = MyEnvVariablesTable.this.getSelection();
                    for (EnvironmentVariable variable : selection) {
                        if (!EnvironmentVariablesDialog.this.myParent.isModifiedSysEnv(variable)) continue;
                        e.getPresentation().setEnabled(true);
                        return;
                    }
                    e.getPresentation().setEnabled(false);
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                    if (actionUpdateThread == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return actionUpdateThread;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/execution/configuration/EnvironmentVariablesDialog$MyEnvVariablesTable$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/execution/configuration/EnvironmentVariablesDialog$MyEnvVariablesTable$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            });
            if (anActionArray == null) {
                MyEnvVariablesTable.$$$reportNull$$$0(0);
            }
            return anActionArray;
        }

        protected ListTableModel<EnvironmentVariable> createListModel() {
            return new ListTableModel(new ColumnInfo[]{new MyNameColumnInfo(this), new MyValueColumnInfo()});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesDialog$MyEnvVariablesTable", "createExtraToolbarActions"));
        }

        protected class MyNameColumnInfo
        extends EnvVariablesTable.NameColumnInfo {
            private final DefaultTableCellRenderer myModifiedRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    component.setEnabled(table.isEnabled() && (hasFocus || isSelected));
                    return component;
                }
            };

            protected MyNameColumnInfo(MyEnvVariablesTable this$1) {
                super((EnvVariablesTable)this$1);
            }

            public TableCellRenderer getCustomizedRenderer(EnvironmentVariable o, TableCellRenderer renderer2) {
                return o.getNameIsWriteable() ? renderer2 : this.myModifiedRenderer;
            }
        }

        protected class MyValueColumnInfo
        extends EnvVariablesTable.ValueColumnInfo {
            private final DefaultTableCellRenderer myModifiedRenderer;

            protected MyValueColumnInfo() {
                super((EnvVariablesTable)MyEnvVariablesTable.this);
                this.myModifiedRenderer = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        component.setFont(component.getFont().deriveFont(1));
                        if (!hasFocus && !isSelected) {
                            component.setForeground(JBUI.CurrentTheme.Link.Foreground.ENABLED);
                        }
                        return component;
                    }
                };
            }

            public boolean isCellEditable(EnvironmentVariable environmentVariable) {
                return true;
            }

            public TableCellRenderer getCustomizedRenderer(EnvironmentVariable o, TableCellRenderer renderer2) {
                return EnvironmentVariablesDialog.this.myParent.isModifiedSysEnv(o) ? this.myModifiedRenderer : renderer2;
            }
        }
    }
}

