/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.ConsoleFilterProviderEx;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkWithPopupMenuInfo;
import com.intellij.execution.filters.LazyFileHyperlinkInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.OpenUrlHyperlinkInfo;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.URLUtil;
import java.awt.event.MouseEvent;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlFilter
implements Filter,
DumbAware {
    private static final String FILE_MINIMAL_PROTOCOL_PREFIX = "file:";
    private final Project myProject;

    public UrlFilter() {
        this(null);
    }

    public UrlFilter(Project project) {
        this.myProject = project;
    }

    private List<Filter.ResultItem> findMatchingItems(String line, Pattern pattern, int textStartOffset) {
        ArrayList<Filter.ResultItem> resultList = new ArrayList<Filter.ResultItem>();
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            resultList.add(new Filter.ResultItem(textStartOffset + matcher.start(), textStartOffset + matcher.end(), this.buildHyperlinkInfo(matcher.group())));
        }
        return resultList;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        if (line == null) {
            UrlFilter.$$$reportNull$$$0(0);
        }
        if (!URLUtil.canContainUrl((String)line)) {
            return null;
        }
        int textStartOffset = entireLength - line.length();
        ArrayList<Filter.ResultItem> resultList = new ArrayList<Filter.ResultItem>();
        if (line.contains(FILE_MINIMAL_PROTOCOL_PREFIX)) {
            resultList.addAll(this.findMatchingItems(line, URLUtil.FILE_URL_PATTERN_OPTIMIZED, textStartOffset));
        }
        if (UrlFilter.isPotentialUrl(line)) {
            resultList.addAll(this.findMatchingItems(line, URLUtil.URL_PATTERN_OPTIMIZED, textStartOffset));
        }
        if (resultList.isEmpty()) {
            return null;
        }
        if (resultList.size() == 1) {
            Filter.ResultItem singleItem = (Filter.ResultItem)resultList.get(0);
            return new Filter.Result(singleItem.getHighlightStartOffset(), singleItem.getHighlightEndOffset(), singleItem.getHyperlinkInfo());
        }
        return new Filter.Result(resultList);
    }

    private static boolean isPotentialUrl(String input) {
        return input.contains("www") || input.contains("http") || input.contains("mailto") || input.contains("ftp") || input.contains("news");
    }

    @NotNull
    protected HyperlinkInfo buildHyperlinkInfo(@NotNull String url) {
        HyperlinkInfo fileHyperlinkInfo;
        if (url == null) {
            UrlFilter.$$$reportNull$$$0(1);
        }
        return (fileHyperlinkInfo = this.buildFileHyperlinkInfo(url)) != null ? fileHyperlinkInfo : new OpenUrlHyperlinkInfo(url);
    }

    @Nullable
    private HyperlinkInfo buildFileHyperlinkInfo(@NotNull String url) {
        if (url == null) {
            UrlFilter.$$$reportNull$$$0(2);
        }
        if (this.myProject != null && !url.endsWith(".html")) {
            int lastValue;
            String prefix = UrlFilter.findFileProtocolPrefix(url);
            if (prefix == null) {
                return null;
            }
            int documentLine = -1;
            int documentColumn = -1;
            int filePathEndIndex = url.length();
            int lastColonInd = url.lastIndexOf(58);
            if (lastColonInd > prefix.length() && lastColonInd < url.length() - 1 && (lastValue = StringUtil.parseInt((String)url.substring(lastColonInd + 1), (int)Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                int preLastValue;
                documentLine = lastValue - 1;
                filePathEndIndex = lastColonInd;
                int preLastColonInd = url.lastIndexOf(58, lastColonInd - 1);
                if (preLastColonInd > prefix.length() && (preLastValue = StringUtil.parseInt((String)url.substring(preLastColonInd + 1, lastColonInd), (int)Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                    documentLine = preLastValue - 1;
                    documentColumn = lastValue - 1;
                    filePathEndIndex = preLastColonInd;
                }
            }
            String filePath = UrlFilter.toWindowsPath(UrlFilter.decode(url.substring(prefix.length(), filePathEndIndex)));
            return new FileUrlHyperlinkInfo(this.myProject, filePath, documentLine, documentColumn, url, true);
        }
        return null;
    }

    @Nullable
    private static String findFileProtocolPrefix(@NotNull String url) {
        if (url == null) {
            UrlFilter.$$$reportNull$$$0(3);
        }
        if (url.startsWith("file:///")) {
            return "file://";
        }
        if (url.startsWith(FILE_MINIMAL_PROTOCOL_PREFIX) && !url.startsWith("file://")) {
            return FILE_MINIMAL_PROTOCOL_PREFIX;
        }
        return null;
    }

    @NotNull
    private static String toWindowsPath(@NotNull String path) {
        if (path == null) {
            UrlFilter.$$$reportNull$$$0(4);
        }
        if (path.length() >= 4 && path.charAt(0) == '/' && OSAgnosticPathUtil.isDriveLetter((char)path.charAt(1)) && path.charAt(2) == ':' && PathUtilRt.isSeparator((char)path.charAt(3))) {
            String string = path.substring(1);
            if (string == null) {
                UrlFilter.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            UrlFilter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String decode(@NotNull String encodedStr) {
        String string;
        if (encodedStr == null) {
            UrlFilter.$$$reportNull$$$0(7);
        }
        try {
            string = URLDecoder.decode(encodedStr, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            String string2 = encodedStr;
            if (string2 == null) {
                UrlFilter.$$$reportNull$$$0(9);
            }
            return string2;
        }
        if (string == null) {
            UrlFilter.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/UrlFilter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encodedStr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/UrlFilter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toWindowsPath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildHyperlinkInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildFileHyperlinkInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileProtocolPrefix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toWindowsPath";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8, 9 -> new IllegalStateException(string);
        };
    }

    public static final class FileUrlHyperlinkInfo
    extends LazyFileHyperlinkInfo
    implements HyperlinkWithPopupMenuInfo {
        @NotNull
        private final String url;
        @ApiStatus.Internal
        public final String filePath;
        @ApiStatus.Internal
        public final int documentLine;
        @ApiStatus.Internal
        public final int documentColumn;

        public FileUrlHyperlinkInfo(@NotNull Project project, @NotNull String filePath, int documentLine, int documentColumn, @NotNull String url, boolean useBrowser) {
            if (project == null) {
                FileUrlHyperlinkInfo.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                FileUrlHyperlinkInfo.$$$reportNull$$$0(1);
            }
            if (url == null) {
                FileUrlHyperlinkInfo.$$$reportNull$$$0(2);
            }
            super(project, filePath, documentLine, documentColumn, useBrowser);
            this.url = url;
            this.filePath = filePath;
            this.documentLine = documentLine;
            this.documentColumn = documentColumn;
        }

        public void navigate(@NotNull Project project) {
            VirtualFile file;
            if (project == null) {
                FileUrlHyperlinkInfo.$$$reportNull$$$0(3);
            }
            if ((file = this.getVirtualFile()) == null || !file.isValid()) {
                Messages.showErrorDialog((Project)project, (String)ExecutionBundle.message((String)"message.cannot.find.file.0", (Object[])new Object[]{StringUtil.trimMiddle((String)this.url, (int)150)}), (String)IdeBundle.message((String)"title.cannot.open.file", (Object[])new Object[0]));
                return;
            }
            super.navigate(project);
        }

        @Override
        @NotNull
        public ActionGroup getPopupMenuGroup(@NotNull MouseEvent event) {
            if (event == null) {
                FileUrlHyperlinkInfo.$$$reportNull$$$0(4);
            }
            ActionGroup actionGroup = new OpenUrlHyperlinkInfo(this.url).getPopupMenuGroup(event);
            if (actionGroup == null) {
                FileUrlHyperlinkInfo.$$$reportNull$$$0(5);
            }
            return actionGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/filters/UrlFilter$FileUrlHyperlinkInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/filters/UrlFilter$FileUrlHyperlinkInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPopupMenuGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "navigate";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getPopupMenuGroup";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class UrlFilterProvider
    implements ConsoleFilterProviderEx {
        public Filter @NotNull [] getDefaultFilters(@NotNull Project project, @NotNull GlobalSearchScope scope) {
            if (project == null) {
                UrlFilterProvider.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                UrlFilterProvider.$$$reportNull$$$0(1);
            }
            Filter[] filterArray = new Filter[]{new UrlFilter(project)};
            if (filterArray == null) {
                UrlFilterProvider.$$$reportNull$$$0(2);
            }
            return filterArray;
        }

        public Filter @NotNull [] getDefaultFilters(@NotNull Project project) {
            if (project == null) {
                UrlFilterProvider.$$$reportNull$$$0(3);
            }
            Filter[] filterArray = this.getDefaultFilters(project, GlobalSearchScope.allScope((Project)project));
            if (filterArray == null) {
                UrlFilterProvider.$$$reportNull$$$0(4);
            }
            return filterArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/filters/UrlFilter$UrlFilterProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/filters/UrlFilter$UrlFilterProvider";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultFilters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultFilters";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }
}

