/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.configurationStore.SerializableScheme;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorConfigurable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class BaseRCSettingsConfigurable
extends SettingsEditorConfigurable<RunnerAndConfigurationSettings> {
    BaseRCSettingsConfigurable(@NotNull SettingsEditor<RunnerAndConfigurationSettings> editor, @NotNull RunnerAndConfigurationSettings settings) {
        if (editor == null) {
            BaseRCSettingsConfigurable.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            BaseRCSettingsConfigurable.$$$reportNull$$$0(1);
        }
        super(editor, (Object)settings);
    }

    public boolean isModified() {
        try {
            Element snapshotXml;
            RunnerAndConfigurationSettings original = (RunnerAndConfigurationSettings)this.getSettings();
            RunManagerImpl runManager = ((RunnerAndConfigurationSettingsImpl)original).getManager();
            if (!original.isTemplate() && !runManager.hasSettings(original)) {
                return true;
            }
            if (this.isSpecificallyModified()) {
                return true;
            }
            SettingsEditor editor = this.getEditor();
            if (editor instanceof ConfigurationSettingsEditorWrapper && !((ConfigurationSettingsEditorWrapper)editor).supportsSnapshots()) {
                return super.isModified();
            }
            if (!this.getEditor().isReadyForApply()) {
                return true;
            }
            RunnerAndConfigurationSettings snapshot = this.getSnapshot();
            Element originalXml = ((SerializableScheme)original).writeScheme();
            return !JDOMUtil.areElementsEqual((Element)originalXml, (Element)(snapshotXml = ((SerializableScheme)snapshot).writeScheme()));
        }
        catch (ConfigurationException configurationException) {
            return super.isModified();
        }
    }

    @NotNull
    protected RunnerAndConfigurationSettings getSnapshot() throws ConfigurationException {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)this.getEditor().getSnapshot();
        if (runnerAndConfigurationSettings == null) {
            BaseRCSettingsConfigurable.$$$reportNull$$$0(2);
        }
        return runnerAndConfigurationSettings;
    }

    boolean isSpecificallyModified() {
        return this.getEditor().isSpecificallyModified();
    }

    public JComponent createComponent() {
        return BaseRCSettingsConfigurable.wrapWithScrollPane(super.createComponent());
    }

    @NotNull
    protected static JBScrollPane wrapWithScrollPane(@Nullable JComponent component) {
        JBScrollPane scrollPane2 = new JBScrollPane(20, 31){

            public Dimension getMinimumSize() {
                Dimension d = super.getMinimumSize();
                JViewport viewport = this.getViewport();
                if (viewport != null) {
                    Component view = viewport.getView();
                    if (view instanceof Scrollable) {
                        d.width = ((Scrollable)((Object)view)).getPreferredScrollableViewportSize().width;
                    }
                    if (view != null) {
                        d.width = view.getMinimumSize().width;
                    }
                }
                d.height = Math.max(d.height, JBUIScale.scale((int)400));
                return d;
            }
        };
        scrollPane2.setBorder((Border)JBUI.Borders.empty());
        scrollPane2.setViewportBorder((Border)JBUI.Borders.empty());
        if (component != null) {
            scrollPane2.getViewport().setView(component);
        }
        JBScrollPane jBScrollPane = scrollPane2;
        if (jBScrollPane == null) {
            BaseRCSettingsConfigurable.$$$reportNull$$$0(3);
        }
        return jBScrollPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/BaseRCSettingsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/BaseRCSettingsConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnapshot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithScrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

