/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.statistics.RunConfigurationUsageTriggerCollector;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/execution/impl/ProcessExecutionListener;", "Lcom/intellij/execution/process/ProcessAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "executorId", "", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "activity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/intellij/execution/ui/RunContentDescriptor;Lcom/intellij/internal/statistic/StructuredIdeActivity;)V", "willTerminateNotified", "Ljava/util/concurrent/atomic/AtomicBoolean;", "terminateNotified", "processTerminated", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "processWillTerminate", "shouldNotBeUsed", "", "intellij.platform.execution.impl"})
final class ProcessExecutionListener
extends ProcessAdapter {
    @NotNull
    private final Project project;
    @NotNull
    private final String executorId;
    @NotNull
    private final ExecutionEnvironment environment;
    @NotNull
    private final RunContentDescriptor descriptor;
    @Nullable
    private final StructuredIdeActivity activity;
    @NotNull
    private final AtomicBoolean willTerminateNotified;
    @NotNull
    private final AtomicBoolean terminateNotified;

    public ProcessExecutionListener(@NotNull Project project, @NotNull String executorId, @NotNull ExecutionEnvironment environment, @NotNull RunContentDescriptor descriptor, @Nullable StructuredIdeActivity activity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.project = project;
        this.executorId = executorId;
        this.environment = environment;
        this.descriptor = descriptor;
        this.activity = activity;
        this.willTerminateNotified = new AtomicBoolean();
        this.terminateNotified = new AtomicBoolean();
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.project.isDisposed() || !this.terminateNotified.compareAndSet(false, true)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> ProcessExecutionListener.processTerminated$lambda$0(this), ModalityState.any(), this.project.getDisposed());
        ProcessHandler processHandler = event.getProcessHandler();
        ((ExecutionListener)this.project.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processTerminated(this.executorId, this.environment, processHandler, event.getExitCode());
        RunConfigurationUsageTriggerCollector.RunConfigurationFinishType runConfigurationFinishType = Intrinsics.areEqual((Object)processHandler.getUserData(ExecutionManagerImpl.Companion.getTERMINATING_FOR_RERUN$intellij_platform_execution_impl()), (Object)true) ? RunConfigurationUsageTriggerCollector.RunConfigurationFinishType.TERMINATED_DUE_TO_RERUN : (Intrinsics.areEqual((Object)processHandler.getUserData(ProcessHandler.TERMINATION_REQUESTED), (Object)true) ? RunConfigurationUsageTriggerCollector.RunConfigurationFinishType.TERMINATED_BY_STOP : RunConfigurationUsageTriggerCollector.RunConfigurationFinishType.UNKNOWN);
        RunConfigurationUsageTriggerCollector.logProcessFinished(this.activity, runConfigurationFinishType);
        processHandler.removeProcessListener((ProcessListener)this);
        SaveAndSyncHandler.Companion.getInstance().scheduleRefresh();
    }

    public void processWillTerminate(@NotNull ProcessEvent event, boolean shouldNotBeUsed) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.project.isDisposed() || !this.willTerminateNotified.compareAndSet(false, true)) {
            return;
        }
        ((ExecutionListener)this.project.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processTerminating(this.executorId, this.environment, event.getProcessHandler());
    }

    private static final void processTerminated$lambda$0(ProcessExecutionListener this$0) {
        RunnerLayoutUi ui = this$0.descriptor.getRunnerLayoutUi();
        if (ui != null && !ui.isDisposed()) {
            ui.updateActionsNow();
        }
    }
}

