/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/impl/RunConfigEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.execution.impl"})
public final class RunConfigEditorNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CharSequence charSequence = file.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        if (!StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)".run.xml", (boolean)false, (int)2, null) || !ProjectFileIndex.getInstance((Project)project).isInContent(file)) {
            return null;
        }
        RunManagerImpl runManager = RunManagerImpl.Companion.getInstanceImpl(project);
        if (!runManager.isFileContainsRunConfiguration$intellij_platform_execution_impl(file)) {
            return null;
        }
        return arg_0 -> RunConfigEditorNotificationProvider.collectNotificationData$lambda$0(runManager, file, project, arg_0);
    }

    private static final void collectNotificationData$lambda$0$0(RunManagerImpl $runManager, VirtualFile $file, Project $project) {
        RunnerAndConfigurationSettings oldSelectedConfig = $runManager.getSelectedConfiguration();
        $runManager.selectConfigurationStoredInFile$intellij_platform_execution_impl($file);
        boolean ok = new EditConfigurationsDialog($project).showAndGet();
        if (!ok) {
            $runManager.setSelectedConfiguration(oldSelectedConfig);
        }
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$0(RunManagerImpl $runManager, VirtualFile $file, Project $project, FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
        panel2.setText(ExecutionBundle.message((String)"manual.editing.of.config.file.not.recommended", (Object[])new Object[0]));
        String string = ExecutionBundle.message((String)"open.run.debug.dialog", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        panel2.createActionLabel(message, () -> RunConfigEditorNotificationProvider.collectNotificationData$lambda$0$0($runManager, $file, $project));
        return panel2;
    }
}

