/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.ExecutionTargetManagerImpl;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.ConfigurationSelectionUtil;
import com.intellij.execution.compound.TypeNameTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.BeforeRunTaskAwareConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunConfigurationBeforeRunProviderDelegate;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public final class RunConfigurationBeforeRunProvider
extends BeforeRunTaskProvider<RunConfigurableBeforeRunTask>
implements DumbAware {
    public static final Key<RunConfigurableBeforeRunTask> ID = Key.create((String)"RunConfigurationTask");
    private static final Logger LOG = Logger.getInstance(RunConfigurationBeforeRunProvider.class);
    private final Project myProject;

    public RunConfigurationBeforeRunProvider(Project project) {
        this.myProject = project;
    }

    public Key<RunConfigurableBeforeRunTask> getId() {
        return ID;
    }

    public Icon getIcon() {
        return AllIcons.Actions.Execute;
    }

    public Icon getTaskIcon(RunConfigurableBeforeRunTask task2) {
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)task2.getSettingsWithTarget().first;
        return settings == null ? null : ProgramRunnerUtil.getConfigurationIcon(settings, false);
    }

    public String getName() {
        return ExecutionBundle.message((String)"before.launch.run.another.configuration.title", (Object[])new Object[0]);
    }

    public String getDescription(RunConfigurableBeforeRunTask task2) {
        Pair<RunnerAndConfigurationSettings, ExecutionTarget> settingsWithTarget = task2.getSettingsWithTarget();
        if (settingsWithTarget.first == null) {
            if (task2.typeNameTarget.getName() == null) {
                return ExecutionBundle.message((String)"before.launch.run.another.configuration", (Object[])new Object[0]);
            }
            return ExecutionBundle.message((String)"before.launch.run.certain.configuration", (Object[])new Object[]{task2.typeNameTarget.getName()});
        }
        String text = ConfigurationSelectionUtil.getDisplayText(((RunnerAndConfigurationSettings)settingsWithTarget.first).getConfiguration(), (ExecutionTarget)settingsWithTarget.second);
        return ExecutionBundle.message((String)"before.launch.run.certain.configuration", (Object[])new Object[]{text});
    }

    public boolean isConfigurable() {
        return true;
    }

    @NotNull
    public RunConfigurableBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(0);
        }
        return new RunConfigurableBeforeRunTask();
    }

    public Promise<Boolean> configureTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull RunConfigurableBeforeRunTask task2) {
        if (context == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(2);
        }
        if (task2 == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(3);
        }
        Project project = configuration.getProject();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
        List configurations = ContainerUtil.map(RunConfigurationBeforeRunProvider.getAvailableConfigurations(configuration), it -> it.getConfiguration());
        AsyncPromise result2 = new AsyncPromise();
        ConfigurationSelectionUtil.createPopup(project, runManager, configurations, (selectedConfigs, selectedTarget) -> {
            RunnerAndConfigurationSettingsImpl selectedSettings;
            RunConfiguration selectedConfig = (RunConfiguration)ContainerUtil.getFirstItem((List)selectedConfigs);
            RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl = selectedSettings = selectedConfig == null ? null : runManager.getSettings(selectedConfig);
            if (selectedSettings != null) {
                task2.setSettingsWithTarget(selectedSettings, (ExecutionTarget)selectedTarget);
                result2.setResult((Object)true);
            } else {
                result2.setResult((Object)false);
            }
        }).showInBestPositionFor(context);
        return result2;
    }

    @NotNull
    private static List<RunnerAndConfigurationSettings> getAvailableConfigurations(@NotNull RunConfiguration runConfiguration) {
        Project project;
        if (runConfiguration == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(4);
        }
        if ((project = runConfiguration.getProject()) == null || !project.isInitialized()) {
            List<RunnerAndConfigurationSettings> list = Collections.emptyList();
            if (list == null) {
                RunConfigurationBeforeRunProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<RunnerAndConfigurationSettings> configurations = new ArrayList<RunnerAndConfigurationSettings>(RunManagerImpl.getInstanceImpl(project).getAllSettings());
        String executorId = DefaultRunExecutor.getRunExecutorInstance().getId();
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)iterator.next();
            if (settings.getConfiguration() != runConfiguration && settings.getType().isManaged() && ProgramRunner.getRunner((String)executorId, (RunProfile)settings.getConfiguration()) != null) continue;
            iterator.remove();
        }
        ArrayList<RunnerAndConfigurationSettings> arrayList = configurations;
        if (arrayList == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull RunConfigurableBeforeRunTask task2) {
        RunnerAndConfigurationSettings settings;
        if (configuration == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(7);
        }
        if (task2 == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(8);
        }
        if ((settings = (RunnerAndConfigurationSettings)task2.getSettingsWithTarget().first) == null) {
            return false;
        }
        String executorId = DefaultRunExecutor.getRunExecutorInstance().getId();
        ProgramRunner runner = ProgramRunner.getRunner((String)executorId, (RunProfile)settings.getConfiguration());
        return runner != null && runner.canRun(executorId, (RunProfile)settings.getConfiguration());
    }

    public boolean executeTask(@NotNull DataContext dataContext, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull RunConfigurableBeforeRunTask task2) {
        if (dataContext == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(9);
        }
        if (configuration == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(10);
        }
        if (env == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(11);
        }
        if (task2 == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(12);
        }
        Pair<RunnerAndConfigurationSettings, ExecutionTarget> settings = task2.getSettingsWithTarget();
        if (settings.first == null) {
            LOG.info("Cannot find run configuration '" + task2.typeNameTarget.getName() + "' configured as 'Before launch' task in '" + env.getRunProfile().getName() + "', task is skipped");
            return true;
        }
        return RunConfigurationBeforeRunProvider.doExecuteTask(env, (RunnerAndConfigurationSettings)settings.first, (ExecutionTarget)settings.second);
    }

    public static boolean doExecuteTask(@NotNull ExecutionEnvironment env, @NotNull RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget target) {
        RunConfiguration configuration;
        if (env == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(14);
        }
        Executor executor = (configuration = settings.getConfiguration()) instanceof BeforeRunTaskAwareConfiguration && ((BeforeRunTaskAwareConfiguration)configuration).useRunExecutor() ? DefaultRunExecutor.getRunExecutorInstance() : env.getExecutor();
        String executorId = executor.getId();
        ExecutionEnvironmentBuilder builder2 = ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)settings);
        if (builder2 == null) {
            LOG.info("Cannot create environment builder for 'Before launch' task '" + settings.getName() + "' in '" + env.getRunProfile().getName() + "', task is skipped");
            return false;
        }
        ExecutionTarget effectiveTarget = target;
        if (effectiveTarget == null && ExecutionTargetManager.canRun((RunConfiguration)settings.getConfiguration(), (ExecutionTarget)env.getExecutionTarget())) {
            effectiveTarget = env.getExecutionTarget();
        }
        List allTargets = ExecutionTargetManager.getInstance((Project)env.getProject()).getTargetsFor(settings.getConfiguration());
        if (effectiveTarget == null) {
            effectiveTarget = (ExecutionTarget)ContainerUtil.find((Iterable)allTargets, it -> it.isReady());
        }
        if (effectiveTarget == null) {
            effectiveTarget = (ExecutionTarget)ContainerUtil.getFirstItem((List)allTargets);
        }
        if (effectiveTarget == null) {
            LOG.debug("No suitable targets for 'Before launch' task '" + settings.getName() + "' in '" + env.getRunProfile().getName() + "', task is skipped");
            return false;
        }
        ExecutionEnvironment environment = builder2.target(effectiveTarget).build();
        environment.setExecutionId(env.getExecutionId());
        env.copyUserDataTo((UserDataHolderBase)environment);
        if (!environment.getRunner().canRun(executorId, environment.getRunProfile())) {
            LOG.debug("'canRun' returned 'false' for 'Before launch' task '" + settings.getName() + "' in '" + env.getRunProfile().getName() + "', task is skipped");
            return false;
        }
        RunConfigurationBeforeRunProvider.beforeRun(environment);
        LOG.debug("Starting 'Before launch' task '" + settings.getName() + "' in '" + env.getRunProfile().getName() + "'");
        return RunConfigurationBeforeRunProvider.doRunTask(executorId, environment, environment.getRunner());
    }

    public static boolean doRunTask(final String executorId, final ExecutionEnvironment environment, ProgramRunner<?> runner) {
        final Semaphore targetDone = new Semaphore();
        final Ref result2 = new Ref((Object)false);
        Disposable disposable = Disposer.newDisposable();
        environment.getProject().getMessageBus().connect(disposable).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStartScheduled(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                if (executorIdLocal == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (environmentLocal == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                    targetDone.down();
                }
            }

            public void processNotStarted(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                if (executorIdLocal == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (environmentLocal == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                    Boolean skipRun = (Boolean)environment.getUserData(ExecutionManagerImpl.EXECUTION_SKIP_RUN);
                    LOG.debug("process not started for before launch task '" + environment.getRunProfile().getName() + "', skipRun=" + skipRun);
                    if (skipRun != null && skipRun.booleanValue()) {
                        result2.set((Object)true);
                    }
                    targetDone.up();
                }
            }

            public void processTerminated(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal, @NotNull ProcessHandler handler2, int exitCode) {
                if (executorIdLocal == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (environmentLocal == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (handler2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                    LOG.debug("process terminated for before launch task '" + environment.getRunProfile().getName() + "', exitCode=" + exitCode);
                    result2.set((Object)(exitCode == 0 ? 1 : 0));
                    targetDone.up();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorIdLocal";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "environmentLocal";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/impl/RunConfigurationBeforeRunProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStartScheduled";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processNotStarted";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                try {
                    runner.execute(environment);
                }
                catch (ExecutionException e) {
                    targetDone.up();
                    LOG.error((Throwable)e);
                }
            }, ModalityState.defaultModalityState());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            Disposer.dispose((Disposable)disposable);
            return false;
        }
        targetDone.waitFor();
        Disposer.dispose((Disposable)disposable);
        return (Boolean)result2.get();
    }

    private static void beforeRun(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(15);
        }
        for (RunConfigurationBeforeRunProviderDelegate delegate : RunConfigurationBeforeRunProviderDelegate.EP_NAME.getExtensionList()) {
            delegate.beforeRun(environment);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/RunConfigurationBeforeRunProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/RunConfigurationBeforeRunProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configureTask";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableConfigurations";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canExecuteTask";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteTask";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "beforeRun";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    public final class RunConfigurableBeforeRunTask
    extends BeforeRunTask<RunConfigurableBeforeRunTask> {
        private final TypeNameTarget typeNameTarget;
        private Pair<@Nullable RunnerAndConfigurationSettings, @Nullable ExecutionTarget> mySettingsWithTarget;

        RunConfigurableBeforeRunTask() {
            super(ID);
            this.typeNameTarget = new TypeNameTarget();
        }

        public void writeExternal(@NotNull Element element) {
            if (element == null) {
                RunConfigurableBeforeRunTask.$$$reportNull$$$0(0);
            }
            super.writeExternal(element);
            if (this.typeNameTarget.getName() != null) {
                element.setAttribute("run_configuration_name", this.typeNameTarget.getName());
            }
            if (this.typeNameTarget.getType() != null) {
                element.setAttribute("run_configuration_type", this.typeNameTarget.getType());
            }
            if (this.typeNameTarget.getTargetId() != null) {
                element.setAttribute("run_configuration_target", this.typeNameTarget.getTargetId());
            }
        }

        public void readExternal(@NotNull Element element) {
            if (element == null) {
                RunConfigurableBeforeRunTask.$$$reportNull$$$0(1);
            }
            super.readExternal(element);
            this.typeNameTarget.setName(element.getAttributeValue("run_configuration_name"));
            this.typeNameTarget.setType(element.getAttributeValue("run_configuration_type"));
            this.typeNameTarget.setTargetId(element.getAttributeValue("run_configuration_target"));
            this.mySettingsWithTarget = null;
        }

        boolean isMySettings(@NotNull RunnerAndConfigurationSettings settings) {
            if (settings == null) {
                RunConfigurableBeforeRunTask.$$$reportNull$$$0(2);
            }
            if (this.mySettingsWithTarget != null) {
                return this.mySettingsWithTarget.first == settings;
            }
            return settings.getType().getId().equals(this.typeNameTarget.getType()) && settings.getName().equals(this.typeNameTarget.getName());
        }

        private void init(@NotNull RunManagerImpl runManager) {
            if (runManager == null) {
                RunConfigurableBeforeRunTask.$$$reportNull$$$0(3);
            }
            if (this.mySettingsWithTarget != null) {
                return;
            }
            String type = this.typeNameTarget.getType();
            String name = this.typeNameTarget.getName();
            String targetId = this.typeNameTarget.getTargetId();
            RunnerAndConfigurationSettings settings = type != null && name != null ? runManager.findConfigurationByTypeAndName(type, name) : null;
            ExecutionTarget target = targetId != null && settings != null ? ((ExecutionTargetManagerImpl)ExecutionTargetManager.getInstance((Project)RunConfigurationBeforeRunProvider.this.myProject)).findTargetByIdFor(settings.getConfiguration(), targetId) : null;
            this.mySettingsWithTarget = new Pair((Object)settings, target);
        }

        public void setSettingsWithTarget(@Nullable RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget target) {
            if (settings == null) {
                this.mySettingsWithTarget = Pair.empty();
                this.typeNameTarget.setName(null);
                this.typeNameTarget.setType(null);
                this.typeNameTarget.setTargetId(null);
            } else {
                this.mySettingsWithTarget = new Pair((Object)settings, (Object)target);
                this.typeNameTarget.setName(settings.getName());
                this.typeNameTarget.setType(settings.getType().getId());
                this.typeNameTarget.setTargetId(target != null ? target.getId() : null);
            }
        }

        @Nullable
        public RunnerAndConfigurationSettings getSettings(@NotNull RunManagerImpl runManager) {
            if (runManager == null) {
                RunConfigurableBeforeRunTask.$$$reportNull$$$0(4);
            }
            return (RunnerAndConfigurationSettings)this.getSettingsWithTarget((RunManagerImpl)runManager).first;
        }

        @Nullable
        public RunnerAndConfigurationSettings getSettings() {
            return (RunnerAndConfigurationSettings)this.getSettingsWithTarget().first;
        }

        private @NotNull Pair<@Nullable RunnerAndConfigurationSettings, @Nullable ExecutionTarget> getSettingsWithTarget(@NotNull RunManagerImpl runManager) {
            if (runManager == null) {
                RunConfigurableBeforeRunTask.$$$reportNull$$$0(5);
            }
            this.init(runManager);
            Pair<RunnerAndConfigurationSettings, ExecutionTarget> pair = this.mySettingsWithTarget;
            if (pair == null) {
                RunConfigurableBeforeRunTask.$$$reportNull$$$0(6);
            }
            return pair;
        }

        private @NotNull Pair<@Nullable RunnerAndConfigurationSettings, @Nullable ExecutionTarget> getSettingsWithTarget() {
            if (this.mySettingsWithTarget != null) {
                Pair<RunnerAndConfigurationSettings, ExecutionTarget> pair = this.mySettingsWithTarget;
                if (pair == null) {
                    RunConfigurableBeforeRunTask.$$$reportNull$$$0(7);
                }
                return pair;
            }
            this.init(RunManagerImpl.getInstanceImpl(RunConfigurationBeforeRunProvider.this.myProject));
            Pair<RunnerAndConfigurationSettings, ExecutionTarget> pair = this.mySettingsWithTarget;
            if (pair == null) {
                RunConfigurableBeforeRunTask.$$$reportNull$$$0(8);
            }
            return pair;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RunConfigurableBeforeRunTask that = (RunConfigurableBeforeRunTask)((Object)o);
            return Comparing.equal((Object)((Object)this.typeNameTarget), (Object)((Object)that.typeNameTarget));
        }

        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.typeNameTarget.hashCode();
            return result2;
        }

        public BeforeRunTask clone() {
            RunConfigurableBeforeRunTask task2 = new RunConfigurableBeforeRunTask();
            if (this.mySettingsWithTarget != null) {
                task2.setSettingsWithTarget((RunnerAndConfigurationSettings)this.mySettingsWithTarget.first, (ExecutionTarget)this.mySettingsWithTarget.second);
            }
            task2.typeNameTarget.setType(this.typeNameTarget.getType());
            task2.typeNameTarget.setName(this.typeNameTarget.getName());
            task2.typeNameTarget.setTargetId(this.typeNameTarget.getTargetId());
            return task2;
        }

        public String toString() {
            return "RunConfigurableBeforeRunTask{name = " + this.typeNameTarget.getName() + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runManager";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/RunConfigurationBeforeRunProvider$RunConfigurableBeforeRunTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/RunConfigurationBeforeRunProvider$RunConfigurableBeforeRunTask";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettingsWithTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "writeExternal";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "readExternal";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isMySettings";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "init";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getSettings";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getSettingsWithTarget";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

