/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.RunConfigurationIconCache;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0006J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\u0016\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R3\u0010\u0004\u001a'\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/execution/impl/RunConfigurationIconAndInvalidCache;", "Lcom/intellij/execution/impl/RunConfigurationIconCache;", "<init>", "()V", "resultMap", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/execution/impl/RunConfigurationIconAndInvalidCache$ConfigurationInfo;", "remove", "", "id", "get", "Ljavax/swing/Icon;", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "project", "Lcom/intellij/openapi/project/Project;", "isInvalid", "", "clear", "checkValidity", "recalculateIcon", "ConfigurationInfo", "IconCalcResult", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nRunConfigurationIconAndInvalidCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurationIconAndInvalidCache.kt\ncom/intellij/execution/impl/RunConfigurationIconAndInvalidCache\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n72#2,2:92\n1#3:94\n*S KotlinDebug\n*F\n+ 1 RunConfigurationIconAndInvalidCache.kt\ncom/intellij/execution/impl/RunConfigurationIconAndInvalidCache\n*L\n31#1:92,2\n31#1:94\n*E\n"})
public final class RunConfigurationIconAndInvalidCache
implements RunConfigurationIconCache {
    @NotNull
    private final ConcurrentMap<String, ConfigurationInfo> resultMap;

    public RunConfigurationIconAndInvalidCache() {
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.resultMap = concurrentMap;
    }

    @Override
    public void remove(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.resultMap.remove(id);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Icon get(@NotNull String id, @NotNull RunnerAndConfigurationSettings settings, @NotNull Project project) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ConcurrentMap<String, ConfigurationInfo> concurrentMap = this.resultMap;
        String key$iv = id;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Icon icon = settings.getConfiguration().getIcon();
            if (icon == null) {
                Icon icon2 = AllIcons.Actions.Help;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Help");
            }
            Icon icon3 = icon;
            this.recalculateIcon(id, project);
            ConfigurationInfo default$iv = new ConfigurationInfo(icon3, false, System.currentTimeMillis(), 0L, null, 16, null);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return ((ConfigurationInfo)object).getIcon();
    }

    public final boolean isInvalid(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ConfigurationInfo configurationInfo = (ConfigurationInfo)this.resultMap.get(id);
        return configurationInfo != null ? configurationInfo.isInvalid() : false;
    }

    @Override
    public void clear() {
        this.resultMap.clear();
    }

    public final void checkValidity(@NotNull String id, @NotNull Project project) {
        boolean expired;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ConfigurationInfo configurationInfo = (ConfigurationInfo)this.resultMap.get(id);
        UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = LafManager.getInstance().getCurrentUIThemeLookAndFeel();
        String lafId = uIThemeLookAndFeelInfo != null ? uIThemeLookAndFeelInfo.getId() : null;
        boolean bl = expired = configurationInfo == null || System.currentTimeMillis() - configurationInfo.getFinishTime() > Math.max(configurationInfo.getCalculationTime(), 150L) * (long)10 || !Intrinsics.areEqual((Object)lafId, (Object)configurationInfo.getLafId());
        if (expired) {
            this.recalculateIcon(id, project);
        }
    }

    private final void recalculateIcon(String id, Project project) {
        Object[] objectArray = new Object[]{this, id};
        ReadAction.nonBlocking(() -> RunConfigurationIconAndInvalidCache.recalculateIcon$lambda$0(project, id)).expireWith((Disposable)project).coalesceBy(objectArray).submit((Executor)NonUrgentExecutor.getInstance()).onSuccess(arg_0 -> RunConfigurationIconAndInvalidCache.recalculateIcon$lambda$2(arg_0 -> RunConfigurationIconAndInvalidCache.recalculateIcon$lambda$1(this, id, arg_0), arg_0));
    }

    private static final IconCalcResult recalculateIcon$lambda$0(Project $project, String $id) {
        Pair pair;
        RunManagerImpl runManagerImpl = RunManagerImpl.Companion.getInstanceImpl($project);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runManagerImpl.getConfigurationById($id);
        if (runnerAndConfigurationSettings == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
        long startTime = System.currentTimeMillis();
        try {
            settings.checkSettings();
            pair = TuplesKt.to((Object)ProgramRunnerUtil.getConfigurationIcon(settings, false), (Object)false);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            pair = TuplesKt.to((Object)ProgramRunnerUtil.getConfigurationIcon(settings, false), (Object)false);
        }
        catch (RuntimeConfigurationException runtimeConfigurationException) {
            boolean invalid = !DumbService.Companion.isDumb(runManagerImpl.getProject());
            pair = TuplesKt.to((Object)ProgramRunnerUtil.getConfigurationIcon(settings, invalid), (Object)invalid);
        }
        Pair pair2 = pair;
        Object object = pair2.component1();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
        Icon icon = (Icon)object;
        boolean invalid = (Boolean)pair2.component2();
        return new IconCalcResult(icon, invalid, startTime);
    }

    private static final Unit recalculateIcon$lambda$1(RunConfigurationIconAndInvalidCache this$0, String $id, IconCalcResult it) {
        if (it == null) {
            this$0.resultMap.remove($id);
        } else {
            long finisTime = System.currentTimeMillis();
            ((Map)this$0.resultMap).put($id, new ConfigurationInfo(it.getIcon(), it.isInvalid(), finisTime, finisTime - it.getStartTime(), null, 16, null));
        }
        return Unit.INSTANCE;
    }

    private static final void recalculateIcon$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u00c6\u0003J=\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0014\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004J\n\u0010\u001f\u001a\u00020\nH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/intellij/execution/impl/RunConfigurationIconAndInvalidCache$ConfigurationInfo;", "", "icon", "Ljavax/swing/Icon;", "isInvalid", "", "finishTime", "", "calculationTime", "lafId", "", "<init>", "(Ljavax/swing/Icon;ZJJLjava/lang/String;)V", "getIcon", "()Ljavax/swing/Icon;", "()Z", "getFinishTime", "()J", "getCalculationTime", "getLafId", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "intellij.platform.execution.impl"})
    private static final class ConfigurationInfo {
        @NotNull
        private final Icon icon;
        private final boolean isInvalid;
        private final long finishTime;
        private final long calculationTime;
        @Nullable
        private final String lafId;

        public ConfigurationInfo(@NotNull Icon icon, boolean isInvalid, long finishTime, long calculationTime, @Nullable String lafId) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            this.icon = icon;
            this.isInvalid = isInvalid;
            this.finishTime = finishTime;
            this.calculationTime = calculationTime;
            this.lafId = lafId;
        }

        public /* synthetic */ ConfigurationInfo(Icon icon, boolean bl, long l, long l2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = LafManager.getInstance().getCurrentUIThemeLookAndFeel();
                string = uIThemeLookAndFeelInfo != null ? uIThemeLookAndFeelInfo.getId() : null;
            }
            this(icon, bl, l, l2, string);
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        public final boolean isInvalid() {
            return this.isInvalid;
        }

        public final long getFinishTime() {
            return this.finishTime;
        }

        public final long getCalculationTime() {
            return this.calculationTime;
        }

        @Nullable
        public final String getLafId() {
            return this.lafId;
        }

        @NotNull
        public final Icon component1() {
            return this.icon;
        }

        public final boolean component2() {
            return this.isInvalid;
        }

        public final long component3() {
            return this.finishTime;
        }

        public final long component4() {
            return this.calculationTime;
        }

        @Nullable
        public final String component5() {
            return this.lafId;
        }

        @NotNull
        public final ConfigurationInfo copy(@NotNull Icon icon, boolean isInvalid, long finishTime, long calculationTime, @Nullable String lafId) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            return new ConfigurationInfo(icon, isInvalid, finishTime, calculationTime, lafId);
        }

        public static /* synthetic */ ConfigurationInfo copy$default(ConfigurationInfo configurationInfo, Icon icon, boolean bl, long l, long l2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                icon = configurationInfo.icon;
            }
            if ((n & 2) != 0) {
                bl = configurationInfo.isInvalid;
            }
            if ((n & 4) != 0) {
                l = configurationInfo.finishTime;
            }
            if ((n & 8) != 0) {
                l2 = configurationInfo.calculationTime;
            }
            if ((n & 0x10) != 0) {
                string = configurationInfo.lafId;
            }
            return configurationInfo.copy(icon, bl, l, l2, string);
        }

        @NotNull
        public String toString() {
            return "ConfigurationInfo(icon=" + this.icon + ", isInvalid=" + this.isInvalid + ", finishTime=" + this.finishTime + ", calculationTime=" + this.calculationTime + ", lafId=" + this.lafId + ")";
        }

        public int hashCode() {
            int result2 = this.icon.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isInvalid);
            result2 = result2 * 31 + Long.hashCode(this.finishTime);
            result2 = result2 * 31 + Long.hashCode(this.calculationTime);
            result2 = result2 * 31 + (this.lafId == null ? 0 : this.lafId.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConfigurationInfo)) {
                return false;
            }
            ConfigurationInfo configurationInfo = (ConfigurationInfo)other;
            if (!Intrinsics.areEqual((Object)this.icon, (Object)configurationInfo.icon)) {
                return false;
            }
            if (this.isInvalid != configurationInfo.isInvalid) {
                return false;
            }
            if (this.finishTime != configurationInfo.finishTime) {
                return false;
            }
            if (this.calculationTime != configurationInfo.calculationTime) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lafId, (Object)configurationInfo.lafId);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/execution/impl/RunConfigurationIconAndInvalidCache$IconCalcResult;", "", "icon", "Ljavax/swing/Icon;", "isInvalid", "", "startTime", "", "<init>", "(Ljavax/swing/Icon;ZJ)V", "getIcon", "()Ljavax/swing/Icon;", "()Z", "getStartTime", "()J", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.execution.impl"})
    private static final class IconCalcResult {
        @NotNull
        private final Icon icon;
        private final boolean isInvalid;
        private final long startTime;

        public IconCalcResult(@NotNull Icon icon, boolean isInvalid, long startTime) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            this.icon = icon;
            this.isInvalid = isInvalid;
            this.startTime = startTime;
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        public final boolean isInvalid() {
            return this.isInvalid;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        @NotNull
        public final Icon component1() {
            return this.icon;
        }

        public final boolean component2() {
            return this.isInvalid;
        }

        public final long component3() {
            return this.startTime;
        }

        @NotNull
        public final IconCalcResult copy(@NotNull Icon icon, boolean isInvalid, long startTime) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            return new IconCalcResult(icon, isInvalid, startTime);
        }

        public static /* synthetic */ IconCalcResult copy$default(IconCalcResult iconCalcResult, Icon icon, boolean bl, long l, int n, Object object) {
            if ((n & 1) != 0) {
                icon = iconCalcResult.icon;
            }
            if ((n & 2) != 0) {
                bl = iconCalcResult.isInvalid;
            }
            if ((n & 4) != 0) {
                l = iconCalcResult.startTime;
            }
            return iconCalcResult.copy(icon, bl, l);
        }

        @NotNull
        public String toString() {
            return "IconCalcResult(icon=" + this.icon + ", isInvalid=" + this.isInvalid + ", startTime=" + this.startTime + ")";
        }

        public int hashCode() {
            int result2 = this.icon.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isInvalid);
            result2 = result2 * 31 + Long.hashCode(this.startTime);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IconCalcResult)) {
                return false;
            }
            IconCalcResult iconCalcResult = (IconCalcResult)other;
            if (!Intrinsics.areEqual((Object)this.icon, (Object)iconCalcResult.icon)) {
                return false;
            }
            if (this.isInvalid != iconCalcResult.isInvalid) {
                return false;
            }
            return this.startTime == iconCalcResult.startTime;
        }
    }
}

