/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch.design;

import com.intellij.execution.multilaunch.MultiLaunchConfiguration;
import com.intellij.execution.multilaunch.design.ExecutableRow;
import com.intellij.execution.multilaunch.design.ExecutablesTableModel;
import com.intellij.execution.multilaunch.execution.executables.Executable;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!J\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000eJ\u0016\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lcom/intellij/execution/multilaunch/design/MultiLaunchConfigurationViewModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getConfiguration", "()Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;", "rows", "", "Lcom/intellij/execution/multilaunch/design/ExecutableRow;", "getRows", "()Ljava/util/List;", "tableModel", "Lcom/intellij/execution/multilaunch/design/ExecutablesTableModel;", "getTableModel", "()Lcom/intellij/execution/multilaunch/design/ExecutablesTableModel;", "activateAllToolWindows", "", "getActivateAllToolWindows", "()Z", "setActivateAllToolWindows", "(Z)V", "reset", "", "addRow", "row", "removeRow", "executable", "Lcom/intellij/execution/multilaunch/execution/executables/Executable;", "replaceRow", "oldRow", "newRow", "intellij.platform.execution.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMultiLaunchConfigurationViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiLaunchConfigurationViewModel.kt\ncom/intellij/execution/multilaunch/design/MultiLaunchConfigurationViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n296#2,2:53\n*S KotlinDebug\n*F\n+ 1 MultiLaunchConfigurationViewModel.kt\ncom/intellij/execution/multilaunch/design/MultiLaunchConfigurationViewModel\n*L\n34#1:53,2\n*E\n"})
public final class MultiLaunchConfigurationViewModel {
    @NotNull
    private final Project project;
    @NotNull
    private final MultiLaunchConfiguration configuration;
    @NotNull
    private final List<ExecutableRow> rows;
    @NotNull
    private final ExecutablesTableModel tableModel;
    private boolean activateAllToolWindows;

    public MultiLaunchConfigurationViewModel(@NotNull Project project, @NotNull MultiLaunchConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.project = project;
        this.configuration = configuration;
        this.rows = new ArrayList();
        this.tableModel = new ExecutablesTableModel(this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final MultiLaunchConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final List<ExecutableRow> getRows() {
        return this.rows;
    }

    @NotNull
    public final ExecutablesTableModel getTableModel() {
        return this.tableModel;
    }

    public final boolean getActivateAllToolWindows() {
        return this.activateAllToolWindows;
    }

    public final void setActivateAllToolWindows(boolean bl) {
        this.activateAllToolWindows = bl;
    }

    public final void reset() {
        while (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeRow(0);
        }
        this.tableModel.addRow(null);
    }

    public final void addRow(@NotNull ExecutableRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        switch (this.tableModel.getRowCount()) {
            case 0: {
                this.tableModel.addRow(row);
                this.tableModel.addRow(null);
                break;
            }
            case 1: {
                this.tableModel.insertRow(0, row);
                break;
            }
            default: {
                this.tableModel.insertRow(this.tableModel.getRowCount() - 1, row);
            }
        }
    }

    public final void removeRow(@NotNull Executable executable) {
        Object v2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            List list = this.tableModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ExecutableRow it = (ExecutableRow)element$iv;
                boolean bl = false;
                ExecutableRow executableRow = it;
                if (!Intrinsics.areEqual((Object)(executableRow != null ? executableRow.getExecutable() : null), (Object)executable)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        ExecutableRow executableRow = v2;
        if (executableRow == null) {
            return;
        }
        ExecutableRow rowToRemove = executableRow;
        this.removeRow(rowToRemove);
    }

    public final void removeRow(@NotNull ExecutableRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        int index = this.tableModel.indexOf(row);
        if (index != -1) {
            this.tableModel.removeRow(index);
        }
    }

    public final void replaceRow(@NotNull ExecutableRow oldRow, @NotNull ExecutableRow newRow) {
        Intrinsics.checkNotNullParameter((Object)oldRow, (String)"oldRow");
        Intrinsics.checkNotNullParameter((Object)newRow, (String)"newRow");
        int index = this.tableModel.indexOf(oldRow);
        if (index != -1) {
            this.tableModel.removeRow(index);
            this.tableModel.insertRow(index, newRow);
        }
    }
}

