/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch.design.tooltips;

import com.intellij.execution.multilaunch.design.Debouncer;
import com.intellij.execution.multilaunch.design.extensions.GeometryExtensionsKt;
import com.intellij.execution.multilaunch.design.tooltips.TooltipProvider;
import com.intellij.execution.multilaunch.design.tooltips.TooltipProvidersTracker;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.hover.HoverListener;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/multilaunch/design/tooltips/TableTooltipsController;", "Lcom/intellij/ui/hover/HoverListener;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "schedulerKey", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/Object;)V", "tooltip", "Lcom/intellij/openapi/ui/popup/Balloon;", "tooltipScheduler", "Lcom/intellij/execution/multilaunch/design/Debouncer;", "tooltipProvidersTracker", "Lcom/intellij/execution/multilaunch/design/tooltips/TooltipProvidersTracker;", "install", "", "table", "Ljavax/swing/JTable;", "uninstall", "mouseEntered", "component", "Ljava/awt/Component;", "x", "", "y", "mouseMoved", "mouseExited", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nTableTooltipsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableTooltipsController.kt\ncom/intellij/execution/multilaunch/design/tooltips/TableTooltipsController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n296#2,2:88\n*S KotlinDebug\n*F\n+ 1 TableTooltipsController.kt\ncom/intellij/execution/multilaunch/design/tooltips/TableTooltipsController\n*L\n39#1:88,2\n*E\n"})
public final class TableTooltipsController
extends HoverListener {
    @NotNull
    private final Object schedulerKey;
    @Nullable
    private Balloon tooltip;
    @NotNull
    private final Debouncer tooltipScheduler;
    @NotNull
    private final TooltipProvidersTracker tooltipProvidersTracker;

    public TableTooltipsController(@NotNull Lifetime lifetime, @NotNull Object schedulerKey) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)schedulerKey, (String)"schedulerKey");
        this.schedulerKey = schedulerKey;
        this.tooltipScheduler = new Debouncer(Registry.Companion.intValue("ide.tooltip.initialReshowDelay"), lifetime);
        this.tooltipProvidersTracker = new TooltipProvidersTracker();
    }

    public /* synthetic */ TableTooltipsController(Lifetime lifetime, Object clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            clazz = TableTooltipsController.class;
        }
        this(lifetime, clazz);
    }

    public final void install(@NotNull JTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.addTo(table);
        table.addContainerListener(this.tooltipProvidersTracker);
    }

    public final void uninstall(@NotNull JTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.removeFrom(table);
        table.removeContainerListener(this.tooltipProvidersTracker);
    }

    public void mouseEntered(@NotNull Component component, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
    }

    public void mouseMoved(@NotNull Component table, int x, int y) {
        Object v1;
        Point tableMouse;
        block4: {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Balloon balloon = this.tooltip;
            if (balloon != null) {
                balloon.hideImmediately();
            }
            tableMouse = new Point(x, y);
            Iterable $this$firstOrNull$iv = this.tooltipProvidersTracker.getProviders();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TooltipProvider it = (TooltipProvider)element$iv;
                boolean bl = false;
                JComponent regionComponent = it.getTooltipTarget();
                Point localMouse = SwingUtilities.convertPoint(table, tableMouse, regionComponent);
                Rectangle localRegion = SwingUtilities.convertRectangle(regionComponent.getParent(), regionComponent.getBounds(), regionComponent);
                Intrinsics.checkNotNull((Object)localMouse);
                Intrinsics.checkNotNull((Object)localRegion);
                if (!GeometryExtensionsKt.isOver(localMouse, localRegion)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        TooltipProvider provider = v1;
        if (provider == null) {
            this.tooltipScheduler.cancel(this.schedulerKey);
        } else {
            this.tooltipScheduler.call(this.schedulerKey, (Function0<Unit>)((Function0)() -> TableTooltipsController.mouseMoved$lambda$1(provider, table, tableMouse, this)));
        }
    }

    public void mouseExited(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.tooltipScheduler.cancel(this.schedulerKey);
    }

    private static final Unit mouseMoved$lambda$1(TooltipProvider $provider, Component $table, Point $tableMouse, TableTooltipsController this$0) {
        Point point;
        boolean shadowEnabled = Registry.Companion.is("ide.balloon.shadowEnabled");
        int shadowSize = Registry.Companion.intValue("ide.balloon.shadow.size");
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(new Html($provider.getTooltipText()).setKeepFont(true), null, UIUtil.getToolTipForeground(), UIUtil.getToolTipBackground(), null).setShadow(shadowEnabled).setAnimationCycle(0).setBorderColor(JBUI.CurrentTheme.Tooltip.borderColor()).setShowCallout(false).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        Balloon newTooltip = balloon;
        Dimension tooltipSize = newTooltip.getPreferredSize();
        boolean bl = shadowEnabled;
        if (bl) {
            point = new Point(JBUI.scale((int)shadowSize), JBUI.scale((int)shadowSize));
        } else if (!bl) {
            point = new Point(0, 0);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Point shadowOffset = point;
        Point balloonOffset = new Point(JBUI.scale((int)10), JBUI.scale((int)10));
        RelativePoint tooltipLocation = new RelativePoint($table, new Point($tableMouse.x + tooltipSize.width / 2 - shadowOffset.x + balloonOffset.x, $tableMouse.y + tooltipSize.height / 2 - shadowOffset.y + balloonOffset.y));
        newTooltip.show(tooltipLocation, Balloon.Position.below);
        this$0.tooltip = newTooltip;
        return Unit.INSTANCE;
    }
}

