/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch.execution;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.multilaunch.MultiLaunchConfiguration;
import com.intellij.execution.multilaunch.design.ExecutableRowFactoryKt;
import com.intellij.execution.multilaunch.execution.ExecutableExecutionModel;
import com.intellij.execution.multilaunch.execution.ExecutionDescriptor;
import com.intellij.execution.multilaunch.execution.ExecutionDescriptorFactoryKt;
import com.intellij.execution.multilaunch.execution.ExecutionMode;
import com.intellij.execution.multilaunch.execution.ExecutionModel;
import com.intellij.execution.multilaunch.execution.ExecutionSession;
import com.intellij.execution.multilaunch.execution.ExecutionSessionManager;
import com.intellij.execution.multilaunch.execution.ExecutionStatus;
import com.intellij.execution.multilaunch.execution.ExecutionStatusKt;
import com.intellij.execution.multilaunch.execution.MultiLaunchExecutionModel;
import com.intellij.execution.multilaunch.execution.executables.Executable;
import com.intellij.execution.multilaunch.execution.messaging.DefaultExecutionNotifier;
import com.intellij.execution.multilaunch.execution.messaging.ExecutableNotifierProxy;
import com.intellij.execution.multilaunch.execution.messaging.ExecutionEventsBus;
import com.intellij.execution.multilaunch.execution.messaging.ExecutionNotifier;
import com.intellij.execution.multilaunch.servicesView.MultiLaunchServicesRefresher;
import com.intellij.execution.multilaunch.state.ExecutableRowSnapshot;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.rd.util.PlatformDependentKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rd.util.reactive.ViewableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 ?2\u00020\u0001:\u0002?@B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010 \u001a\u00020!J&\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0086@\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020!2\u0006\u0010#\u001a\u00020$J\u0016\u0010*\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020,J,\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u0002012\u0006\u0010\f\u001a\u00020\r2\f\u00102\u001a\b\u0012\u0004\u0012\u00020/0.H\u0002J\u0018\u00103\u001a\u00020!2\u0006\u00104\u001a\u0002052\u0006\u00100\u001a\u000201H\u0002J\u0018\u00106\u001a\u00020!2\u0006\u00104\u001a\u0002052\u0006\u00100\u001a\u000201H\u0002J6\u00107\u001a\b\u0012\u0004\u0012\u0002080.2\u0006\u00104\u001a\u0002052\u0006\u00100\u001a\u0002012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u00109\u001a\u00020&2\u0006\u0010%\u001a\u00020&2\u0006\u0010:\u001a\u00020/H\u0002J \u0010;\u001a\u00020!2\u0006\u00104\u001a\u0002052\u0006\u0010\f\u001a\u00020\r2\u0006\u00100\u001a\u000201H\u0002J \u0010<\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\u0006\u0010=\u001a\u00020>H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000b\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000b\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000b\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006A"}, d2={"Lcom/intellij/execution/multilaunch/execution/ExecutionEngine;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "eventBus", "Lcom/intellij/execution/multilaunch/execution/messaging/ExecutionEventsBus;", "getEventBus", "()Lcom/intellij/execution/multilaunch/execution/messaging/ExecutionEventsBus;", "eventBus$delegate", "Lkotlin/Lazy;", "publisher", "Lcom/intellij/execution/multilaunch/execution/messaging/ExecutionNotifier;", "getPublisher", "()Lcom/intellij/execution/multilaunch/execution/messaging/ExecutionNotifier;", "publisher$delegate", "executionModel", "Lcom/intellij/execution/multilaunch/execution/ExecutionModel;", "getExecutionModel", "()Lcom/intellij/execution/multilaunch/execution/ExecutionModel;", "executionModel$delegate", "serviceViewUpdatePublisher", "Lcom/intellij/execution/multilaunch/servicesView/MultiLaunchServicesRefresher;", "getServiceViewUpdatePublisher", "()Lcom/intellij/execution/multilaunch/servicesView/MultiLaunchServicesRefresher;", "serviceViewUpdatePublisher$delegate", "sessionManager", "Lcom/intellij/execution/multilaunch/execution/ExecutionSessionManager;", "getSessionManager", "()Lcom/intellij/execution/multilaunch/execution/ExecutionSessionManager;", "sessionManager$delegate", "initialize", "", "execute", "configuration", "Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;", "executionMode", "Lcom/intellij/execution/multilaunch/execution/ExecutionMode;", "activity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "(Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;Lcom/intellij/execution/multilaunch/execution/ExecutionMode;Lcom/intellij/internal/statistic/StructuredIdeActivity;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stop", "executable", "Lcom/intellij/execution/multilaunch/execution/executables/Executable;", "proxifyDescriptors", "", "Lcom/intellij/execution/multilaunch/execution/ExecutionDescriptor;", "configurationModel", "Lcom/intellij/execution/multilaunch/execution/MultiLaunchExecutionModel;", "descriptors", "markNotStarted", "session", "Lcom/intellij/execution/multilaunch/execution/ExecutionSession;", "markWaiting", "createConditionListeners", "Lcom/intellij/util/messages/MessageBusConnection;", "calculateExecutionMode", "descriptor", "startMultiLaunch", "setStatus", "status", "Lcom/intellij/execution/multilaunch/execution/ExecutionStatus;", "Companion", "StatusListener", "intellij.platform.execution.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nExecutionEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionEngine.kt\ncom/intellij/execution/multilaunch/execution/ExecutionEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1586#2:186\n1661#2,3:187\n1915#2,2:190\n1915#2,2:192\n1642#2,10:194\n1915#2:204\n1916#2:206\n1652#2:207\n1642#2,10:208\n1915#2:218\n1916#2:220\n1652#2:221\n1205#2,2:223\n1282#2,4:225\n1#3:205\n1#3:219\n1#3:222\n*S KotlinDebug\n*F\n+ 1 ExecutionEngine.kt\ncom/intellij/execution/multilaunch/execution/ExecutionEngine\n*L\n90#1:186\n90#1:187,3\n96#1:190,2\n103#1:192,2\n117#1:194,10\n117#1:204\n117#1:206\n117#1:207\n43#1:208,10\n43#1:218\n43#1:220\n43#1:221\n45#1:223,2\n45#1:225,4\n117#1:205\n43#1:219\n*E\n"})
public final class ExecutionEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy eventBus$delegate;
    @NotNull
    private final Lazy publisher$delegate;
    @NotNull
    private final Lazy executionModel$delegate;
    @NotNull
    private final Lazy serviceViewUpdatePublisher$delegate;
    @NotNull
    private final Lazy sessionManager$delegate;

    public ExecutionEngine(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.eventBus$delegate = LazyKt.lazy(() -> ExecutionEngine.eventBus_delegate$lambda$0(this));
        this.publisher$delegate = LazyKt.lazy(() -> ExecutionEngine.publisher_delegate$lambda$0(this));
        this.executionModel$delegate = LazyKt.lazy(() -> ExecutionEngine.executionModel_delegate$lambda$0(this));
        this.serviceViewUpdatePublisher$delegate = LazyKt.lazy(() -> ExecutionEngine.serviceViewUpdatePublisher_delegate$lambda$0(this));
        this.sessionManager$delegate = LazyKt.lazy(ExecutionEngine::sessionManager_delegate$lambda$0);
    }

    private final ExecutionEventsBus getEventBus() {
        Lazy lazy = this.eventBus$delegate;
        return (ExecutionEventsBus)lazy.getValue();
    }

    private final ExecutionNotifier getPublisher() {
        Lazy lazy = this.publisher$delegate;
        return (ExecutionNotifier)lazy.getValue();
    }

    private final ExecutionModel getExecutionModel() {
        Lazy lazy = this.executionModel$delegate;
        return (ExecutionModel)lazy.getValue();
    }

    private final MultiLaunchServicesRefresher getServiceViewUpdatePublisher() {
        Lazy lazy = this.serviceViewUpdatePublisher$delegate;
        return (MultiLaunchServicesRefresher)lazy.getValue();
    }

    private final ExecutionSessionManager getSessionManager() {
        Lazy lazy = this.sessionManager$delegate;
        return (ExecutionSessionManager)lazy.getValue();
    }

    public final void initialize() {
        this.getEventBus().subscribe(new StatusListener(), UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)));
        this.getExecutionModel().getConfigurations().adviseAddRemove(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), (arg_0, arg_1, arg_2) -> ExecutionEngine.initialize$lambda$0(this, arg_0, arg_1, arg_2));
    }

    @Nullable
    public final Object execute(@NotNull MultiLaunchConfiguration configuration, @NotNull ExecutionMode executionMode, @NotNull StructuredIdeActivity activity, @NotNull Continuation<? super Unit> $completion) {
        MultiLaunchExecutionModel multiLaunchExecutionModel = (MultiLaunchExecutionModel)this.getExecutionModel().getConfigurations().get((Object)configuration);
        if (multiLaunchExecutionModel == null) {
            throw new CantRunException(ExecutionBundle.message((String)"run.configurations.multilaunch.error.configuration.doesnt.exist", (Object[])new Object[0]));
        }
        MultiLaunchExecutionModel configurationModel = multiLaunchExecutionModel;
        this.stop(configuration);
        ExecutionSession session = new ExecutionSession(this.project, configurationModel);
        this.getSessionManager().setActiveSession(configuration, session);
        this.markNotStarted(session, configurationModel);
        this.createConditionListeners(session, configurationModel, this.getEventBus(), executionMode, activity);
        this.startMultiLaunch(session, this.getPublisher(), configurationModel);
        Object object = session.awaitExecution($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void stop(@NotNull MultiLaunchConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        ExecutionSession executionSession = this.getSessionManager().getActiveSession(configuration);
        if (executionSession == null) {
            return;
        }
        ExecutionSession session = executionSession;
        session.stop();
    }

    public final void stop(@NotNull MultiLaunchConfiguration configuration, @NotNull Executable executable) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        ExecutionSession executionSession = this.getSessionManager().getActiveSession(configuration);
        if (executionSession == null) {
            return;
        }
        ExecutionSession session = executionSession;
        session.stop(executable);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ExecutionDescriptor> proxifyDescriptors(MultiLaunchExecutionModel configurationModel, ExecutionNotifier publisher, List<ExecutionDescriptor> descriptors) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = descriptors;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExecutionDescriptor executionDescriptor = (ExecutionDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ExecutionDescriptor.copy$default((ExecutionDescriptor)it, new ExecutableNotifierProxy(configurationModel, it.getExecutable(), publisher), null, false, 6, null));
        }
        return (List)destination$iv$iv;
    }

    private final void markNotStarted(ExecutionSession session, MultiLaunchExecutionModel configurationModel) {
        Iterable $this$forEach$iv = configurationModel.getExecutables().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutableExecutionModel it = (ExecutableExecutionModel)element$iv;
            boolean bl = false;
            it.getStatus$intellij_platform_execution_impl().set((Object)ExecutionStatus.NotStarted.INSTANCE);
        }
        this.getServiceViewUpdatePublisher().refresh(session.getModel().getConfiguration());
    }

    private final void markWaiting(ExecutionSession session, MultiLaunchExecutionModel configurationModel) {
        Iterable $this$forEach$iv = configurationModel.getExecutables().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutableExecutionModel it = (ExecutableExecutionModel)element$iv;
            boolean bl = false;
            it.getStatus$intellij_platform_execution_impl().set((Object)ExecutionStatus.Waiting.INSTANCE);
        }
        this.getServiceViewUpdatePublisher().refresh(session.getModel().getConfiguration());
    }

    /*
     * WARNING - void declaration
     */
    private final List<MessageBusConnection> createConditionListeners(ExecutionSession session, MultiLaunchExecutionModel configurationModel, ExecutionEventsBus eventBus, ExecutionMode executionMode, StructuredIdeActivity activity) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = configurationModel.getExecutables().values();
        boolean $i$f$mapNotNull = false;
        void var8_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MessageBusConnection messageBusConnection;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ExecutableExecutionModel it = (ExecutableExecutionModel)element$iv$iv;
            boolean bl2 = false;
            ExecutionMode mode = this.calculateExecutionMode(executionMode, it.getDescriptor());
            if (session.getLifetime(it.getDescriptor().getExecutable()) == null) {
                messageBusConnection = null;
            } else {
                LifetimeDefinition lifetime;
                lifetime.onTerminationIfAlive(() -> ExecutionEngine.createConditionListeners$lambda$0$0(it, this, configurationModel));
                ExecutionNotifier notifier = it.getDescriptor().createListener((Lifetime)lifetime, mode, activity);
                messageBusConnection = eventBus.subscribe(configurationModel.getConfiguration(), notifier, (Lifetime)lifetime);
            }
            if (messageBusConnection == null) continue;
            MessageBusConnection it$iv$iv = messageBusConnection;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ExecutionMode calculateExecutionMode(ExecutionMode executionMode, ExecutionDescriptor descriptor) {
        return executionMode == ExecutionMode.Debug && descriptor.getExecutable().getSupportsDebugging() && !descriptor.getDisableDebugging() ? ExecutionMode.Debug : ExecutionMode.Run;
    }

    private final void startMultiLaunch(ExecutionSession session, ExecutionNotifier publisher, MultiLaunchExecutionModel configurationModel) {
        this.markWaiting(session, configurationModel);
        List executables = CollectionsKt.toList((Iterable)configurationModel.getExecutables().keySet());
        RdCoroutinesUtilKt.launchBackground$default((Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(publisher, session, (List<? extends Executable>)executables, null){
            int label;
            final /* synthetic */ ExecutionNotifier $publisher;
            final /* synthetic */ ExecutionSession $session;
            final /* synthetic */ List<Executable> $executables;
            {
                this.$publisher = $publisher;
                this.$session = $session;
                this.$executables = $executables;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$publisher.start(this.$session.getModel().getConfiguration(), this.$executables);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void setStatus(MultiLaunchConfiguration configuration, Executable executable, ExecutionStatus status) {
        Object object = (ViewableMap<Executable, ExecutableExecutionModel>)this.getExecutionModel().getConfigurations().get((Object)configuration);
        if (object != null && (object = ((MultiLaunchExecutionModel)object).getExecutables()) != null && (object = (ExecutableExecutionModel)object.get((Object)executable)) != null && (object = ((ExecutableExecutionModel)object).getStatus$intellij_platform_execution_impl()) != null) {
            object.set((Object)status);
        }
        this.getServiceViewUpdatePublisher().refresh(configuration);
    }

    private static final ExecutionEventsBus eventBus_delegate$lambda$0(ExecutionEngine this$0) {
        return ExecutionEventsBus.Companion.getInstance(this$0.project);
    }

    private static final ExecutionNotifier publisher_delegate$lambda$0(ExecutionEngine this$0) {
        return this$0.getEventBus().createPublisher();
    }

    private static final ExecutionModel executionModel_delegate$lambda$0(ExecutionEngine this$0) {
        return ExecutionModel.Companion.getInstance(this$0.project);
    }

    private static final MultiLaunchServicesRefresher serviceViewUpdatePublisher_delegate$lambda$0(ExecutionEngine this$0) {
        return MultiLaunchServicesRefresher.Companion.getInstance(this$0.project);
    }

    private static final ExecutionSessionManager sessionManager_delegate$lambda$0() {
        return new ExecutionSessionManager();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit initialize$lambda$0(ExecutionEngine this$0, AddRemove event, MultiLaunchConfiguration configuration, MultiLaunchExecutionModel configModel) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)configModel, (String)"configModel");
        switch (WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
            case 1: {
                void $this$associateTo$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = configuration.getState().getRows();
                boolean $i$f$mapNotNull = false;
                void var7_7 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo22 = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ExecutionDescriptor it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    ExecutableRowSnapshot it = (ExecutableRowSnapshot)((Object)element$iv$iv);
                    boolean bl2 = false;
                    if (ExecutionDescriptorFactoryKt.toDescriptor(ExecutableRowFactoryKt.toRow(it, this$0.project, configuration)) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List it = (List)destination$iv$iv;
                boolean bl = false;
                List<ExecutionDescriptor> descriptors = this$0.proxifyDescriptors(configModel, this$0.getPublisher(), it);
                Iterable $this$associate$iv = descriptors;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable $i$f$mapNotNullTo22 = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv2;
                    ExecutionDescriptor it2 = (ExecutionDescriptor)element$iv$iv;
                    boolean bl4 = false;
                    Pair pair = TuplesKt.to((Object)it2.getExecutable(), (Object)new ExecutableExecutionModel(it2));
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map pairs = destination$iv$iv2;
                configModel.getExecutables().putAll(pairs);
                this$0.getServiceViewUpdatePublisher().refresh(configuration);
                break;
            }
            case 2: {
                configModel.getExecutables().clear();
                this$0.getServiceViewUpdatePublisher().refresh();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit createConditionListeners$lambda$0$0(ExecutableExecutionModel $it, ExecutionEngine this$0, MultiLaunchExecutionModel $configurationModel) {
        if (!ExecutionStatusKt.isDone((ExecutionStatus)$it.getStatus$intellij_platform_execution_impl().getValue())) {
            this$0.setStatus($configurationModel.getConfiguration(), $it.getDescriptor().getExecutable(), ExecutionStatus.Canceled.INSTANCE);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/multilaunch/execution/ExecutionEngine$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/execution/multilaunch/execution/ExecutionEngine;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.execution.impl"})
    @SourceDebugExtension(value={"SMAP\nExecutionEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionEngine.kt\ncom/intellij/execution/multilaunch/execution/ExecutionEngine$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,185:1\n30#2,2:186\n*S KotlinDebug\n*F\n+ 1 ExecutionEngine.kt\ncom/intellij/execution/multilaunch/execution/ExecutionEngine$Companion\n*L\n28#1:186,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExecutionEngine getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ExecutionEngine> serviceClass$iv = ExecutionEngine.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ExecutionEngine)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0016J\"\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0016R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/execution/multilaunch/execution/ExecutionEngine$StatusListener;", "Lcom/intellij/execution/multilaunch/execution/messaging/DefaultExecutionNotifier;", "<init>", "(Lcom/intellij/execution/multilaunch/execution/ExecutionEngine;)V", "executablesLeft", "", "Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;", "Ljava/util/HashSet;", "Lcom/intellij/execution/multilaunch/execution/executables/Executable;", "Lkotlin/collections/HashSet;", "start", "", "configuration", "executables", "", "beforeExecute", "executable", "afterSuccess", "afterCancel", "afterFail", "reason", "", "afterExecute", "intellij.platform.execution.impl"})
    public final class StatusListener
    extends DefaultExecutionNotifier {
        @NotNull
        private final Map<MultiLaunchConfiguration, HashSet<Executable>> executablesLeft = PlatformDependentKt.concurrentMapOf();

        @Override
        public void start(@NotNull MultiLaunchConfiguration configuration, @NotNull List<? extends Executable> executables) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter(executables, (String)"executables");
            this.executablesLeft.put(configuration, CollectionsKt.toHashSet((Iterable)executables));
        }

        @Override
        public void beforeExecute(@NotNull MultiLaunchConfiguration configuration, @NotNull Executable executable) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            ExecutionEngine.this.setStatus(configuration, executable, ExecutionStatus.Started.INSTANCE);
        }

        @Override
        public void afterSuccess(@NotNull MultiLaunchConfiguration configuration, @NotNull Executable executable) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            ExecutionEngine.this.setStatus(configuration, executable, ExecutionStatus.Finished.INSTANCE);
        }

        @Override
        public void afterCancel(@NotNull MultiLaunchConfiguration configuration, @NotNull Executable executable) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            ExecutionEngine.this.setStatus(configuration, executable, ExecutionStatus.Canceled.INSTANCE);
        }

        @Override
        public void afterFail(@NotNull MultiLaunchConfiguration configuration, @NotNull Executable executable, @Nullable Throwable reason) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            ExecutionEngine.this.setStatus(configuration, executable, new ExecutionStatus.Failed(reason));
        }

        @Override
        public void afterExecute(@NotNull MultiLaunchConfiguration configuration, @NotNull Executable executable) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            ExecutionSession executionSession = ExecutionEngine.this.getSessionManager().getActiveSession(configuration);
            if (executionSession == null) {
                return;
            }
            ExecutionSession session = executionSession;
            session.stop(executable);
            HashSet<Executable> hashSet = this.executablesLeft.get(configuration);
            if (hashSet == null) {
                return;
            }
            HashSet<Executable> left = hashSet;
            left.remove(executable);
            if (left.isEmpty()) {
                session.stop();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AddRemove.values().length];
            try {
                nArray[AddRemove.Add.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddRemove.Remove.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

