/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch.servicesView;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.multilaunch.execution.ExecutableExecutionModel;
import com.intellij.execution.multilaunch.execution.ExecutionStatus;
import com.intellij.execution.multilaunch.execution.MultiLaunchExecutionModel;
import com.intellij.execution.multilaunch.servicesView.actions.executable.CancelExecutableAction;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBPanelWithEmptyText;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\n\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/execution/multilaunch/servicesView/ExecutableServiceViewDescriptor;", "Lcom/intellij/execution/services/ServiceViewDescriptor;", "configurationModel", "Lcom/intellij/execution/multilaunch/execution/MultiLaunchExecutionModel;", "executableModel", "Lcom/intellij/execution/multilaunch/execution/ExecutableExecutionModel;", "<init>", "(Lcom/intellij/execution/multilaunch/execution/MultiLaunchExecutionModel;Lcom/intellij/execution/multilaunch/execution/ExecutableExecutionModel;)V", "toolbarActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "getToolbarActions", "()Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "toolbarActions$delegate", "Lkotlin/Lazy;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getContentComponent", "Ljavax/swing/JComponent;", "onNodeSelected", "", "selectedServices", "", "", "Companion", "intellij.platform.execution.impl"})
public final class ExecutableServiceViewDescriptor
implements ServiceViewDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiLaunchExecutionModel configurationModel;
    @NotNull
    private final ExecutableExecutionModel executableModel;
    @NotNull
    private final Lazy toolbarActions$delegate;

    public ExecutableServiceViewDescriptor(@NotNull MultiLaunchExecutionModel configurationModel, @NotNull ExecutableExecutionModel executableModel) {
        Intrinsics.checkNotNullParameter((Object)configurationModel, (String)"configurationModel");
        Intrinsics.checkNotNullParameter((Object)executableModel, (String)"executableModel");
        this.configurationModel = configurationModel;
        this.executableModel = executableModel;
        this.toolbarActions$delegate = LazyKt.lazy(() -> ExecutableServiceViewDescriptor.toolbarActions_delegate$lambda$0(this));
    }

    private final DefaultActionGroup getToolbarActions() {
        Lazy lazy = this.toolbarActions$delegate;
        return (DefaultActionGroup)lazy.getValue();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        PresentationData presentationData;
        PresentationData $this$getPresentation_u24lambda_u240 = presentationData = new PresentationData();
        boolean bl = false;
        $this$getPresentation_u24lambda_u240.setIcon(ExecutableServiceViewDescriptor.Companion.getStatusIcon(this.executableModel));
        $this$getPresentation_u24lambda_u240.addText(this.executableModel.getDescriptor().getExecutable().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        $this$getPresentation_u24lambda_u240.addText(" - ", SimpleTextAttributes.GRAY_ATTRIBUTES);
        $this$getPresentation_u24lambda_u240.addText(ExecutableServiceViewDescriptor.Companion.getStatusText(this.executableModel), SimpleTextAttributes.GRAY_ATTRIBUTES);
        return (ItemPresentation)presentationData;
    }

    @NotNull
    public ActionGroup getToolbarActions() {
        return (ActionGroup)this.getToolbarActions();
    }

    @NotNull
    public JComponent getContentComponent() {
        JBPanelWithEmptyText jBPanelWithEmptyText = new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"run.configurations.multilaunch.services.executable.use.toolbar.placeholder", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)jBPanelWithEmptyText, (String)"withEmptyText(...)");
        return (JComponent)jBPanelWithEmptyText;
    }

    public void onNodeSelected(@Nullable List<Object> selectedServices) {
        super.onNodeSelected(selectedServices);
    }

    private static final DefaultActionGroup toolbarActions_delegate$lambda$0(ExecutableServiceViewDescriptor this$0) {
        AnAction[] anActionArray = new AnAction[]{new CancelExecutableAction(this$0.configurationModel, this$0.executableModel)};
        return new DefaultActionGroup(anActionArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u00a8\u0006\n"}, d2={"Lcom/intellij/execution/multilaunch/servicesView/ExecutableServiceViewDescriptor$Companion;", "", "<init>", "()V", "getStatusIcon", "Ljavax/swing/Icon;", "state", "Lcom/intellij/execution/multilaunch/execution/ExecutableExecutionModel;", "getStatusText", "", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final Icon getStatusIcon(ExecutableExecutionModel state) {
            Icon icon;
            ExecutionStatus executionStatus = (ExecutionStatus)state.getStatus$intellij_platform_execution_impl().getValue();
            if (executionStatus instanceof ExecutionStatus.NotStarted) {
                Icon icon2 = AllIcons.RunConfigurations.TestUnknown;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"TestUnknown");
            } else if (executionStatus instanceof ExecutionStatus.Waiting) {
                AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"INSTANCE");
                icon = (Icon)animatedIcon;
            } else if (executionStatus instanceof ExecutionStatus.Started) {
                AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"INSTANCE");
                icon = (Icon)animatedIcon;
            } else if (executionStatus instanceof ExecutionStatus.Finished) {
                Icon icon3 = AllIcons.RunConfigurations.TestPassed;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"TestPassed");
            } else if (executionStatus instanceof ExecutionStatus.Failed) {
                Icon icon4 = AllIcons.RunConfigurations.TestFailed;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"TestFailed");
            } else if (executionStatus instanceof ExecutionStatus.Canceled) {
                Icon icon5 = AllIcons.RunConfigurations.TestTerminated;
                icon = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"TestTerminated");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return icon;
        }

        @NlsContexts.Label
        private final String getStatusText(ExecutableExecutionModel state) {
            String string;
            ExecutionStatus executionStatus = (ExecutionStatus)state.getStatus$intellij_platform_execution_impl().getValue();
            if (executionStatus instanceof ExecutionStatus.NotStarted) {
                String string2 = ExecutionBundle.message((String)"run.configurations.multilaunch.status.not.started", (Object[])new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            } else if (executionStatus instanceof ExecutionStatus.Waiting) {
                Object[] objectArray = new Object[]{state.getDescriptor().getCondition().getText()};
                String string3 = ExecutionBundle.message((String)"run.configurations.multilaunch.status.waiting", (Object[])objectArray);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            } else if (executionStatus instanceof ExecutionStatus.Started) {
                String string4 = ExecutionBundle.message((String)"run.configurations.multilaunch.status.started", (Object[])new Object[0]);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            } else if (executionStatus instanceof ExecutionStatus.Canceled) {
                String string5 = ExecutionBundle.message((String)"run.configurations.multilaunch.status.canceled", (Object[])new Object[0]);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            } else if (executionStatus instanceof ExecutionStatus.Failed) {
                String string6 = ExecutionBundle.message((String)"run.configurations.multilaunch.status.failed", (Object[])new Object[0]);
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
            } else if (executionStatus instanceof ExecutionStatus.Finished) {
                String string7 = ExecutionBundle.message((String)"run.configurations.multilaunch.status.finished", (Object[])new Object[0]);
                string = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

