/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runToolbar;

import com.intellij.execution.actions.ExecutorAction;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.runToolbar.RunToolbarDataKt;
import com.intellij.execution.runToolbar.RunToolbarProcess;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B+\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarAdditionAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "executorGroup", "Lcom/intellij/execution/executors/ExecutorGroup;", "process", "Lcom/intellij/execution/runToolbar/RunToolbarProcess;", "selectedAction", "Lkotlin/Function0;", "<init>", "(Lcom/intellij/execution/executors/ExecutorGroup;Lcom/intellij/execution/runToolbar/RunToolbarProcess;Lkotlin/jvm/functions/Function0;)V", "getProcess", "()Lcom/intellij/execution/runToolbar/RunToolbarProcess;", "getSelectedAction", "()Lkotlin/jvm/functions/Function0;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "updateAndGetVisibility", "", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "actionPerformed", "intellij.platform.execution.impl"})
public final class RunToolbarAdditionAction
extends AnAction {
    @NotNull
    private final ExecutorGroup<?> executorGroup;
    @NotNull
    private final RunToolbarProcess process;
    @NotNull
    private final Function0<AnAction> selectedAction;

    public RunToolbarAdditionAction(@NotNull ExecutorGroup<?> executorGroup, @NotNull RunToolbarProcess process2, @NotNull Function0<? extends AnAction> selectedAction) {
        Intrinsics.checkNotNullParameter(executorGroup, (String)"executorGroup");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter(selectedAction, (String)"selectedAction");
        this.executorGroup = executorGroup;
        this.process = process2;
        this.selectedAction = selectedAction;
        Presentation presentation = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getTemplatePresentation(...)");
        this.updateAndGetVisibility(presentation);
    }

    @NotNull
    public final RunToolbarProcess getProcess() {
        return this.process;
    }

    @NotNull
    public final Function0<AnAction> getSelectedAction() {
        return this.selectedAction;
    }

    public void update(@NotNull AnActionEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
            presentation.setVisible(this.updateAndGetVisibility(presentation2));
            Project project = e.getProject();
            if (project == null) break block0;
            Project it = project;
            boolean bl = false;
            e.getPresentation().setEnabled(!RunToolbarDataKt.isActiveProcess(e));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private final boolean updateAndGetVisibility(Presentation presentation) {
        boolean bl;
        AnAction action = (AnAction)this.selectedAction.invoke();
        if (action instanceof ExecutorAction) {
            presentation.copyFrom(((ExecutorAction)action).getTemplatePresentation());
            String string = ((ExecutorAction)action).getTemplatePresentation().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            presentation.setText(this.executorGroup.getRunToolbarActionText(string));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            AnAction anAction = (AnAction)this.selectedAction.invoke();
            if (anAction == null) break block0;
            anAction.actionPerformed(e);
        }
    }
}

