/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runToolbar;

import com.intellij.application.Topics;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarRollbackToPrevious;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Companion", "intellij.platform.execution.impl"})
public final class RunToolbarRollbackToPrevious
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ROLLBACK_AVAILABILITY = "ide.widget.toolbar.rollback.availability";
    @NotNull
    private static final String INCLUSION_NAVBAR_STATE = "ide.widget.toolbar.first.inclusion.navbar.state";
    @NotNull
    private static final String INCLUSION_TOOLBAR_STATE = "ide.widget.toolbar.first.inclusion.toolbar.state";
    @Nullable
    private static Disposable hideListenerDisposable;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PropertiesComponent properties = PropertiesComponent.getInstance();
        e.getPresentation().setEnabledAndVisible(properties.getBoolean(ROLLBACK_AVAILABILITY));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PropertiesComponent properties = PropertiesComponent.getInstance();
        ToolbarSettings.Companion.getInstance().setVisible(false);
        UISettings uiSettings = UISettings.Companion.getInstance();
        uiSettings.setShowNavigationBar(properties.getBoolean(INCLUSION_NAVBAR_STATE));
        uiSettings.setShowMainToolbar(properties.getBoolean(INCLUSION_TOOLBAR_STATE));
        uiSettings.fireUISettingsChanged();
        RunToolbarRollbackToPrevious.Companion.checkState();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\tJ\b\u0010\u000f\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarRollbackToPrevious$Companion;", "", "<init>", "()V", "ROLLBACK_AVAILABILITY", "", "INCLUSION_NAVBAR_STATE", "INCLUSION_TOOLBAR_STATE", "saveDataIfNeeded", "", "isFirstSessionForNewUser", "", "hideListenerDisposable", "Lcom/intellij/openapi/Disposable;", "addHideActionHelper", "checkState", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void saveDataIfNeeded(boolean isFirstSessionForNewUser) {
            PropertiesComponent properties = PropertiesComponent.getInstance();
            if (isFirstSessionForNewUser) {
                properties.setValue(RunToolbarRollbackToPrevious.ROLLBACK_AVAILABILITY, false);
            } else {
                properties.setValue(RunToolbarRollbackToPrevious.ROLLBACK_AVAILABILITY, true);
                properties.setValue(RunToolbarRollbackToPrevious.INCLUSION_NAVBAR_STATE, UISettings.Companion.getInstance().getShowNavigationBar());
                properties.setValue(RunToolbarRollbackToPrevious.INCLUSION_TOOLBAR_STATE, UISettings.Companion.getInstance().getShowMainToolbar());
            }
            hideListenerDisposable = null;
        }

        public final void addHideActionHelper() {
            boolean bl;
            boolean bl2 = bl = hideListenerDisposable == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            PropertiesComponent properties = PropertiesComponent.getInstance();
            if (properties.getBoolean(RunToolbarRollbackToPrevious.ROLLBACK_AVAILABILITY)) {
                if (ToolbarSettings.Companion.getInstance().isVisible()) {
                    CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
                    Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
                    CheckedDisposable disposable = checkedDisposable;
                    Disposer.register((Disposable)((Disposable)ApplicationManager.getApplication()), (Disposable)((Disposable)disposable));
                    hideListenerDisposable = (Disposable)disposable;
                    Topic topic = UISettingsListener.TOPIC;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                    Topics.subscribe((Topic)topic, (Disposable)((Disposable)disposable), Companion::addHideActionHelper$lambda$0);
                } else {
                    this.checkState();
                }
            }
        }

        private final void checkState() {
            block1: {
                PropertiesComponent properties = PropertiesComponent.getInstance();
                if (ToolbarSettings.Companion.getInstance().isVisible()) break block1;
                properties.setValue(RunToolbarRollbackToPrevious.ROLLBACK_AVAILABILITY, false);
                Disposable disposable = hideListenerDisposable;
                if (disposable != null) {
                    disposable.dispose();
                }
            }
        }

        private static final void addHideActionHelper$lambda$0(UISettings it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Companion.checkState();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

