/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.NotNullFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0005H\u0007J(\u0010\u000b\u001a\u001a\u0012\u0016\u0012\u0014 \u000e*\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\r0\u0005\u00a2\u0006\u0002\b\r0\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/execution/runners/ConsoleTitleGen;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "consoleTitle", "", "shouldAddNumberToTitle", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Z)V", "makeTitle", "getActiveConsoles", "", "Lcom/intellij/build/events/BuildEventsNls$Title;", "kotlin.jvm.PlatformType", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nConsoleTitleGen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleTitleGen.kt\ncom/intellij/execution/runners/ConsoleTitleGen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n777#2:51\n873#2,2:52\n1586#2:54\n1661#2,3:55\n*S KotlinDebug\n*F\n+ 1 ConsoleTitleGen.kt\ncom/intellij/execution/runners/ConsoleTitleGen\n*L\n47#1:51\n47#1:52,2\n48#1:54\n48#1:55,3\n*E\n"})
public class ConsoleTitleGen {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String consoleTitle;
    private final boolean shouldAddNumberToTitle;

    @JvmOverloads
    public ConsoleTitleGen(@NotNull Project myProject, @NlsContexts.TabTitle @NotNull String consoleTitle, boolean shouldAddNumberToTitle) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)consoleTitle, (String)"consoleTitle");
        this.myProject = myProject;
        this.consoleTitle = consoleTitle;
        this.shouldAddNumberToTitle = shouldAddNumberToTitle;
    }

    public /* synthetic */ ConsoleTitleGen(Project project, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(project, string, bl);
    }

    @NlsContexts.TabTitle
    @NotNull
    public final String makeTitle() {
        if (this.shouldAddNumberToTitle) {
            List<String> activeConsoleNames = this.getActiveConsoles(this.consoleTitle);
            int max = -1;
            for (String name : activeConsoleNames) {
                try {
                    Intrinsics.checkNotNull((Object)name);
                    int numBegin = StringsKt.lastIndexOf$default((CharSequence)name, (String)"(", (int)0, (boolean)false, (int)6, null);
                    if (numBegin != -1) {
                        String numString;
                        Intrinsics.checkNotNullExpressionValue((Object)name.substring(numBegin + 1, name.length() - 1), (String)"substring(...)");
                        int num = Integer.parseInt(numString);
                        if (num <= max) continue;
                        max = num;
                        continue;
                    }
                    max = 0;
                }
                catch (Exception exception) {}
            }
            return max == -1 ? this.consoleTitle : this.consoleTitle + " (" + (max + 1) + ")";
        }
        return this.consoleTitle;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<String> getActiveConsoles(@NotNull String consoleTitle) {
        void $this$mapTo$iv$iv;
        RunContentDescriptor it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)consoleTitle, (String)"consoleTitle");
        List<RunContentDescriptor> list = ExecutionHelper.collectConsolesByDisplayName(this.myProject, (NotNullFunction<? super String, Boolean>)((NotNullFunction)arg_0 -> ConsoleTitleGen.getActiveConsoles$lambda$1(arg_0 -> ConsoleTitleGen.getActiveConsoles$lambda$0(consoleTitle, arg_0), arg_0)));
        Intrinsics.checkNotNullExpressionValue(list, (String)"collectConsolesByDisplayName(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (RunContentDescriptor)element$iv$iv;
            boolean bl = false;
            ProcessHandler processHandler = it.getProcessHandler();
            boolean bl2 = processHandler != null ? !processHandler.isProcessTerminated() : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RunContentDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDisplayName());
        }
        return (List)destination$iv$iv;
    }

    @JvmOverloads
    public ConsoleTitleGen(@NotNull Project myProject, @NlsContexts.TabTitle @NotNull String consoleTitle) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)consoleTitle, (String)"consoleTitle");
        this(myProject, consoleTitle, false, 4, null);
    }

    private static final Boolean getActiveConsoles$lambda$0(String $consoleTitle, String dom) {
        Intrinsics.checkNotNull((Object)dom);
        return StringsKt.startsWith$default((String)dom, (String)$consoleTitle, (boolean)false, (int)2, null);
    }

    private static final Boolean getActiveConsoles$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

