/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.diagnostic.logging.LogConsoleManagerBase;
import com.intellij.diagnostic.logging.LogFilesManager;
import com.intellij.diagnostic.logging.OutputFileUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.AdditionalTabComponentManagerEx;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentProxy;
import com.intellij.execution.runners.PreferredPlace;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.GridImpl;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.execution.ui.layout.impl.ViewContextEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.MoreActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.content.SingleContentSupplier;
import com.intellij.psi.search.ExecutionSearchScopes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunTab
implements Disposable {
    @ApiStatus.Experimental
    public static final Key<PreferredPlace> PREFERRED_PLACE = Key.create((String)"RunTab.preferredActionPlace");
    @ApiStatus.Internal
    public static final DataKey<ExecutionEnvironmentProxy> EXECUTION_ENVIRONMENT_PROXY = DataKey.create((String)"RunTab.executionEnvironmentProxy");
    @ApiStatus.Experimental
    public static final DataKey<RunTab> KEY = DataKey.create((String)"RunTab");
    @NotNull
    protected final RunnerLayoutUi myUi;
    private LogFilesManager myManager;
    protected RunContentDescriptor myRunContentDescriptor;
    protected ExecutionEnvironment myEnvironment;
    protected final Project myProject;
    protected final GlobalSearchScope mySearchScope;
    @ApiStatus.Internal
    protected ExecutionEnvironmentProxy myEnvironmentProxy;
    private LogConsoleManagerBase logConsoleManager;

    protected RunTab(@NotNull ExecutionEnvironment environment, @NotNull String runnerType) {
        if (environment == null) {
            RunTab.$$$reportNull$$$0(0);
        }
        if (runnerType == null) {
            RunTab.$$$reportNull$$$0(1);
        }
        this(environment.getProject(), ExecutionSearchScopes.executionScope((Project)environment.getProject(), (RunProfile)environment.getRunProfile()), runnerType, environment.getExecutor().getId(), environment.getRunProfile().getName());
        this.myEnvironment = environment;
    }

    public void dispose() {
        this.myRunContentDescriptor = null;
        this.myEnvironment = null;
        this.logConsoleManager = null;
    }

    protected RunTab(@NotNull Project project, @NotNull GlobalSearchScope searchScope, @NotNull String runnerType, @NotNull String runnerTitle, @NotNull String sessionName) {
        if (project == null) {
            RunTab.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            RunTab.$$$reportNull$$$0(3);
        }
        if (runnerType == null) {
            RunTab.$$$reportNull$$$0(4);
        }
        if (runnerTitle == null) {
            RunTab.$$$reportNull$$$0(5);
        }
        if (sessionName == null) {
            RunTab.$$$reportNull$$$0(6);
        }
        this.myProject = project;
        this.mySearchScope = searchScope;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project).create(runnerType, runnerTitle, sessionName, (Disposable)this);
        this.myUi.getContentManager().addUiDataProvider(sink -> {
            sink.set(CommonDataKeys.PROJECT, (Object)this.myProject);
            sink.set(KEY, (Object)this);
            sink.set(LangDataKeys.RUN_CONTENT_DESCRIPTOR, (Object)this.myRunContentDescriptor);
            sink.set(SingleContentSupplier.KEY, (Object)this.getSupplier());
            if (this.myEnvironment != null) {
                sink.set(ExecutionDataKeys.EXECUTION_ENVIRONMENT, (Object)this.myEnvironment);
                sink.set(LangDataKeys.RUN_PROFILE, (Object)this.myEnvironment.getRunProfile());
            }
            if (this.myEnvironmentProxy != null) {
                sink.set(EXECUTION_ENVIRONMENT_PROXY, (Object)this.myEnvironmentProxy);
            }
        });
    }

    @ApiStatus.Internal
    @Nullable
    protected SingleContentSupplier getSupplier() {
        return null;
    }

    @NotNull
    public LogConsoleManagerBase getLogConsoleManager() {
        if (this.logConsoleManager == null) {
            this.logConsoleManager = this.createLogConsoleManager(null, () -> this.myRunContentDescriptor == null ? null : this.myRunContentDescriptor.getProcessHandler());
        }
        LogConsoleManagerBase logConsoleManagerBase = this.logConsoleManager;
        if (logConsoleManagerBase == null) {
            RunTab.$$$reportNull$$$0(7);
        }
        return logConsoleManagerBase;
    }

    @ApiStatus.Internal
    @NotNull
    protected LogConsoleManagerBase createLogConsoleManager(AdditionalTabComponentManagerEx delegate, Supplier<ProcessHandler> handlerSupplier) {
        return new LogConsoleManagerImpl(delegate, handlerSupplier);
    }

    protected final void initLogConsoles(@NotNull RunProfile runConfiguration, @NotNull RunContentDescriptor contentDescriptor, @Nullable ExecutionConsole console) {
        if (runConfiguration == null) {
            RunTab.$$$reportNull$$$0(8);
        }
        if (contentDescriptor == null) {
            RunTab.$$$reportNull$$$0(9);
        }
        ProcessHandler processHandler = contentDescriptor.getProcessHandler();
        if (runConfiguration instanceof RunConfigurationBase) {
            RunConfigurationBase configuration = (RunConfigurationBase)runConfiguration;
            if (this.myManager == null) {
                this.myManager = new LogFilesManager(this.myProject, this.getLogConsoleManager(), (Disposable)contentDescriptor);
            }
            this.myManager.addLogConsoles(configuration, processHandler);
            if (processHandler != null) {
                OutputFileUtil.attachDumpListener(configuration, processHandler, console);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerTitle";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/runners/RunTab";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/runners/RunTab";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogConsoleManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initLogConsoles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    private class LogConsoleManagerImpl
    extends LogConsoleManagerBase {
        private final Supplier<ProcessHandler> myProcessHandlerSupplier;

        LogConsoleManagerImpl(AdditionalTabComponentManagerEx delegate, Supplier<ProcessHandler> processHandlerSupplier) {
            super(RunTab.this.myProject, RunTab.this.mySearchScope, delegate);
            this.myProcessHandlerSupplier = processHandlerSupplier;
        }

        @Override
        protected Icon getDefaultIcon() {
            return AllIcons.Debugger.Console;
        }

        @Override
        protected RunnerLayoutUi getUi() {
            return RunTab.this.myUi;
        }

        @Override
        public ProcessHandler getProcessHandler() {
            return this.myProcessHandlerSupplier.get();
        }
    }

    public static final class ToolbarActionGroup
    extends DefaultActionGroup {
        private final MoreActionGroup myMoreActionGroup = new MoreActionGroup();

        public ToolbarActionGroup(ActionGroup group2) {
            this.addAll(group2);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] children = super.getChildren(e);
            if (e != null) {
                ToolWindow window = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW);
                SingleContentSupplier data = (SingleContentSupplier)e.getData(SingleContentSupplier.KEY);
                if (data instanceof RunTabSupplier && window != null) {
                    ActionGroup actions;
                    boolean isMoveToolbar = ((RunTabSupplier)data).isMoveToolbar();
                    if (!isMoveToolbar) {
                        if (children == null) {
                            ToolbarActionGroup.$$$reportNull$$$0(0);
                        }
                        return children;
                    }
                    ContentManager manager = window.getContentManager();
                    if (manager.getContentCount() > 1 && (actions = data.getToolbarActions()) != null) {
                        return this.merge(actions.getChildren(e), children);
                    }
                }
            }
            if (children == null) {
                ToolbarActionGroup.$$$reportNull$$$0(1);
            }
            return children;
        }

        private AnAction @NotNull [] merge(AnAction @NotNull [] head, AnAction @NotNull [] tail) {
            if (head == null) {
                ToolbarActionGroup.$$$reportNull$$$0(2);
            }
            if (tail == null) {
                ToolbarActionGroup.$$$reportNull$$$0(3);
            }
            ArrayList<Object> result2 = new ArrayList<Object>(head.length + tail.length);
            result2.addAll(Arrays.asList(head));
            this.myMoreActionGroup.removeAll();
            if (ArrayUtil.getLastElement((Object[])head) instanceof MoreActionGroup) {
                result2.remove(result2.size() - 1);
            }
            result2.add(Separator.create());
            result2.addAll(Arrays.asList(tail));
            if (ArrayUtil.getLastElement((Object[])tail) instanceof MoreActionGroup) {
                this.myMoreActionGroup.addAll((ActionGroup)ArrayUtil.getLastElement((Object[])tail));
                result2.remove(result2.size() - 1);
            }
            if (ArrayUtil.getLastElement((Object[])head) instanceof MoreActionGroup) {
                this.myMoreActionGroup.add((AnAction)Separator.create());
                this.myMoreActionGroup.addAll((ActionGroup)ArrayUtil.getLastElement((Object[])head));
            }
            result2.add(this.myMoreActionGroup);
            AnAction[] anActionArray = result2.toArray(EMPTY_ARRAY);
            if (anActionArray == null) {
                ToolbarActionGroup.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/runners/RunTab$ToolbarActionGroup";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "head";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tail";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/runners/RunTab$ToolbarActionGroup";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    @ApiStatus.Internal
    protected class RunTabSupplier
    implements SingleContentSupplier {
        @Nullable
        private final ActionGroup myActionGroup;
        private final Map<TabInfo, Content> myTabInfoContentMap = new LinkedHashMap<TabInfo, Content>();
        private boolean myMoveToolbar = false;
        private final ActionGroup layoutActionGroup = new ActionGroup(ExecutionBundle.messagePointer((String)"runner.content.tooltip.layout.settings", (Object[])new Object[0]), () -> "", AllIcons.Debugger.RestoreLayout){

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                RunnerContentUi runnerContentUi;
                RunnerLayoutUi runnerLayoutUi = RunTab.this.myUi;
                if (runnerLayoutUi instanceof RunnerLayoutUiImpl) {
                    RunnerLayoutUiImpl o = (RunnerLayoutUiImpl)runnerLayoutUi;
                    runnerContentUi = o.getContentUI();
                } else {
                    runnerContentUi = null;
                }
                RunnerContentUi contentUi = runnerContentUi;
                AnAction[] anActionArray = contentUi == null ? EMPTY_ARRAY : contentUi.getViewActions();
                if (anActionArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }

            public void update(@NotNull AnActionEvent e) {
                RunnerContentUi runnerContentUi;
                RunnerLayoutUi runnerLayoutUi;
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((runnerLayoutUi = RunTab.this.myUi) instanceof RunnerLayoutUiImpl) {
                    RunnerLayoutUiImpl o = (RunnerLayoutUiImpl)runnerLayoutUi;
                    runnerContentUi = o.getContentUI();
                } else {
                    runnerContentUi = null;
                }
                RunnerContentUi contentUi = runnerContentUi;
                e.getPresentation().setEnabledAndVisible(contentUi != null && contentUi.getViewActions().length > 0);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/execution/runners/RunTab$RunTabSupplier$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/execution/runners/RunTab$RunTabSupplier$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };

        public RunTabSupplier(ActionGroup group2) {
            this.myActionGroup = group2;
            this.layoutActionGroup.setPopup(true);
            this.layoutActionGroup.getTemplatePresentation().putClientProperty(ActionUtil.HIDE_DROPDOWN_ICON, (Object)Boolean.TRUE);
        }

        @NotNull
        public JBTabs getTabs() {
            RunnerContentUi runnerContentUi;
            RunnerLayoutUi runnerLayoutUi = RunTab.this.myUi;
            if (runnerLayoutUi instanceof RunnerLayoutUiImpl) {
                RunnerLayoutUiImpl o = (RunnerLayoutUiImpl)runnerLayoutUi;
                runnerContentUi = o.getContentUI();
            } else {
                runnerContentUi = null;
            }
            RunnerContentUi contentUi = runnerContentUi;
            JBTabs jBTabs = ((RunnerContentUi)Objects.requireNonNull(contentUi)).getTabs();
            if (jBTabs == null) {
                RunTabSupplier.$$$reportNull$$$0(0);
            }
            return jBTabs;
        }

        @Nullable
        public ActionGroup getToolbarActions() {
            return this.myActionGroup;
        }

        @NotNull
        public List<AnAction> getContentActions() {
            List<ActionGroup> list = List.of(this.layoutActionGroup);
            if (list == null) {
                RunTabSupplier.$$$reportNull$$$0(1);
            }
            return list;
        }

        public void init(@Nullable ActionToolbar mainToolbar, @Nullable ActionToolbar contentToolbar) {
            JBTabs tabs = this.getTabs();
            if (tabs instanceof JBTabsEx) {
                ((JBTabsEx)tabs).setHideTopPanel(true);
            }
        }

        public void reset() {
            JBTabs tabs = this.getTabs();
            if (tabs instanceof JBTabsEx) {
                ((JBTabsEx)tabs).setHideTopPanel(false);
            }
        }

        public boolean isClosable(@NotNull TabInfo tab) {
            List<Content> gridContents;
            if (tab == null) {
                RunTabSupplier.$$$reportNull$$$0(2);
            }
            return !(gridContents = ((GridImpl)((Object)tab.getComponent())).getContents()).isEmpty() && gridContents.get(0).isCloseable();
        }

        public void close(@NotNull TabInfo tab) {
            if (tab == null) {
                RunTabSupplier.$$$reportNull$$$0(3);
            }
            GridImpl grid = (GridImpl)((Object)tab.getComponent());
            ViewContextEx context = grid.getViewContext();
            List<Content> content = grid.getContents();
            if (content.isEmpty()) {
                super.close(tab);
                return;
            }
            context.getContentManager().removeContent(content.get(0), context.isToDisposeRemovedContent());
        }

        public void addSubContent(@NotNull TabInfo tabInfo, @NotNull Content content) {
            if (tabInfo == null) {
                RunTabSupplier.$$$reportNull$$$0(4);
            }
            if (content == null) {
                RunTabSupplier.$$$reportNull$$$0(5);
            }
            this.myTabInfoContentMap.put(tabInfo, content);
        }

        @NotNull
        public Collection<Content> getSubContents() {
            Collection<Content> collection = this.myTabInfoContentMap.values();
            if (collection == null) {
                RunTabSupplier.$$$reportNull$$$0(6);
            }
            return collection;
        }

        public boolean isMoveToolbar() {
            return this.myMoveToolbar;
        }

        public void setMoveToolbar(boolean moveToolbar) {
            this.myMoveToolbar = moveToolbar;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/runners/RunTab$RunTabSupplier";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tab";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabInfo";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentActions";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/runners/RunTab$RunTabSupplier";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubContents";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isClosable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "close";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addSubContent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

