/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.target.BrowsableTargetEnvironmentType;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeConfigurationKt;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetUIUtil;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.util.text.StringKt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0014\u0010\u0014\u001a\u00020\u0012*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0004J(\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018*\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dH\u0004J\u0014\u0010\u001e\u001a\u00020\u0012*\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/execution/target/LanguageRuntimeConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "config", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "targetType", "Lcom/intellij/execution/target/TargetEnvironmentType;", "targetProvider", "Ljava/util/function/Supplier;", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/execution/target/LanguageRuntimeConfiguration;Lcom/intellij/execution/target/TargetEnvironmentType;Ljava/util/function/Supplier;Lcom/intellij/openapi/project/Project;)V", "targetVolumeContributions", "", "Lcom/intellij/execution/target/LanguageRuntimeType$VolumeDescriptor;", "Lcom/intellij/execution/target/TargetEnvironmentType$TargetSpecificVolumeContributionUI;", "apply", "", "reset", "addVolumeUI", "Lcom/intellij/ui/dsl/builder/Panel;", "volumeDescriptor", "browsableTextField", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/dsl/builder/Row;", "title", "", "property", "Lcom/intellij/ui/dsl/builder/MutableProperty;", "resetFrom", "volume", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nLanguageRuntimeConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageRuntimeConfigurable.kt\ncom/intellij/execution/target/LanguageRuntimeConfigurable\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,70:1\n221#2,2:71\n221#2,2:73\n*S KotlinDebug\n*F\n+ 1 LanguageRuntimeConfigurable.kt\ncom/intellij/execution/target/LanguageRuntimeConfigurable\n*L\n23#1:71,2\n30#1:73,2\n*E\n"})
public abstract class LanguageRuntimeConfigurable
extends BoundConfigurable {
    @NotNull
    private final LanguageRuntimeConfiguration config;
    @NotNull
    private final TargetEnvironmentType<?> targetType;
    @NotNull
    private final Supplier<? extends TargetEnvironmentConfiguration> targetProvider;
    @NotNull
    private final Project project;
    @NotNull
    private final Map<LanguageRuntimeType.VolumeDescriptor, TargetEnvironmentType.TargetSpecificVolumeContributionUI> targetVolumeContributions;

    public LanguageRuntimeConfigurable(@NotNull LanguageRuntimeConfiguration config, @NotNull TargetEnvironmentType<?> targetType, @NotNull Supplier<? extends TargetEnvironmentConfiguration> targetProvider, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter(targetProvider, (String)"targetProvider");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(config.getDisplayName(), LanguageRuntimeConfigurationKt.getRuntimeType((LanguageRuntimeConfiguration)config).getHelpTopic());
        this.config = config;
        this.targetType = targetType;
        this.targetProvider = targetProvider;
        this.project = project;
        this.targetVolumeContributions = new LinkedHashMap();
    }

    public void apply() {
        super.apply();
        Map<LanguageRuntimeType.VolumeDescriptor, TargetEnvironmentType.TargetSpecificVolumeContributionUI> $this$forEach$iv = this.targetVolumeContributions;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<LanguageRuntimeType.VolumeDescriptor, TargetEnvironmentType.TargetSpecificVolumeContributionUI>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<LanguageRuntimeType.VolumeDescriptor, TargetEnvironmentType.TargetSpecificVolumeContributionUI> element$iv;
            Map.Entry<LanguageRuntimeType.VolumeDescriptor, TargetEnvironmentType.TargetSpecificVolumeContributionUI> entry = element$iv = iterator.next();
            boolean bl = false;
            LanguageRuntimeType.VolumeDescriptor volume = entry.getKey();
            TargetEnvironmentType.TargetSpecificVolumeContributionUI contribution = entry.getValue();
            this.config.setTargetSpecificData(volume, contribution.getConfiguredValue());
        }
    }

    public void reset() {
        super.reset();
        Map<LanguageRuntimeType.VolumeDescriptor, TargetEnvironmentType.TargetSpecificVolumeContributionUI> $this$forEach$iv = this.targetVolumeContributions;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<LanguageRuntimeType.VolumeDescriptor, TargetEnvironmentType.TargetSpecificVolumeContributionUI>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<LanguageRuntimeType.VolumeDescriptor, TargetEnvironmentType.TargetSpecificVolumeContributionUI> element$iv;
            Map.Entry<LanguageRuntimeType.VolumeDescriptor, TargetEnvironmentType.TargetSpecificVolumeContributionUI> entry = element$iv = iterator.next();
            boolean bl = false;
            LanguageRuntimeType.VolumeDescriptor volume = entry.getKey();
            TargetEnvironmentType.TargetSpecificVolumeContributionUI contribution = entry.getValue();
            this.resetFrom(contribution, volume);
        }
    }

    protected final void addVolumeUI(@NotNull Panel $this$addVolumeUI, @NotNull LanguageRuntimeType.VolumeDescriptor volumeDescriptor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$addVolumeUI, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)volumeDescriptor, (String)"volumeDescriptor");
            $this$addVolumeUI.row(volumeDescriptor.getWizardLabel(), arg_0 -> LanguageRuntimeConfigurable.addVolumeUI$lambda$0(this, volumeDescriptor, arg_0));
            TargetEnvironmentType.TargetSpecificVolumeContributionUI targetSpecificVolumeContributionUI = this.targetType.createVolumeContributionUI();
            if (targetSpecificVolumeContributionUI == null) break block0;
            TargetEnvironmentType.TargetSpecificVolumeContributionUI it = targetSpecificVolumeContributionUI;
            boolean bl = false;
            this.targetVolumeContributions.put(volumeDescriptor, it);
            JComponent component = it.createComponent();
            this.resetFrom(it, volumeDescriptor);
            $this$addVolumeUI.row("", arg_0 -> LanguageRuntimeConfigurable.addVolumeUI$lambda$1$0(component, arg_0));
        }
    }

    @NotNull
    protected final Cell<?> browsableTextField(@NotNull Row $this$browsableTextField, @NlsContexts.DialogTitle @NotNull String title, @NotNull MutableProperty<String> property) {
        Intrinsics.checkNotNullParameter((Object)$this$browsableTextField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return this.targetType instanceof BrowsableTargetEnvironmentType ? TargetUIUtil.textFieldWithBrowseTargetButton$default($this$browsableTextField, (BrowsableTargetEnvironmentType)this.targetType, this.targetProvider, this.project, title, property, null, 32, null).align((Align)AlignX.FILL.INSTANCE) : TextFieldKt.bindText((Cell)$this$browsableTextField.textField(), property).align((Align)AlignX.FILL.INSTANCE);
    }

    private final void resetFrom(TargetEnvironmentType.TargetSpecificVolumeContributionUI $this$resetFrom, LanguageRuntimeType.VolumeDescriptor volume) {
        Object object = this.config.getTargetSpecificData(volume);
        if (object == null || (object = object.toStorableMap()) == null) {
            object = MapsKt.emptyMap();
        }
        $this$resetFrom.resetFrom((Map)object);
    }

    private static final String addVolumeUI$lambda$0$0(LanguageRuntimeConfigurable this$0, LanguageRuntimeType.VolumeDescriptor $volumeDescriptor) {
        String string = StringKt.nullize((String)this$0.config.getTargetPathValue($volumeDescriptor), (boolean)true);
        if (string == null) {
            string = $volumeDescriptor.getDefaultPath();
        }
        return string;
    }

    private static final Unit addVolumeUI$lambda$0$1(LanguageRuntimeConfigurable this$0, LanguageRuntimeType.VolumeDescriptor $volumeDescriptor, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.config.setTargetPath($volumeDescriptor, StringKt.nullize((String)it, (boolean)true));
        return Unit.INSTANCE;
    }

    private static final Unit addVolumeUI$lambda$1$0(JComponent $component, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell($component).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit addVolumeUI$lambda$0(LanguageRuntimeConfigurable this$0, LanguageRuntimeType.VolumeDescriptor $volumeDescriptor, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        MutableProperty propertyBinding = MutablePropertyKt.MutableProperty(() -> LanguageRuntimeConfigurable.addVolumeUI$lambda$0$0(this$0, $volumeDescriptor), arg_0 -> LanguageRuntimeConfigurable.addVolumeUI$lambda$0$1(this$0, $volumeDescriptor, arg_0));
        Cell.comment$default(this$0.browsableTextField($this$row, $volumeDescriptor.getBrowsingTitle(), (MutableProperty<String>)propertyBinding), (String)$volumeDescriptor.getDescription(), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }
}

