/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetCounterUsagesCollector;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.ide.wizard.AbstractWizardEx;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0011\u001a\u00020\u0005H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentWizard;", "Lcom/intellij/ide/wizard/AbstractWizardEx;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "subject", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "steps", "", "Lcom/intellij/ide/wizard/AbstractWizardStepEx;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/execution/target/TargetEnvironmentConfiguration;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSubject", "()Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "getHelpId", "getStyle", "Lcom/intellij/openapi/ui/DialogWrapper$DialogStyle;", "show", "", "doCancelAction", "doOKAction", "Companion", "ValidationCallbackConsumer", "intellij.platform.execution.impl"})
public final class TargetEnvironmentWizard
extends AbstractWizardEx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final TargetEnvironmentConfiguration subject;

    public TargetEnvironmentWizard(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @NotNull TargetEnvironmentConfiguration subject, @NotNull List<? extends AbstractWizardStepEx> steps) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter(steps, (String)"steps");
        super(title, project, steps);
        this.project = project;
        this.subject = subject;
        for (AbstractWizardStepEx abstractWizardStepEx : steps) {
            if (!(abstractWizardStepEx instanceof ValidationCallbackConsumer)) continue;
            ((ValidationCallbackConsumer)abstractWizardStepEx).accept(() -> TargetEnvironmentWizard._init_$lambda$0(this, abstractWizardStepEx));
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final TargetEnvironmentConfiguration getSubject() {
        return this.subject;
    }

    @NotNull
    protected String getHelpId() {
        return "reference.remote.target.wizard." + this.subject.getTypeId();
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        return DialogWrapper.DialogStyle.COMPACT;
    }

    public void show() {
        TargetCounterUsagesCollector.reportTargetCreationBegan(this.project, this.subject.getTypeId());
        super.show();
    }

    public void doCancelAction() {
        TargetCounterUsagesCollector.reportTargetCreationCancelled(this.project, this.subject.getTypeId(), this.getCurrentStep());
        super.doCancelAction();
    }

    protected void doOKAction() {
        TargetCounterUsagesCollector.reportTargetCreationSucceeded(this.project, this.subject.getTypeId());
        super.doOKAction();
    }

    private static final Unit _init_$lambda$0(TargetEnvironmentWizard this$0, AbstractWizardStepEx $step) {
        this$0.setErrorInfoAll(((ValidationCallbackConsumer)$step).doValidateAll());
        return Unit.INSTANCE;
    }

    @JvmStatic
    @Nullable
    public static final <C extends TargetEnvironmentConfiguration> TargetEnvironmentWizard createWizard(@NotNull Project project, @NotNull TargetEnvironmentType<C> targetType, @Nullable LanguageRuntimeType<?> runtimeType) {
        return Companion.createWizard(project, targetType, runtimeType);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u0004\u0018\u00010\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rH\u0007J\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentWizard$Companion;", "", "<init>", "()V", "createWizard", "Lcom/intellij/execution/target/TargetEnvironmentWizard;", "C", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "targetType", "Lcom/intellij/execution/target/TargetEnvironmentType;", "runtimeType", "Lcom/intellij/execution/target/LanguageRuntimeType;", "defaultDialogInsets", "Lcom/intellij/util/ui/JBInsets;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final <C extends TargetEnvironmentConfiguration> TargetEnvironmentWizard createWizard(@NotNull Project project, @NotNull TargetEnvironmentType<C> targetType, @Nullable LanguageRuntimeType<?> runtimeType) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
            if (!targetType.providesNewWizard(project, runtimeType)) {
                return null;
            }
            TargetEnvironmentConfiguration config = (TargetEnvironmentConfiguration)targetType.createDefaultConfig();
            List list = targetType.createStepsForNewWizard(project, config, runtimeType);
            if (list == null) {
                return null;
            }
            List steps = list;
            String string = ExecutionBundle.message((String)"run.on.targets.wizard.title.new.target", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new TargetEnvironmentWizard(project, string, config, steps);
        }

        @NotNull
        public final JBInsets defaultDialogInsets() {
            JBInsets jBInsets = UIUtil.getRegularPanelInsets();
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"getRegularPanelInsets(...)");
            return jBInsets;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentWizard$ValidationCallbackConsumer;", "Ljava/util/function/Consumer;", "Lkotlin/Function0;", "", "doValidateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.platform.execution.impl"})
    public static interface ValidationCallbackConsumer
    extends Consumer<Function0<? extends Unit>> {
        @NotNull
        public List<ValidationInfo> doValidateAll();
    }
}

