/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Comparing;
import javax.swing.JComponent;
import javax.swing.JTextField;

public final class TargetPathFragment<T extends TargetEnvironmentAwareRunProfile>
extends SettingsEditorFragment<T, LabeledComponent<JTextField>> {
    public static final String ID = "target.project.path";

    public TargetPathFragment() {
        super(ID, null, null, (JComponent)LabeledComponent.create((JComponent)new JTextField(), (String)ExecutionBundle.message((String)"label.project.path.on.target", (Object[])new Object[0]), (String)"West"), -1, (t, component) -> ((JTextField)component.getComponent()).setText(TargetPathFragment.getPath(t)), (t, component) -> TargetPathFragment.setPath(t, ((JTextField)component.getComponent()).getText()), t -> TargetEnvironmentConfigurations.getEffectiveTargetName((TargetEnvironmentAwareRunProfile)t) != null);
    }

    private static String getPath(TargetEnvironmentAwareRunProfile t) {
        ModuleBasedConfiguration configuration = (ModuleBasedConfiguration)t;
        if (configuration.getProjectPathOnTarget() != null) {
            return configuration.getProjectPathOnTarget();
        }
        String targetName = TargetEnvironmentConfigurations.getEffectiveTargetName((TargetEnvironmentAwareRunProfile)t, (Project)configuration.getProject());
        if (targetName == null) {
            return "";
        }
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)TargetEnvironmentsManager.getInstance((Project)configuration.getProject()).getTargets().findByName(targetName);
        return targetEnvironmentConfiguration == null ? null : targetEnvironmentConfiguration.getProjectRootOnTarget();
    }

    private static void setPath(TargetEnvironmentAwareRunProfile t, String path) {
        ModuleBasedConfiguration configuration = (ModuleBasedConfiguration)t;
        configuration.setProjectPathOnTarget(path);
        String targetName = TargetEnvironmentConfigurations.getEffectiveTargetName((TargetEnvironmentAwareRunProfile)t, (Project)configuration.getProject());
        if (targetName == null) {
            return;
        }
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)TargetEnvironmentsManager.getInstance((Project)configuration.getProject()).getTargets().findByName(targetName);
        if (targetEnvironmentConfiguration != null && Comparing.strEqual((String)targetEnvironmentConfiguration.getProjectRootOnTarget(), (String)path)) {
            configuration.setProjectPathOnTarget(null);
        }
    }
}

