/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.EnvFilesOptions;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.statistics.MacroUsageCollector;
import com.intellij.execution.util.EnvFilesUtilKt;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.ide.macro.MacroWithParams;
import com.intellij.ide.macro.PromptingMacro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.WorkingDirectoryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.workspace.SubprojectInfoProvider;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class ProgramParametersConfigurator {
    private static final ExtensionPointName<WorkingDirectoryProvider> WORKING_DIRECTORY_PROVIDER_EP_NAME = ExtensionPointName.create((String)"com.intellij.module.workingDirectoryProvider");
    @Deprecated(forRemoval=true)
    public static final String MODULE_WORKING_DIR = "%MODULE_WORKING_DIR%";
    private static final DataKey<Boolean> VALIDATION_MODE = DataKey.create((String)"validation.mode");
    private boolean myValidation;

    public void configureConfiguration(@NotNull SimpleProgramParameters parameters, @NotNull CommonProgramRunConfigurationParameters configuration) {
        if (parameters == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(1);
        }
        Project project = configuration.getProject();
        Module module = this.getModule(configuration);
        HashMap<String, String> envs = new HashMap<String, String>();
        if (configuration instanceof EnvFilesOptions) {
            envs.putAll(EnvFilesUtilKt.configureEnvsFromFiles((EnvFilesOptions)((Object)configuration), true));
        }
        envs.putAll(configuration.getEnvs());
        EnvironmentUtil.inlineParentOccurrences(envs);
        for (Map.Entry entry : envs.entrySet()) {
            entry.setValue(this.expandPath((String)entry.getValue(), module, project));
        }
        parameters.setEnv(envs);
        parameters.getProgramParametersList().patchMacroWithEnvs(envs);
        String parametersString = this.expandPathAndMacros(configuration.getProgramParameters(), module, project);
        parameters.getProgramParametersList().addParametersString(parametersString);
        parameters.setWorkingDirectory(this.getWorkingDir(configuration, project, module));
        parameters.setPassParentEnvs(configuration.isPassParentEnvs());
    }

    @Contract(value="!null, _, _ -> !null")
    @Nullable
    public String expandPathAndMacros(String s, @Nullable Module module, @NotNull Project project) {
        String path;
        if (project == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(2);
        }
        if ((path = s) != null) {
            path = this.expandPath(path, module, project);
        }
        if (path != null) {
            path = ProgramParametersConfigurator.expandMacros(path, ProgramParametersConfigurator.projectContext(project, module, this.myValidation), false);
        }
        return path;
    }

    public void setValidation(boolean validation) {
        this.myValidation = validation;
    }

    @ApiStatus.Internal
    @NotNull
    public static DataContext projectContext(@NotNull Project project, @Nullable Module module, @Nullable Boolean validationMode) {
        if (project == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(3);
        }
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.VIRTUAL_FILE, (Object)project.getBaseDir()).add(CommonDataKeys.PROJECT, (Object)project).add(PlatformCoreDataKeys.PROJECT_FILE_DIRECTORY, (Object)project.getBaseDir()).add(PlatformCoreDataKeys.MODULE, (Object)module).add(LangDataKeys.MODULE_CONTEXT, (Object)module).add(VALIDATION_MODE, (Object)validationMode).build();
        if (dataContext == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(4);
        }
        return dataContext;
    }

    public static String expandMacros(@Nullable String path) {
        return !StringUtil.isEmpty((String)path) ? ProgramParametersConfigurator.expandMacros(path, DataContext.EMPTY_CONTEXT, false) : path;
    }

    @NotNull
    public static List<String> expandMacrosAndParseParameters(@Nullable String parametersStringWithMacros) {
        if (StringUtil.isEmpty((String)parametersStringWithMacros)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ProgramParametersConfigurator.$$$reportNull$$$0(5);
            }
            return list;
        }
        String expandedParametersString = ProgramParametersConfigurator.expandMacros(parametersStringWithMacros, ProgramParametersConfigurator.createContext(DataContext.EMPTY_CONTEXT), true);
        List list = ParametersListUtil.parse((String)expandedParametersString);
        if (list == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static String expandMacros(@NotNull String path, @NotNull DataContext fallbackDataContext, boolean applyParameterEscaping) {
        if (path == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(7);
        }
        if (fallbackDataContext == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(8);
        }
        if (!Registry.is((String)"allow.macros.for.run.configurations")) {
            return path;
        }
        DataContext context = ProgramParametersConfigurator.createContext(fallbackDataContext);
        try {
            Collection macros = MacroManager.getInstance().getMacros();
            return MacroManager.expandMacros((String)path, (Collection)macros, (macro, occurence) -> {
                String value = StringUtil.notNullize((String)ProgramParametersConfigurator.previewOrExpandMacro(macro, context, occurence));
                return applyParameterEscaping ? ParametersListUtil.escape((CharSequence)value) : value;
            });
        }
        catch (Macro.ExecutionCancelledException ignore) {
            return path;
        }
    }

    private static DataContext createContext(@NotNull DataContext fallbackDataContext) {
        DataContext envContext;
        if (fallbackDataContext == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(9);
        }
        return (envContext = ExecutionManagerImpl.getEnvironmentDataContext()) == null ? fallbackDataContext : dataId -> {
            Object data = envContext.getData(dataId);
            return data != null ? data : fallbackDataContext.getData(dataId);
        };
    }

    @Nullable
    private static String previewOrExpandMacro(Macro macro, DataContext dataContext, String occurence) {
        try {
            Boolean mode;
            if ((macro instanceof PromptingMacro || macro instanceof MacroWithParams) && (mode = (Boolean)VALIDATION_MODE.getData(dataContext)) != null && mode.booleanValue()) {
                throw new IncorrectOperationException();
            }
            String value = macro instanceof PromptingMacro ? macro.expandOccurence(dataContext, occurence) : (String)ReadAction.nonBlocking(() -> macro.expandOccurence(dataContext, occurence)).executeSynchronously();
            MacroUsageCollector.logMacroExpanded(macro, value != null);
            return value;
        }
        catch (Macro.ExecutionCancelledException e) {
            return null;
        }
    }

    public @SystemIndependent @Nullable String getWorkingDir(@NotNull CommonProgramRunConfigurationParameters configuration, @NotNull Project project, @Nullable Module module) {
        if (configuration == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(11);
        }
        Object workingDirectory = PathUtil.toSystemIndependentName((String)configuration.getWorkingDirectory());
        String projectDirectory = this.getDefaultWorkingDir(project, module);
        if (StringUtil.isEmptyOrSpaces((String)workingDirectory) && (workingDirectory = projectDirectory) == null) {
            return null;
        }
        if (((String)(workingDirectory = this.expandPathAndMacros((String)workingDirectory, module, project).replace("$MODULE_DIR$", "$MODULE_WORKING_DIR$").replace(MODULE_WORKING_DIR, "$MODULE_WORKING_DIR$"))).contains("$MODULE_WORKING_DIR$")) {
            String moduleDirectory;
            if (module != null && (moduleDirectory = this.getDefaultWorkingDir(module)) != null) {
                return ((String)workingDirectory).replace("$MODULE_WORKING_DIR$", moduleDirectory);
            }
            if (projectDirectory != null) {
                return ((String)workingDirectory).replace("$MODULE_WORKING_DIR$", projectDirectory);
            }
        }
        if (projectDirectory != null && !OSAgnosticPathUtil.isAbsolute((String)workingDirectory)) {
            workingDirectory = projectDirectory + "/" + (String)workingDirectory;
        }
        return workingDirectory;
    }

    @Nullable
    private String getDefaultWorkingDir(@NotNull Project project, @Nullable Module module) {
        String path;
        if (project == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(12);
        }
        if (module != null && (path = SubprojectInfoProvider.Companion.getSubprojectPath(module)) != null) {
            return path;
        }
        return this.getDefaultWorkingDir(project);
    }

    @Nullable
    protected String getDefaultWorkingDir(@NotNull Project project) {
        String path;
        if (project == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(13);
        }
        return (path = project.getBasePath()) != null && LocalFileSystem.getInstance().findFileByPath(path) != null ? path : null;
    }

    @Nullable
    protected String getDefaultWorkingDir(@NotNull Module module) {
        if (module == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(14);
        }
        for (WorkingDirectoryProvider provider : (WorkingDirectoryProvider[])WORKING_DIRECTORY_PROVIDER_EP_NAME.getExtensions()) {
            @SystemIndependent String path = provider.getWorkingDirectoryPath(module);
            if (path == null) continue;
            return path;
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length > 0) {
            return roots[0].getPath();
        }
        return null;
    }

    public void checkWorkingDirectoryExist(@NotNull CommonProgramRunConfigurationParameters configuration, @NotNull Project project, @Nullable Module module) throws RuntimeConfigurationWarning {
        boolean exists;
        String workingDir;
        if (configuration == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(15);
        }
        if (project == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(16);
        }
        if ((workingDir = this.getWorkingDir(configuration, project, module)) == null) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"dialog.message.working.directory.null.for.project.module", (Object[])new Object[]{project.getName(), project.getBasePath(), module == null ? "null" : "'" + module.getName() + "' (" + module.getModuleFilePath() + ")"}));
        }
        try {
            exists = Files.exists(Paths.get(workingDir, new String[0]), new LinkOption[0]);
        }
        catch (InvalidPathException e) {
            exists = false;
        }
        if (!exists) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"dialog.message.working.directory.doesn.t.exist", (Object[])new Object[]{workingDir}));
        }
    }

    protected String expandPath(@Nullable String path, @Nullable Module module, @NotNull Project project) {
        if (project == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(17);
        }
        if (module != null && "$MODULE_DIR$".equals(path) && module.getModuleFilePath().contains("/.idea/") && ExternalProjectSystemRegistry.getInstance().getExternalSource(module) != null) {
            return this.getDefaultWorkingDir(module);
        }
        path = PathMacroManager.getInstance((ComponentManager)project).expandPath(path);
        if (module != null) {
            path = PathMacroManager.getInstance((Module)module).expandPath(path);
        }
        return path;
    }

    @Nullable
    protected Module getModule(CommonProgramRunConfigurationParameters cp) {
        return cp instanceof ModuleBasedConfiguration ? ((ModuleBasedConfiguration)cp).getConfigurationModule().getModule() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/util/ProgramParametersConfigurator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackDataContext";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/util/ProgramParametersConfigurator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "projectContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "expandMacrosAndParseParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "expandPathAndMacros";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "projectContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expandMacros";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDir";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultWorkingDir";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkWorkingDirectoryExist";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "expandPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    public static final class ParametersConfiguratorException
    extends RuntimeException {
        public ParametersConfiguratorException(@Nls String message, Throwable cause) {
            super(message, cause);
        }
    }
}

