/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.ConsoleFolding;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/wsl/WslDistributionConsoleFolding;", "Lcom/intellij/execution/ConsoleFolding;", "<init>", "()V", "shouldFoldLine", "", "project", "Lcom/intellij/openapi/project/Project;", "line", "", "shouldFoldLineNoProject", "shouldBeAttachedToThePreviousLine", "getPlaceholderText", "lines", "", "Companion", "intellij.platform.execution.impl"})
@ApiStatus.Internal
public final class WslDistributionConsoleFolding
extends ConsoleFolding {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String WSL_EXE_DISTRIBUTION = "wsl.exe --distribution";

    @Override
    public boolean shouldFoldLine(@NotNull Project project, @NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.shouldFoldLineNoProject(line);
    }

    @VisibleForTesting
    public final boolean shouldFoldLineNoProject(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        int wslExeIndex = StringsKt.indexOf$default((CharSequence)line, (String)WSL_EXE_DISTRIBUTION, (int)0, (boolean)false, (int)6, null);
        if (wslExeIndex <= 0) {
            return false;
        }
        int execIndex = StringsKt.indexOf$default((CharSequence)line, (String)"--exec", (int)(wslExeIndex + 1), (boolean)false, (int)4, null);
        if (execIndex < 0) {
            return false;
        }
        int ampIndex = StringsKt.indexOf$default((CharSequence)line, (String)"&& ", (int)0, (boolean)false, (int)6, null);
        boolean bl = 0 <= ampIndex ? ampIndex < execIndex : false;
        if (bl) {
            return false;
        }
        String string = line.substring(0, wslExeIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        char[] cArray = new char[]{'\\', '/'};
        String wslExePath = StringsKt.trim((String)string, (char[])cArray);
        String string2 = PathEnvironmentVariableUtil.getPathVariableValue();
        return string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)wslExePath, (boolean)false, (int)2, null) : false;
    }

    @Override
    public boolean shouldBeAttachedToThePreviousLine() {
        return false;
    }

    @Override
    @Nullable
    public String getPlaceholderText(@NotNull Project project, @NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        if (lines.size() != 1) {
            return null;
        }
        return this.getPlaceholderText(lines.get(0));
    }

    @VisibleForTesting
    @Nullable
    public final String getPlaceholderText(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        int indexOfDistribution = StringsKt.indexOf$default((CharSequence)line, (String)"--distribution", (int)0, (boolean)false, (int)6, null) + 14 + 1;
        if (indexOfDistribution <= 14 || indexOfDistribution >= line.length()) {
            return null;
        }
        String string = line.substring(indexOfDistribution);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String distributionLine = string;
        int distributionSpaceIndex = StringsKt.indexOf$default((CharSequence)distributionLine, (String)" ", (int)0, (boolean)false, (int)6, null);
        if (distributionSpaceIndex < 0) {
            return null;
        }
        String string2 = distributionLine.substring(0, distributionSpaceIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        distributionLine = string2;
        char[] cArray = new char[]{'\"'};
        distributionLine = StringsKt.trim((String)distributionLine, (char[])cArray);
        int indexOfAmp = StringsKt.lastIndexOf$default((CharSequence)line, (String)"&& ", (int)0, (boolean)false, (int)6, null);
        int indexOfExec = StringsKt.indexOf$default((CharSequence)line, (String)"--exec", (int)0, (boolean)false, (int)6, null);
        int userCLStart = indexOfAmp + 3;
        if (userCLStart <= 2 && (userCLStart = indexOfExec + 6 + 1) <= 6) {
            return null;
        }
        int indexOfExitCode = StringsKt.lastIndexOf$default((CharSequence)line, (String)"; exitcode=$?", (int)0, (boolean)false, (int)6, null);
        boolean endsWithQuote = StringsKt.endsWith$default((String)line, (String)"\"", (boolean)false, (int)2, null);
        int userCLEnd = indexOfExitCode == -1 ? (endsWithQuote ? (indexOfAmp < 0 && indexOfExec >= 0 && StringsKt.indexOf$default((CharSequence)line, (String)"-c \"", (int)0, (boolean)false, (int)6, null) >= 0 ? line.length() - 1 : line.length() - 2) : line.length() - 1) : indexOfExitCode - 1;
        String userCL = StringsKt.substring((String)line, (IntRange)new IntRange(userCLStart, userCLEnd));
        Object[] objectArray = new Object[]{distributionLine, userCL};
        return ExecutionBundle.message((String)"wsl.folding.placeholder", (Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/execution/wsl/WslDistributionConsoleFolding$Companion;", "", "<init>", "()V", "WSL_EXE_DISTRIBUTION", "", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

