/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Collection;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TerminalEscapeKeyListener {
    @NotNull
    private final JBTerminalPanel myTerminalPanel;

    public TerminalEscapeKeyListener(@NotNull JBTerminalPanel terminalPanel) {
        if (terminalPanel == null) {
            TerminalEscapeKeyListener.$$$reportNull$$$0(0);
        }
        this.myTerminalPanel = terminalPanel;
    }

    public void handleKeyEvent(@NotNull KeyEvent e) {
        if (e == null) {
            TerminalEscapeKeyListener.$$$reportNull$$$0(1);
        }
        Project project = this.myTerminalPanel.getContextProject();
        if (e.getID() == 401 && !e.isConsumed() && project != null && !project.isDisposed() && this.shouldSwitchFocusToEditor(e)) {
            ToolWindowManager.getInstance((Project)project).activateEditorComponent();
            e.consume();
        }
    }

    private boolean shouldSwitchFocusToEditor(@NotNull KeyEvent e) {
        if (e == null) {
            TerminalEscapeKeyListener.$$$reportNull$$$0(2);
        }
        ToolWindow toolWindow = this.myTerminalPanel.getContextToolWindow();
        AnAction terminalSwitchFocusToEditorAction = TerminalEscapeKeyListener.getTerminalSwitchFocusToEditorAction();
        if (toolWindow == null) {
            return false;
        }
        if (terminalSwitchFocusToEditorAction != null) {
            Collection strokes = KeymapUtil.getKeyStrokes((ShortcutSet)terminalSwitchFocusToEditorAction.getShortcutSet());
            if (JBTerminalWidget.isTerminalToolWindow(toolWindow)) {
                return TerminalEscapeKeyListener.isMatched(e, strokes);
            }
            return strokes.isEmpty() ? TerminalEscapeKeyListener.isEscape(e) : TerminalEscapeKeyListener.isMatched(e, strokes);
        }
        return TerminalEscapeKeyListener.isEscape(e);
    }

    private static boolean isMatched(@NotNull KeyEvent e, @NotNull Collection<KeyStroke> strokes) {
        if (e == null) {
            TerminalEscapeKeyListener.$$$reportNull$$$0(3);
        }
        if (strokes == null) {
            TerminalEscapeKeyListener.$$$reportNull$$$0(4);
        }
        return ContainerUtil.exists(strokes, stroke -> stroke.getKeyCode() == e.getKeyCode() && stroke.getModifiers() == UIUtil.getAllModifiers((InputEvent)e));
    }

    @Nullable
    private static AnAction getTerminalSwitchFocusToEditorAction() {
        return ActionManager.getInstance().getAction("Terminal.SwitchFocusToEditor");
    }

    private static boolean isEscape(@NotNull KeyEvent e) {
        if (e == null) {
            TerminalEscapeKeyListener.$$$reportNull$$$0(5);
        }
        return e.getKeyCode() == 27 && e.getModifiersEx() == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalPanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strokes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/terminal/TerminalEscapeKeyListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleKeyEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSwitchFocusToEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isMatched";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEscape";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

