/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.application.options.editor.EditorOptionsListener;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSchemeColorPalette;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.terminal.TerminalUiSettingsListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="TerminalUiSettingsManager", storages={@Storage(value="other.xml")})
@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u0007\u0018\u0000 52\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003567B\t\b\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0011H\u0001J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\b\u0010,\u001a\u00020\u0016H\u0002J\u0006\u0010-\u001a\u00020\u000eJ\u000e\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020 J\u000e\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u000eJ\b\u00100\u001a\u00020\u000eH\u0002J\u0006\u00101\u001a\u00020\u0016J\b\u00102\u001a\u00020\u0016H\u0016J\b\u00103\u001a\u00020\u0002H\u0016J\u0010\u00104\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010!\u001a\u00020 2\u0006\u0010\u0006\u001a\u00020 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u0010'\u001a\u00020&2\u0006\u0010\u0006\u001a\u00020&8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u00068"}, d2={"Lcom/intellij/terminal/TerminalUiSettingsManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/terminal/TerminalUiSettingsManager$State;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "value", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "editorColorsScheme", "getEditorColorsScheme", "()Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "cachedColorPalette", "Lcom/intellij/terminal/JBTerminalSchemeColorPalette;", "fontSize", "", "listeners", "", "Lcom/intellij/terminal/TerminalUiSettingsListener;", "state", "getTerminalColorPalette", "Lcom/intellij/terminal/TerminalColorPalette;", "addListener", "", "parentDisposable", "listener", "Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "cursorShape", "getCursorShape", "()Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "setCursorShape", "(Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;)V", "fireCursorUpdate", "", "maxVisibleCompletionItemsCount", "getMaxVisibleCompletionItemsCount", "()I", "setMaxVisibleCompletionItemsCount", "(I)V", "", "autoShowDocumentationPopup", "getAutoShowDocumentationPopup", "()Z", "setAutoShowDocumentationPopup", "(Z)V", "fireFontChanged", "getFontSize", "setFontSize", "newFontSize", "detectFontSize", "resetFontSize", "dispose", "getState", "loadState", "Companion", "CursorShape", "State", "intellij.platform.execution.impl"})
public final class TerminalUiSettingsManager
implements PersistentStateComponent<State>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private EditorColorsScheme editorColorsScheme;
    @Nullable
    private JBTerminalSchemeColorPalette cachedColorPalette;
    private float fontSize = -1.0f;
    @NotNull
    private final List<TerminalUiSettingsListener> listeners = new CopyOnWriteArrayList();
    @NotNull
    private State state = new State();

    public TerminalUiSettingsManager() {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        this.editorColorsScheme = editorColorsScheme;
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> TerminalUiSettingsManager._init_$lambda$0(this, arg_0));
        Topic topic2 = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, arg_0 -> TerminalUiSettingsManager._init_$lambda$1(this, arg_0));
        Topic topic3 = EditorOptionsListener.APPEARANCE_CONFIGURABLE_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"APPEARANCE_CONFIGURABLE_TOPIC");
        connection.subscribe(topic3, () -> TerminalUiSettingsManager._init_$lambda$2(this));
    }

    @NotNull
    public final EditorColorsScheme getEditorColorsScheme() {
        return this.editorColorsScheme;
    }

    @NotNull
    public final TerminalColorPalette getTerminalColorPalette() {
        JBTerminalSchemeColorPalette palette = this.cachedColorPalette;
        if (palette == null) {
            this.cachedColorPalette = palette = new JBTerminalSchemeColorPalette(this.editorColorsScheme);
        }
        return palette;
    }

    @JvmName(name="addListener")
    public final void addListener(@NotNull Disposable parentDisposable, @NotNull TerminalUiSettingsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> TerminalUiSettingsManager.addListener$lambda$0(this, listener2));
    }

    @NotNull
    public final CursorShape getCursorShape() {
        return this.state.getCursorShape();
    }

    public final void setCursorShape(@NotNull CursorShape value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.state.setCursorShape(value);
        this.fireCursorUpdate();
    }

    private final void fireCursorUpdate() {
        for (TerminalUiSettingsListener listener2 : this.listeners) {
            listener2.cursorChanged();
        }
    }

    public final int getMaxVisibleCompletionItemsCount() {
        return this.state.getMaxVisibleCompletionItemsCount();
    }

    public final void setMaxVisibleCompletionItemsCount(int value) {
        this.state.setMaxVisibleCompletionItemsCount(value);
    }

    public final boolean getAutoShowDocumentationPopup() {
        return this.state.getAutoShowDocumentationPopup();
    }

    public final void setAutoShowDocumentationPopup(boolean value) {
        this.state.setAutoShowDocumentationPopup(value);
    }

    private final void fireFontChanged() {
        for (TerminalUiSettingsListener listener2 : this.listeners) {
            listener2.fontChanged();
        }
    }

    public final float getFontSize() {
        if (this.fontSize <= 0.0f) {
            this.fontSize = this.detectFontSize();
        }
        return this.fontSize;
    }

    public final void setFontSize(int newFontSize) {
        this.setFontSize((float)newFontSize);
    }

    public final void setFontSize(float newFontSize) {
        float prevFontSize = this.fontSize;
        this.fontSize = newFontSize;
        if (!(prevFontSize == this.fontSize)) {
            this.fireFontChanged();
        }
    }

    private final float detectFontSize() {
        return UISettings.Companion.getInstance().getPresentationMode() ? UISettingsUtils.Companion.getInstance().getPresentationModeFontSize() : UISettingsUtils.Companion.getInstance().getScaledConsoleFontSize();
    }

    public final void resetFontSize() {
        this.setFontSize(this.detectFontSize());
    }

    public void dispose() {
    }

    @NotNull
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    private static final void _init_$lambda$0(TerminalUiSettingsManager this$0, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.resetFontSize();
    }

    private static final void _init_$lambda$1(TerminalUiSettingsManager this$0, EditorColorsScheme editorColorsScheme) {
        EditorColorsScheme editorColorsScheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme2, (String)"getGlobalScheme(...)");
        this$0.editorColorsScheme = editorColorsScheme2;
        this$0.cachedColorPalette = null;
        this$0.resetFontSize();
    }

    private static final void _init_$lambda$2(TerminalUiSettingsManager this$0) {
        this$0.fireCursorUpdate();
    }

    private static final void addListener$lambda$0(TerminalUiSettingsManager this$0, TerminalUiSettingsListener $listener) {
        this$0.listeners.remove($listener);
    }

    @JvmStatic
    @NotNull
    public static final TerminalUiSettingsManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/terminal/TerminalUiSettingsManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/terminal/TerminalUiSettingsManager;", "intellij.platform.execution.impl"})
    @SourceDebugExtension(value={"SMAP\nTerminalUiSettingsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalUiSettingsManager.kt\ncom/intellij/terminal/TerminalUiSettingsManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,159:1\n42#2,3:160\n*S KotlinDebug\n*F\n+ 1 TerminalUiSettingsManager.kt\ncom/intellij/terminal/TerminalUiSettingsManager$Companion\n*L\n138#1:160,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalUiSettingsManager getInstance() {
            boolean $i$f$service = false;
            Class<TerminalUiSettingsManager> serviceClass$iv = TerminalUiSettingsManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (TerminalUiSettingsManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0016\b\u0002\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "", "text", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getText", "()Ljava/lang/String;", "BLOCK", "UNDERLINE", "VERTICAL", "intellij.platform.execution.impl"})
    public static final class CursorShape
    extends Enum<CursorShape> {
        @NotNull
        private final String text;
        public static final /* enum */ CursorShape BLOCK;
        public static final /* enum */ CursorShape UNDERLINE;
        public static final /* enum */ CursorShape VERTICAL;
        private static final /* synthetic */ CursorShape[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CursorShape(String text) {
            this.text = text;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public static CursorShape[] values() {
            return (CursorShape[])$VALUES.clone();
        }

        public static CursorShape valueOf(String value) {
            return Enum.valueOf(CursorShape.class, value);
        }

        @NotNull
        public static EnumEntries<CursorShape> getEntries() {
            return $ENTRIES;
        }

        static {
            String string = IdeBundle.message((String)"terminal.cursor.shape.block.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            BLOCK = new CursorShape(string);
            String string2 = IdeBundle.message((String)"terminal.cursor.shape.underline.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            UNDERLINE = new CursorShape(string2);
            String string3 = IdeBundle.message((String)"terminal.cursor.shape.vertical.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            VERTICAL = new CursorShape(string3);
            $VALUES = cursorShapeArray = new CursorShape[]{CursorShape.BLOCK, CursorShape.UNDERLINE, CursorShape.VERTICAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/terminal/TerminalUiSettingsManager$State;", "", "<init>", "()V", "cursorShape", "Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "getCursorShape", "()Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "setCursorShape", "(Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;)V", "maxVisibleCompletionItemsCount", "", "getMaxVisibleCompletionItemsCount", "()I", "setMaxVisibleCompletionItemsCount", "(I)V", "autoShowDocumentationPopup", "", "getAutoShowDocumentationPopup", "()Z", "setAutoShowDocumentationPopup", "(Z)V", "intellij.platform.execution.impl"})
    public static final class State {
        @NotNull
        private CursorShape cursorShape = CursorShape.BLOCK;
        private int maxVisibleCompletionItemsCount = 6;
        private boolean autoShowDocumentationPopup = true;

        @NotNull
        public final CursorShape getCursorShape() {
            return this.cursorShape;
        }

        public final void setCursorShape(@NotNull CursorShape cursorShape) {
            Intrinsics.checkNotNullParameter((Object)((Object)cursorShape), (String)"<set-?>");
            this.cursorShape = cursorShape;
        }

        public final int getMaxVisibleCompletionItemsCount() {
            return this.maxVisibleCompletionItemsCount;
        }

        public final void setMaxVisibleCompletionItemsCount(int n) {
            this.maxVisibleCompletionItemsCount = n;
        }

        public final boolean getAutoShowDocumentationPopup() {
            return this.autoShowDocumentationPopup;
        }

        public final void setAutoShowDocumentationPopup(boolean bl) {
            this.autoShowDocumentationPopup = bl;
        }
    }
}

