/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.java;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.ContributedConfigurationBase;
import com.intellij.execution.target.ContributedConfigurationsList;
import com.intellij.execution.target.ContributedTypeBase;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.target.java.JavaLanguageRuntimeType;
import com.intellij.execution.target.java.JavaLanguageRuntimeTypeConstants;
import com.intellij.execution.target.java.JavaLanguageRuntimeUIFactory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.text.StringKt;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0002H\u0016J\u0014\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J2\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00022\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u00022\u0006\u0010$\u001a\u00020\"H\u0016J\u0018\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010&2\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J3\u0010'\u001a\b\u0012\u0004\u0012\u0002H)0(\"\u0004\b\u0000\u0010)*\u0004\u0018\u0001H)2\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H)0(0+H\u0002\u00a2\u0006\u0002\u0010,J\u0012\u0010-\u001a\u0004\u0018\u00010\n2\u0006\u0010.\u001a\u00020\nH\u0002J\u0014\u0010/\u001a\u0004\u0018\u0001002\b\u0010.\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0016J\u0010\u00104\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u00020\n8\u0016X\u0097D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00070\n\u00a2\u0006\u0002\b\u000e8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u001b\u0010\u0010\u001a\u00070\n\u00a2\u0006\u0002\b\u000e8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u00065"}, d2={"Lcom/intellij/execution/target/java/JavaLanguageRuntimeType;", "Lcom/intellij/execution/target/LanguageRuntimeType;", "Lcom/intellij/execution/target/java/JavaLanguageRuntimeConfiguration;", "<init>", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "configurableDescription", "Lorg/jetbrains/annotations/Nls;", "getConfigurableDescription", "launchDescription", "getLaunchDescription", "isApplicableTo", "", "runConfig", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "createDefaultConfig", "createSerializer", "Lcom/intellij/openapi/components/PersistentStateComponent;", "config", "createConfigurable", "Lcom/intellij/openapi/options/Configurable;", "project", "Lcom/intellij/openapi/project/Project;", "targetEnvironmentType", "Lcom/intellij/execution/target/TargetEnvironmentType;", "targetSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "findLanguageRuntime", "target", "createIntrospector", "Lcom/intellij/execution/target/LanguageRuntimeType$Introspector;", "completeOrElse", "Ljava/util/concurrent/CompletionStage;", "T", "orElse", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/util/concurrent/CompletionStage;", "tryParseJavaHome", "output", "tryParseJavaVersionFromOutput", "Lcom/intellij/util/lang/JavaVersion;", "volumeDescriptors", "", "Lcom/intellij/execution/target/LanguageRuntimeType$VolumeDescriptor;", "duplicateConfig", "intellij.platform.execution"})
@SourceDebugExtension(value={"SMAP\nJavaLanguageRuntimeType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaLanguageRuntimeType.kt\ncom/intellij/execution/target/java/JavaLanguageRuntimeType\n+ 2 ContributedConfigurationsList.kt\ncom/intellij/execution/target/ContributedConfigurationsList\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n44#2:145\n808#3,11:146\n1#4:157\n*S KotlinDebug\n*F\n+ 1 JavaLanguageRuntimeType.kt\ncom/intellij/execution/target/java/JavaLanguageRuntimeType\n*L\n55#1:145\n55#1:146,11\n*E\n"})
public final class JavaLanguageRuntimeType
extends LanguageRuntimeType<JavaLanguageRuntimeConfiguration> {
    @NotNull
    private final Icon icon;
    @NlsSafe
    @NotNull
    private final String displayName;
    @Nls
    @NotNull
    private final String configurableDescription;
    @Nls
    @NotNull
    private final String launchDescription;

    public JavaLanguageRuntimeType() {
        super(JavaLanguageRuntimeTypeConstants.getTYPE_ID());
        Icon icon = AllIcons.FileTypes.Java;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Java");
        this.icon = icon;
        this.displayName = "Java";
        String string = ExecutionBundle.message("JavaLanguageRuntimeType.configurable.description.configure.java", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.configurableDescription = string;
        String string2 = ExecutionBundle.message("JavaLanguageRuntimeType.launch.description.run.java.application", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.launchDescription = string2;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @NotNull
    public String getConfigurableDescription() {
        return this.configurableDescription;
    }

    @Override
    @NotNull
    public String getLaunchDescription() {
        return this.launchDescription;
    }

    @Override
    public boolean isApplicableTo(@NotNull RunnerAndConfigurationSettings runConfig) {
        Intrinsics.checkNotNullParameter((Object)runConfig, (String)"runConfig");
        return true;
    }

    @Override
    @NotNull
    public JavaLanguageRuntimeConfiguration createDefaultConfig() {
        return new JavaLanguageRuntimeConfiguration();
    }

    @Override
    @NotNull
    public PersistentStateComponent<?> createSerializer(@NotNull JavaLanguageRuntimeConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return config;
    }

    @Override
    @NotNull
    public Configurable createConfigurable(@NotNull Project project, @NotNull JavaLanguageRuntimeConfiguration config, @NotNull TargetEnvironmentType<?> targetEnvironmentType, @NotNull Supplier<TargetEnvironmentConfiguration> targetSupplier) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(targetEnvironmentType, (String)"targetEnvironmentType");
        Intrinsics.checkNotNullParameter(targetSupplier, (String)"targetSupplier");
        Configurable configurable = ((JavaLanguageRuntimeUIFactory)ApplicationManager.getApplication().getService(JavaLanguageRuntimeUIFactory.class)).create(config, targetEnvironmentType, targetSupplier, project);
        Intrinsics.checkNotNullExpressionValue((Object)configurable, (String)"create(...)");
        return configurable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public JavaLanguageRuntimeConfiguration findLanguageRuntime(@NotNull TargetEnvironmentConfiguration target) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ContributedConfigurationsList<LanguageRuntimeConfiguration, LanguageRuntimeType<?>> this_$iv = target.getRuntimes();
        boolean $i$f$findByType = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.resolvedConfigs();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof JavaLanguageRuntimeConfiguration)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        return (JavaLanguageRuntimeConfiguration)((ContributedConfigurationBase)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv)));
    }

    @Override
    @Nullable
    public LanguageRuntimeType.Introspector<JavaLanguageRuntimeConfiguration> createIntrospector(@NotNull JavaLanguageRuntimeConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!StringsKt.isBlank((CharSequence)config.getHomePath()) && !StringsKt.isBlank((CharSequence)config.getJavaVersionString())) {
            return null;
        }
        return new LanguageRuntimeType.Introspector<JavaLanguageRuntimeConfiguration>(config, this){
            final /* synthetic */ JavaLanguageRuntimeConfiguration $config;
            final /* synthetic */ JavaLanguageRuntimeType this$0;
            {
                this.$config = $config;
                this.this$0 = $receiver;
            }

            public CompletableFuture<JavaLanguageRuntimeConfiguration> introspect(LanguageRuntimeType.Introspectable subject) {
                CompletionStage<String> completionStage;
                CompletableFuture<String> javaHomePromise;
                Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
                CompletionStage<String> completionStage2 = javaHomePromise = StringsKt.isBlank((CharSequence)this.$config.getHomePath()) ? ((CompletableFuture)subject.promiseEnvironmentVariable("JAVA_HOME").thenCompose(arg_0 -> createIntrospector.1.introspect$lambda$1(arg_0 -> createIntrospector.1.introspect$lambda$0(this.this$0, subject, arg_0), arg_0))).thenApply(arg_0 -> createIntrospector.1.introspect$lambda$3(arg_0 -> createIntrospector.1.introspect$lambda$2(this, arg_0), arg_0)) : LanguageRuntimeType.Introspector.Companion.getDONE();
                if (StringsKt.isBlank((CharSequence)this.$config.getJavaVersionString())) {
                    Object[] objectArray = new String[]{"java", "-version"};
                    completionStage = subject.promiseExecuteScript(CollectionsKt.listOf((Object[])objectArray)).thenApply(arg_0 -> createIntrospector.1.introspect$lambda$5(arg_0 -> createIntrospector.1.introspect$lambda$4(this, arg_0), arg_0));
                } else {
                    completionStage = LanguageRuntimeType.Introspector.Companion.getDONE();
                }
                CompletableFuture<String> versionPromise = completionStage;
                CompletableFuture[] completableFutureArray = new CompletableFuture[]{javaHomePromise, versionPromise};
                CompletionStage completionStage3 = CompletableFuture.allOf(completableFutureArray).thenApply(arg_0 -> createIntrospector.1.introspect$lambda$7(arg_0 -> createIntrospector.1.introspect$lambda$6(this.$config, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage3, (String)"thenApply(...)");
                return completionStage3;
            }

            private final void acceptJavaHome(String javaHome) {
                block1: {
                    if (!StringsKt.isBlank((CharSequence)this.$config.getHomePath())) break block1;
                    String string = StringKt.nullize((String)javaHome, (boolean)true);
                    if (string != null) {
                        String string2 = string;
                        JavaLanguageRuntimeConfiguration javaLanguageRuntimeConfiguration = this.$config;
                        String it = string2;
                        boolean bl = false;
                        javaLanguageRuntimeConfiguration.setHomePath(it);
                    }
                }
            }

            private final void acceptJavaVersion(ProcessOutput $this$acceptJavaVersion) {
                block2: {
                    String string;
                    Object object;
                    Object object2;
                    block1: {
                        String string2;
                        object2 = new String[]{$this$acceptJavaVersion.getStderr(), $this$acceptJavaVersion.getStdout()};
                        object2 = CollectionsKt.listOf((Object[])object2);
                        object = this.this$0;
                        Iterator<T> iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            String it = (String)iterator.next();
                            boolean bl = false;
                            if ((it = JavaLanguageRuntimeType.access$tryParseJavaVersionFromOutput((JavaLanguageRuntimeType)object, it)) == null) continue;
                            string2 = it;
                            break block1;
                        }
                        string2 = string = null;
                    }
                    if (string == null) break block2;
                    object2 = string;
                    object = this.$config;
                    Object it = object2;
                    boolean bl = false;
                    ((JavaLanguageRuntimeConfiguration)object).setJavaVersionString(it.toString());
                }
            }

            private static final CompletionStage introspect$lambda$0(JavaLanguageRuntimeType this$0, LanguageRuntimeType.Introspectable $subject, String it) {
                return JavaLanguageRuntimeType.access$completeOrElse(this$0, it, () -> createIntrospector.1.introspect$lambda$0$0($subject, this$0));
            }

            private static final CompletionStage introspect$lambda$0$0(LanguageRuntimeType.Introspectable $subject, JavaLanguageRuntimeType this$0) {
                Object[] objectArray = new String[]{"java", "-XshowSettings:properties", "-version"};
                CompletionStage completionStage = $subject.promiseExecuteScript(CollectionsKt.listOf((Object[])objectArray)).handle((arg_0, arg_1) -> createIntrospector.1.introspect$lambda$0$0$1((arg_0, arg_1) -> createIntrospector.1.introspect$lambda$0$0$0(this$0, arg_0, arg_1), arg_0, arg_1));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"handle(...)");
                return completionStage;
            }

            private static final String introspect$lambda$0$0$0(JavaLanguageRuntimeType this$0, ProcessOutput output, Throwable throwable) {
                String string;
                Object object = output;
                if (object != null && (object = object.getStdout()) != null) {
                    Object s = object;
                    boolean bl = false;
                    string = JavaLanguageRuntimeType.access$tryParseJavaHome(this$0, (String)s);
                } else {
                    string = null;
                }
                return string;
            }

            private static final String introspect$lambda$0$0$1(Function2 $tmp0, Object p0, Throwable p1) {
                return (String)$tmp0.invoke(p0, (Object)p1);
            }

            private static final CompletionStage introspect$lambda$1(Function1 $tmp0, Object p0) {
                return (CompletionStage)$tmp0.invoke(p0);
            }

            private static final Unit introspect$lambda$2(createIntrospector.1 this$0, String it) {
                this$0.acceptJavaHome(it);
                return Unit.INSTANCE;
            }

            private static final Unit introspect$lambda$3(Function1 $tmp0, Object p0) {
                return (Unit)$tmp0.invoke(p0);
            }

            private static final Unit introspect$lambda$4(createIntrospector.1 this$0, ProcessOutput it) {
                Intrinsics.checkNotNull((Object)it);
                this$0.acceptJavaVersion(it);
                return Unit.INSTANCE;
            }

            private static final Unit introspect$lambda$5(Function1 $tmp0, Object p0) {
                return (Unit)$tmp0.invoke(p0);
            }

            private static final JavaLanguageRuntimeConfiguration introspect$lambda$6(JavaLanguageRuntimeConfiguration $config, Void it) {
                return $config;
            }

            private static final JavaLanguageRuntimeConfiguration introspect$lambda$7(Function1 $tmp0, Object p0) {
                return (JavaLanguageRuntimeConfiguration)$tmp0.invoke(p0);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private final <T> CompletionStage<T> completeOrElse(T $this$completeOrElse, Function0<? extends CompletionStage<T>> orElse) {
        CompletionStage completionStage;
        Object object = $this$completeOrElse;
        if (object != null) {
            T it = object;
            boolean bl = false;
            CompletableFuture<T> completableFuture = CompletableFuture.completedFuture($this$completeOrElse);
            object = completableFuture;
            if (completableFuture != null) {
                completionStage = (CompletionStage)object;
                return completionStage;
            }
        }
        completionStage = (CompletionStage)orElse.invoke();
        return completionStage;
    }

    private final String tryParseJavaHome(String output) {
        Properties properties = new Properties();
        properties.load(new StringReader(output));
        return properties.getProperty("java.home");
    }

    private final JavaVersion tryParseJavaVersionFromOutput(String output) {
        JavaVersion javaVersion;
        block5: {
            Object object = output;
            if (object != null && (object = StringsKt.lines((CharSequence)((CharSequence)object))) != null) {
                for (String it : (Iterable)object) {
                    JavaVersion javaVersion2;
                    Object object2;
                    boolean bl = false;
                    try {
                        boolean bl2 = false;
                        object2 = Result.constructor-impl((Object)JavaVersion.Companion.parse(it));
                    }
                    catch (Throwable throwable) {
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    if ((javaVersion2 = (JavaVersion)(Result.isFailure-impl((Object)object2) ? null : object2)) == null) continue;
                    javaVersion = javaVersion2;
                    break block5;
                }
                javaVersion = null;
            } else {
                javaVersion = null;
            }
        }
        return javaVersion;
    }

    @Override
    @NotNull
    public List<LanguageRuntimeType.VolumeDescriptor> volumeDescriptors() {
        Object[] objectArray = new LanguageRuntimeType.VolumeDescriptor[]{JavaLanguageRuntimeTypeConstants.getCLASS_PATH_VOLUME(), JavaLanguageRuntimeTypeConstants.getAGENTS_VOLUME()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public JavaLanguageRuntimeConfiguration duplicateConfig(@NotNull JavaLanguageRuntimeConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return (JavaLanguageRuntimeConfiguration)ContributedTypeBase.Companion.duplicatePersistentComponent((ContributedTypeBase)this, (ContributedConfigurationBase)config);
    }

    public static final /* synthetic */ CompletionStage access$completeOrElse(JavaLanguageRuntimeType $this, Object $receiver, Function0 orElse) {
        return $this.completeOrElse($receiver, orElse);
    }

    public static final /* synthetic */ String access$tryParseJavaHome(JavaLanguageRuntimeType $this, String output) {
        return $this.tryParseJavaHome(output);
    }

    public static final /* synthetic */ JavaVersion access$tryParseJavaVersionFromOutput(JavaLanguageRuntimeType $this, String output) {
        return $this.tryParseJavaVersionFromOutput(output);
    }
}

