/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.build.events.BuildEventsNls;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.RunContentDescriptorId;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptorParentCoroutineScopeKt;
import com.intellij.execution.ui.RunContentDescriptorReusePolicy;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ide.HelpIdProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.content.Content;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContentDescriptor
implements Disposable {
    public static final Key<RunContentDescriptor> DESCRIPTOR_KEY = Key.create((String)"Descriptor");
    public static final Key<String> CONTENT_TOOL_WINDOW_ID_KEY = Key.create((String)"ContentToolWindowId");
    private static final Logger LOG = Logger.getInstance(RunContentDescriptor.class);
    private ExecutionConsole myExecutionConsole;
    private ProcessHandler myProcessHandler;
    private JComponent myComponent;
    private final MutableStateFlow<@NlsContexts.TabTitle @Nullable String> myDisplayNameView;
    private final MutableStateFlow<@Nullable Icon> myIconView;
    private final String myHelpId;
    private RunnerLayoutUi myRunnerLayoutUi;
    private RunContentDescriptorReusePolicy myReusePolicy;
    private boolean myActivateToolWindowWhenAdded;
    private boolean myReuseToolWindowActivation;
    private boolean mySelectContentWhenAdded;
    private long myExecutionId;
    private Computable<JComponent> myFocusComputable;
    private boolean myAutoFocusContent;
    private final CoroutineScope myCoroutineScope;
    private Content myContent;
    private String myContentToolWindowId;
    private RunContentDescriptorId myId;
    private final AnAction @NotNull [] myRestartActions;
    @Nullable
    private final Runnable myActivationCallback;
    private String myRunConfigurationName;
    private String myRunConfigurationTypeId;

    public RunContentDescriptor(@Nullable ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull JComponent component, @NlsContexts.TabTitle String displayName, @Nullable Icon icon, @Nullable Runnable activationCallback) {
        if (component == null) {
            RunContentDescriptor.$$$reportNull$$$0(0);
        }
        this(executionConsole, processHandler, component, displayName, icon, activationCallback, null);
    }

    public RunContentDescriptor(@Nullable ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull JComponent component, @NlsContexts.TabTitle String displayName, @Nullable Icon icon, @Nullable Runnable activationCallback, AnAction @Nullable [] restartActions) {
        if (component == null) {
            RunContentDescriptor.$$$reportNull$$$0(1);
        }
        this.myDisplayNameView = StateFlowKt.MutableStateFlow(null);
        this.myIconView = StateFlowKt.MutableStateFlow(null);
        this.myRunnerLayoutUi = null;
        this.myReusePolicy = RunContentDescriptorReusePolicy.DEFAULT;
        this.myActivateToolWindowWhenAdded = true;
        this.myReuseToolWindowActivation = false;
        this.mySelectContentWhenAdded = true;
        this.myExecutionId = 0L;
        this.myFocusComputable = null;
        this.myAutoFocusContent = false;
        this.myCoroutineScope = RunContentDescriptorParentCoroutineScopeKt.createRunContentDescriptorCoroutineScope();
        this.myId = null;
        this.myExecutionConsole = executionConsole;
        this.myProcessHandler = processHandler;
        this.myComponent = component;
        this.myDisplayNameView.setValue((Object)displayName);
        this.myIconView.setValue((Object)icon);
        this.myHelpId = this.myExecutionConsole instanceof HelpIdProvider ? ((HelpIdProvider)this.myExecutionConsole).getHelpId() : null;
        this.myActivationCallback = activationCallback;
        if (this.myExecutionConsole != null) {
            Disposer.register((Disposable)this, (Disposable)this.myExecutionConsole);
        }
        AnAction[] anActionArray = this.myRestartActions = restartActions == null ? AnAction.EMPTY_ARRAY : restartActions;
        if (processHandler != null) {
            this.setContentToolWindowId((String)processHandler.getUserData(CONTENT_TOOL_WINDOW_ID_KEY));
        }
    }

    public RunContentDescriptor(@Nullable ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull JComponent component, @NlsContexts.TabTitle String displayName, @Nullable Icon icon) {
        if (component == null) {
            RunContentDescriptor.$$$reportNull$$$0(2);
        }
        this(executionConsole, processHandler, component, displayName, icon, null, null);
    }

    public RunContentDescriptor(@Nullable ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull JComponent component, @NlsContexts.TabTitle String displayName) {
        if (component == null) {
            RunContentDescriptor.$$$reportNull$$$0(3);
        }
        this(executionConsole, processHandler, component, displayName, null, null, null);
    }

    public RunContentDescriptor(@NotNull RunProfile profile, @NotNull ExecutionResult executionResult, @NotNull RunnerLayoutUi ui) {
        AnAction[] anActionArray;
        if (profile == null) {
            RunContentDescriptor.$$$reportNull$$$0(4);
        }
        if (executionResult == null) {
            RunContentDescriptor.$$$reportNull$$$0(5);
        }
        if (ui == null) {
            RunContentDescriptor.$$$reportNull$$$0(6);
        }
        ExecutionConsole executionConsole = executionResult.getExecutionConsole();
        ProcessHandler processHandler = executionResult.getProcessHandler();
        String string = profile.getName();
        Icon icon = profile.getIcon();
        if (executionResult instanceof DefaultExecutionResult) {
            DefaultExecutionResult res = (DefaultExecutionResult)executionResult;
            anActionArray = res.getRestartActions();
        } else {
            anActionArray = null;
        }
        this(executionConsole, processHandler, string, icon, ui, anActionArray);
    }

    @ApiStatus.Internal
    public RunContentDescriptor(@Nullable ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NlsContexts.TabTitle String displayName, @Nullable Icon icon, @NotNull RunnerLayoutUi ui, AnAction @Nullable [] restartActions) {
        if (ui == null) {
            RunContentDescriptor.$$$reportNull$$$0(7);
        }
        this(executionConsole, processHandler, ui.getComponent(), displayName, icon, null, restartActions);
        this.myRunnerLayoutUi = ui;
    }

    @Nullable
    public Runnable getActivationCallback() {
        return this.myActivationCallback;
    }

    public AnAction @NotNull [] getRestartActions() {
        AnAction[] anActionArray = this.myRestartActions.length == 0 ? AnAction.EMPTY_ARRAY : (AnAction[])this.myRestartActions.clone();
        if (anActionArray == null) {
            RunContentDescriptor.$$$reportNull$$$0(8);
        }
        return anActionArray;
    }

    public ExecutionConsole getExecutionConsole() {
        return this.myExecutionConsole;
    }

    public void dispose() {
        CoroutineScopeKt.cancel((CoroutineScope)this.myCoroutineScope, null);
        this.myExecutionConsole = null;
        this.myComponent = null;
        this.myProcessHandler = null;
        this.myContent = null;
    }

    @Nullable
    public Icon getIcon() {
        return (Icon)this.myIconView.getValue();
    }

    @ApiStatus.Experimental
    public StateFlow<Icon> getIconProperty() {
        return this.myIconView;
    }

    @ApiStatus.Experimental
    protected void setIcon(@Nullable Icon icon) {
        this.myIconView.setValue((Object)icon);
    }

    @Nullable
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public void setProcessHandler(ProcessHandler processHandler) {
        this.myProcessHandler = processHandler;
    }

    public boolean isContentReuseProhibited() {
        return false;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    @BuildEventsNls.Title
    public String getDisplayName() {
        return (String)this.myDisplayNameView.getValue();
    }

    @ApiStatus.Experimental
    public StateFlow<@Nullable @BuildEventsNls.Title String> getDisplayNameProperty() {
        return this.myDisplayNameView;
    }

    @ApiStatus.Experimental
    protected void setDisplayName(@NlsContexts.TabTitle @Nullable String displayName) {
        this.myDisplayNameView.setValue((Object)displayName);
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    @Nullable
    public Content getAttachedContent() {
        return this.myContent;
    }

    public void setAttachedContent(@NotNull Content content) {
        if (content == null) {
            RunContentDescriptor.$$$reportNull$$$0(9);
        }
        this.myContent = content;
    }

    @ApiStatus.Internal
    public RunContentDescriptorId getId() {
        return this.myId;
    }

    @ApiStatus.Internal
    public void setId(RunContentDescriptorId id) {
        LOG.debug("Id " + String.valueOf(id) + " is set for " + String.valueOf(this) + "(old id=" + String.valueOf(this.myId) + ")");
        this.myId = id;
    }

    @ApiStatus.Internal
    public String getRunConfigurationName() {
        return this.myRunConfigurationName;
    }

    @ApiStatus.Internal
    public void setRunConfigurationName(String runConfigurationName) {
        this.myRunConfigurationName = runConfigurationName;
    }

    @ApiStatus.Internal
    public String getRunConfigurationTypeId() {
        return this.myRunConfigurationTypeId;
    }

    @ApiStatus.Internal
    public void setRunConfigurationTypeId(String runConfigurationTypeId) {
        this.myRunConfigurationTypeId = runConfigurationTypeId;
    }

    @Nullable
    public String getContentToolWindowId() {
        return this.myContentToolWindowId;
    }

    public void setContentToolWindowId(@Nullable String contentToolWindowId) {
        this.myContentToolWindowId = contentToolWindowId;
    }

    public boolean isActivateToolWindowWhenAdded() {
        return this.myActivateToolWindowWhenAdded;
    }

    public void setActivateToolWindowWhenAdded(boolean activateToolWindowWhenAdded) {
        this.myActivateToolWindowWhenAdded = activateToolWindowWhenAdded;
    }

    public boolean isSelectContentWhenAdded() {
        return this.mySelectContentWhenAdded;
    }

    public void setSelectContentWhenAdded(boolean selectContentWhenAdded) {
        this.mySelectContentWhenAdded = selectContentWhenAdded;
    }

    public boolean isReuseToolWindowActivation() {
        return this.myReuseToolWindowActivation;
    }

    public void setReuseToolWindowActivation(boolean reuseToolWindowActivation) {
        this.myReuseToolWindowActivation = reuseToolWindowActivation;
    }

    public long getExecutionId() {
        return this.myExecutionId;
    }

    public void setExecutionId(long executionId) {
        this.myExecutionId = executionId;
    }

    @ApiStatus.Internal
    public CoroutineScope getCoroutineScope() {
        return this.myCoroutineScope;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "#" + this.hashCode() + "(" + this.getDisplayName() + ", " + String.valueOf(this.getProcessHandler()) + ")";
    }

    public Computable<JComponent> getPreferredFocusComputable() {
        return this.myFocusComputable;
    }

    public void setFocusComputable(Computable<JComponent> focusComputable) {
        this.myFocusComputable = focusComputable;
    }

    public boolean isAutoFocusContent() {
        return this.myAutoFocusContent;
    }

    public void setAutoFocusContent(boolean autoFocusContent) {
        this.myAutoFocusContent = autoFocusContent;
    }

    @Nullable
    public RunnerLayoutUi getRunnerLayoutUi() {
        return this.myRunnerLayoutUi;
    }

    public void setRunnerLayoutUi(@Nullable RunnerLayoutUi runnerLayoutUi) {
        this.myRunnerLayoutUi = runnerLayoutUi;
    }

    @ApiStatus.Experimental
    public boolean isHiddenContent() {
        return false;
    }

    @NotNull
    public RunContentDescriptorReusePolicy getReusePolicy() {
        RunContentDescriptorReusePolicy runContentDescriptorReusePolicy = this.myReusePolicy;
        if (runContentDescriptorReusePolicy == null) {
            RunContentDescriptor.$$$reportNull$$$0(10);
        }
        return runContentDescriptorReusePolicy;
    }

    public void setReusePolicy(@NotNull RunContentDescriptorReusePolicy reusePolicy) {
        if (reusePolicy == null) {
            RunContentDescriptor.$$$reportNull$$$0(11);
        }
        this.myReusePolicy = reusePolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/RunContentDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reusePolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/RunContentDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getReusePolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setAttachedContent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setReusePolicy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10 -> new IllegalStateException(string);
        };
    }
}

