/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ui.NamedColorUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Filter
extends PossiblyDumbAware {
    public static final Filter[] EMPTY_ARRAY = new Filter[0];

    @Nullable
    public Result applyFilter(@NotNull String var1, int var2);

    public static class ResultItem {
        private static final Lazy<Map<TextAttributesKey, TextAttributes>> GRAYED_BY_NORMAL_CACHE = LazyKt.lazy(() -> {
            ConcurrentHashMap map = new ConcurrentHashMap(2);
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                application.getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, __ -> map.clear());
            }
            return map;
        });
        private final int highlightStartOffset;
        private final int highlightEndOffset;
        @Nullable
        private final TextAttributes highlightAttributes;
        @Nullable
        private final HyperlinkInfo hyperlinkInfo;
        private final TextAttributes myFollowedHyperlinkAttributes;
        private final TextAttributes myHoveredHyperlinkAttributes;

        public ResultItem(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo) {
            this(highlightStartOffset, highlightEndOffset, hyperlinkInfo, null, null);
        }

        public ResultItem(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes highlightAttributes) {
            this(highlightStartOffset, highlightEndOffset, hyperlinkInfo, highlightAttributes, null);
        }

        public ResultItem(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, boolean grayedHyperlink) {
            this(highlightStartOffset, highlightEndOffset, hyperlinkInfo, grayedHyperlink ? ResultItem.getGrayedHyperlinkAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES) : null, grayedHyperlink ? ResultItem.getGrayedHyperlinkAttributes(CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES) : null);
        }

        public ResultItem(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes highlightAttributes, @Nullable TextAttributes followedHyperlinkAttributes) {
            this(highlightStartOffset, highlightEndOffset, hyperlinkInfo, highlightAttributes, followedHyperlinkAttributes, null);
        }

        @ApiStatus.Internal
        public ResultItem(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes highlightAttributes, @Nullable TextAttributes followedHyperlinkAttributes, @Nullable TextAttributes hoveredHyperlinkAttributes) {
            this.highlightStartOffset = highlightStartOffset;
            this.highlightEndOffset = highlightEndOffset;
            TextRange.assertProperRange((int)highlightStartOffset, (int)highlightEndOffset, (Object)"");
            this.hyperlinkInfo = hyperlinkInfo;
            this.highlightAttributes = highlightAttributes;
            this.myFollowedHyperlinkAttributes = followedHyperlinkAttributes;
            this.myHoveredHyperlinkAttributes = hoveredHyperlinkAttributes;
        }

        public int getHighlightStartOffset() {
            return this.highlightStartOffset;
        }

        public int getHighlightEndOffset() {
            return this.highlightEndOffset;
        }

        @Nullable
        public TextAttributes getHighlightAttributes() {
            return this.highlightAttributes;
        }

        @Nullable
        public TextAttributes getFollowedHyperlinkAttributes() {
            return this.myFollowedHyperlinkAttributes;
        }

        @ApiStatus.Internal
        @Nullable
        public TextAttributes getHoveredHyperlinkAttributes() {
            return this.myHoveredHyperlinkAttributes;
        }

        @Nullable
        public HyperlinkInfo getHyperlinkInfo() {
            return this.hyperlinkInfo;
        }

        public int getHighlighterLayer() {
            return this.getHyperlinkInfo() != null ? 5900 : 5800;
        }

        @Nullable
        private static TextAttributes getGrayedHyperlinkAttributes(@NotNull TextAttributesKey normalHyperlinkAttrsKey) {
            EditorColorsScheme globalScheme;
            TextAttributes normalHyperlinkAttrs;
            TextAttributes grayedHyperlinkAttrs;
            if (normalHyperlinkAttrsKey == null) {
                ResultItem.$$$reportNull$$$0(0);
            }
            if ((grayedHyperlinkAttrs = (TextAttributes)((Map)GRAYED_BY_NORMAL_CACHE.getValue()).get(normalHyperlinkAttrsKey)) == null && (normalHyperlinkAttrs = (globalScheme = EditorColorsManager.getInstance().getGlobalScheme()).getAttributes(normalHyperlinkAttrsKey)) != null) {
                grayedHyperlinkAttrs = normalHyperlinkAttrs.clone();
                grayedHyperlinkAttrs.setForegroundColor(NamedColorUtil.getInactiveTextColor());
                grayedHyperlinkAttrs.setEffectColor(NamedColorUtil.getInactiveTextColor());
                ((Map)GRAYED_BY_NORMAL_CACHE.getValue()).put(normalHyperlinkAttrsKey, grayedHyperlinkAttrs);
            }
            return grayedHyperlinkAttrs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "normalHyperlinkAttrsKey", "com/intellij/execution/filters/Filter$ResultItem", "getGrayedHyperlinkAttributes"));
        }
    }

    public static enum NextAction {
        EXIT,
        CONTINUE_FILTERING;

    }

    public static class Result
    extends ResultItem {
        private NextAction myNextAction;
        private final List<? extends ResultItem> myResultItems;

        public Result(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo) {
            this(highlightStartOffset, highlightEndOffset, hyperlinkInfo, null);
        }

        public Result(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes highlightAttributes) {
            super(highlightStartOffset, highlightEndOffset, hyperlinkInfo, highlightAttributes, null);
            this.myNextAction = NextAction.EXIT;
            this.myResultItems = null;
        }

        public Result(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes highlightAttributes, @Nullable TextAttributes followedHyperlinkAttributes) {
            this(highlightStartOffset, highlightEndOffset, hyperlinkInfo, highlightAttributes, followedHyperlinkAttributes, null);
        }

        @ApiStatus.Internal
        public Result(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes highlightAttributes, @Nullable TextAttributes followedHyperlinkAttributes, @Nullable TextAttributes hoveredHyperlinkAttributes) {
            super(highlightStartOffset, highlightEndOffset, hyperlinkInfo, highlightAttributes, followedHyperlinkAttributes, hoveredHyperlinkAttributes);
            this.myNextAction = NextAction.EXIT;
            this.myResultItems = null;
        }

        public Result(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, boolean grayedHyperlink) {
            super(highlightStartOffset, highlightEndOffset, hyperlinkInfo, grayedHyperlink);
            this.myNextAction = NextAction.EXIT;
            this.myResultItems = null;
        }

        public Result(@NotNull List<? extends ResultItem> resultItems) {
            if (resultItems == null) {
                Result.$$$reportNull$$$0(0);
            }
            super(0, 0, null, null, null);
            this.myNextAction = NextAction.EXIT;
            this.myResultItems = resultItems;
        }

        @NotNull
        public List<ResultItem> getResultItems() {
            List<? extends ResultItem> resultItems = this.myResultItems;
            if (resultItems == null) {
                resultItems = Collections.singletonList(this);
            }
            List<ResultItem> list = Collections.unmodifiableList(resultItems);
            if (list == null) {
                Result.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @Deprecated
        public int getHighlightStartOffset() {
            return super.getHighlightStartOffset();
        }

        @Override
        @Deprecated
        public int getHighlightEndOffset() {
            return super.getHighlightEndOffset();
        }

        @Override
        @Deprecated
        @Nullable
        public TextAttributes getHighlightAttributes() {
            return super.getHighlightAttributes();
        }

        @Override
        @Deprecated
        @Nullable
        public HyperlinkInfo getHyperlinkInfo() {
            return super.getHyperlinkInfo();
        }

        @Nullable
        public HyperlinkInfo getFirstHyperlinkInfo() {
            HyperlinkInfo info = super.getHyperlinkInfo();
            if (info == null && this.myResultItems != null) {
                for (int i = 0; i < this.myResultItems.size(); ++i) {
                    ResultItem resultItem = this.myResultItems.get(i);
                    if (resultItem.getHyperlinkInfo() == null) continue;
                    return resultItem.getHyperlinkInfo();
                }
            }
            return info;
        }

        public NextAction getNextAction() {
            return this.myNextAction;
        }

        public void setNextAction(NextAction nextAction) {
            this.myNextAction = nextAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultItems";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/filters/Filter$Result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/filters/Filter$Result";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

