/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.Platform;
import com.intellij.execution.target.ExternallySynchronized;
import com.intellij.execution.target.PathMapping;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.openapi.util.io.FileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0006\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0002\u001a\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002\u001a\u0012\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001*\u00020\u0003H\u0002\u001a\f\u0010\t\u001a\u00020\b*\u00020\nH\u0002\u001a\f\u0010\t\u001a\u00020\b*\u00020\u000bH\u0002\u001a\\\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013H\u0007\u001a \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u001a\u001c\u0010\u001b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013H\u0002\u001a'\u0010\u001e\u001a\u00020\u00022\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020 \"\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0013\u00a2\u0006\u0002\u0010!\u001a\u0014\u0010\"\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u001a\u0014\u0010#\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u001a\u0014\u0010$\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u001a\u0014\u0010%\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u00a8\u0006&"}, d2={"getLocalPaths", "", "", "Lcom/intellij/execution/target/TargetEnvironment;", "targetPath", "getTargetPaths", "localPath", "collectPathMappings", "Lcom/intellij/execution/target/PathMapping;", "toPathMapping", "Lcom/intellij/execution/target/TargetEnvironment$SynchronizedVolume;", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "findPathVariants", "mappings", "", "sourcePath", "sourcePathFun", "Lkotlin/Function1;", "sourceFileSeparator", "", "destPathFun", "destFileSeparator", "isAncestor", "", "ancestor", "file", "fileSeparator", "replaceFileSeparator", "currentFileSeparator", "newFileSeparator", "joinTargetPaths", "paths", "", "([Ljava/lang/String;C)Ljava/lang/String;", "normalizeFileSeparatorCharacter", "removeRepetitiveFileSeparators", "normalizeRelativePath", "ensureEndsWithFileSeparator", "intellij.platform.execution"})
@JvmName(name="TargetEnvironmentPaths")
@SourceDebugExtension(value={"SMAP\nTargetEnvironmentPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetEnvironmentPaths.kt\ncom/intellij/execution/target/TargetEnvironmentPaths\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1586#2:120\n1661#2,3:121\n1586#2:124\n1661#2,3:125\n1642#2,10:128\n1915#2:138\n1916#2:140\n1652#2:141\n1#3:139\n*S KotlinDebug\n*F\n+ 1 TargetEnvironmentPaths.kt\ncom/intellij/execution/target/TargetEnvironmentPaths\n*L\n36#1:120\n36#1:121,3\n41#1:124\n41#1:125,3\n57#1:128,10\n57#1:138\n57#1:140\n57#1:141\n57#1:139\n*E\n"})
public final class TargetEnvironmentPaths {
    @NotNull
    public static final List<String> getLocalPaths(@NotNull TargetEnvironment $this$getLocalPaths, @NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getLocalPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        return TargetEnvironmentPaths.findPathVariants((Iterable<PathMapping>)TargetEnvironmentPaths.collectPathMappings($this$getLocalPaths), targetPath, (Function1<? super PathMapping, String>)((Function1)TargetEnvironmentPaths::getLocalPaths$lambda$0), $this$getLocalPaths.getTargetPlatform().getPlatform().fileSeparator, (Function1<? super PathMapping, String>)((Function1)TargetEnvironmentPaths::getLocalPaths$lambda$1), Platform.current().fileSeparator);
    }

    @NotNull
    public static final List<String> getTargetPaths(@NotNull TargetEnvironment $this$getTargetPaths, @NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        return TargetEnvironmentPaths.findPathVariants((Iterable<PathMapping>)TargetEnvironmentPaths.collectPathMappings($this$getTargetPaths), localPath, (Function1<? super PathMapping, String>)((Function1)TargetEnvironmentPaths::getTargetPaths$lambda$0), Platform.current().fileSeparator, (Function1<? super PathMapping, String>)((Function1)TargetEnvironmentPaths::getTargetPaths$lambda$1), $this$getTargetPaths.getTargetPlatform().getPlatform().fileSeparator);
    }

    private static final List<PathMapping> collectPathMappings(TargetEnvironment $this$collectPathMappings) {
        List list;
        TargetEnvironment.UploadableVolume p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        if ($this$collectPathMappings instanceof ExternallySynchronized) {
            $this$map$iv = ((ExternallySynchronized)((Object)$this$collectPathMappings)).getSynchronizedVolumes();
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TargetEnvironment.SynchronizedVolume synchronizedVolume = (TargetEnvironment.SynchronizedVolume)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TargetEnvironmentPaths.toPathMapping((TargetEnvironment.SynchronizedVolume)((Object)p0)));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List externallySynchronizedPathMappings = list;
        $this$map$iv = $this$collectPathMappings.getUploadVolumes().values();
        collection = externallySynchronizedPathMappings;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (TargetEnvironment.UploadableVolume)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(TargetEnvironmentPaths.toPathMapping(p0));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private static final PathMapping toPathMapping(TargetEnvironment.SynchronizedVolume $this$toPathMapping) {
        return new PathMapping(((Object)$this$toPathMapping.getLocalRootPath()).toString(), $this$toPathMapping.getTargetPath());
    }

    private static final PathMapping toPathMapping(TargetEnvironment.UploadableVolume $this$toPathMapping) {
        return new PathMapping(((Object)$this$toPathMapping.getLocalRoot()).toString(), $this$toPathMapping.getTargetRoot());
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final List<String> findPathVariants(@NotNull Iterable<PathMapping> mappings, @NotNull String sourcePath, @NotNull Function1<? super PathMapping, String> sourcePathFun, char sourceFileSeparator, @NotNull Function1<? super PathMapping, String> destPathFun, char destFileSeparator) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter(sourcePathFun, (String)"sourcePathFun");
        Intrinsics.checkNotNullParameter(destPathFun, (String)"destPathFun");
        Iterable<PathMapping> $this$mapNotNull$iv = mappings;
        boolean $i$f$mapNotNull = false;
        Iterable<PathMapping> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PathMapping mapping = (PathMapping)element$iv$iv;
            boolean bl2 = false;
            String sourceBase = (String)sourcePathFun.invoke((Object)mapping);
            if (TargetEnvironmentPaths.isAncestor(sourceBase, sourcePath, sourceFileSeparator)) {
                String destBase = (String)destPathFun.invoke((Object)mapping);
                if (FileUtil.getRelativePath((String)sourceBase, (String)sourcePath, (char)sourceFileSeparator) != null) {
                    String relativeSourcePath;
                    boolean bl3 = false;
                    String relativeDestPath = TargetEnvironmentPaths.replaceFileSeparator(relativeSourcePath, sourceFileSeparator, destFileSeparator);
                    String[] stringArray = new String[]{destBase, relativeDestPath};
                    string = TargetEnvironmentPaths.joinTargetPaths(stringArray, destFileSeparator);
                } else {
                    string = null;
                }
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean isAncestor(String ancestor, String file, char fileSeparator) {
        return fileSeparator == '\\' ? FileUtil.isAncestor((String)FileUtil.toSystemIndependentName((String)ancestor), (String)FileUtil.toSystemIndependentName((String)file), (boolean)false) : FileUtil.isAncestor((String)ancestor, (String)file, (boolean)false);
    }

    private static final String replaceFileSeparator(String $this$replaceFileSeparator, char currentFileSeparator, char newFileSeparator) {
        return currentFileSeparator == newFileSeparator ? $this$replaceFileSeparator : StringsKt.replace$default((String)$this$replaceFileSeparator, (char)currentFileSeparator, (char)newFileSeparator, (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String joinTargetPaths(@NotNull String[] paths, char fileSeparator) {
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        Iterator iterator = ArrayIteratorKt.iterator((Object[])paths);
        Object path = TargetEnvironmentPaths.removeRepetitiveFileSeparators(TargetEnvironmentPaths.normalizeFileSeparatorCharacter((String)iterator.next(), fileSeparator), fileSeparator);
        while (iterator.hasNext()) {
            String basePath = TargetEnvironmentPaths.ensureEndsWithFileSeparator((String)path, fileSeparator);
            String normalizedRelativePath = TargetEnvironmentPaths.normalizeRelativePath(TargetEnvironmentPaths.removeRepetitiveFileSeparators(TargetEnvironmentPaths.normalizeFileSeparatorCharacter((String)iterator.next(), fileSeparator), fileSeparator), fileSeparator);
            path = basePath + normalizedRelativePath;
        }
        return path;
    }

    private static final String normalizeFileSeparatorCharacter(String $this$normalizeFileSeparatorCharacter, char fileSeparator) {
        return fileSeparator == '\\' ? StringsKt.replace$default((String)$this$normalizeFileSeparatorCharacter, (char)'/', (char)fileSeparator, (boolean)false, (int)4, null) : $this$normalizeFileSeparatorCharacter;
    }

    private static final String removeRepetitiveFileSeparators(String $this$removeRepetitiveFileSeparators, char fileSeparator) {
        return fileSeparator == '\\' && StringsKt.startsWith$default((String)$this$removeRepetitiveFileSeparators, (String)"\\\\", (boolean)false, (int)2, null) ? "\\" + StringsKt.replace$default((String)$this$removeRepetitiveFileSeparators, (String)("" + fileSeparator + fileSeparator), (String)String.valueOf(fileSeparator), (boolean)false, (int)4, null) : StringsKt.replace$default((String)$this$removeRepetitiveFileSeparators, (String)("" + fileSeparator + fileSeparator), (String)String.valueOf(fileSeparator), (boolean)false, (int)4, null);
    }

    private static final String normalizeRelativePath(String $this$normalizeRelativePath, char fileSeparator) {
        String string;
        if ($this$normalizeRelativePath.length() == 1 && $this$normalizeRelativePath.charAt(0) == '.') {
            string = "";
        } else if (StringsKt.startsWith$default((String)$this$normalizeRelativePath, (String)("." + fileSeparator), (boolean)false, (int)2, null)) {
            String string2 = $this$normalizeRelativePath.substring(2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = $this$normalizeRelativePath;
        }
        return StringsKt.removeSuffix((String)string, (CharSequence)String.valueOf(fileSeparator));
    }

    private static final String ensureEndsWithFileSeparator(String $this$ensureEndsWithFileSeparator, char fileSeparator) {
        return StringsKt.endsWith$default((CharSequence)$this$ensureEndsWithFileSeparator, (char)fileSeparator, (boolean)false, (int)2, null) ? $this$ensureEndsWithFileSeparator : $this$ensureEndsWithFileSeparator + fileSeparator;
    }

    private static final String getLocalPaths$lambda$0(PathMapping pathMapping) {
        Intrinsics.checkNotNullParameter((Object)pathMapping, (String)"pathMapping");
        return pathMapping.getTargetPath();
    }

    private static final String getLocalPaths$lambda$1(PathMapping pathMapping) {
        Intrinsics.checkNotNullParameter((Object)pathMapping, (String)"pathMapping");
        return pathMapping.getLocalPath();
    }

    private static final String getTargetPaths$lambda$0(PathMapping pathMapping) {
        Intrinsics.checkNotNullParameter((Object)pathMapping, (String)"pathMapping");
        return pathMapping.getLocalPath();
    }

    private static final String getTargetPaths$lambda$1(PathMapping pathMapping) {
        Intrinsics.checkNotNullParameter((Object)pathMapping, (String)"pathMapping");
        return pathMapping.getTargetPath();
    }
}

